/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.properties.Translation;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.editors.ErrorMessage;
import org.teiid.designer.extension.ui.editors.LocaleProposalProvider;

public class EditTranslationDialog
extends FormDialog {
    private Button btnOk;
    private final List<Translation> existingTranslations;
    private Locale locale;
    private ScrolledForm scrolledForm;
    private final String title;
    private final String translationType;
    private final ErrorMessage localeError;
    private final ErrorMessage translationError;
    private String translation;
    private Translation translationBeingEdited;

    public EditTranslationDialog(Shell parentShell, String title, String translationType, Collection<Translation> existingTranslations) {
        super(parentShell);
        CoreArgCheck.isNotNull((Object)title, (String)"title is null");
        CoreArgCheck.isNotNull((Object)translationType, (String)"translationType is null");
        this.title = title;
        this.translationType = translationType;
        this.existingTranslations = existingTranslations == null ? new ArrayList<Translation>() : new ArrayList<Translation>(existingTranslations);
        this.localeError = new ErrorMessage();
        this.translationError = new ErrorMessage();
    }

    public EditTranslationDialog(Shell parentShell, String title, String translationType, Collection<Translation> existingTranslations, Translation translationBeingEdited) {
        this(parentShell, title, translationType, existingTranslations);
        CoreArgCheck.isNotNull((Object)translationBeingEdited, (String)"translationBeingEdited is null");
        this.translationBeingEdited = translationBeingEdited;
        this.locale = this.translationBeingEdited.getLocale();
        this.translation = this.translationBeingEdited.getTranslation();
        this.existingTranslations.remove(this.translationBeingEdited);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEditMode()) {
            newShell.setText(Messages.editMetaclassDialogTitle);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        String current;
        int index;
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.title);
        this.scrolledForm.setImage(Activator.getDefault().getImage("icons/model-extension-definition-editor.png"));
        this.scrolledForm.setMessage(Messages.translationDialogMsg, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        Label lblLocale = toolkit.createLabel(body, Messages.localeLabel, 0);
        lblLocale.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        CCombo cbxLocales = new CCombo(body, 0x800808);
        this.localeError.setControl((Control)cbxLocales);
        toolkit.adapt((Control)cbxLocales, true, false);
        cbxLocales.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)cbxLocales.getLayoutData()).widthHint = (int)((double)this.getParentShell().getSize().x * 0.8);
        ((GridData)cbxLocales.getLayoutData()).heightHint = cbxLocales.getItemHeight() + 4;
        final ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        Collections.sort(locales, ExtensionConstants.LOCALE_COMPARATOR);
        for (Locale locale : locales) {
            cbxLocales.add(locale.getDisplayName());
        }
        if (this.isEditMode() && (index = cbxLocales.indexOf(current = this.translationBeingEdited.getLocale().getDisplayName())) != -1) {
            cbxLocales.select(index);
        }
        cbxLocales.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ((CCombo)e.widget).getSelectionIndex();
                EditTranslationDialog.this.handleLocaleChanged((Locale)locales.get(index));
            }
        });
        cbxLocales.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    int index = ((CCombo)e.widget).getSelectionIndex();
                    EditTranslationDialog.this.handleLocaleChanged((Locale)locales.get(index));
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        cbxLocales.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                int index = ((CCombo)e.widget).getSelectionIndex();
                if (!locales.isEmpty() && index > 0 && index < locales.size()) {
                    EditTranslationDialog.this.handleLocaleChanged((Locale)locales.get(index));
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        LocaleProposalProvider proposalProvider = new LocaleProposalProvider(cbxLocales);
        proposalProvider.init();
        Label lblTranslation = toolkit.createLabel(body, Messages.translationLabel, 0);
        lblTranslation.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text txtTranslation = toolkit.createText(body, null, 2882);
        this.translationError.setControl((Control)txtTranslation);
        txtTranslation.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)txtTranslation.getLayoutData()).verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        ((GridData)txtTranslation.getLayoutData()).heightHint = txtTranslation.getLineHeight() * 3;
        ((GridData)txtTranslation.getLayoutData()).widthHint = (int)((double)this.getParentShell().getSize().x * 0.8);
        if (this.isEditMode()) {
            txtTranslation.setText(this.translationBeingEdited.getTranslation());
        }
        txtTranslation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTranslationDialog.this.handleTranslationChanged(((Text)e.widget).getText());
            }
        });
    }

    public Translation getTranslation() {
        return new Translation(this.locale, this.translation);
    }

    void handleLocaleChanged(Locale newLocale) {
        this.locale = newLocale;
        this.validate();
        this.updateState();
    }

    void handleTranslationChanged(String newTranslation) {
        this.translation = newTranslation;
        this.validate();
        this.updateState();
    }

    private boolean isEditMode() {
        return this.translationBeingEdited != null;
    }

    private void updateState() {
        boolean enable = false;
        if (!this.localeError.isError() && !this.translationError.isError()) {
            enable = true;
            if (this.isEditMode()) {
                Locale localeBeingEdited = this.translationBeingEdited.getLocale();
                if (this.locale == null) {
                    enable = localeBeingEdited != null;
                } else {
                    boolean bl = enable = localeBeingEdited == null || !localeBeingEdited.equals(this.locale);
                }
                if (!enable) {
                    boolean bl = enable = !CoreStringUtil.equals((String)this.translation, (String)this.translationBeingEdited.getTranslation());
                }
            }
            if (!CoreStringUtil.equals((String)Messages.translationDialogMsg, (String)this.scrolledForm.getMessage())) {
                this.scrolledForm.setMessage("", 1);
                this.scrolledForm.setMessage(Messages.translationDialogMsg, 0);
            }
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }

    private void validate() {
        this.localeError.setStatus(ModelExtensionDefinitionValidator.validateTranslationLocale((Locale)this.locale));
        if (!this.localeError.isError()) {
            assert (this.locale != null) : "locale is null and should not be";
            Translation newTranslation = new Translation(this.locale, this.translation);
            ArrayList<Translation> temp = new ArrayList<Translation>(this.existingTranslations);
            temp.add(newTranslation);
            this.localeError.setStatus(ModelExtensionDefinitionValidator.validateTranslations((String)this.translationType, temp, (boolean)false));
        }
        this.localeError.update(this.scrolledForm.getMessageManager());
        this.translationError.setStatus((MedStatus)ModelExtensionDefinitionValidator.validateTranslationText((String)this.translation));
        this.translationError.update(this.scrolledForm.getMessageManager());
    }
}

