/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.extension.AbstractMetaclassNameProvider;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.definition.ValidationStatus;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinitionImpl;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.properties.Translation;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.editors.EditAllowedValueDialog;
import org.teiid.designer.extension.ui.editors.EditTranslationDialog;
import org.teiid.designer.extension.ui.editors.ErrorMessage;
import org.teiid.designer.extension.ui.editors.RuntimeTypeProposalProvider;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.MessageFormDialog;

final class EditPropertyDialog
extends FormDialog {
    private final String metaclassName;
    private final NamespaceProvider namespaceProvider;
    private Button btnEditDescription;
    private Button btnEditDisplayName;
    private Button btnOk;
    private Button btnRemoveDescription;
    private Button btnRemoveDisplayName;
    private Button btnAllowedValues;
    private List lstAllowedValues;
    private Button btnAddValue;
    private Button btnEditValue;
    private Button btnRemoveValue;
    private Button btnInitialValue;
    private Text txtInitialValue;
    private Button btnFixedValue;
    private TableViewerBuilder descriptionViewer;
    private TableViewerBuilder displayNameViewer;
    private final Collection<String> existingPropIds;
    private IManagedForm managedForm;
    private ModelExtensionPropertyDefinition propDefnBeingEdited;
    private ModelExtensionPropertyDefinition propDefn;
    private ScrolledForm scrolledForm;
    private final ErrorMessage advancedError;
    private final ErrorMessage allowedValuesError;
    private final ErrorMessage displayNameError;
    private final ErrorMessage descriptionError;
    private final ErrorMessage indexedError;
    private final ErrorMessage initialValueError;
    private final ErrorMessage maskedError;
    private final ErrorMessage requiredError;
    private final ErrorMessage simpleIdError;
    private final ErrorMessage typeError;

    public EditPropertyDialog(Shell shell, NamespaceProvider namespaceProvider, String metaclassName, Collection<String> existingPropIds) {
        super(shell);
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is empty");
        CoreArgCheck.isNotNull((Object)namespaceProvider, (String)"namespaceProvider is null");
        this.metaclassName = metaclassName;
        this.namespaceProvider = namespaceProvider;
        this.propDefn = new ModelExtensionPropertyDefinitionImpl(this.namespaceProvider);
        this.existingPropIds = existingPropIds == null ? new ArrayList<String>() : new ArrayList<String>(existingPropIds);
        this.advancedError = new ErrorMessage();
        this.allowedValuesError = new ErrorMessage();
        this.displayNameError = new ErrorMessage();
        this.descriptionError = new ErrorMessage();
        this.indexedError = new ErrorMessage();
        this.initialValueError = new ErrorMessage();
        this.maskedError = new ErrorMessage();
        this.requiredError = new ErrorMessage();
        this.simpleIdError = new ErrorMessage();
        this.typeError = new ErrorMessage();
    }

    public EditPropertyDialog(Shell shell, NamespaceProvider namespaceProvider, String metaclassName, Collection<String> existingPropIds, ModelExtensionPropertyDefinition propDefnBeingEdited) {
        this(shell, namespaceProvider, metaclassName, existingPropIds);
        this.propDefnBeingEdited = propDefnBeingEdited;
        if (this.propDefnBeingEdited != null) {
            this.propDefnBeingEdited = propDefnBeingEdited;
            this.existingPropIds.remove(this.propDefnBeingEdited.getSimpleId());
            this.propDefn.setAdvanced(this.propDefnBeingEdited.isAdvanced());
            this.propDefn.setAllowedValues(this.propDefnBeingEdited.allowedValues());
            this.propDefn.setDefaultValue(this.propDefnBeingEdited.getDefaultValue());
            this.propDefn.setFixedValue(this.propDefnBeingEdited.getFixedValue());
            this.propDefn.setIndex(this.propDefnBeingEdited.shouldBeIndexed());
            this.propDefn.setMasked(this.propDefnBeingEdited.isMasked());
            this.propDefn.setRequired(this.propDefnBeingEdited.isRequired());
            this.propDefn.setSimpleId(this.propDefnBeingEdited.getSimpleId());
            this.propDefn.setType(this.propDefnBeingEdited.getType());
            if (!this.propDefnBeingEdited.getDescriptions().isEmpty()) {
                for (Translation description : this.propDefnBeingEdited.getDescriptions()) {
                    this.propDefn.addDescription((Translation)description.clone());
                }
            }
            if (!this.propDefnBeingEdited.getDisplayNames().isEmpty()) {
                for (Translation displayName : this.propDefnBeingEdited.getDisplayNames()) {
                    this.propDefn.addDisplayName((Translation)displayName.clone());
                }
            }
        }
    }

    private void addMessage(ErrorMessage errorMsg) {
        errorMsg.update(this.scrolledForm.getMessageManager());
        if (errorMsg.isOk()) {
            this.scrolledForm.setMessage(errorMsg.getMessage(), 0);
        }
    }

    private void configureColumn(TableViewerColumn viewerColumn, String headerText, String headerToolTip, boolean resizable) {
        TableColumn column = viewerColumn.getColumn();
        column.setText(headerText);
        column.setToolTipText(headerToolTip);
        column.setMoveable(false);
        column.setResizable(resizable);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEditMode()) {
            newShell.setText(Messages.editPropertyDialogTitle);
        } else {
            newShell.setText(Messages.addPropertyDialogTitle);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    private Section createDescriptionSection(Composite body, FormToolkit toolkit) {
        Composite container;
        Section section = FormUtil.createSection((IManagedForm)this.managedForm, (FormToolkit)toolkit, (Composite)body, (String)Messages.editPropertyDialogDescriptionSectionTitle, (String)Messages.editPropertyDialogDescriptionSectionDescription, (int)8642, (boolean)true);
        section.setExpanded(false);
        Section finalSection = section;
        Button[] buttons = FormUtil.createSectionToolBar((Section)finalSection, (FormToolkit)toolkit, (Image[])new Image[]{Activator.getDefault().getImage("icons/add-metaclass.png"), Activator.getDefault().getImage("icons/edit-metaclass.png"), Activator.getDefault().getImage("icons/remove-metaclass.png")});
        buttons[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleAddDescription();
            }
        });
        buttons[0].setToolTipText(Messages.editPropertyDialogAddDescriptionButtonToolTip);
        buttons[1].setEnabled(false);
        buttons[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleEditDescription();
            }
        });
        buttons[1].setToolTipText(Messages.editPropertyDialogEditDescriptionButtonToolTip);
        this.btnEditDescription = buttons[1];
        buttons[2].setEnabled(false);
        buttons[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleRemoveDescription();
            }
        });
        buttons[2].setToolTipText(Messages.editPropertyDialogRemoveDescriptionButtonToolTip);
        this.btnRemoveDescription = buttons[2];
        Composite finalContainer = container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        this.descriptionViewer = new TableViewerBuilder(finalContainer, 2820);
        Table table = this.descriptionViewer.getTable();
        toolkit.adapt((Composite)table);
        this.descriptionError.setControl((Control)table);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        ((GridData)table.getLayoutData()).widthHint = (int)((double)this.getParentShell().getSize().x * 0.4);
        this.descriptionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return EditPropertyDialog.this.getPropertyDefinition().getDescriptions().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.descriptionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.descriptionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditPropertyDialog.this.handleEditDescription();
            }
        });
        this.descriptionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditPropertyDialog.this.handleDescriptionSelected();
            }
        });
        TableViewerColumn firstColumn = this.descriptionViewer.createColumn(16384, 50, 50, true);
        this.configureColumn(firstColumn, ColumnHeaders.LOCALE, ColumnToolTips.LOCALE, true);
        firstColumn.setLabelProvider((CellLabelProvider)new TranslationLabelProvider(0));
        TableViewerColumn lastColumn = this.descriptionViewer.createColumn(16384, 50, 50, true);
        lastColumn.setLabelProvider((CellLabelProvider)new TranslationLabelProvider(1));
        this.configureColumn(lastColumn, ColumnHeaders.TRANSLATION, ColumnToolTips.TRANSLATION, true);
        this.descriptionViewer.setInput((Object)this);
        return finalSection;
    }

    private Section createDisplayNameSection(Composite body, FormToolkit toolkit) {
        Composite container;
        Section section = FormUtil.createSection((IManagedForm)this.managedForm, (FormToolkit)toolkit, (Composite)body, (String)Messages.editPropertyDialogDisplayNameSectionTitle, (String)Messages.editPropertyDialogDisplayNameSectionDescription, (int)8642, (boolean)true);
        section.setExpanded(false);
        Section finalSection = section;
        Button[] buttons = FormUtil.createSectionToolBar((Section)finalSection, (FormToolkit)toolkit, (Image[])new Image[]{Activator.getDefault().getImage("icons/add-metaclass.png"), Activator.getDefault().getImage("icons/edit-metaclass.png"), Activator.getDefault().getImage("icons/remove-metaclass.png")});
        buttons[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleAddDisplayName();
            }
        });
        buttons[0].setToolTipText(Messages.editPropertyDialogAddDisplayNameButtonToolTip);
        buttons[1].setEnabled(false);
        buttons[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleEditDisplayName();
            }
        });
        buttons[1].setToolTipText(Messages.editPropertyDialogEditDisplayNameButtonToolTip);
        this.btnEditDisplayName = buttons[1];
        buttons[2].setEnabled(false);
        buttons[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleRemoveDisplayName();
            }
        });
        buttons[2].setToolTipText(Messages.editPropertyDialogRemoveDisplayNameButtonToolTip);
        this.btnRemoveDisplayName = buttons[2];
        Composite finalContainer = container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        this.displayNameViewer = new TableViewerBuilder(finalContainer, 2820);
        Table table = this.displayNameViewer.getTable();
        toolkit.adapt((Composite)table);
        this.displayNameError.setControl((Control)table);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        ((GridData)table.getLayoutData()).widthHint = (int)((double)this.getParentShell().getSize().x * 0.4);
        this.displayNameViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return EditPropertyDialog.this.getPropertyDefinition().getDisplayNames().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.displayNameViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.displayNameViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditPropertyDialog.this.handleEditDisplayName();
            }
        });
        this.displayNameViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditPropertyDialog.this.handleDisplayNameSelected();
            }
        });
        TableViewerColumn firstColumn = this.displayNameViewer.createColumn(16384, 50, 50, true);
        firstColumn.setLabelProvider((CellLabelProvider)new TranslationLabelProvider(0));
        this.configureColumn(firstColumn, ColumnHeaders.LOCALE, ColumnToolTips.LOCALE, true);
        TableViewerColumn lastColumn = this.displayNameViewer.createColumn(16384, 50, 50, true);
        lastColumn.setLabelProvider((CellLabelProvider)new TranslationLabelProvider(1));
        this.configureColumn(lastColumn, ColumnHeaders.TRANSLATION, ColumnToolTips.TRANSLATION, true);
        this.displayNameViewer.setInput((Object)this);
        return finalSection;
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite body;
        this.managedForm = managedForm;
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Messages.propertyDialogTitle);
        this.scrolledForm.setImage(Activator.getDefault().getImage("icons/model-extension-definition-editor.png"));
        this.scrolledForm.setMessage(Messages.propertyDialogMessage, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite finalBody = body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        body.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
            }
        });
        Section infoSection = this.createInfoSection(finalBody, toolkit);
        Section propertyValueSection = this.createPropertyValueSection(finalBody, toolkit);
        Section displayNameSection = this.createDisplayNameSection(finalBody, toolkit);
        Section descriptionSection = this.createDescriptionSection(finalBody, toolkit);
        infoSection.descriptionVerticalSpacing = propertyValueSection.getTextClientHeightDifference();
        descriptionSection.descriptionVerticalSpacing = displayNameSection.getTextClientHeightDifference();
        this.propDefn.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                EditPropertyDialog.this.handlePropertyChanged(e);
            }
        });
        this.validateAll();
    }

    private Section createInfoSection(Composite body, FormToolkit toolkit) {
        Section section;
        Section finalSection = section = FormUtil.createSection((IManagedForm)this.managedForm, (FormToolkit)toolkit, (Composite)body, (String)Messages.editPropertyDialogInfoSectionTitle, (String)Messages.editPropertyDialogInfoSectionDescription, (int)8642, (boolean)true);
        Composite container = toolkit.createComposite((Composite)finalSection);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        finalSection.setClient((Control)container);
        Composite finalContainer = container;
        toolkit.createLabel(finalContainer, Messages.metaclassLabel);
        String labelStr = this.getMetaclassShortName(this.metaclassName);
        Label label = toolkit.createLabel(finalContainer, labelStr);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(finalContainer, Messages.namespacePrefixLabel);
        Label label2 = toolkit.createLabel(finalContainer, this.namespaceProvider.getNamespacePrefix());
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.createLabel(finalContainer, Messages.simpleIdLabel);
        Text txtSimpleId = toolkit.createText(finalContainer, "", 2048);
        this.simpleIdError.setControl((Control)txtSimpleId);
        txtSimpleId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtSimpleId.setFocus();
        txtSimpleId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditPropertyDialog.this.handleSimpleIdChanged(((Text)e.widget).getText());
            }
        });
        if (this.isEditMode() && this.propDefn.getSimpleId() != null) {
            txtSimpleId.setText(this.propDefn.getSimpleId());
        }
        toolkit.createLabel(finalContainer, Messages.runtimeTypeLabel);
        CCombo cbxRuntimeType = new CCombo(finalContainer, 0x800808);
        toolkit.adapt((Control)cbxRuntimeType, true, false);
        this.typeError.setControl((Control)cbxRuntimeType);
        cbxRuntimeType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)cbxRuntimeType.getLayoutData()).heightHint = cbxRuntimeType.getItemHeight() + 4;
        ModelExtensionPropertyDefinition.Type[] typeArray = ModelExtensionPropertyDefinition.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelExtensionPropertyDefinition.Type type = typeArray[n2];
            cbxRuntimeType.add(type.getRuntimeType());
            ++n2;
        }
        String runtimeType = this.propDefn.getRuntimeType();
        if (!CoreStringUtil.isEmpty((String)runtimeType)) {
            int index = cbxRuntimeType.indexOf(runtimeType);
            if (index == -1) {
                UiConstants.UTIL.log((Object)NLS.bind((String)Messages.editPropertyDialogInvalidRuntimeTypeMsg, (Object)runtimeType));
            } else {
                cbxRuntimeType.select(index);
            }
        }
        cbxRuntimeType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditPropertyDialog.this.handleRuntimeTypeChanged(((CCombo)e.widget).getText());
            }
        });
        RuntimeTypeProposalProvider proposalProvider = new RuntimeTypeProposalProvider(cbxRuntimeType);
        proposalProvider.init();
        Button btn = toolkit.createButton(finalContainer, Messages.editPropertyDialogAdvancedButtonText, 32);
        this.advancedError.setControl((Control)btn);
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ((GridData)btn.getLayoutData()).verticalIndent = 5;
        ((GridData)btn.getLayoutData()).horizontalSpan = 2;
        btn.setSelection(this.propDefn.isAdvanced());
        btn.setToolTipText(Messages.advancedPropertyAttributeColumnHeaderToolTip);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleAdvancedChanged(((Button)e.widget).getSelection());
            }
        });
        btn = toolkit.createButton(finalContainer, Messages.editPropertyDialogIndexButtonText, 32);
        this.indexedError.setControl((Control)btn);
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ((GridData)btn.getLayoutData()).horizontalSpan = 2;
        btn.setSelection(this.propDefn.shouldBeIndexed());
        btn.setToolTipText(Messages.indexedPropertyAttributeColumnHeaderToolTip);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleIndexedChanged(((Button)e.widget).getSelection());
            }
        });
        return finalSection;
    }

    private Section createPropertyValueSection(Composite body, FormToolkit toolkit) {
        String[] allowedValues;
        Composite container;
        Section section = FormUtil.createSection((IManagedForm)this.managedForm, (FormToolkit)toolkit, (Composite)body, (String)Messages.editPropertyDialogPropertyValueSectionTitle, (String)Messages.editPropertyDialogPropertyValueSectionDescription, (int)8642, (boolean)true);
        Composite finalContainer = container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)container);
        Button btnRequired = toolkit.createButton(finalContainer, Messages.editPropertyDialogRequiredButtonText, 32);
        this.requiredError.setControl((Control)btnRequired);
        btnRequired.setSelection(this.propDefn.isRequired());
        btnRequired.setToolTipText(Messages.editPropertyDialogRequiredButtonToolTip);
        btnRequired.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleRequiredChanged(((Button)e.widget).getSelection());
            }
        });
        Button btnMasked = toolkit.createButton(finalContainer, Messages.editPropertyDialogMaskedButtonText, 32);
        this.maskedError.setControl((Control)btnMasked);
        btnMasked.setSelection(this.propDefn.isMasked());
        btnMasked.setToolTipText(Messages.editPropertyDialogMaskedButtonToolTip);
        btnMasked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleMaskedChanged(((Button)e.widget).getSelection());
            }
        });
        Composite middle = toolkit.createComposite(finalContainer);
        GridLayout middleLayout = new GridLayout(2, false);
        middleLayout.horizontalSpacing = 0;
        middleLayout.marginHeight = 0;
        middleLayout.marginWidth = 0;
        middle.setLayout((Layout)middleLayout);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.btnAllowedValues = toolkit.createButton(middle, Messages.editPropertyDialogAllowedValuesButtonText, 32);
        this.btnAllowedValues.setToolTipText(Messages.editPropertyDialogAllowedValuesButtonToolTip);
        this.btnAllowedValues.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ((GridData)this.btnAllowedValues.getLayoutData()).horizontalSpan = 2;
        this.btnAllowedValues.setEnabled(ModelExtensionPropertyDefinition.Type.BOOLEAN != this.propDefn.getType());
        this.lstAllowedValues = new List(middle, 2052);
        this.allowedValuesError.setControl((Control)this.lstAllowedValues);
        this.lstAllowedValues.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.lstAllowedValues.getLayoutData()).horizontalIndent = 20;
        ((GridData)this.lstAllowedValues.getLayoutData()).heightHint = this.lstAllowedValues.getItemHeight() * 5;
        this.lstAllowedValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleAllowedValueSelected();
            }
        });
        this.btnAllowedValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleHasAllowedValuesSelected();
            }
        });
        Composite pnlButtons = toolkit.createComposite(middle);
        RowLayout btnLayout = new RowLayout(512);
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.spacing = 0;
        btnLayout.marginTop = 0;
        btnLayout.marginBottom = 0;
        pnlButtons.setLayout((Layout)btnLayout);
        pnlButtons.setLayoutData((Object)new GridData(4, 4, true, true));
        this.btnAddValue = toolkit.createButton(pnlButtons, "", 0x800000);
        this.btnAddValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleAddAllowedValue();
            }
        });
        this.btnAddValue.setToolTipText(Messages.editPropertyDialogAddAllowedValueButtonToolTip);
        this.btnAddValue.setImage(Activator.getDefault().getImage("icons/add-metaclass.png"));
        this.btnEditValue = toolkit.createButton(pnlButtons, "", 0x800000);
        this.btnEditValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleEditAllowedValue();
            }
        });
        this.btnEditValue.setToolTipText(Messages.editPropertyDialogEditAllowedValueButtonToolTip);
        this.btnEditValue.setImage(Activator.getDefault().getImage("icons/edit-metaclass.png"));
        this.btnRemoveValue = toolkit.createButton(pnlButtons, "", 0x800000);
        this.btnRemoveValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleRemoveAllowedValue();
            }
        });
        this.btnRemoveValue.setToolTipText(Messages.editPropertyDialogRemoveAllowedValueButtonToolTip);
        this.btnRemoveValue.setImage(Activator.getDefault().getImage("icons/remove-metaclass.png"));
        if (this.isEditMode() && (allowedValues = this.propDefn.getAllowedValues()) != null && allowedValues.length != 0) {
            this.btnAllowedValues.setSelection(true);
            this.lstAllowedValues.setItems(allowedValues);
        }
        boolean enable = this.btnAllowedValues.getSelection() && this.btnAllowedValues.getEnabled();
        this.lstAllowedValues.setEnabled(enable);
        this.btnAddValue.setEnabled(enable);
        this.btnEditValue.setEnabled(false);
        this.btnRemoveValue.setEnabled(false);
        Composite bottom = toolkit.createComposite(finalContainer, 0);
        bottom.setLayout((Layout)new GridLayout(2, false));
        bottom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.btnInitialValue = toolkit.createButton(bottom, Messages.editPropertyDialogInitialValueButtonText, 32);
        this.btnInitialValue.setToolTipText(Messages.editPropertyDialogInitialValueButtonToolTip);
        this.btnInitialValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleHasInitialValueSelected();
            }
        });
        this.txtInitialValue = toolkit.createText(bottom, "", 2048);
        this.initialValueError.setControl((Control)this.txtInitialValue);
        this.txtInitialValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditPropertyDialog.this.handleInitialValueChanged(((Text)e.widget).getText());
            }
        });
        this.txtInitialValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnFixedValue = toolkit.createButton(bottom, Messages.editPropertyDialogFixedValueButtonText, 32);
        this.btnFixedValue.setToolTipText(Messages.editPropertyDialogFixedValueButtonToolTip);
        this.btnFixedValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditPropertyDialog.this.handleHasFixedValueSelected();
            }
        });
        this.btnFixedValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ((GridData)this.btnFixedValue.getLayoutData()).horizontalIndent = 20;
        ((GridData)this.btnFixedValue.getLayoutData()).horizontalSpan = 2;
        if (!CoreStringUtil.isEmpty((String)this.propDefn.getDefaultValue())) {
            this.btnInitialValue.setSelection(true);
            this.txtInitialValue.setText(this.propDefn.getDefaultValue());
        } else if (!CoreStringUtil.isEmpty((String)this.propDefn.getFixedValue())) {
            this.btnInitialValue.setSelection(true);
            this.btnFixedValue.setSelection(true);
            this.txtInitialValue.setText(this.propDefn.getFixedValue());
        } else {
            this.btnInitialValue.setSelection(false);
            this.btnFixedValue.setSelection(false);
            this.btnFixedValue.setEnabled(false);
        }
        return section;
    }

    private String getMetaclassShortName(String metaclass) {
        return AbstractMetaclassNameProvider.getLabel((String)metaclass);
    }

    ModelExtensionPropertyDefinition getPropertyDefinition() {
        return this.propDefn;
    }

    String getSelectedAllowedValue() {
        int index = this.lstAllowedValues.getSelectionIndex();
        return index == -1 ? null : this.lstAllowedValues.getItem(index);
    }

    Translation getSelectedDescription() {
        IStructuredSelection selection = (IStructuredSelection)this.descriptionViewer.getSelection();
        return selection.isEmpty() ? null : (Translation)selection.getFirstElement();
    }

    Translation getSelectedDisplayName() {
        IStructuredSelection selection = (IStructuredSelection)this.displayNameViewer.getSelection();
        return selection.isEmpty() ? null : (Translation)selection.getFirstElement();
    }

    void handleAddAllowedValue() {
        EditAllowedValueDialog dialog = new EditAllowedValueDialog(this.getShell(), this.propDefn.getType(), this.propDefn.getAllowedValues());
        dialog.create();
        this.sizeDialog(dialog.getShell(), this.getShell());
        if (dialog.open() == 0) {
            String newAllowedValue = dialog.getAllowedValue();
            if (this.propDefn.addAllowedValue(newAllowedValue)) {
                this.lstAllowedValues.add(newAllowedValue);
            } else {
                UiConstants.UTIL.log((Object)NLS.bind((String)Messages.editPropertyDialogAllowedValueNotAddedMsg, (Object)newAllowedValue));
            }
        }
    }

    void handleAddDescription() {
        EditTranslationDialog dialog = new EditTranslationDialog(this.getShell(), Messages.addPropertyDescriptionDialogTitle, org.teiid.designer.extension.Messages.propertyDescription, this.propDefn.getDescriptions());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            Translation newDescription = dialog.getTranslation();
            if (this.propDefn.addDescription(newDescription)) {
                this.descriptionViewer.refresh();
            } else {
                UiConstants.UTIL.log((Object)NLS.bind((String)Messages.editPropertyDialogDescriptionNotAddedMsg, (Object)newDescription));
            }
        }
    }

    void handleAddDisplayName() {
        EditTranslationDialog dialog = new EditTranslationDialog(this.getShell(), Messages.addPropertyDisplayNameDialogTitle, org.teiid.designer.extension.Messages.propertyDisplayName, this.propDefn.getDisplayNames());
        dialog.create();
        this.sizeDialog(dialog.getShell(), this.getShell());
        if (dialog.open() == 0) {
            Translation newDisplayName = dialog.getTranslation();
            if (this.propDefn.addDisplayName(newDisplayName)) {
                this.displayNameViewer.refresh();
            } else {
                UiConstants.UTIL.log((Object)NLS.bind((String)Messages.editPropertyDialogDisplayNameNotAddedMsg, (Object)newDisplayName));
            }
        }
    }

    void handleAdvancedChanged(boolean newValue) {
        this.propDefn.setAdvanced(newValue);
    }

    void handleAllowedValueSelected() {
        boolean enable;
        boolean bl = enable = this.lstAllowedValues.getSelectionIndex() != -1;
        if (this.btnEditValue.getEnabled() != enable) {
            this.btnEditValue.setEnabled(enable);
        }
        if (this.btnRemoveValue.getEnabled() != enable) {
            this.btnRemoveValue.setEnabled(enable);
        }
    }

    void handleDescriptionSelected() {
        boolean enable;
        IStructuredSelection selection = (IStructuredSelection)this.descriptionViewer.getSelection();
        boolean bl = enable = !selection.isEmpty();
        if (this.btnEditDescription.getEnabled() != enable) {
            this.btnEditDescription.setEnabled(enable);
        }
        if (this.btnRemoveDescription.getEnabled() != enable) {
            this.btnRemoveDescription.setEnabled(enable);
        }
    }

    void handleDisplayNameSelected() {
        boolean enable;
        IStructuredSelection selection = (IStructuredSelection)this.displayNameViewer.getSelection();
        boolean bl = enable = !selection.isEmpty();
        if (this.btnEditDisplayName.getEnabled() != enable) {
            this.btnEditDisplayName.setEnabled(enable);
        }
        if (this.btnRemoveDisplayName.getEnabled() != enable) {
            this.btnRemoveDisplayName.setEnabled(enable);
        }
    }

    void handleEditAllowedValue() {
        String selectedAllowedValue = this.getSelectedAllowedValue();
        assert (selectedAllowedValue != null) : "Edit allowed value button is enabled and shouldn't be";
        EditAllowedValueDialog dialog = new EditAllowedValueDialog(this.getShell(), this.propDefn.getType(), this.propDefn.getAllowedValues(), selectedAllowedValue);
        dialog.create();
        this.sizeDialog(dialog.getShell(), this.getShell());
        if (dialog.open() == 0) {
            String changedValue = dialog.getAllowedValue();
            if (this.propDefn.removeAllowedValue(selectedAllowedValue)) {
                this.lstAllowedValues.remove(selectedAllowedValue);
                if (this.propDefn.addAllowedValue(changedValue)) {
                    this.lstAllowedValues.add(changedValue);
                }
            }
        }
    }

    void handleEditDescription() {
        assert (this.getSelectedDescription() != null) : "Edit description button is enabled and shouldn't be";
        Translation selectedDescription = this.getSelectedDescription();
        EditTranslationDialog dialog = new EditTranslationDialog(this.getShell(), Messages.editPropertyDescriptionDialogTitle, org.teiid.designer.extension.Messages.propertyDescription, this.propDefn.getDescriptions(), selectedDescription);
        dialog.create();
        this.sizeDialog(dialog.getShell(), this.getShell());
        if (dialog.open() == 0) {
            Translation changedDescription = dialog.getTranslation();
            this.propDefn.removeDescription(selectedDescription);
            this.propDefn.addDescription(changedDescription);
            this.descriptionViewer.refresh();
        }
    }

    void handleEditDisplayName() {
        assert (this.getSelectedDisplayName() != null) : "Edit display name button is enabled and shouldn't be";
        Translation selectedDisplayName = this.getSelectedDisplayName();
        EditTranslationDialog dialog = new EditTranslationDialog(this.getShell(), Messages.editPropertyDescriptionDialogTitle, org.teiid.designer.extension.Messages.propertyDisplayName, this.propDefn.getDisplayNames(), selectedDisplayName);
        dialog.create();
        this.sizeDialog(dialog.getShell(), this.getShell());
        if (dialog.open() == 0) {
            Translation changedDisplayName = dialog.getTranslation();
            this.propDefn.removeDisplayName(selectedDisplayName);
            this.propDefn.addDisplayName(changedDisplayName);
            this.displayNameViewer.refresh();
        }
    }

    void handleHasAllowedValuesSelected() {
        boolean enable = this.btnAllowedValues.getSelection();
        if (enable) {
            String[] stringArray = this.lstAllowedValues.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedValue = stringArray[n2];
                this.propDefn.addAllowedValue(allowedValue);
                ++n2;
            }
        } else {
            String[] stringArray = this.lstAllowedValues.getItems();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String allowedValue = stringArray[n3];
                this.propDefn.removeAllowedValue(allowedValue);
                ++n3;
            }
        }
        boolean bl = enable = ModelExtensionPropertyDefinition.Type.BOOLEAN != this.propDefn.getType();
        if (this.btnAllowedValues.getEnabled() != enable) {
            this.btnAllowedValues.setEnabled(enable);
        }
        if (this.lstAllowedValues.getEnabled() != enable) {
            this.lstAllowedValues.setEnabled(enable);
        }
        if (this.btnAddValue.getEnabled() != enable) {
            this.btnAddValue.setEnabled(enable);
        }
        boolean bl2 = enable = enable && this.lstAllowedValues.getSelectionIndex() != -1;
        if (this.btnEditValue.getEnabled() != enable) {
            this.btnEditValue.setEnabled(enable);
        }
        if (this.btnRemoveValue.getEnabled() != enable) {
            this.btnRemoveValue.setEnabled(enable);
        }
        this.validateAllowedValues();
        this.updateState();
    }

    void handleHasFixedValueSelected() {
        boolean hasFixedValue = this.btnFixedValue.getSelection();
        String value = this.txtInitialValue.getText();
        if (hasFixedValue) {
            this.propDefn.setDefaultValue(null);
            this.propDefn.setFixedValue(value);
        } else {
            this.propDefn.setFixedValue(null);
            this.propDefn.setDefaultValue(value);
        }
    }

    void handleHasInitialValueSelected() {
        boolean hasInitialValue = this.btnInitialValue.getSelection();
        boolean valueIsFixed = this.btnFixedValue.getSelection();
        String value = this.txtInitialValue.getText();
        if (hasInitialValue) {
            if (valueIsFixed) {
                this.propDefn.setFixedValue(value);
                this.propDefn.setDefaultValue(null);
            } else {
                this.propDefn.setDefaultValue(value);
                this.propDefn.setFixedValue(null);
            }
        } else {
            this.propDefn.setDefaultValue(null);
            this.propDefn.setFixedValue(null);
        }
        if (this.txtInitialValue.getEnabled() != hasInitialValue) {
            this.txtInitialValue.setEnabled(hasInitialValue);
        }
        if (this.btnFixedValue.getEnabled() != hasInitialValue) {
            this.btnFixedValue.setEnabled(hasInitialValue);
        }
        this.validateInitialValue(hasInitialValue, valueIsFixed);
        this.updateState();
    }

    void handleIndexedChanged(boolean newValue) {
        this.propDefn.setIndex(newValue);
    }

    void handleInitialValueChanged(String newValue) {
        boolean shouldHaveInitialValue = this.btnInitialValue.getSelection();
        if (shouldHaveInitialValue) {
            if (this.btnFixedValue.getSelection()) {
                this.propDefn.setFixedValue(newValue);
                this.propDefn.setDefaultValue(null);
            } else {
                this.propDefn.setFixedValue(null);
                this.propDefn.setDefaultValue(newValue);
            }
        } else {
            this.propDefn.setFixedValue(null);
            this.propDefn.setDefaultValue(null);
        }
    }

    void handleMaskedChanged(boolean newValue) {
        this.propDefn.setMasked(newValue);
    }

    void handlePropertyChanged(PropertyChangeEvent e) {
        this.scrolledForm.getMessageManager().setAutoUpdate(false);
        String propName = e.getPropertyName();
        if (ModelExtensionPropertyDefinition.PropertyName.ADVANCED.toString().equals(propName)) {
            this.validateAdvancedValue();
        } else if (ModelExtensionPropertyDefinition.PropertyName.ALLOWED_VALUES.toString().equals(propName)) {
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if ((newValue != null && !(newValue instanceof String) || oldValue != null && !(oldValue instanceof String)) && newValue instanceof Collection) {
                this.lstAllowedValues.removeAll();
                Object[] newValues = ((Collection)newValue).toArray();
                if (newValues.length != 0) {
                    Object[] objectArray = newValues;
                    int n = newValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value = objectArray[n2];
                        if (newValue instanceof Collection) {
                            this.lstAllowedValues.add((String)value);
                        }
                        ++n2;
                    }
                    if (!this.btnAllowedValues.getSelection()) {
                        this.btnAllowedValues.setSelection(true);
                    }
                }
            }
            this.validateAllowedValues();
        } else if (ModelExtensionPropertyDefinition.PropertyName.DEFAULT_VALUE.toString().equals(propName)) {
            this.validateInitialValue(this.btnInitialValue.getSelection(), false);
        } else if (ModelExtensionPropertyDefinition.PropertyName.DESCRIPTION.toString().equals(propName)) {
            this.validateDescriptions();
        } else if (ModelExtensionPropertyDefinition.PropertyName.DISPLAY_NAME.toString().equals(propName)) {
            this.validateDisplayNames();
        } else if (ModelExtensionPropertyDefinition.PropertyName.FIXED_VALUE.toString().equals(propName)) {
            this.validateInitialValue(this.btnInitialValue.getSelection(), true);
        } else if (ModelExtensionPropertyDefinition.PropertyName.INDEX.toString().equals(propName)) {
            this.validateIndex();
        } else if (ModelExtensionPropertyDefinition.PropertyName.MASKED.toString().equals(propName)) {
            this.validateMasked();
        } else if (ModelExtensionPropertyDefinition.PropertyName.REQUIRED.toString().equals(propName)) {
            this.validateRequired();
        } else if (ModelExtensionPropertyDefinition.PropertyName.SIMPLE_ID.toString().equals(propName)) {
            this.validateSimpleId();
        } else if (ModelExtensionPropertyDefinition.PropertyName.TYPE.toString().equals(propName)) {
            this.validateType();
        } else assert (false);
        this.updateState();
        this.scrolledForm.getMessageManager().setAutoUpdate(true);
    }

    void handleRemoveAllowedValue() {
        assert (this.getSelectedAllowedValue() != null) : "Remove allowed value button is enabled and shouldn't be";
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.removeAllowedValueDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.removeAllowedValueDialogMsg, (Object)this.getSelectedDescription()))) {
            this.propDefn.removeAllowedValue(this.getSelectedAllowedValue());
            this.lstAllowedValues.remove(this.getSelectedAllowedValue());
            this.handleAllowedValueSelected();
        }
    }

    void handleRemoveDescription() {
        assert (this.getSelectedDescription() != null) : "Remove description button is enabled and shouldn't be";
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.removeDescriptionDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.removeDescriptionDialogMsg, (Object)this.getSelectedDescription()))) {
            this.propDefn.removeDescription(this.getSelectedDescription());
            this.descriptionViewer.refresh();
        }
    }

    void handleRemoveDisplayName() {
        assert (this.getSelectedDisplayName() != null) : "Remove display name button is enabled and shouldn't be";
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)Messages.removeDisplayNameDialogTitle, (Image)Activator.getDefault().getImage("icons/model-extension-definition-editor.png"), (String)NLS.bind((String)Messages.removeDisplayNameDialogMsg, (Object)this.getSelectedDisplayName()))) {
            this.propDefn.removeDisplayName(this.getSelectedDisplayName());
            this.displayNameViewer.refresh();
        }
    }

    void handleRequiredChanged(boolean newValue) {
        this.propDefn.setRequired(newValue);
    }

    void handleRuntimeTypeChanged(String newValue) {
        ModelExtensionPropertyDefinition.Type newType = null;
        try {
            newType = ModelExtensionPropertyDefinition.Utils.convertRuntimeType((String)newValue);
            this.propDefn.setType(newType);
            this.handleHasAllowedValuesSelected();
        }
        catch (Exception e) {
            UiConstants.UTIL.log((Throwable)e);
        }
    }

    void handleSimpleIdChanged(String newValue) {
        this.propDefn.setSimpleId(newValue);
    }

    private boolean isEditMode() {
        return this.propDefnBeingEdited != null;
    }

    private void sizeDialog(Shell dialogShell, Shell parentShell) {
        dialogShell.pack();
        Point dialogSize = dialogShell.getSize();
        Point parentSize = parentShell.getSize();
        if (dialogSize.x > parentSize.x || dialogSize.y > parentSize.y) {
            dialogShell.setSize((int)((double)parentSize.x * 0.8), (int)((double)parentSize.y * 0.8));
        }
    }

    private void updateState() {
        boolean enable;
        boolean bl = enable = this.scrolledForm.getMessageType() != 3;
        if (enable && !Messages.propertyDialogMessage.equals(this.scrolledForm.getMessage())) {
            this.scrolledForm.setMessage(Messages.propertyDialogMessage, 1);
            this.scrolledForm.setMessage(Messages.propertyDialogMessage, 0);
        }
        if (enable) {
            if (this.isEditMode()) {
                boolean bl2 = enable = !this.propDefn.equals(this.propDefnBeingEdited);
            }
            if (this.btnOk.getEnabled() != enable) {
                this.btnOk.setEnabled(enable);
            }
        } else if (this.btnOk.getEnabled()) {
            this.btnOk.setEnabled(false);
        }
    }

    private void validateAdvancedValue() {
        this.advancedError.setStatus(ModelExtensionDefinitionValidator.validatePropertyAdvancedAttribute((boolean)this.propDefn.isAdvanced()));
        this.addMessage(this.advancedError);
    }

    private void validateAll() {
        this.validateAdvancedValue();
        this.validateAllowedValues();
        this.validateDescriptions();
        this.validateDisplayNames();
        this.validateIndex();
        this.validateInitialValue(this.btnInitialValue.getSelection(), this.btnFixedValue.getSelection());
        this.validateMasked();
        this.validateRequired();
        this.validateSimpleId();
        this.validateType();
    }

    private void validateAllowedValues() {
        this.allowedValuesError.clearMessage();
        if (this.btnAllowedValues.getSelection() && this.propDefn.allowedValues().isEmpty()) {
            this.allowedValuesError.setMessage(Messages.editPropertyDialogAllowedValueRequiredMsg);
        }
        if (!this.allowedValuesError.isError()) {
            this.allowedValuesError.setStatus(ModelExtensionDefinitionValidator.validatePropertyAllowedValues((String)this.propDefn.getRuntimeType(), (String[])this.propDefn.getAllowedValues()));
        }
        this.addMessage(this.allowedValuesError);
        this.validateInitialValue(this.btnInitialValue.getSelection(), this.btnFixedValue.getSelection());
    }

    private void validateDescriptions() {
        this.descriptionError.setStatus(ModelExtensionDefinitionValidator.validateTranslations((String)org.teiid.designer.extension.Messages.propertyDescription, (Collection)this.propDefn.getDescriptions(), (boolean)true));
        this.addMessage(this.descriptionError);
    }

    private void validateDisplayNames() {
        this.displayNameError.setStatus(ModelExtensionDefinitionValidator.validateTranslations((String)org.teiid.designer.extension.Messages.propertyDisplayName, (Collection)this.propDefn.getDisplayNames(), (boolean)true));
        this.addMessage(this.displayNameError);
    }

    private void validateIndex() {
        this.indexedError.setStatus(ModelExtensionDefinitionValidator.validatePropertyIndexedAttribute((boolean)this.propDefn.shouldBeIndexed()));
        this.addMessage(this.indexedError);
    }

    private void validateInitialValue(boolean shouldHaveInitialValue, boolean valueIsFixed) {
        if (shouldHaveInitialValue) {
            if (valueIsFixed) {
                this.initialValueError.setStatus(ModelExtensionDefinitionValidator.validatePropertyFixedValue((String)this.propDefn.getRuntimeType(), (String)this.propDefn.getFixedValue(), (String[])this.propDefn.getAllowedValues()));
            } else {
                this.initialValueError.setStatus(ModelExtensionDefinitionValidator.validatePropertyDefaultValue((String)this.propDefn.getRuntimeType(), (String)this.propDefn.getDefaultValue(), (String[])this.propDefn.getAllowedValues()));
            }
        } else {
            this.initialValueError.setMessage(null);
        }
        this.addMessage(this.initialValueError);
    }

    private void validateMasked() {
        this.maskedError.setStatus(ModelExtensionDefinitionValidator.validatePropertyMaskedAttribute((boolean)this.propDefn.isMasked()));
        this.addMessage(this.maskedError);
    }

    private void validateRequired() {
        this.requiredError.setStatus(ModelExtensionDefinitionValidator.validatePropertyRequiredAttribute((boolean)this.propDefn.isRequired()));
        this.addMessage(this.requiredError);
    }

    private void validateSimpleId() {
        String simpleId = this.propDefn.getSimpleId();
        this.simpleIdError.setStatus(ModelExtensionDefinitionValidator.validatePropertySimpleId((String)simpleId));
        if (!this.simpleIdError.isError() && !CoreStringUtil.isEmpty((String)simpleId) && this.existingPropIds.contains(simpleId)) {
            this.simpleIdError.setStatus((MedStatus)ValidationStatus.createErrorMessage((String)NLS.bind((String)org.teiid.designer.extension.Messages.duplicatePropertyIdValidatinMsg, (Object)simpleId)));
        }
        this.addMessage(this.simpleIdError);
    }

    private void validateType() {
        this.typeError.setStatus(ModelExtensionDefinitionValidator.validatePropertyRuntimeType((String)this.propDefn.getRuntimeType()));
        this.addMessage(this.typeError);
        this.validateAllowedValues();
    }

    private static interface ColumnHeaders {
        public static final String LOCALE = Messages.localeColumnText;
        public static final String TRANSLATION = Messages.translationColumnText;
    }

    private static interface ColumnIndexes {
        public static final int LOCALE = 0;
        public static final int TRANSLATION = 1;
    }

    private static interface ColumnToolTips {
        public static final String LOCALE = Messages.localeColumnToolTip;
        public static final String TRANSLATION = Messages.translationColumnToolTip;
    }

    class TranslationLabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;

        public TranslationLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Translation translation = (Translation)element;
            if (this.columnIndex == 0) {
                return translation.getLocale().toString();
            }
            if (1 == this.columnIndex) {
                return translation.getTranslation();
            }
            return super.getText(element);
        }
    }
}

