/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

abstract class CComboProposalProvider
implements IControlContentAdapter,
IControlContentAdapter2,
IContentProposalProvider {
    private static final long DEFAULT_DURATION = 500L;
    private final CCombo combo;
    private long duration = 500L;
    private String pattern = "";
    private long t1 = System.currentTimeMillis();
    private long t2;

    protected CComboProposalProvider(CCombo combo) {
        this(combo, 500L);
    }

    protected CComboProposalProvider(CCombo combo, long duration) {
        this.duration = duration;
        this.combo = combo;
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CComboProposalProvider.this.handleKeyPressed(e);
            }
        });
    }

    protected abstract char[] getActivationChars();

    public final String getControlContents(Control control) {
        return this.combo.getText();
    }

    public final int getCursorPosition(Control control) {
        return this.combo.getSelection().x;
    }

    public final Rectangle getInsertionBounds(Control control) {
        int position = this.combo.getSelection().y;
        String contents = this.combo.getText();
        GC gc = new GC((Drawable)this.combo);
        gc.setFont(this.combo.getFont());
        Point extent = gc.textExtent(contents.substring(0, Math.min(position, contents.length())));
        gc.dispose();
        return new Rectangle(this.combo.getClientArea().x + extent.x, this.combo.getClientArea().y, 1, this.combo.getClientArea().height);
    }

    public final IContentProposal[] getProposals(String contents, int position) {
        if (this.combo.getListVisible()) {
            return new IContentProposal[0];
        }
        List<String> matches = this.proposalsFor(this.pattern);
        if (matches.isEmpty()) {
            return new IContentProposal[0];
        }
        IContentProposal[] proposals = new IContentProposal[matches.size()];
        int i = 0;
        for (String match : matches) {
            proposals[i++] = new ContentProposal(match);
        }
        return proposals;
    }

    public final Point getSelection(Control control) {
        return this.combo.getSelection();
    }

    final void handleKeyPressed(KeyEvent e) {
        this.t2 = System.currentTimeMillis();
        if (this.t2 - this.t1 > this.duration) {
            this.pattern = "";
        }
        this.t1 = this.t2;
        this.pattern = !Character.isLetter(e.character) ? "" : String.valueOf(this.pattern) + e.character;
    }

    final void init() {
        ContentProposalAdapter proposalAdapter = new ContentProposalAdapter((Control)this.combo, (IControlContentAdapter)this, (IContentProposalProvider)this, null, this.getActivationChars());
        proposalAdapter.setProposalAcceptanceStyle(2);
    }

    public final void insertControlContents(Control control, String text, int cursorPosition) {
        String contents = this.combo.getText();
        Point selection = this.combo.getSelection();
        StringBuilder builder = new StringBuilder();
        builder.append(contents.substring(0, selection.x)).append(text);
        if (selection.y < contents.length()) {
            builder.append(contents.substring(selection.y, contents.length()));
        }
        this.setText(builder.toString());
    }

    protected abstract List<String> proposalsFor(String var1);

    public final void setControlContents(Control control, String contents, int cursorPosition) {
        this.setText(contents);
        this.setCursorPosition(control, cursorPosition);
    }

    public final void setCursorPosition(Control control, int index) {
        this.combo.setSelection(new Point(index, index));
    }

    public final void setSelection(Control control, Point range) {
        this.combo.setSelection(range);
    }

    private void setText(String newSelection) {
        int index = this.combo.indexOf(newSelection);
        if (index != -1) {
            this.combo.select(index);
        }
    }
}

