/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.actions;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.wizards.ManageModelExtensionDefnsWizard;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ManageModelExtensionDefnsAction
extends SortableSelectionAction {
    private final ModelExtensionRegistry registry = Platform.isRunning() ? ExtensionPlugin.getInstance().getRegistry() : null;

    public ManageModelExtensionDefnsAction() {
        super(Messages.manageModelExtensionDefnsActionTitle, -1);
    }

    public boolean isValidSelection(ISelection selection) {
        return this.canManageModelSelected(selection);
    }

    public void run() {
        ModelResource modelResource = null;
        if (!this.getSelection().isEmpty()) {
            IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
            modelResource = ModelUtilities.getModelResource((Object)modelFile);
        }
        if (modelResource != null) {
            StructuredSelection structuredSelection = new StructuredSelection(modelResource);
            ManageModelExtensionDefnsWizard wizard = new ManageModelExtensionDefnsWizard();
            IFile file = (IFile)modelResource.getResource();
            ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)file, (boolean)true);
            if (editor != null && editor.isDirty()) {
                boolean doContinue = MessageDialog.openQuestion((Shell)wizard.getShell(), (String)Messages.manageModelExtensionDefnsActionModelDirtyTitle, (String)Messages.manageModelExtensionDefnsActionModelDirtyMsg);
                if (!doContinue) {
                    return;
                }
                ModelEditorManager.save((IFile)file);
            }
            wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), (IStructuredSelection)structuredSelection);
            WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public boolean isApplicable(ISelection selection) {
        return this.canManageModelSelected(selection);
    }

    private boolean canManageModelSelected(ISelection theSelection) {
        Object selectedObj;
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1 && this.isModelFile(selectedObj = allObjs.get(0))) {
            Collection meds = this.registry.getAllDefinitions();
            for (ModelExtensionDefinition med : meds) {
                ModelExtensionAssistant assistant = med.getModelExtensionAssistant();
                if (!assistant.supportsMedOperation("ADD_MED_TO_MODEL", selectedObj) && !assistant.supportsMedOperation("DELETE_MED_FROM_MODEL", selectedObj)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isModelFile(Object obj) {
        IPath path;
        if (obj instanceof IFile && (path = ((IFile)obj).getLocation()) != null) {
            return ModelFileUtil.isModelFile((File)path.toFile());
        }
        return false;
    }
}

