/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLFactoryImpl;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.wizards.NewWSDLWizard;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFileOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFilePage;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;

public class NewWSDLFileWizard
extends NewWSDLWizard {
    private static final String DOT_WSDL = ".wsdl";
    private String _createdFilePath = null;
    private WSDLFileCreationPage _filePage = null;
    private WSDLNewFileOptionsPage _optionsPage;
    private BindingGenerator _generator = new BindingGenerator(null, null);
    private String _initialName = null;
    private IStructuredSelection _selection = null;
    private IFile _fNewFile = null;
    private boolean _fOpenEditorWhenFinished = false;

    public boolean performFinish() {
        if (this._filePage != null) {
            this._fNewFile = this._filePage.createNewFile();
            if (this._fNewFile == null) {
                return false;
            }
            String charSet = "UTF-8";
            String wsdlPrefix = "wsdl";
            Vector namespaces = this._optionsPage.getNamespaceInfo();
            String prefix = this._optionsPage.getPrefix();
            String definitionName = this._optionsPage.getDefinitionName();
            URI uri2 = URI.createPlatformResourceURI((String)this._fNewFile.getFullPath().toOSString(), (boolean)false);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI((String)"*.wsdl"));
            resource.setURI(uri2);
            WSDLFactoryImpl factory = new WSDLFactoryImpl();
            DefinitionImpl definition = (DefinitionImpl)factory.createDefinition();
            resource.getContents().add((Object)definition);
            definition.setTargetNamespace(this._optionsPage.getTargetNamespace());
            definition.setLocation(this._fNewFile.getLocation().toString());
            definition.setEncoding(charSet);
            definition.setQName(new QName(wsdlPrefix, definitionName));
            definition.addNamespace(prefix, this._optionsPage.getTargetNamespace());
            int i = 0;
            while (i < namespaces.size()) {
                NamespaceInfo info = (NamespaceInfo)namespaces.get(i);
                if (info.prefix.length() > 0) {
                    definition.addNamespace(info.prefix, info.uri);
                } else {
                    definition.addNamespace(null, info.uri);
                }
                ++i;
            }
            definition.updateElement(true);
            try {
                if (this._optionsPage.getCreateSkeletonBoolean()) {
                    CreateWSDLElementHelper.PART_TYPE_OR_DEFINITION = this._optionsPage.isSoapDocLiteralProtocol() ? "ELEMENT_DECLARATION" : "TYPE_DEFINITION";
                    CreateWSDLElementHelper.serviceName = definitionName;
                    String protocolName = new String();
                    String protocol = this._optionsPage.getProtocol();
                    ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
                    ContentGeneratorUIExtension extension = registry.getExtensionForLabel(protocol);
                    if (extension != null) {
                        protocolName = extension.getName();
                    }
                    CreateWSDLElementHelper.portName = String.valueOf(definitionName) + protocolName;
                    this.createPortType(definitionName, wsdlPrefix, prefix, charSet, factory);
                    Service service = CreateWSDLElementHelper.createService((Definition)definition);
                    Iterator bindingIt = definition.getEBindings().iterator();
                    Binding binding = null;
                    if (bindingIt.hasNext()) {
                        binding = (Binding)bindingIt.next();
                    }
                    this._generator.setDefinition((Definition)definition);
                    this._generator.setBinding(binding);
                    Port port = (Port)service.getEPorts().iterator().next();
                    this._generator.setName(ComponentReferenceUtil.getName((Binding)port.getEBinding()));
                    this._generator.setRefName(ComponentReferenceUtil.getPortTypeReference((Binding)port.getEBinding()));
                    this._generator.setOverwrite(true);
                    this._generator.generateBinding();
                    this._generator.generatePortContent();
                }
                resource.save(null);
            }
            catch (Exception e) {
                System.out.println("\nCould not write new WSDL file in WSDL Wizard: " + e);
            }
            if (this.getSelection().getFirstElement() instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)this.getSelection().getFirstElement();
                IResource pkgresource = root.getResource();
                if (pkgresource == null) {
                    IJavaElement element = root.getParent();
                    pkgresource = element.getResource();
                }
                if (this._fNewFile instanceof IFile) {
                    pkgresource = this._fNewFile.getParent();
                }
                if (pkgresource instanceof IFolder) {
                    IFolder folder = (IFolder)pkgresource;
                    IFolder parent = (IFolder)folder.getParent();
                    this._createdFilePath = this._fNewFile.getProjectRelativePath().makeRelativeTo(parent.getProjectRelativePath()).toPortableString();
                }
            } else {
                this._createdFilePath = this._fNewFile.getProjectRelativePath().toPortableString();
            }
            if (this._fOpenEditorWhenFinished) {
                NewWSDLFileWizard.openEditor((IFile)this._fNewFile);
            }
            return true;
        }
        return false;
    }

    public IStructuredSelection getSelection() {
        return this._selection;
    }

    public String getCreatedFilePath() {
        return this._createdFilePath;
    }

    public void setStartingFileName(String filename) {
        this._initialName = filename;
    }

    public String getStartingFileName() {
        return this._initialName;
    }

    public void setOpenOnFinish(boolean flag) {
        this._fOpenEditorWhenFinished = flag;
    }

    public void addPages() {
        this._filePage = new WSDLFileCreationPage(this.getSelection());
        this._optionsPage = new WSDLNewFileOptionsPage(Messages._UI_TITLE_OPTIONS, Messages._UI_TITLE_OPTIONS, null, (WizardNewFileCreationPage)this._filePage);
        this._optionsPage.setBindingGenerator(this._generator);
        this.addPage((IWizardPage)this._filePage);
        this.addPage((IWizardPage)this._optionsPage);
    }

    public IPath getNewFilePath() {
        String fileName = this._filePage.getFileName();
        return fileName != null ? new Path(fileName) : null;
    }

    public IFile getNewFile() {
        return this._fNewFile;
    }

    public boolean canFinish() {
        return this._filePage.isPageComplete() && this._optionsPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(org.switchyard.tools.ui.i18n.Messages.NewWSDLFileWizard_wizardTitle);
        this._selection = currentSelection;
    }

    private void createPortType(String definitionName, String wsdlPrefix, String prefix, String charSet, WSDLFactoryImpl factory) throws IOException {
        IPreferenceStore preferenceStore = WSDLEditorPlugin.getInstance().getPreferenceStore();
        boolean createPortTypeInSeparateWSDL = preferenceStore.getBoolean("generateSeparateInterface");
        if (createPortTypeInSeparateWSDL) {
            CreateWSDLElementHelper.IMPORT_PORT_TYPE_FROM_ANOTHER_FILE = false;
            CreateWSDLElementHelper.portTypeName = definitionName;
            IFile portTypeFile = this.getIntfFile(this._fNewFile);
            URI portTypeURI = URI.createPlatformResourceURI((String)portTypeFile.getFullPath().toOSString(), (boolean)false);
            ResourceSetImpl portTypeResourceSet = new ResourceSetImpl();
            WSDLResourceImpl portTypeResource = (WSDLResourceImpl)portTypeResourceSet.createResource(URI.createURI((String)"*.wsdl"));
            portTypeResource.setURI(portTypeURI);
            DefinitionImpl portTypeDefinition = (DefinitionImpl)factory.createDefinition();
            portTypeResource.getContents().add((Object)portTypeDefinition);
            String portTypeNamespace = this.getPortTypeDefaultTargetNamespace();
            portTypeDefinition.setTargetNamespace(portTypeNamespace);
            portTypeDefinition.setLocation(portTypeFile.getLocation().toString());
            portTypeDefinition.setEncoding(charSet);
            portTypeDefinition.setQName(new QName(wsdlPrefix, String.valueOf(definitionName) + this.getPortTypeFileSuffix()));
            portTypeDefinition.addNamespace(prefix, portTypeNamespace);
            portTypeDefinition.updateElement(true);
            CreateWSDLElementHelper.createPortType((Definition)portTypeDefinition);
            portTypeResource.save(null);
            CreateWSDLElementHelper.portTypeNamespace = portTypeDefinition.getTargetNamespace();
            CreateWSDLElementHelper.portTypePrefix = this.getPortTypeDefaultPrefix();
            CreateWSDLElementHelper.portTypeLocation = portTypeFile.getName();
            CreateWSDLElementHelper.IMPORT_PORT_TYPE_FROM_ANOTHER_FILE = true;
        } else {
            CreateWSDLElementHelper.portTypeName = null;
            CreateWSDLElementHelper.portTypeNamespace = null;
            CreateWSDLElementHelper.portTypePrefix = null;
            CreateWSDLElementHelper.portTypeLocation = null;
            CreateWSDLElementHelper.IMPORT_PORT_TYPE_FROM_ANOTHER_FILE = false;
        }
    }

    private String getPortTypeFileSuffix() {
        return WSDLEditorPlugin.getInstance().getPreferenceStore().getString("interfaceFileSuffix");
    }

    private String getPortTypeDefaultPrefix() {
        return WSDLEditorPlugin.getInstance().getPreferenceStore().getString("interfaceDefaultPrefix");
    }

    private String getPortTypeDefaultTargetNamespace() {
        return WSDLEditorPlugin.getInstance().getPreferenceStore().getString("interfaceDefaultTargetNamespace");
    }

    private IFile getIntfFile(IFile file) {
        String baseName = file.getFullPath().removeFileExtension().lastSegment();
        String suffix = String.valueOf(this.getPortTypeFileSuffix()) + DOT_WSDL;
        String fileName = String.valueOf(baseName) + suffix;
        IContainer parent = file.getParent();
        IFile result = parent.getFile((IPath)new Path(fileName));
        if (!result.exists()) {
            return result;
        }
        int count = 1;
        while (count < 100) {
            fileName = String.valueOf(baseName) + count + suffix;
            result = parent.getFile((IPath)new Path(fileName));
            if (!result.exists()) break;
            ++count;
        }
        return result;
    }

    private class WSDLFileCreationPage
    extends WSDLNewFilePage {
        public WSDLFileCreationPage(IStructuredSelection selection) {
            super(selection);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (this.getWizard() instanceof NewWSDLFileWizard) {
                NewWSDLFileWizard wizard = (NewWSDLFileWizard)this.getWizard();
                if (wizard.getStartingFileName() != null) {
                    this.setFileName(wizard.getStartingFileName());
                } else {
                    this.setFileName(this.computeDefaultFileName());
                }
            }
            this.setPageComplete(this.validatePage());
        }

        protected void createAdvancedControls(Composite parent) {
        }

        protected IStatus validateLinkedResource() {
            return Status.OK_STATUS;
        }

        protected void createLinkTarget() {
        }
    }
}

