/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.explorer.IArtifactsNode;
import org.switchyard.tools.ui.explorer.IComponentsNode;
import org.switchyard.tools.ui.explorer.IReferencesNode;
import org.switchyard.tools.ui.explorer.IServicesNode;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.ISwitchYardRootNode;
import org.switchyard.tools.ui.explorer.impl.ArtifactsNode;
import org.switchyard.tools.ui.explorer.impl.ComponentsNode;
import org.switchyard.tools.ui.explorer.impl.ReferencesNode;
import org.switchyard.tools.ui.explorer.impl.ServicesNode;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardRootNode
implements ISwitchYardRootNode {
    private ISwitchYardProject _switchYardProject;
    private SwitchYardModel _configuration;
    private IServicesNode _servicesNode;
    private IReferencesNode _referencesNode;
    private IComponentsNode _componentsNode;
    private IArtifactsNode _artifactsNode;

    public SwitchYardRootNode(IProject project) {
        this._switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(project);
    }

    @Override
    public synchronized IServicesNode getServicesNode() {
        if (this._servicesNode == null) {
            this._servicesNode = new ServicesNode(this, this._configuration);
        }
        return this._servicesNode;
    }

    @Override
    public synchronized IReferencesNode getReferencesNode() {
        if (this._referencesNode == null) {
            this._referencesNode = new ReferencesNode(this, this._configuration);
        }
        return this._referencesNode;
    }

    @Override
    public synchronized IComponentsNode getComponentsNode() {
        if (this._componentsNode == null) {
            this._componentsNode = new ComponentsNode(this, this._configuration);
        }
        return this._componentsNode;
    }

    @Override
    public synchronized IArtifactsNode getArtifactsNode() {
        if (this._artifactsNode == null) {
            this._artifactsNode = new ArtifactsNode(this, this._configuration);
        }
        return this._artifactsNode;
    }

    @Override
    public ISwitchYardProject getSwitchYardProject() {
        return this._switchYardProject;
    }

    @Override
    public IProject getProject() {
        return this._switchYardProject.getProject();
    }

    @Override
    public ISwitchYardNode getParent() {
        return null;
    }

    @Override
    public synchronized String getTargetNamespace() {
        if (this._configuration == null) {
            return null;
        }
        if (this._configuration.getTargetNamespace() != null) {
            return this._configuration.getTargetNamespace();
        }
        if (this._configuration.getComposite() != null) {
            return this._configuration.getComposite().getTargetNamespace();
        }
        return null;
    }

    public synchronized SwitchYardModel getModel() {
        return this._configuration;
    }

    public void dispose() {
        this.resetState();
        this._switchYardProject = null;
    }

    @Override
    public synchronized String getName() {
        if (this._configuration == null) {
            return this.getProject().getName();
        }
        if (this._configuration.getName() != null) {
            return this._configuration.getName();
        }
        if (this._configuration.getComposite() != null) {
            return this._configuration.getComposite().getName();
        }
        return null;
    }

    @Override
    public ISwitchYardRootNode getRoot() {
        return this;
    }

    public synchronized void reload(IProgressMonitor monitor) {
        this.resetState();
        try {
            IFile outputFile = this._switchYardProject.getOutputSwitchYardConfigurationFile();
            if (outputFile == null || !outputFile.exists()) {
                outputFile = this._switchYardProject.getSwitchYardConfigurationFile();
            }
            ModelPuller puller = new ModelPuller();
            this._configuration = (SwitchYardModel)puller.pull(outputFile.getContents());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", String.valueOf(Messages.SwitchYardRootNode_errorLogMessage_errorLoadingSYConfig) + this._switchYardProject.getProject(), (Throwable)e));
        }
        monitor.done();
    }

    private synchronized void resetState() {
        this._servicesNode = null;
        this._referencesNode = null;
        this._componentsNode = null;
        this._artifactsNode = null;
        this._configuration = null;
    }
}

