/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.List;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IComponentNode;
import org.switchyard.tools.ui.explorer.IComponentReference;
import org.switchyard.tools.ui.explorer.IComponentService;
import org.switchyard.tools.ui.explorer.IComponentsNode;
import org.switchyard.tools.ui.explorer.impl.ComponentReference;
import org.switchyard.tools.ui.explorer.impl.ComponentService;

public class ComponentNode
extends AbstractSwitchYardNode
implements IComponentNode {
    private ComponentModel _component;
    private List<IComponentService> _services;
    private List<IComponentReference> _references;

    public ComponentNode(IComponentsNode parent, ComponentModel component) {
        super(parent);
        this._component = component;
        List services = component.getServices();
        this._services = new ArrayList<IComponentService>(services.size());
        for (ComponentServiceModel service : services) {
            this._services.add(new ComponentService(this, service));
        }
        List references = component.getReferences();
        this._references = new ArrayList<IComponentReference>(references.size());
        for (ComponentReferenceModel reference : references) {
            this._references.add(new ComponentReference(this, reference));
        }
    }

    @Override
    public String getName() {
        return this._component.getName();
    }

    @Override
    public List<IComponentService> getServices() {
        return this._services;
    }

    @Override
    public List<IComponentReference> getReferences() {
        return this._references;
    }

    public ComponentModel getModel() {
        return this._component;
    }

    public int hashCode() {
        return this._component.getQName() == null ? super.hashCode() : this._component.getQName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentNode) {
            ComponentNode other = (ComponentNode)obj;
            return other.getRoot().equals(this.getRoot()) && other._component.getQName() != null && this._component.getQName() != null && other._component.getQName().equals(this._component.getQName());
        }
        return false;
    }
}

