/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.features.create.ext.CreateEndpointFigureFeature;
import org.fusesource.ide.camel.editor.provider.ext.ICustomPaletteEntry;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.catalog.Dependency;

public class BrokerPaletteEntry
implements ICustomPaletteEntry {
    private static final String PROTOCOL = "broker";

    @Override
    public ICreateFeature newCreateFeature(IFeatureProvider fp) {
        return new CreateEndpointFigureFeature(fp, "AMQ Broker", "Creates an ActiveMQ broker endpoint...", new Endpoint("broker:queue:foo"), this.getRequiredDependencies());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public boolean providesProtocol(String protocol) {
        return PROTOCOL.equalsIgnoreCase(protocol);
    }

    @Override
    public List<Dependency> getRequiredDependencies() {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        Dependency dep = new Dependency();
        dep.setGroupId("org.apache.activemq");
        dep.setArtifactId("activemq-camel");
        dep.setVersion("5.11.0.redhat-620133");
        deps.add(dep);
        dep = new Dependency();
        dep.setGroupId("org.apache.camel");
        dep.setArtifactId("camel-jms");
        dep.setVersion(Activator.getDefault().getCamelVersion());
        deps.add(dep);
        return deps;
    }
}

