/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.Messages;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.editor.features.custom.CreateNodeConnectionFeature;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.provider.ext.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Bean;
import org.fusesource.ide.camel.model.generated.Route;
import org.fusesource.ide.commons.camel.tools.BeanDef;
import org.fusesource.ide.commons.util.Strings;

public abstract class AbstractAddNodeMenuFactory {
    protected static final String DEFAULT_IMAGE_KEY = "org.fusesource.demo.icons.generic.png_small";
    private AbstractNode selectedNode;
    private RiderDesignEditor editor;

    public void setupMenuStructure(ContextMenuEntry rootMenu, ICustomContext context, IFeatureProvider fp, ArrayList<IToolEntry> toolEntries) {
        AbstractNode selectedNode = AbstractAddNodeMenuFactory.getSelectedNode(context, fp);
        boolean onlyEndpoints = false;
        if (selectedNode instanceof Route || selectedNode == null) {
            onlyEndpoints = true;
        }
        ContextMenuEntry connectorsEntry = new ContextMenuEntry(null, null);
        connectorsEntry.setText(Messages.connectorsDrawerTitle);
        connectorsEntry.setSubmenu(true);
        ContextMenuEntry endpointsEntry = new ContextMenuEntry(null, null);
        endpointsEntry.setText(Messages.endpointsDrawerTitle);
        endpointsEntry.setSubmenu(true);
        ContextMenuEntry routingEntry = new ContextMenuEntry(null, (IContext)context);
        routingEntry.setText(Messages.routingDrawerTitle);
        routingEntry.setSubmenu(true);
        ContextMenuEntry controlFlowEntry = new ContextMenuEntry(null, (IContext)context);
        controlFlowEntry.setText(Messages.controlFlowDrawerTitle);
        controlFlowEntry.setSubmenu(true);
        ContextMenuEntry transformationEntry = new ContextMenuEntry(null, (IContext)context);
        transformationEntry.setText(Messages.transformationDrawerTitle);
        transformationEntry.setSubmenu(true);
        ContextMenuEntry miscEntry = new ContextMenuEntry(null, (IContext)context);
        miscEntry.setText(Messages.miscellaneousDrawerTitle);
        miscEntry.setSubmenu(true);
        this.fillEndpointsContextMenu(connectorsEntry, context, fp);
        this.fillAdditionalEndpointsContextMenu(connectorsEntry, context, fp, toolEntries);
        if (!onlyEndpoints) {
            this.fillRoutingContextMenu(routingEntry, context, fp);
            this.fillControlFlowContextMenu(controlFlowEntry, context, fp);
            this.fillTransformationContextMenu(transformationEntry, context, fp);
            this.fillMiscellaneousContextMenu(miscEntry, context, fp);
        }
        if (selectedNode != null) {
            ContextMenuEntry values;
            boolean useChildMenu;
            Set<Endpoint> endpoints = AbstractNodes.getAllEndpoints(selectedNode);
            SortedMap<String, BeanDef> beans = AbstractNodes.getAllBeans(selectedNode);
            if (endpoints.size() <= 0) {
                beans.size();
            }
            if (endpoints.size() > 0) {
                useChildMenu = false;
                if (useChildMenu) {
                    values = new ContextMenuEntry(null, null);
                    values.setText(Messages.endpointsDrawerTitle);
                    values.setSubmenu(true);
                    this.addEndpointInstances(values, endpoints, context, fp);
                    endpointsEntry.add((IContextMenuEntry)values);
                } else {
                    this.addEndpointInstances(endpointsEntry, endpoints, context, fp);
                }
            }
            if (beans.size() > 0) {
                useChildMenu = false;
                if (useChildMenu) {
                    values = new ContextMenuEntry(null, null);
                    values.setText(Messages.endpointsDrawerTitle);
                    values.setSubmenu(true);
                    this.addBeanInstances(values, beans, context, fp);
                    endpointsEntry.add((IContextMenuEntry)values);
                } else {
                    this.addBeanInstances(endpointsEntry, beans, context, fp);
                }
            }
        }
        this.sortMenuByItemName(connectorsEntry);
        this.sortMenuByItemName(endpointsEntry);
        rootMenu.add((IContextMenuEntry)connectorsEntry);
        rootMenu.add((IContextMenuEntry)endpointsEntry);
        rootMenu.add((IContextMenuEntry)routingEntry);
        rootMenu.add((IContextMenuEntry)controlFlowEntry);
        rootMenu.add((IContextMenuEntry)transformationEntry);
        rootMenu.add((IContextMenuEntry)miscEntry);
    }

    private void sortMenuByItemName(ContextMenuEntry menuEntry) {
        Arrays.sort(menuEntry.getChildren(), new Comparator<IContextMenuEntry>(){

            @Override
            public int compare(IContextMenuEntry o1, IContextMenuEntry o2) {
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        });
    }

    protected void addBeanInstances(ContextMenuEntry menu, Map<String, BeanDef> beans, ICustomContext context, IFeatureProvider fp) {
        ArrayList<String> processedBeans = new ArrayList<String>();
        for (Map.Entry<String, BeanDef> entry : beans.entrySet()) {
            final String name = entry.getKey();
            final String aClass = beans.get(name).getClassName();
            if (Strings.isBlank((String)name) && Strings.isBlank((String)aClass) || !beans.get(name).getBeanType().equalsIgnoreCase("bean") || processedBeans.contains(name)) continue;
            processedBeans.add(name);
            String description = "bean '" + name + "' of type " + aClass;
            this.addMenuItem(menu, name, description, Bean.class, context, fp, new CreateNodeConnectionFeature(fp, Bean.class){

                @Override
                protected AbstractNode createNode(ICustomContext ctx) throws Exception {
                    Bean bean = new Bean();
                    bean.setName(name);
                    bean.setRef(name);
                    bean.setBeanType(aClass);
                    return bean;
                }
            });
        }
    }

    protected void addEndpointInstances(ContextMenuEntry menu, Set<Endpoint> endpoints, ICustomContext context, IFeatureProvider fp) {
        TreeMap<String, Endpoint> map = new TreeMap<String, Endpoint>();
        ArrayList<String> processedURIs = new ArrayList<String>();
        for (final Endpoint endpoint : endpoints) {
            map.put(endpoint.getDisplayText(), endpoint);
        }
        for (final Endpoint endpoint : map.values()) {
            String id = endpoint.getId();
            String url = endpoint.getUri();
            if (Strings.isBlank((String)id) && Strings.isBlank((String)url) || processedURIs.contains(url)) continue;
            processedURIs.add(url);
            String description = endpoint.getDescription();
            String title = endpoint.getDisplayText();
            this.addMenuItem(menu, title, description, Endpoint.class, context, fp, new CreateNodeConnectionFeature(fp, Endpoint.class){

                @Override
                protected AbstractNode createNode(ICustomContext ctx) throws Exception {
                    return new Endpoint(endpoint);
                }
            });
        }
    }

    protected void addMenuItem(ContextMenuEntry parent, String label, String description, Class<? extends AbstractNode> clazz, ICustomContext context, IFeatureProvider fp) {
        this.addMenuItem(parent, label, description, clazz, context, fp, (ObjectCreationToolEntry)null);
    }

    protected void addMenuItem(ContextMenuEntry parent, String label, String description, Class<? extends AbstractNode> clazz, ICustomContext context, IFeatureProvider fp, ObjectCreationToolEntry octe) {
        CreateNodeConnectionFeature feature = new CreateNodeConnectionFeature(fp, clazz, octe);
        this.addMenuItem(parent, label, description, clazz, context, fp, feature);
    }

    protected void addMenuItem(ContextMenuEntry parent, String label, String description, Class<? extends AbstractNode> clazz, ICustomContext context, IFeatureProvider fp, CreateNodeConnectionFeature feature) {
        AbstractAddNodeMenuFactory.getSelectedNode(context, fp);
        Object newObject = this.newInstance(clazz);
        if (newObject instanceof AbstractNode) {
            AbstractNode cfr_ignored_0 = (AbstractNode)newObject;
            ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)feature, (IContext)context);
            menuEntry.setText(label);
            menuEntry.setDescription(description);
            try {
                AbstractNode node = clazz.newInstance();
                String iconName = node.getIconName();
                menuEntry.setIconId(ImageProvider.getKeyForSmallIcon(iconName));
            }
            catch (Exception exception) {
                menuEntry.setIconId(DEFAULT_IMAGE_KEY);
            }
            menuEntry.setSubmenu(false);
            parent.add((IContextMenuEntry)menuEntry);
        }
    }

    public static AbstractNode getSelectedNode(ICustomContext context, IFeatureProvider fp) {
        RiderDesignEditor editor;
        Object bo;
        RouteSupport selectedNode = null;
        PictogramElement[] elements = context.getPictogramElements();
        if (elements != null && elements.length > 0 && (bo = fp.getBusinessObjectForPictogramElement(elements[0])) instanceof AbstractNode) {
            selectedNode = (AbstractNode)bo;
        }
        if (selectedNode == null && (editor = RiderDesignEditor.toRiderDesignEditor(fp)) != null) {
            selectedNode = editor.getSelectedRoute();
        }
        return selectedNode;
    }

    public void fillMenu(RiderDesignEditor editor, Menu menu, ArrayList<IToolEntry> additionalEndpoints) {
        block5: {
            ArrayList<MenuManager> menus;
            block4: {
                MenuManager subMenu;
                this.editor = editor;
                this.selectedNode = editor.getSelectedNode();
                menus = new ArrayList<MenuManager>();
                if (this.selectedNode instanceof RouteContainer && !(this.selectedNode instanceof RouteSupport)) {
                    subMenu = new MenuManager(EditorMessages.paletteRouteTitle, "org.fusesource.ide.actions.add.routes");
                    this.addMenuItem((IMenuManager)subMenu, EditorMessages.addRouteTitle, EditorMessages.addRouteDescription, Route.class);
                    this.addMenu(menus, subMenu);
                } else {
                    subMenu = new MenuManager(Messages.endpointsDrawerTitle, "org.fusesource.ide.actions.add.endpoints");
                    this.fillEndpointsMenu((IMenuManager)subMenu);
                    this.fillAdditionalEndpointsMenu((IMenuManager)subMenu, additionalEndpoints);
                    Arrays.sort(subMenu.getItems(), new Comparator<IContributionItem>(){

                        @Override
                        public int compare(IContributionItem o1, IContributionItem o2) {
                            return o1.getId().compareToIgnoreCase(o2.getId());
                        }
                    });
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.routingDrawerTitle, "org.fusesource.ide.actions.add.routing");
                    this.fillRoutingMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.controlFlowDrawerTitle, "org.fusesource.ide.actions.add.control");
                    this.fillControlFlowMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.transformationDrawerTitle, "org.fusesource.ide.actions.add.transformation");
                    this.fillTransformationMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.miscellaneousDrawerTitle, "org.fusesource.ide.actions.add.miscellaneous");
                    this.fillMiscellaneousMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                }
                int index = menu.getItemCount();
                if (menus.size() != 1) break block4;
                MenuManager childMenu = (MenuManager)menus.get(0);
                IContributionItem[] items = childMenu.getItems();
                childMenu.removeAll();
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.fill(menu, index++);
                    ++n2;
                }
                break block5;
            }
            if (menus.size() <= 1) break block5;
            for (MenuManager childMenu : menus) {
                childMenu.fill(menu, menu.getItemCount());
            }
        }
    }

    public void fillMenu(RiderDesignEditor editor, MenuManager menu, AbstractNode node, ArrayList<IToolEntry> additionalEndpoints) {
        block5: {
            ArrayList<MenuManager> menus;
            block4: {
                MenuManager subMenu;
                this.editor = editor;
                this.selectedNode = node;
                menus = new ArrayList<MenuManager>();
                if (this.selectedNode instanceof RouteContainer && !(this.selectedNode instanceof RouteSupport)) {
                    subMenu = new MenuManager(EditorMessages.paletteRouteTitle, "org.fusesource.ide.actions.add.routes");
                    this.addMenuItem((IMenuManager)subMenu, EditorMessages.addRouteTitle, EditorMessages.addRouteDescription, Route.class);
                    this.addMenu(menus, subMenu);
                } else {
                    subMenu = new MenuManager(Messages.endpointsDrawerTitle, "org.fusesource.ide.actions.add.endpoints");
                    this.fillEndpointsMenu((IMenuManager)subMenu);
                    this.fillAdditionalEndpointsMenu((IMenuManager)subMenu, additionalEndpoints);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.routingDrawerTitle, "org.fusesource.ide.actions.add.routing");
                    this.fillRoutingMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.controlFlowDrawerTitle, "org.fusesource.ide.actions.add.control");
                    this.fillControlFlowMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.transformationDrawerTitle, "org.fusesource.ide.actions.add.transformation");
                    this.fillTransformationMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                    subMenu = new MenuManager(Messages.miscellaneousDrawerTitle, "org.fusesource.ide.actions.add.miscellaneous");
                    this.fillMiscellaneousMenu((IMenuManager)subMenu);
                    this.addMenu(menus, subMenu);
                }
                if (menus.size() != 1) break block4;
                MenuManager childMenu = (MenuManager)menus.get(0);
                IContributionItem[] items = childMenu.getItems();
                childMenu.removeAll();
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    menu.add(item);
                    ++n2;
                }
                break block5;
            }
            if (menus.size() <= 1) break block5;
            for (MenuManager childMenu : menus) {
                menu.add((IContributionItem)childMenu);
            }
        }
    }

    protected void addMenu(List<MenuManager> menus, MenuManager subMenu) {
        IContributionItem[] items = subMenu.getItems();
        if (items != null && items.length > 0) {
            menus.add(subMenu);
        }
    }

    protected void addMenuItem(IMenuManager menu, String title, String description, final Class<? extends AbstractNode> aClass) {
        AbstractNode newNode;
        Object newObject = this.newInstance(aClass);
        if (newObject instanceof AbstractNode && ((newNode = (AbstractNode)newObject) instanceof RouteSupport || this.selectedNode != null && this.selectedNode.canConnectTo(newNode))) {
            final AbstractNode node = this.selectedNode;
            Action action = new Action(){

                public void runWithEvent(Event event) {
                    if (newNode instanceof Route) {
                        AbstractAddNodeMenuFactory.this.editor.addNewRoute();
                    } else {
                        DiagramOperations.addNode(AbstractAddNodeMenuFactory.this.editor, aClass, node);
                    }
                }
            };
            action.setId("org.fusesource.ide.actions.add." + newNode.getPatternName());
            action.setText(title);
            action.setToolTipText(description);
            action.setDescription(description);
            action.setImageDescriptor(this.getImageDescriptor(newNode.getSmallIconName()));
            menu.add((IAction)action);
        }
    }

    protected Object newInstance(Class<?> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to create instance of " + aClass.getName() + ". " + e, (Throwable)e);
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return org.fusesource.ide.camel.model.Activator.getDefault().getImageDescriptor(key);
    }

    private void fillAdditionalEndpointsContextMenu(ContextMenuEntry menu, ICustomContext context, IFeatureProvider fp, ArrayList<IToolEntry> toolEntries) {
        for (IToolEntry te : toolEntries) {
            PaletteCategoryItemProvider pcip;
            ObjectCreationToolEntry octe;
            if (!(te instanceof ObjectCreationToolEntry) || !((octe = (ObjectCreationToolEntry)te).getCreateFeature() instanceof PaletteCategoryItemProvider) || (pcip = (PaletteCategoryItemProvider)octe.getCreateFeature()) == null || pcip.getCategoryType() != PaletteCategoryItemProvider.CATEGORY_TYPE.COMPONENTS) continue;
            CreateFigureFeature cff = (CreateFigureFeature)octe.getCreateFeature();
            this.addMenuItem(menu, octe.getLabel(), octe.getDescription(), cff.getClazz(), context, fp, octe);
        }
    }

    private void fillAdditionalEndpointsMenu(IMenuManager menu, ArrayList<IToolEntry> toolEntries) {
        for (IToolEntry te : toolEntries) {
            if (!(te instanceof ObjectCreationToolEntry)) continue;
            ObjectCreationToolEntry octe = (ObjectCreationToolEntry)te;
            this.addMenuItem(menu, octe.getLabel(), octe.getDescription(), Endpoint.class);
        }
    }

    protected abstract void fillTransformationContextMenu(ContextMenuEntry var1, ICustomContext var2, IFeatureProvider var3);

    protected abstract void fillControlFlowContextMenu(ContextMenuEntry var1, ICustomContext var2, IFeatureProvider var3);

    protected abstract void fillRoutingContextMenu(ContextMenuEntry var1, ICustomContext var2, IFeatureProvider var3);

    protected abstract void fillEndpointsContextMenu(ContextMenuEntry var1, ICustomContext var2, IFeatureProvider var3);

    protected abstract void fillMiscellaneousContextMenu(ContextMenuEntry var1, ICustomContext var2, IFeatureProvider var3);

    protected abstract void fillTransformationMenu(IMenuManager var1);

    protected abstract void fillControlFlowMenu(IMenuManager var1);

    protected abstract void fillRoutingMenu(IMenuManager var1);

    protected abstract void fillEndpointsMenu(IMenuManager var1);

    protected abstract void fillMiscellaneousMenu(IMenuManager var1);
}

