/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.propertysheet.CamelComponentUtils;
import org.fusesource.ide.camel.editor.propertysheet.PropertiesUtils;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.catalog.components.Component;
import org.fusesource.ide.camel.model.catalog.components.UriParameter;
import org.fusesource.ide.camel.model.catalog.components.UriParameterKind;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.util.Strings;

public class AdvancedEndpointPropertiesSection
extends AbstractPropertySection {
    private FormToolkit toolkit;
    private Form form;
    private CTabFolder tabFolder;
    private CTabItem pathTab;
    private CTabItem commonTab;
    private CTabItem consumerTab;
    private CTabItem producerTab;
    private Endpoint selectedEP;
    private DataBindingContext dbc;
    private IObservableMap modelMap = new WritableMap();
    private Component component;

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.component = null;
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.dbc = new DataBindingContext();
        Object o = Selections.getFirstSelection((ISelection)selection);
        AbstractNode n = AbstractNodes.toAbstractNode(o);
        if (n instanceof Endpoint) {
            this.selectedEP = (Endpoint)n;
            this.component = PropertiesUtils.getComponentFor(this.selectedEP);
            this.form.setText("Advanced Properties - " + DiagramUtils.filterFigureLabel(this.selectedEP.getDisplayText()));
        } else {
            this.selectedEP = null;
            this.form.setText("Advanced Properties");
        }
        int idx = Math.max(this.tabFolder.getSelectionIndex(), 0);
        if (this.pathTab != null) {
            this.pathTab.dispose();
        }
        if (this.commonTab != null) {
            this.commonTab.dispose();
        }
        if (this.consumerTab != null) {
            this.consumerTab.dispose();
        }
        if (this.producerTab != null) {
            this.producerTab.dispose();
        }
        this.createPathTab(this.tabFolder);
        this.createCommonsTab(this.tabFolder);
        this.createConsumerTab(this.tabFolder);
        this.createProducerTab(this.tabFolder);
        this.tabFolder.setSingle(this.tabFolder.getItemCount() == 1);
        this.tabFolder.setSelection(Math.min(idx, this.tabFolder.getItemCount() - 1));
    }

    protected void generateTabContents(List<UriParameter> props, final Composite page, boolean ignorePathProperties) {
        Collections.sort(props, new Comparator<UriParameter>(){

            @Override
            public int compare(UriParameter o1, UriParameter o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (UriParameter p : props) {
            Text txtField;
            if (ignorePathProperties && p.getKind() != null && p.getKind().equalsIgnoreCase("path")) continue;
            final UriParameter prop = p;
            ISWTObservableValue uiObservable = null;
            IObservableValue modelObservable = null;
            Object validator = null;
            String s = Strings.humanize((String)p.getName());
            if (p.getDeprecated() != null && p.getDeprecated().equalsIgnoreCase("true")) {
                s = String.valueOf(s) + " (deprecated)";
            }
            Label l = this.toolkit.createLabel(page, s);
            l.setLayoutData((Object)new GridData());
            if (p.getDescription() != null) {
                l.setToolTipText(p.getDescription());
            }
            if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                l.setForeground(Display.getDefault().getSystemColor(9));
            }
            Text c = null;
            if (CamelComponentUtils.isBooleanProperty(prop)) {
                Button checkBox = this.toolkit.createButton(page, "", 2080);
                Boolean b = (Boolean)PropertiesUtils.getTypedPropertyFromUri(this.selectedEP, prop, this.component);
                checkBox.setSelection(b.booleanValue());
                checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, ((Button)e.getSource()).getSelection(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                checkBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = checkBox;
                this.modelMap.put((Object)p.getName(), (Object)checkBox.getSelection());
                uiObservable = WidgetProperties.selection().observe((Widget)checkBox);
            } else if (CamelComponentUtils.isTextProperty(prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = txtField;
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (AdvancedEndpointPropertiesSection.this.selectedEP.getUri().startsWith("ref:")) {
                                String refId;
                                String string = refId = AdvancedEndpointPropertiesSection.this.selectedEP.getUri().trim().length() > "ref:".length() ? AdvancedEndpointPropertiesSection.this.selectedEP.getUri().substring("ref:".length()) : null;
                                if (refId == null || refId.trim().length() < 1 || AdvancedEndpointPropertiesSection.this.selectedEP.getParent().getParent().getCamelContextEndpointUris().get(refId) == null) {
                                    return ValidationStatus.error((String)"The entered reference does not exist in your context!");
                                }
                            }
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isNumberProperty(prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 133124);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        String val = txt.getText();
                        try {
                            Double.parseDouble(val);
                            txt.setBackground(ColorConstants.white);
                            PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                        }
                        catch (NumberFormatException numberFormatException) {
                            txt.setBackground(ColorConstants.red);
                            return;
                        }
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = txtField;
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
                validator = new IValidator(){

                    public IStatus validate(Object value) {
                        if (prop.getRequired() != null && prop.getRequired().equalsIgnoreCase("true") && (value == null || value.toString().trim().length() < 1)) {
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                        if (value != null && value.toString().trim().length() > 0) {
                            try {
                                Double.parseDouble(value.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                return ValidationStatus.error((String)("The parameter " + prop.getName() + " requires a numeric value."));
                            }
                        }
                        return ValidationStatus.ok();
                    }
                };
            } else if (CamelComponentUtils.isChoiceProperty(prop)) {
                CCombo choiceCombo = new CCombo(page, 0x80080C);
                this.toolkit.adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setItems(CamelComponentUtils.getChoices(prop));
                int i = 0;
                while (i < choiceCombo.getItems().length) {
                    if (choiceCombo.getItem(i).equalsIgnoreCase(PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component))) {
                        choiceCombo.select(i);
                        break;
                    }
                    ++i;
                }
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, choice.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                choiceCombo.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isFileProperty(prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                Button btn_browse = this.toolkit.createButton(page, "...", 2056);
                btn_browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DirectoryDialog dd = new DirectoryDialog(page.getShell());
                        String pathName = dd.open();
                        if (pathName != null) {
                            txtField.setText(pathName);
                        }
                    }
                });
                btn_browse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                c = txtField;
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isExpressionProperty(prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = txtField;
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else if (CamelComponentUtils.isUnsupportedProperty(prop)) {
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                c = txtField;
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            } else {
                Class<?> classToLoad;
                txtField = this.toolkit.createText(page, PropertiesUtils.getPropertyFromUri(this.selectedEP, prop, this.component), 18436);
                txtField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Text txt = (Text)e.getSource();
                        PropertiesUtils.updateURIParams(AdvancedEndpointPropertiesSection.this.selectedEP, prop, txt.getText(), AdvancedEndpointPropertiesSection.this.component, AdvancedEndpointPropertiesSection.this.modelMap);
                    }
                });
                txtField.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                URLClassLoader child = CamelComponentUtils.getProjectClassLoader();
                try {
                    classToLoad = prop.getJavaType().indexOf("<") != -1 ? child.loadClass(prop.getJavaType().substring(0, prop.getJavaType().indexOf("<"))) : child.loadClass(prop.getJavaType());
                }
                catch (ClassNotFoundException ex) {
                    Activator.getLogger().warning("Cannot find class " + prop.getJavaType() + " on classpath.", (Throwable)ex);
                    classToLoad = null;
                }
                final IProject project = Activator.getDiagramEditor().getCamelContextFile().getProject();
                final Class<?> fClass = classToLoad;
                Button btn_create = this.toolkit.createButton(page, " + ", 2056);
                btn_create.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String value;
                        NewClassCreationWizard wiz = new NewClassCreationWizard();
                        wiz.addPages();
                        wiz.init(PlatformUI.getWorkbench(), null);
                        NewClassWizardPage wp = (NewClassWizardPage)wiz.getStartingPage();
                        WizardDialog wd = new WizardDialog(e.display.getActiveShell(), (IWizard)wiz);
                        if (fClass.isInterface()) {
                            wp.setSuperInterfaces(Arrays.asList(fClass.getName()), true);
                        } else {
                            wp.setSuperClass(fClass.getName(), true);
                        }
                        wp.setAddComments(true, true);
                        IPackageFragmentRoot fragroot = null;
                        try {
                            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
                            IPath[] paths = facade.getCompileSourceLocations();
                            if (paths != null && paths.length > 0) {
                                IPath[] iPathArray = paths;
                                int n = paths.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IPath p = iPathArray[n2];
                                    if (p != null) {
                                        IResource res = project.findMember(p);
                                        fragroot = javaProject.getPackageFragmentRoot(res);
                                        break;
                                    }
                                    ++n2;
                                }
                                if (fragroot != null) {
                                    wp.setPackageFragmentRoot(fragroot, true);
                                }
                                wp.setPackageFragment(PropertiesUtils.getPackage(javaProject, fragroot), true);
                            }
                        }
                        catch (Exception ex) {
                            Activator.getLogger().error((Throwable)ex);
                        }
                        if (wd.open() == 0 && (value = wp.getCreatedType().getFullyQualifiedName()) != null) {
                            txtField.setText(value);
                        }
                    }
                });
                btn_create.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                btn_create.setEnabled(fClass != null);
                Button btn_browse = this.toolkit.createButton(page, "...", 2056);
                btn_browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            Object o;
                            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                            IJavaElement[] elements = new IJavaElement[]{javaProject};
                            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
                            FilteredTypesSelectionDialog dlg = new FilteredTypesSelectionDialog(Display.getDefault().getActiveShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 5);
                            if (dlg.open() == 0 && (o = dlg.getFirstResult()) instanceof SourceType) {
                                txtField.setText(((SourceType)o).getFullyQualifiedName());
                            }
                        }
                        catch (Exception ex) {
                            Activator.getLogger().error((Throwable)ex);
                        }
                    }
                });
                btn_browse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
                btn_browse.setEnabled(fClass != null);
                c = txtField;
                if (p.getRequired() != null && p.getRequired().equalsIgnoreCase("true")) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
                this.modelMap.put((Object)p.getName(), (Object)txtField.getText());
                uiObservable = WidgetProperties.text((int)24).observe((Widget)txtField);
            }
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setBeforeSetValidator(validator);
            modelObservable = Observables.observeMapEntry((IObservableMap)this.modelMap, (Object)p.getName());
            Binding bindValue = this.dbc.bindValue((IObservableValue)uiObservable, modelObservable, strategy, null);
            ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
            if (p.getDescription() == null) continue;
            c.setToolTipText(p.getDescription());
        }
    }

    private void createPathTab(CTabFolder folder) {
        List<UriParameter> props = PropertiesUtils.getPathProperties(this.selectedEP);
        if (props.isEmpty()) {
            return;
        }
        this.pathTab = new CTabItem(this.tabFolder, 0);
        this.pathTab.setText("Path");
        Composite page = this.toolkit.createComposite((Composite)folder);
        page.setLayout((Layout)new GridLayout(4, false));
        this.generateTabContents(props, page, false);
        this.pathTab.setControl((Control)page);
    }

    private void createCommonsTab(CTabFolder folder) {
        List<UriParameter> props = PropertiesUtils.getPropertiesFor(this.selectedEP, UriParameterKind.BOTH);
        if (props.isEmpty()) {
            return;
        }
        this.commonTab = new CTabItem(this.tabFolder, 0);
        this.commonTab.setText("General");
        Composite page = this.toolkit.createComposite((Composite)folder);
        page.setLayout((Layout)new GridLayout(4, false));
        this.generateTabContents(props, page, true);
        this.commonTab.setControl((Control)page);
    }

    private void createConsumerTab(CTabFolder folder) {
        List<UriParameter> props = PropertiesUtils.getPropertiesFor(this.selectedEP, UriParameterKind.CONSUMER);
        if (props.isEmpty()) {
            return;
        }
        this.consumerTab = new CTabItem(this.tabFolder, 0);
        this.consumerTab.setText("Consumer");
        Composite page = this.toolkit.createComposite((Composite)folder);
        page.setLayout((Layout)new GridLayout(4, false));
        this.generateTabContents(props, page, true);
        this.consumerTab.setControl((Control)page);
    }

    private void createProducerTab(CTabFolder folder) {
        List<UriParameter> props = PropertiesUtils.getPropertiesFor(this.selectedEP, UriParameterKind.PRODUCER);
        if (props.isEmpty()) {
            return;
        }
        this.producerTab = new CTabItem(this.tabFolder, 0);
        this.producerTab.setText("Producer");
        Composite page = this.toolkit.createComposite((Composite)folder);
        page.setLayout((Layout)new GridLayout(4, false));
        this.generateTabContents(props, page, true);
        this.producerTab.setControl((Control)page);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        this.tabFolder = new CTabFolder(sbody, 0x800080);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{20}, true);
        this.tabFolder.setCursor(FormsResources.getHandCursor());
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.form.setText("Advanced Properties");
        this.toolkit.decorateFormHeading(this.form);
        this.form.layout();
        this.tabFolder.setSelection(0);
    }
}

