/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.commons.util.Strings;

public class SwitchRouteAction
extends Action {
    private RouteSupport route;
    private int counter;

    public SwitchRouteAction(RouteSupport route, int counter) {
        this.route = route;
        this.counter = counter;
    }

    public void run() {
        RiderDesignEditor editor = Activator.getDiagramEditor();
        editor.setSelectedRouteIndex(this.counter);
    }

    public String getText() {
        String id = this.route.getId();
        if (Strings.isBlank((String)id)) {
            id = "" + (this.counter + 1);
        }
        return "Route: " + id;
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("route16.png");
    }

    public boolean isChecked() {
        RiderDesignEditor editor = Activator.getDiagramEditor();
        RouteSupport selectedRoute = editor.getSelectedRoute();
        return this.route == selectedRoute;
    }

    public int getStyle() {
        return 2;
    }
}

