/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create.ext;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.features.create.ext.CreateFigureFeature;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ConnectorEndpoint;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.catalog.components.Component;
import org.fusesource.ide.commons.util.Strings;

public class CreateConnectorFigureFeature
extends CreateFigureFeature<Endpoint> {
    private final ConnectorEndpoint endpoint;
    protected final Component component;

    public CreateConnectorFigureFeature(IFeatureProvider fp, Component component) {
        super(fp, Strings.isBlank((String)component.getTitle()) ? Strings.humanize((String)component.getSchemeTitle()) : component.getTitle(), component.getDescription(), Endpoint.class);
        this.endpoint = new ConnectorEndpoint(component.getSyntax() != null ? component.getSyntax() : String.format("%s:", component.getScheme()));
        this.setExemplar((AbstractNode)this.endpoint);
        this.component = component;
    }

    @Override
    protected String getIconName() {
        return String.format("%s.png", this.component.getSchemeTitle().replaceAll("-", "_"));
    }

    @Override
    protected AbstractNode createNode() {
        return new ConnectorEndpoint(this.endpoint);
    }

    @Override
    public Object[] create(ICreateContext context) {
        try {
            this.updateMavenDependencies(this.component.getDependencies());
        }
        catch (CoreException ex) {
            Activator.getLogger().error("Unable to add the component dependency to the project maven configuration file.", (Throwable)ex);
        }
        return super.create(context);
    }

    public Component getConnector() {
        return this.component;
    }
}

