/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.IPrefersPerspective;
import org.fusesource.ide.camel.editor.Messages;
import org.fusesource.ide.camel.editor.editor.GlobalConfigEditor;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditorData;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Route;
import org.fusesource.ide.camel.model.io.ICamelEditorInput;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.preferences.PreferenceManager;

public class RiderEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ITabbedPropertySheetPageContributor,
IPrefersPerspective,
IPropertyChangeListener {
    public static final String RIDER_PERSPECTIVE_ID = "org.fusesource.ide.branding.perspective";
    public static final int DESIGN_PAGE_INDEX = 0;
    public static final int SOURCE_PAGE_INDEX = 1;
    public static final int GLOBAL_CONF_INDEX = 2;
    private StructuredTextEditor sourceEditor;
    private RiderDesignEditor designEditor;
    private GlobalConfigEditor globalConfigEditor;
    private ISelection savedSelection;
    private RiderDesignEditorData designEditorData = new RiderDesignEditorData();
    private int designPageIndex;
    private int lastActivePageIdx = 0;
    private boolean processEvent = true;

    public RiderEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void markDirty() {
        this.designEditor.setDirty(true);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.closeEditorsWithoutValidInput();
                break;
            }
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage[] pages = RiderEditor.this.getSite().getWorkbenchWindow().getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorInput editorInput = RiderEditor.this.sourceEditor.getEditorInput();
                            if (editorInput instanceof FileEditorInput && ((FileEditorInput)editorInput).getFile().getProject().equals((Object)event.getResource())) {
                                IWorkbenchPage page = pages[i];
                                IEditorPart editorPart = page.findEditor(editorInput);
                                page.closeEditor(editorPart, true);
                            }
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void closeEditorsWithoutValidInput() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] eds;
                IEditorReference[] iEditorReferenceArray = eds = RiderEditor.this.getSite().getPage().getEditorReferences();
                int n = eds.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorInput editorInput;
                    IEditorReference er = iEditorReferenceArray[n2];
                    IEditorPart editor = er.getEditor(false);
                    if (editor != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput && !((FileEditorInput)editorInput).getFile().exists()) {
                        RiderEditor.this.getSite().getPage().closeEditor(er.getEditor(false), false);
                        if (er != null && er.getEditor(false) != null) {
                            er.getEditor(false).dispose();
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    protected void createPages() {
        this.createDesignPage(0);
        this.createSourcePage(1);
        IDocument document = this.getDocument();
        if (document == null) {
            throw new IllegalStateException("No Document available!");
        }
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                RiderEditor.this.designEditor.onTextEditorPropertyChange();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    private void createSourcePage(int index) {
        try {
            this.sourceEditor = new StructuredTextEditor();
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof ICamelEditorInput) {
                ICamelEditorInput camelEditorInput = (ICamelEditorInput)editorInput;
                editorInput = camelEditorInput.getFileEditorInput();
            }
            this.addPage(index, (IEditorPart)this.sourceEditor, editorInput);
            this.setPageText(index, Messages.editorSourcePageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createDesignPage(int index) {
        try {
            this.designEditor = new RiderDesignEditor(this);
            this.designPageIndex = index;
            IEditorInput editorInput = this.getEditorInput();
            this.addPage(index, (IEditorPart)this.designEditor, editorInput);
            this.setPageText(index, Messages.editorDesignPageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested design editor", null, (IStatus)e.getStatus());
        }
    }

    private void createGlobalConfPage(int index) {
        try {
            this.globalConfigEditor = new GlobalConfigEditor(this);
            IEditorInput editorInput = this.getEditorInput();
            this.addPage(index, (IEditorPart)this.globalConfigEditor, editorInput);
            this.setPageText(index, Messages.editorGlobalConfigurationPageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested global configuration page", null, (IStatus)e.getStatus());
        }
    }

    private Object getField(Object owner, String name, Class<?> aClass) {
        try {
            return Objects.getField((Object)owner, (String)name, aClass);
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to access field: " + name + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite partSite = part.getSite();
                part.dispose();
                if (partSite instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        String text;
        String newText;
        IDocument document;
        if (this.getActiveEditor() == null) {
            return;
        }
        boolean doSave = this.continueWithUnconnectedFigures();
        if (!doSave) {
            return;
        }
        if (this.getActiveEditor().equals(this.designEditor) && (document = this.getDocument()) != null && !Objects.equal((Object)(newText = this.designEditor.updateEditorText(text = document.get())), (Object)text)) {
            document.set(newText);
        }
        if (this.designEditor.getEditorInput() != null && this.designEditor.getEditorInput() instanceof ICamelEditorInput) {
            ICamelEditorInput camelInput = (ICamelEditorInput)this.designEditor.getEditorInput();
            IDocument doc = this.getDocument();
            if (doc != null) {
                String xml = doc.get();
                camelInput.save(xml);
            }
        } else {
            this.sourceEditor.doSave(monitor);
        }
        if ((document = this.getDocument()) != null) {
            this.designEditor.clearCache();
            text = document.get();
            Activator.getLogger().debug("Updating the design model from the updated text");
            this.designEditor.loadEditorText(text);
            this.designEditor.refreshDiagramContents();
            this.designEditor.fireModelChanged();
            this.sourceEditor.doRevertToSaved();
            this.designEditor.clearChangedFlags();
        }
    }

    public void doSaveAs() {
        if (this.getActiveEditor() == null) {
            return;
        }
        boolean doSave = this.continueWithUnconnectedFigures();
        if (!doSave) {
            return;
        }
        if (this.getActiveEditor().equals(this.designEditor)) {
            this.updatedDesignPage(false);
        }
        this.sourceEditor.doSaveAs();
        IDocument document = this.getDocument();
        if (document != null) {
            this.designEditor.clearCache();
            String text = document.get();
            Activator.getLogger().debug("Updating the design model from the updated text");
            this.designEditor.loadEditorText(text);
            this.designEditor.refreshDiagramContents();
            this.designEditor.fireModelChanged();
            this.designEditor.clearChangedFlags();
        }
    }

    protected void saveAsFile(IFile file) {
        ByteArrayInputStream source = new ByteArrayInputStream(this.getDocument().get().getBytes());
        try {
            if (file.exists()) {
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Activator.showUserError("Failed to save file", "Failed to write to " + file, (Exception)((Object)e));
        }
    }

    protected void doSaveAs(IEditorPart editor) {
        editor.doSaveAs();
        this.setPageText(1, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void saveSelection() {
        this.savedSelection = this.getActiveEditor().getEditorSite().getSelectionProvider().getSelection();
    }

    protected void restoreSelection() {
        this.getActiveEditor().getEditorSite().getSelectionProvider().setSelection(this.savedSelection);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        this.openPropertiesView();
    }

    private void openPropertiesView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow wbw;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (page = wbw.getActivePage()) != null) {
                    try {
                        if (page.findView("org.eclipse.ui.views.PropertySheet") == null) {
                            page.showView("org.eclipse.ui.views.PropertySheet");
                        }
                    }
                    catch (PartInitException ex) {
                        Activator.getLogger().error((Throwable)ex);
                    }
                }
            }
        });
    }

    protected void pageChange(int newPageIndex) {
        try {
            if (newPageIndex == 1) {
                boolean doPageChange = this.continueWithUnconnectedFigures();
                if (doPageChange) {
                    if (this.sourceEditor == null) {
                        this.sourceEditor = new StructuredTextEditor();
                    }
                    if (this.lastActivePageIdx == 0) {
                        this.updatedDesignPage();
                    }
                    if (this.lastActivePageIdx == 2) {
                        this.updatedConfigPage();
                    }
                } else {
                    this.setActivePage(0);
                    newPageIndex = 0;
                }
            } else if (newPageIndex == 0) {
                if (this.lastActivePageIdx == 1) {
                    this.updatedTextPage();
                }
                if (this.lastActivePageIdx == 2) {
                    this.updatedConfigPage();
                }
            } else {
                if (this.lastActivePageIdx == 0) {
                    this.updatedDesignPage();
                }
                if (this.lastActivePageIdx == 1) {
                    this.updatedTextPage();
                }
                this.globalConfigEditor.reload();
            }
        }
        finally {
            this.lastActivePageIdx = newPageIndex;
            super.pageChange(newPageIndex);
        }
    }

    private boolean continueWithUnconnectedFigures() {
        boolean unconnectedNodeFound = false;
        unconnectedNodeFound = this.findUnconnectedNode(this.designEditor.getModel().getChildren());
        if (!unconnectedNodeFound) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)EditorMessages.unconnectedNodeFoundTitle, (String)EditorMessages.unconnectedNodeFoundText);
    }

    private boolean findUnconnectedNode(List<AbstractNode> nodes) {
        boolean unconnected = false;
        for (AbstractNode node : nodes) {
            if (!(node instanceof Route) && node.getAllConnections().isEmpty()) {
                return true;
            }
            if (node.getChildren().isEmpty() || !(unconnected = this.findUnconnectedNode(node.getChildren()))) continue;
            return true;
        }
        return false;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    void updatedDesignPage() {
        this.updatedDesignPage(true);
    }

    void updatedDesignPage(boolean async) {
        this.designEditor.runIfDiagramModified(new Runnable(){

            @Override
            public void run() {
                IDocument document = RiderEditor.this.getDocument();
                if (document != null) {
                    String text = document.get();
                    String newText = RiderEditor.this.designEditor.updateEditorText(text);
                    if (!Objects.equal((Object)newText, (Object)text)) {
                        document.set(newText);
                    }
                }
            }
        }, async);
    }

    private void updatedTextPage() {
        this.designEditor.runIfTextModified(new Runnable(){

            @Override
            public void run() {
                IDocument document = RiderEditor.this.getDocument();
                if (document != null) {
                    RiderEditor.this.designEditor.clearCache();
                    String text = document.get();
                    Activator.getLogger().debug("Updating the design model from the updated text");
                    RiderEditor.this.designEditor.loadEditorText(text);
                    RiderEditor.this.designEditor.refreshDiagramContents();
                    RiderEditor.this.designEditor.update();
                    RiderEditor.this.designEditor.setFocus();
                    RiderEditor.this.designEditor.fireModelChanged();
                }
            }
        });
    }

    private void updatedConfigPage() {
    }

    public Object getAdapter(Class adapter) {
        Object answer;
        IEditorInput editorInput;
        if (adapter == RiderDesignEditor.class) {
            return this.designEditor;
        }
        if (adapter == TextEditor.class) {
            return this.sourceEditor;
        }
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (adapter == ActionRegistry.class) {
            return this.designEditor.getActionRegistry();
        }
        if (adapter == IDocumentProvider.class && (editorInput = this.getEditorInput()) != null && (answer = editorInput.getAdapter(adapter)) != null) {
            return answer;
        }
        return super.getAdapter(adapter);
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public RiderDesignEditor getDesignEditor() {
        return this.designEditor;
    }

    public GlobalConfigEditor getGlobalConfigEditor() {
        return this.globalConfigEditor;
    }

    public AbstractNode getSelectedNode() {
        return this.designEditor.getSelectedNode();
    }

    public void setSelectedNode(AbstractNode newSelection) {
        this.designEditor.setSelectedNode(newSelection);
    }

    public RouteContainer getModel() {
        return this.designEditor.getModel();
    }

    public RouteSupport getSelectedRoute() {
        return this.designEditor.getSelectedRoute();
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        this.designEditor.setSelectedRoute(selectedRoute);
    }

    public RiderDesignEditorData getDesignEditorData() {
        return this.designEditorData;
    }

    public IDocument getDocument() {
        IEditorInput element = this.sourceEditor.getEditorInput();
        IDocumentProvider documentProvider = this.sourceEditor.getDocumentProvider();
        if (documentProvider != null) {
            IDocument document = documentProvider.getDocument((Object)element);
            return document;
        }
        return null;
    }

    @Override
    public String getPreferredPerspectiveId() {
        return null;
    }

    public void onFileLoading(IFile file) {
        if (file instanceof IResource) {
            this.setPartName(file.getLocation().lastSegment());
        } else {
            this.setPartName(file.getName());
        }
    }

    public void onInputLoading(IEditorInput input) {
        this.setPartName(input.getName());
    }

    public void switchToDesignEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderEditor.this.updatedDesignPage();
                RiderEditor.this.setActiveEditor((IEditorPart)RiderEditor.this.getDesignEditor());
                RiderEditor.this.setActivePage(0);
                RiderEditor.this.getDesignEditor().setFocus();
            }
        });
    }

    public void switchToSourceEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderEditor.this.updatedDesignPage();
                RiderEditor.this.setActiveEditor((IEditorPart)RiderEditor.this.getSourceEditor());
                RiderEditor.this.setActivePage(1);
                RiderEditor.this.getSourceEditor().setFocus();
            }
        });
    }

    public void switchToGlobalConfigEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderEditor.this.setActiveEditor((IEditorPart)RiderEditor.this.getGlobalConfigEditor());
                RiderEditor.this.setActivePage(2);
                RiderEditor.this.getGlobalConfigEditor().setFocus();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("preferIdAsLabelPreference")) {
            this.designEditor.update();
        } else if (event.getProperty().equals("diagramLayoutOrientationPreference")) {
            this.designEditor.autoLayoutRoute();
        } else if (event.getProperty().equals("diagramGridVisibilityPreference")) {
            DiagramUtils.setGridVisible((Boolean)event.getNewValue(), this.designEditor);
        } else if (event.getProperty().equals("diagramTextColorPreference") || event.getProperty().equals("diagramConnectionColorPreference") || event.getProperty().equals("diagramFigureBackgroundColorPreference") || event.getProperty().equals("diagramFigureForegroundColorPreference")) {
            this.designEditor.getDiagramBehavior().refresh();
        } else if (event.getProperty().equals("diagramGridColorPreference")) {
            this.designEditor.setupGridVisibilityAsync();
        }
    }
}

