/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.commands.DiagramOperations;
import org.fusesource.ide.camel.editor.commands.ImportCamelContextElementsCommand;
import org.fusesource.ide.camel.editor.editor.CamelDiagramBehaviour;
import org.fusesource.ide.camel.editor.editor.INodeViewer;
import org.fusesource.ide.camel.editor.editor.ModelChangeListener;
import org.fusesource.ide.camel.editor.editor.PropertyChangeCommand;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditorData;
import org.fusesource.ide.camel.editor.editor.RiderEditor;
import org.fusesource.ide.camel.editor.editor.RiderEditorContextMenuProvider;
import org.fusesource.ide.camel.editor.outline.RiderOutlinePage;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Route;
import org.fusesource.ide.camel.model.io.ICamelEditorInput;
import org.fusesource.ide.camel.model.io.IRemoteCamelEditorInput;
import org.fusesource.ide.commons.camel.tools.ValidationHandler;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.CamelThread;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.util.CamelDebugContextEditorInput;
import org.fusesource.ide.preferences.PreferenceManager;

public class RiderDesignEditor
extends DiagramEditor
implements INodeViewer,
IDebugEventSetListener,
ISelectionListener,
IBreakpointsListener {
    private final RiderDesignEditorData data;
    private RiderEditor editor;
    private KeyHandler keyHandler;
    private AbstractEditPart selectedEditPart;
    private AbstractEditPart lastSelectedEditPart;
    private boolean asyncSwitchToSource;
    private boolean dirty = false;
    private boolean disableCommandEvents;
    private IEditorSite editorSite;
    private IEditorInput editorInput;
    private IProject container;
    private IFile camelContextFile;
    private RouteContainer model;
    private RouteSupport activeRoute;
    private CamelDiagramBehaviour camelDiagramBehaviour;
    private boolean graphitiDoesNotMarkAsDirty = true;
    private DesignerCache activeConfig;
    private Map<RouteSupport, DesignerCache> cache = new HashMap<RouteSupport, DesignerCache>();
    private AbstractNode highlightedNodeInDebugger;
    private PropertyChangeListener nodePropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CommandStack commandStack = RiderDesignEditor.this.getCommandStack();
            if (commandStack != null) {
                PropertyChangeCommand command = new PropertyChangeCommand(evt);
                commandStack.execute((org.eclipse.gef.commands.Command)command);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramOperations.updateSelectedNode(RiderDesignEditor.this);
                    RiderDesignEditor.this.getDiagramTypeProvider().getDiagramBehavior().refresh();
                }
            });
            if (RiderDesignEditor.this.selectedEditPart != null) {
                RiderDesignEditor.this.selectedEditPart.refresh();
            } else if (RiderDesignEditor.this.lastSelectedEditPart != null) {
                RiderDesignEditor.this.lastSelectedEditPart.refresh();
            }
        }
    };
    private Composite parent;

    public static RiderDesignEditor toRiderDesignEditor(IDiagramBehavior behavior) {
        if (behavior instanceof RiderDesignEditor) {
            return (RiderDesignEditor)behavior;
        }
        return null;
    }

    public static RiderDesignEditor toRiderDesignEditor(IFeatureProvider fp) {
        if (fp == null) {
            return null;
        }
        return RiderDesignEditor.toRiderDesignEditor(fp.getDiagramTypeProvider());
    }

    public static RiderDesignEditor toRiderDesignEditor(IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider == null) {
            return null;
        }
        return RiderDesignEditor.toRiderDesignEditor(diagramTypeProvider.getDiagramBehavior());
    }

    public RiderDesignEditor(RiderEditor parent) {
        ISelectionService sel;
        this.data = parent.getDesignEditorData();
        this.activeConfig = new DesignerCache();
        this.editor = parent;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()) != null) {
            sel.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void init(IEditorSite editorSite, IEditorInput input) throws PartInitException {
        this.editorSite = editorSite;
        this.editorInput = input;
        super.init(editorSite, input);
    }

    protected DiagramBehavior createDiagramBehavior() {
        this.camelDiagramBehaviour = new CamelDiagramBehaviour((IDiagramContainerUI)this);
        return this.camelDiagramBehaviour;
    }

    public DiagramBehavior getDiagramBehavior() {
        return this.camelDiagramBehaviour;
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.camelDiagramBehaviour.getConfigurationProvider();
    }

    public RiderEditor getMultiPageEditor() {
        return this.editor;
    }

    protected void setInput(IEditorInput input) {
        this.setPartName(input.getName());
        super.setInput(input);
        if (this.data.loadModelOnSetInput) {
            this.loadModelFromInput(input);
        }
        this.initializeDiagram(this.activeConfig.diagram);
        try {
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                CamelDebugContextEditorInput ips = entry.getEditorInput();
                IFile f = (IFile)ips.getAdapter(IFile.class);
                if (!f.getFullPath().toFile().getPath().equals(this.asFileEditorInput(input).getFile().getFullPath().toFile().getPath())) continue;
                String endpointId = null;
                Set ids = entry.getDebugTarget().getDebugger().getSuspendedBreakpointNodeIds();
                if (ids != null && ids.size() > 0) {
                    endpointId = (String)ids.iterator().next();
                }
                this.highlightBreakpointNodeWithID(endpointId);
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        this.getEditingDomain().getCommandStack().flush();
    }

    protected void initializeDiagramForSelectedRoute() {
        if (this.activeRoute == null || this.activeConfig == null) {
            return;
        }
        if (this.activeConfig.diagram == null) {
            this.activeConfig.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
            this.initializeDiagram(this.activeConfig.diagram);
        }
    }

    private void initializeDiagram(Diagram diagram) {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        if (diagramTypeProvider == null) {
            return;
        }
        if (diagramTypeProvider.getDiagram() != diagram) {
            diagramTypeProvider.resourceReloaded(this.activeConfig.diagram);
        }
        this.getEditingDomain().getCommandStack().execute((Command)new ImportCamelContextElementsCommand(this, this.getEditingDomain(), diagram));
        DiagramOperations.layoutDiagram(this);
        this.setupGridVisibilityAsync();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
    }

    protected void contributeToActionBars() {
        IActionBars bars = null;
        if (this.editorSite == null) {
            Activator.getLogger().warning("No IEditorSite registered for " + this);
            return;
        }
        bars = this.editorSite.getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    public Composite getParent() {
        return this.parent;
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
    }

    public String getCamelContextURI() {
        IFile file;
        RouteSupport selectedRoute = this.getSelectedRoute();
        String id = selectedRoute.getId();
        if (id == null || id.length() == 0) {
            id = "#" + selectedRoute.hashCode();
        }
        if ((file = this.getCamelContextFile()) != null) {
            return String.valueOf(file.getFullPath().toString()) + "_" + id;
        }
        IRemoteCamelEditorInput input = this.getRemoteCamelEditorInput();
        if (input != null) {
            return input.getUriText();
        }
        return id;
    }

    public IFile getCamelContextFile() {
        IFileEditorInput fileEditorInput = this.getFileEditorInput();
        if (fileEditorInput != null) {
            return fileEditorInput.getFile();
        }
        return null;
    }

    public void setCamelContextFile(IFile file) {
        this.camelContextFile = file;
    }

    protected IFileEditorInput getFileEditorInput() {
        return this.asFileEditorInput(this.editorInput);
    }

    protected IRemoteCamelEditorInput getRemoteCamelEditorInput() {
        return this.asRemoteCamelEditorInput(this.editorInput);
    }

    public IFileEditorInput asFileEditorInput(IEditorInput input) {
        URI uri;
        if (input instanceof IFileEditorInput) {
            return (IFileEditorInput)input;
        }
        if (input instanceof ICamelEditorInput) {
            ICamelEditorInput camelEditorInput = (ICamelEditorInput)input;
            IEditorInput fileEditorInput = camelEditorInput.getFileEditorInput();
            if (fileEditorInput instanceof IFileEditorInput) {
                return (IFileEditorInput)fileEditorInput;
            }
            if (fileEditorInput instanceof FileStoreEditorInput) {
                FileStoreEditorInput cfr_ignored_0 = (FileStoreEditorInput)fileEditorInput;
                return new FileEditorInput((IFile)input.getAdapter(IFile.class));
            }
        } else if (input instanceof IDiagramEditorInput && (uri = ((IDiagramEditorInput)input).getUri()).isPlatformResource()) {
            return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
        }
        return null;
    }

    public IRemoteCamelEditorInput asRemoteCamelEditorInput(IEditorInput input) {
        if (input instanceof IRemoteCamelEditorInput) {
            return (IRemoteCamelEditorInput)input;
        }
        if (input instanceof ICamelEditorInput) {
            ICamelEditorInput camelEditorInput = (ICamelEditorInput)input;
            IEditorInput fileEditorInput = camelEditorInput.getFileEditorInput();
            if (fileEditorInput instanceof IRemoteCamelEditorInput) {
                return (IRemoteCamelEditorInput)fileEditorInput;
            }
        } else {
            if (input instanceof IURIEditorInput) {
                final IURIEditorInput uriInput = (IURIEditorInput)input;
                return new IRemoteCamelEditorInput(){

                    public String getUriText() {
                        return uriInput.getName();
                    }

                    public String getXml() throws IOException {
                        return IOUtils.loadText((InputStream)uriInput.getURI().toURL().openStream(), (String)"UTF-8");
                    }
                };
            }
            if (input instanceof DiagramEditorInput) {
                final DiagramEditorInput uriInput = (DiagramEditorInput)input;
                return new IRemoteCamelEditorInput(){

                    public String getUriText() {
                        return uriInput.getName();
                    }

                    public String getXml() throws IOException {
                        try {
                            return IOUtils.loadText((InputStream)new java.net.URI(uriInput.getUri().toString()).toURL().openStream(), (String)"UTF-8");
                        }
                        catch (URISyntaxException e) {
                            throw new IOException("Unable to resolve resource.", e);
                        }
                    }
                };
            }
        }
        return null;
    }

    @Override
    public AbstractNode getSelectedNode() {
        return AbstractNodes.getSelectedNode(Selections.getSelection((IWorkbenchSite)this.getEditorSite()));
    }

    @Override
    public void setSelectedNode(AbstractNode newSelection) {
        if (newSelection != null) {
            EditPart selectEditPart = RiderDesignEditor.findEditPart(newSelection, (EditPart)this.getRootEditPart());
            if (selectEditPart != null) {
                this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)selectEditPart));
            } else {
                Activator.getLogger().error("Could not find editPart for selection: " + newSelection, (Throwable)new Exception());
            }
        }
        this.data.selectedNode = newSelection;
    }

    public static EditPart findEditPart(AbstractNode node, EditPart part) {
        EditPart nodeEditPart;
        AbstractNode modelNode;
        RootEditPart root;
        EditPart contents;
        if (part instanceof RootEditPart && (contents = (root = (RootEditPart)part).getContents()) != null) {
            return RiderDesignEditor.findEditPart(node, contents);
        }
        if (part instanceof EditPart && Objects.equal((Object)node, (Object)(modelNode = AbstractNodes.toAbstractNode(nodeEditPart = part)))) {
            return nodeEditPart;
        }
        List children = part.getChildren();
        for (EditPart childPart : children) {
            EditPart answer = RiderDesignEditor.findEditPart(node, childPart);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    public AbstractEditPart getLastSelectedEditPart() {
        return this.lastSelectedEditPart;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() == this.editor && this.editor.getActiveEditor() == this) {
            this.updateActions(this.getSelectionActions());
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof AbstractEditPart) {
                    this.selectedEditPart = (AbstractEditPart)firstElement;
                    AbstractNode node = AbstractNodes.toAbstractNode(firstElement);
                    if (node != null) {
                        if (this.data.selectedNode != null) {
                            this.data.selectedNode.removePropertyChangeListener(this.nodePropertyListener);
                        }
                        this.data.selectedNode = node;
                        this.data.selectedNode.addPropertyChangeListener(this.nodePropertyListener);
                    }
                    if (this.selectedEditPart != null) {
                        this.lastSelectedEditPart = this.selectedEditPart;
                    }
                } else if (firstElement instanceof CamelStackFrame) {
                    CamelStackFrame stackFrame = (CamelStackFrame)firstElement;
                    this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                } else if (firstElement instanceof CamelThread) {
                    CamelThread t = (CamelThread)firstElement;
                    try {
                        CamelStackFrame stackFrame = (CamelStackFrame)t.getTopStackFrame();
                        if (stackFrame != null) {
                            this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                        }
                    }
                    catch (DebugException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                }
            }
        }
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        RiderEditorContextMenuProvider provider = new RiderEditorContextMenuProvider(this, this, (EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.fireModelDirty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    protected void fireModelDirty() {
        this.setDirty(true);
        boolean changed = this.getCommandStack().isDirty();
        if (!this.disableCommandEvents && (changed || this.graphitiDoesNotMarkAsDirty)) {
            this.data.diagramChanged = true;
        }
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(final Object template) {
                if (template instanceof CreationFactory) {
                    return (CreationFactory)template;
                }
                if (template instanceof Class) {
                    return new SimpleFactory((Class)template);
                }
                Activator.getLogger().debug("============= Template: " + template + " is not a CreationFactory or Class! " + Objects.typeName((Object)template));
                return new CreationFactory(){

                    public Object getNewObject() {
                        return template;
                    }

                    public Object getObjectType() {
                        if (template == null) {
                            return null;
                        }
                        return template.getClass();
                    }
                };
            }
        };
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class || type == GraphicalEditorWithFlyoutPalette.class || type == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == EditDomain.class) {
            return this.getEditDomain();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == ZoomManager.class) {
            GraphicalViewer graphicalViewer = this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return null;
            }
            RootEditPart root = graphicalViewer.getRootEditPart();
            if (root instanceof ScalableRootEditPartAnimated) {
                ScalableRootEditPartAnimated scalableRoot = (ScalableRootEditPartAnimated)root;
                return scalableRoot.getZoomManager();
            }
            if (root instanceof ScalableRootEditPart) {
                return ((ScalableRootEditPart)root).getZoomManager();
            }
            return null;
        }
        if (type == IContentOutlinePage.class) {
            return new RiderOutlinePage(this);
        }
        return super.getAdapter(type);
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    private void handleLoadException(Exception e) {
        Activator.getLogger().error("** Load failed. Using default model. **", (Throwable)e);
        try {
            this.setModel(new RouteContainer());
        }
        catch (PartInitException partInitException) {
            Activator.getLogger().warning("Failed to reload the diagram: " + e, (Throwable)e);
        }
        this.getModel().setFailedToParseXml(true);
    }

    public void update() {
        DiagramOperations.updateDiagram(this);
        this.getDiagramBehavior().refresh();
        if (this.getDiagram() != null) {
            this.selectPictogramElements(new PictogramElement[]{this.getDiagram().getContainer()});
        }
    }

    public void fireModelChanged() {
        for (ModelChangeListener listener : this.data.modelChangeListeners) {
            listener.onModelChange();
        }
    }

    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public RouteContainer getModel() {
        if (this.data.model == null && this.editorInput != null) {
            this.data.lazyLoading = true;
            try {
                this.loadModelFromInput(this.editorInput);
            }
            finally {
                this.data.lazyLoading = false;
            }
        }
        return this.data.model;
    }

    public void setModel(RouteContainer model) throws PartInitException {
        if (model != this.data.model) {
            this.data.model = model;
            this.data.selectedRoute = null;
            this.setInitialRoute();
            if (this.data.selectedRouteIndex != this.data.indexOfRoute(this.data.selectedRoute) && this.data.selectedRouteIndex < this.data.model.getChildren().size()) {
                this.setSelectedRouteIndex(this.data.selectedRouteIndex);
            }
        }
    }

    public RouteSupport getSelectedRoute() {
        List children;
        if (this.data.selectedRoute == null && (children = this.getModel().getChildren()) != null) {
            AbstractNode node;
            int size = children.size();
            int idx = this.data.selectedRouteIndex;
            if (idx < 0 || idx >= size) {
                idx = 0;
            }
            if (size > 0 && (node = (AbstractNode)children.get(idx)) instanceof RouteSupport) {
                this.data.selectedRoute = (RouteSupport)node;
            }
        }
        if (this.data.selectedRoute == null) {
            this.setInitialRoute();
        }
        return this.data.selectedRoute;
    }

    public void clearSelectedRouteCache() {
        this.data.selectedRoute = null;
        this.data.selectedRouteIndex = -1;
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        if (this.data.selectedRoute != selectedRoute) {
            int index = this.data.indexOfRoute(selectedRoute);
            this.setSelectedRouteIndex(index);
        }
    }

    public void switchRoute(RouteSupport newRoute) {
        if (newRoute == this.activeRoute) {
            return;
        }
        if (this.activeRoute != null) {
            this.cache.put(this.activeRoute, this.activeConfig);
        }
        this.activeRoute = newRoute;
        if (this.cache.containsKey(newRoute)) {
            this.activeConfig = this.cache.get(newRoute);
        } else {
            DiagramEditorInput oldInput = this.activeConfig.input;
            this.activeConfig = new DesignerCache();
            this.activeConfig.input = oldInput;
        }
        this.refreshDiagramContents();
    }

    public void refreshDiagramContents() {
        this.initializeDiagramForSelectedRoute();
        if (this.activeConfig != null && this.activeConfig.diagram != null) {
            this.getDiagramTypeProvider().init(this.activeConfig.diagram, (IDiagramBehavior)this.getDiagramBehavior());
            this.getDiagramBehavior().getRefreshBehavior().initRefresh();
            this.setPictogramElementsForSelection(null);
            GraphicalViewer graphicalViewer = this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return;
            }
            graphicalViewer.setContents((Object)this.activeConfig.diagram);
            this.getDiagramBehavior().refreshContent();
        }
    }

    private void setInitialRoute() {
        if (this.getModel() != null) {
            if (this.getModel().getChildren().isEmpty()) {
                Route route = new Route();
                this.getModel().addChild((AbstractNode)route);
            }
            this.data.selectedRoute = this.activeRoute = (RouteSupport)this.getModel().getChildren().get(0);
        }
    }

    public void setSelectedRouteIndex(int index) {
        this.data.selectedRouteIndex = index;
        this.data.selectedRoute = (RouteSupport)this.getModel().getChildren().get(index);
        this.switchRoute(this.data.selectedRoute);
    }

    public void setupGridVisibilityAsync() {
        DiagramOperations.updateGridColor(this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor.this.setupGridVisibility();
            }
        });
    }

    private void setupGridVisibility() {
        boolean gridVisible = PreferenceManager.getInstance().loadPreferenceAsBoolean("diagramGridVisibilityPreference");
        DiagramUtils.setGridVisible(gridVisible, this);
        this.getDiagramBehavior().refresh();
    }

    public IProject getContainer() {
        return this.container;
    }

    public void setContainer(IProject container) {
        this.container = container;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    public SelectionSynchronizer getSelectionSyncer() {
        return this.getSelectionSynchronizer();
    }

    public KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public void dispose() {
        ISelectionService sel;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()) != null) {
            sel.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        this.editorInput = null;
        this.activeConfig = null;
        ActionRegistry actionRegistry = this.getActionRegistry();
        if (actionRegistry != null) {
            actionRegistry.dispose();
        }
        if (this.getDiagramTypeProvider() != null) {
            super.dispose();
        }
    }

    protected void loadModelFromInput(IEditorInput editorInput) {
        block12: {
            this.data.loaded = false;
            try {
                try {
                    if (editorInput instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)editorInput).getFile();
                        this.loadModelFromFile(file);
                        break block12;
                    }
                    if (editorInput instanceof ICamelEditorInput) {
                        ICamelEditorInput camelInput = (ICamelEditorInput)editorInput;
                        this.editor.onInputLoading((IEditorInput)camelInput);
                        this.setModel(camelInput.loadModel());
                        break block12;
                    }
                    if (editorInput instanceof IURIEditorInput) {
                        this.editor.onInputLoading(editorInput);
                        IURIEditorInput uriInput = (IURIEditorInput)editorInput;
                        java.net.URI uri = uriInput.getURI();
                        URL url = uri.toURL();
                        if (url == null) {
                            Activator.getLogger().warning("Unsupported URI type " + uri);
                        } else {
                            String xml = IOUtils.loadText((InputStream)url.openStream(), (String)"UTF-8");
                            this.setModel(this.data.marshaller.loadRoutesFromText(xml));
                        }
                        break block12;
                    }
                    this.editor.onInputLoading(editorInput);
                    Activator.getLogger().warning("Unsupported IEditorInput type " + editorInput);
                }
                catch (Exception e) {
                    this.handleLoadException(e);
                    this.switchToSourceEditor();
                    if (!this.asyncSwitchToSource) {
                        this.data.loaded = true;
                    }
                }
            }
            finally {
                if (!this.asyncSwitchToSource) {
                    this.data.loaded = true;
                }
            }
        }
    }

    protected void switchToSourceEditor() {
        this.asyncSwitchToSource = true;
        this.editor.switchToSourceEditor();
    }

    public void loadModelFromFile(IFile file) throws Exception {
        ValidationHandler status;
        this.editor.onFileLoading(file);
        this.setModel(this.data.marshaller.loadRoutes(file));
        if (file.getName().contentEquals("switchyard.xml")) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)EditorMessages.switchyardFoundTitle, (String)EditorMessages.switchyardFoundText);
            this.switchToSourceEditor();
        }
        if ((status = this.getModel().validate()).hasErrors()) {
            this.switchToSourceEditor();
        }
    }

    public void loadModelFromRemoteContext(ICamelEditorInput editorInput) throws IOException, PartInitException {
        this.editor.onInputLoading((IEditorInput)editorInput);
        this.setModel(editorInput.loadModel());
    }

    public void loadEditorText(String text) {
        try {
            this.setModel(this.data.marshaller.loadRoutesFromText(text));
            this.validateXml();
        }
        catch (Exception e) {
            this.showValidationError(e);
        }
    }

    public void validateXml() throws Exception {
        if (this.data.loaded) {
            if (this.getModel() == null || this.getModel().isFailedToParseXml()) {
                IDocument document = this.editor.getDocument();
                if (document != null) {
                    String text = document.get();
                    this.loadEditorText(text);
                }
            } else {
                ValidationHandler status = this.getModel().validate();
                if (status.hasErrors()) {
                    String error = status.userMessage();
                    this.showXmlValidationError(error);
                }
            }
        }
    }

    public void autoLayoutRoute() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiagramOperations.layoutDiagram(RiderDesignEditor.this);
            }
        });
    }

    public Diagram getDiagram() {
        return this.activeConfig == null ? null : this.activeConfig.diagram;
    }

    public void setTransactionalEditingDomain(TransactionalEditingDomain editingDomain) {
    }

    protected DiagramEditorInput getDiagramInput() {
        DiagramEditorInput diagramInput = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof DiagramEditorInput) {
            diagramInput = (DiagramEditorInput)input;
        }
        return diagramInput;
    }

    public IEditorInput getEditorInput() {
        if (this.editorInput != null) {
            return this.editorInput;
        }
        return super.getEditorInput();
    }

    public String updateEditorText(String editorXml) {
        return this.data.marshaller.updateText(editorXml, this.getModel());
    }

    public void runIfDiagramModified(Runnable block) {
        this.runIfDiagramModified(block, true);
    }

    public void runIfDiagramModified(Runnable block, boolean async) {
        this.data.shownValidationError = false;
        if (this.data.diagramChanged) {
            try {
                if (async) {
                    Display.getDefault().syncExec(block);
                } else {
                    block.run();
                }
            }
            finally {
                this.clearChangedFlags();
            }
        }
    }

    protected void clearChangedFlags() {
        this.data.diagramChanged = false;
        this.data.textChanged = false;
        this.getCommandStack().markSaveLocation();
        this.getEditingDomain().getCommandStack().flush();
        this.setDirty(false);
    }

    public void onTextEditorPropertyChange() {
        this.data.textChanged = true;
    }

    public void runIfTextModified(Runnable block) {
        block6: {
            try {
                try {
                    Display.getDefault().syncExec(block);
                    this.validateXml();
                }
                catch (Exception e) {
                    this.showValidationError(e);
                    this.clearChangedFlags();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.clearChangedFlags();
                throw throwable;
            }
            this.clearChangedFlags();
        }
        if (this.asyncSwitchToSource) {
            this.asyncSwitchToSource = false;
            this.data.loaded = true;
        }
    }

    protected void showValidationError(Exception e) {
        String text = e.getMessage();
        if (e instanceof RuntimeException) {
            Throwable cause = e.getCause();
            if (cause != null) {
                text = cause.getMessage();
                Activator.getLogger().error((Throwable)e);
            } else {
                Activator.getLogger().error((Throwable)e);
            }
        }
        this.showXmlValidationError(text);
    }

    public void showXmlValidationError(String text) {
        if (this.data.loaded && !this.data.shownValidationError) {
            String message = NLS.bind((String)EditorMessages.saveModifiedTextFailedText, (Object)text);
            this.data.shownValidationError = true;
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)EditorMessages.saveModifiedTextFailedTitle, (String)message);
        }
    }

    public void markXmlSaved() {
        CommandStack stack = this.getCommandStack();
        if (stack == null) {
            Activator.getLogger().warning("No command stack available when trying to save document!");
        } else {
            stack.markSaveLocation();
        }
    }

    public IFeatureProvider getFeatureProvider() {
        return this.getDiagramTypeProvider().getFeatureProvider();
    }

    protected RootEditPart getRootEditPart() {
        return this.getGraphicalViewer().getRootEditPart();
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.data.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.data.modelChangeListeners.remove(listener);
    }

    public void clearCache() {
        this.activeRoute = null;
        this.activeConfig.diagram = null;
        this.getDiagramTypeProvider().getDiagram().eResource().eAdapters().clear();
        this.getEditingDomain().getResourceSet().getResources().remove((Object)this.getDiagramTypeProvider().getDiagram().eResource());
    }

    public void addNewRoute() {
        DiagramOperations.addNewRoute(this);
    }

    public void deleteRoute() {
        RouteSupport selectedRoute = this.getSelectedRoute();
        if (selectedRoute != null) {
            DiagramOperations.deleteRoute(this, selectedRoute);
        }
    }

    public RiderEditor getEditor() {
        return this.editor;
    }

    public DesignerCache getActiveConfig() {
        return this.activeConfig;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor.this.refreshDiagramContents();
            }
        });
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor.this.refreshDiagramContents();
            }
        });
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor.this.refreshDiagramContents();
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent ev = debugEventArray[n2];
            if (ev.getSource() instanceof CamelThread || ev.getSource() instanceof CamelStackFrame) {
                if (ev.getSource() instanceof CamelThread && (ev.getKind() == 8 || ev.getKind() == 1)) {
                    this.resetHighlightBreakpointNode();
                } else if (ev.getSource() instanceof CamelThread) {
                    CamelThread thread = (CamelThread)ev.getSource();
                    if (ev.getKind() == 2 && ev.getDetail() == 16) {
                        try {
                            CamelStackFrame stackFrame = (CamelStackFrame)thread.getTopStackFrame();
                            if (stackFrame != null) {
                                this.highlightBreakpointNodeWithID(stackFrame.getEndpointId());
                            }
                        }
                        catch (DebugException ex) {
                            Activator.getLogger().error((Throwable)ex);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public synchronized AbstractNode getHighlightedNodeInDebugger() {
        return this.highlightedNodeInDebugger;
    }

    private synchronized void highlightBreakpointNodeWithID(String endpointNodeId) {
        AbstractNode node = this.getModel().getNode(endpointNodeId);
        if (node == null) {
            return;
        }
        if (this.highlightedNodeInDebugger != null && node.getId() != null && node.getId().equals(this.highlightedNodeInDebugger.getId())) {
            return;
        }
        this.resetHighlightBreakpointNode();
        this.setDebugHighLight(node, true);
        this.highlightedNodeInDebugger = node;
    }

    private synchronized void resetHighlightBreakpointNode() {
        this.setDebugHighLight(this.highlightedNodeInDebugger, false);
        this.highlightedNodeInDebugger = null;
    }

    private synchronized void setDebugHighLight(AbstractNode bo, boolean highlight) {
        if (bo == null) {
            return;
        }
        DiagramOperations.highlightNode(this, bo, highlight);
    }

    public class DesignerCache {
        public Diagram diagram;
        public DiagramEditorInput input;
    }
}

