/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.CamelModelLoader;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.RouteSupport;

public class ImportCamelContextElementsCommand
extends RecordingCommand {
    private final RiderDesignEditor designEditor;
    private TransactionalEditingDomain editingDomain;
    private Resource createdResource;
    private Diagram diagram;
    private IFeatureProvider featureProvider;

    public ImportCamelContextElementsCommand(RiderDesignEditor designEditor, TransactionalEditingDomain editingDomain, Diagram diagram) {
        super(editingDomain);
        this.diagram = diagram;
        this.designEditor = designEditor;
        this.editingDomain = editingDomain;
    }

    protected void doExecute() {
        RouteSupport selectedRoute = this.designEditor.getSelectedRoute();
        URI uri = URI.createPlatformResourceURI((String)this.designEditor.getCamelContextURI(), (boolean)true);
        this.createdResource = this.editingDomain.getResourceSet().createResource(uri);
        this.createdResource.getContents().add((Object)this.diagram);
        this.featureProvider = this.designEditor.getFeatureProvider();
        CamelModelLoader bpmnFileReader = new CamelModelLoader(this.diagram, this.featureProvider);
        Activator.getLogger().debug("Loading diagram: " + this.diagram + " with route: " + selectedRoute + " # " + System.identityHashCode(selectedRoute));
        try {
            bpmnFileReader.loadModel(selectedRoute);
        }
        catch (RuntimeException e) {
            Activator.getLogger().error("Failed to load model: " + e, (Throwable)e);
        }
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public Resource getCreatedResource() {
        return this.createdResource;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

