/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;

public class CamelModelChangeListener
implements ResourceSetListener {
    private IDiagramBehavior diagramBehavior;

    public CamelModelChangeListener(RiderDesignEditor riderDesignEditor) {
        this.setDiagramEditor((IDiagramBehavior)riderDesignEditor.getDiagramBehavior());
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (diagram != null && diagram.getPictogramLinks().size() == 0) {
            return;
        }
        HashSet<EObject> changedBOs = new HashSet<EObject>();
        List notifications = event.getNotifications();
        for (Notification notification : notifications) {
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject)) continue;
            changedBOs.add((EObject)notifier);
        }
        final PictogramElement[] dirtyPes = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(changedBOs.toArray());
        if (dirtyPes.length == 0) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CamelModelChangeListener.this.getDiagramTypeProvider().isAutoUpdateAtRuntime() && CamelModelChangeListener.this.getDiagramContainer().isDirty()) {
                    CamelModelChangeListener.this.getDiagramTypeProvider().getNotificationService().updatePictogramElements(dirtyPes);
                } else {
                    CamelModelChangeListener.this.getDiagramTypeProvider().getDiagramBehavior().refresh();
                }
            }
        });
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    private IDiagramTypeProvider getDiagramTypeProvider() {
        return this.getDiagramBehavior().getDiagramContainer().getDiagramTypeProvider();
    }

    private IDiagramContainer getDiagramContainer() {
        return this.getDiagramBehavior().getDiagramContainer();
    }

    private IDiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }

    private void setDiagramEditor(IDiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }
}

