/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.util.Locale;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;

public final class I18nUtil {
    public static Locale parseLocaleString(String localeString) {
        CoreArgCheck.isNotEmpty(localeString);
        if (CoreStringUtil.isEmpty(localeString)) {
            return null;
        }
        if ((localeString = localeString.trim()).toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        int languageIndex = localeString.indexOf(95);
        String language = null;
        if (languageIndex == -1) {
            return new Locale(localeString, "");
        }
        language = localeString.substring(0, languageIndex);
        int countryIndex = localeString.indexOf(95, languageIndex + 1);
        String country = null;
        if (countryIndex == -1) {
            country = localeString.substring(languageIndex + 1);
            return new Locale(language, country);
        }
        country = localeString.substring(languageIndex + 1, countryIndex);
        String variant = localeString.substring(countryIndex + 1);
        return new Locale(language, country, variant);
    }

    public static String getPropertyPrefix(Class clazz) {
        CoreArgCheck.isNotNull(clazz);
        return String.valueOf(clazz.getSimpleName()) + '.';
    }

    public static String getPropertyPrefix(Object object) {
        CoreArgCheck.isNotNull(object);
        return I18nUtil.getPropertyPrefix(object.getClass());
    }

    private I18nUtil() {
    }

    public static interface Constants {
        public static final char PROPERTY_NAME_SEPARATOR_CHAR = '.';
    }
}

