/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.OperationUtil;

public class FileUtils {
    public static final char SEPARATOR = '/';
    public static int DEFAULT_BUFFER_SIZE = 8092;
    public static String TEMP_DIRECTORY;
    public static final String JAVA_IO_TEMP_DIR = "java.io.tmpdir";
    private static final String TEMP_FILE = "delete.me";
    private static final String TEMP_FILE_RENAMED = "delete.me.old";
    public static final char[] SUFFIX_class;
    public static final char[] SUFFIX_CLASS;
    public static final char[] SUFFIX_java;
    public static final char[] SUFFIX_JAVA;
    public static final char[] SUFFIX_jar;
    public static final char[] SUFFIX_JAR;
    public static final char[] SUFFIX_zip;
    public static final char[] SUFFIX_ZIP;

    static {
        SUFFIX_class = ".class".toCharArray();
        SUFFIX_CLASS = ".CLASS".toCharArray();
        SUFFIX_java = ".java".toCharArray();
        SUFFIX_JAVA = ".JAVA".toCharArray();
        SUFFIX_jar = ".jar".toCharArray();
        SUFFIX_JAR = ".JAR".toCharArray();
        SUFFIX_zip = ".zip".toCharArray();
        SUFFIX_ZIP = ".ZIP".toCharArray();
        String tempDirPath = System.getProperty(JAVA_IO_TEMP_DIR);
        TEMP_DIRECTORY = tempDirPath.endsWith(File.separator) ? tempDirPath : String.valueOf(tempDirPath) + File.separator;
    }

    public static String toFileNameWithExtension(String name, String extension) {
        return FileUtils.toFileNameWithExtension(name, extension, false);
    }

    public static String toFileNameWithExtension(String name, String extension, boolean force) {
        boolean extBeginsWithExtChr;
        if (name == null) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.The_name_of_the_file_may_not_be_null", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (extension == null) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.The_file_extension_may_not_be_null", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (name.endsWith(extension)) {
            return name;
        }
        if (!force && name.indexOf(46) >= 0) {
            return name;
        }
        int nameLen = name.length() - 1;
        int extLen = extension.length();
        boolean nameEndsWithExtChr = nameLen >= 0 && name.charAt(nameLen) == '.';
        boolean bl = extBeginsWithExtChr = extLen > 0 && extension.charAt(0) == '.';
        if (nameEndsWithExtChr && extBeginsWithExtChr) {
            return String.valueOf(name.substring(0, nameLen)) + extension;
        }
        if (!nameEndsWithExtChr && !extBeginsWithExtChr) {
            return String.valueOf(name) + Constants.FILE_EXTENSION_SEPARATOR + extension;
        }
        return String.valueOf(name) + extension;
    }

    public static boolean isFilenameValid(String newName) {
        return true;
    }

    public static String getBaseFileNameWithoutExtension(String path) {
        return CoreStringUtil.getFirstToken(CoreStringUtil.getLastToken(path, "/"), ".");
    }

    public static String getExtension(File theFile) {
        return FileUtils.getExtension(theFile.getPath());
    }

    public static String getExtension(String theFileName) {
        String result = null;
        int index = theFileName.lastIndexOf(46);
        if (index != -1 && index + 1 != theFileName.length()) {
            result = theFileName.substring(index + 1);
        }
        return result;
    }

    public static final boolean isArchiveFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_jar[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAR[suffixIndex]) {
                suffixLength = SUFFIX_ZIP.length;
                if (nameLength < suffixLength) {
                    return false;
                }
                int j = 0;
                while (j < suffixLength) {
                    c = name.charAt(nameLength - j - 1);
                    if (c != SUFFIX_zip[suffixIndex = suffixLength - j - 1] && c != SUFFIX_ZIP[suffixIndex]) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return true;
    }

    public static final ArrayList<File> getFilesForPattern(String pathToScan, String startWith, String endsWith) {
        File folderToScan = new File(pathToScan);
        File[] listOfFiles = folderToScan.listFiles();
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String target_file;
            File file = fileArray[n2];
            if (file.isFile() && (target_file = file.getName()).startsWith(startWith) && target_file.endsWith(endsWith)) {
                list.add(file);
            }
            ++n2;
        }
        return list;
    }

    public static File copy(File fromFile, File destDirectory, boolean overwrite) throws IOException {
        File toFile = new File(destDirectory, fromFile.getName());
        if (toFile.exists()) {
            if (overwrite) {
                toFile.delete();
            } else {
                String msg = CoreModelerPlugin.Util.getString("FileUtils.File_already_exists", (Object)toFile.getName());
                throw new IOException(msg);
            }
        }
        if (!fromFile.exists()) {
            throw new FileNotFoundException(CoreModelerPlugin.Util.getString("FileUtils.File_does_not_exist._1", (Object)fromFile.getName()));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fromFile);
            FileUtils.write((InputStream)fis, toFile);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return toFile;
    }

    public static void copy(File source, OutputStream destination) throws Exception {
        OperationUtil.perform(new UnreliableCopy(source, destination));
    }

    public static void copy(InputStream source, File destination) throws Exception {
        OperationUtil.perform(new UnreliableCopy(source, destination));
    }

    public static void copy(InputStream source, OutputStream destination) throws Exception {
        byte[] buf = new byte[DEFAULT_BUFFER_SIZE];
        int len = source.read(buf);
        while (len >= 0) {
            destination.write(buf, 0, len);
            len = source.read(buf);
        }
    }

    public static void copy(String fromFileName, String toFileName) throws IOException {
        FileUtils.copy(fromFileName, toFileName, true);
    }

    public static void copy(String fromFileName, String toFileName, boolean overwrite) throws IOException {
        File fromFile;
        File toFile = new File(toFileName);
        if (toFile.exists()) {
            if (overwrite) {
                toFile.delete();
            } else {
                String msg = CoreModelerPlugin.Util.getString("FileUtils.File_already_exists", (Object)toFileName);
                throw new IOException(msg);
            }
        }
        if (!(fromFile = new File(fromFileName)).exists()) {
            throw new FileNotFoundException(CoreModelerPlugin.Util.getString("FileUtils.File_does_not_exist._1", (Object)fromFileName));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fromFile);
            FileUtils.write((InputStream)fis, toFileName);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static void copyDirectoriesRecursively(File sourceDirectory, File targetDirectory, FilenameFilter filter) throws Exception {
        FileUtils.copyRecursively(sourceDirectory, targetDirectory, filter, true);
    }

    public static void copyFile(String orginDirectory, String destDirectory, String fileName) throws Exception {
        FileUtils.copyFile(orginDirectory, fileName, destDirectory, fileName);
    }

    public static void copyFile(String orginDirectory, String orginFileName, String destDirectory, String destFileName) throws Exception {
        FileUtils.copy(String.valueOf(orginDirectory) + File.separator + orginFileName, String.valueOf(destDirectory) + File.separator + destFileName);
    }

    public static void copyRecursively(File sourceDirectory, File targetDirectory, FilenameFilter filter, boolean includeSourceRoot) throws FileNotFoundException, Exception {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException(CoreModelerPlugin.Util.getString("FileUtils.File_does_not_exist._1", (Object)sourceDirectory));
        }
        if (!sourceDirectory.isDirectory()) {
            throw new FileNotFoundException(CoreModelerPlugin.Util.getString("FileUtils.Not_a_directory", (Object)sourceDirectory));
        }
        File targetDir = new File(String.valueOf(targetDirectory.getAbsolutePath()) + File.separatorChar + sourceDirectory.getName());
        if (includeSourceRoot) {
            targetDir.mkdir();
        } else {
            targetDir = new File(String.valueOf(targetDirectory.getAbsolutePath()) + File.separatorChar);
        }
        File[] sourceFiles = null;
        sourceFiles = filter != null ? sourceDirectory.listFiles(filter) : sourceDirectory.listFiles();
        File[] fileArray = sourceFiles;
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File srcFile = fileArray[n2];
            if (srcFile.isDirectory()) {
                File childTargetDir = new File(targetDir.getAbsolutePath());
                FileUtils.copyRecursively(srcFile, childTargetDir, filter, true);
            } else {
                FileUtils.copy(srcFile.getAbsolutePath(), String.valueOf(targetDir.getAbsolutePath()) + File.separatorChar + srcFile.getName());
            }
            ++n2;
        }
    }

    public static long getCheckSum(File f) throws Exception {
        long l;
        block7: {
            CoreArgCheck.isNotNull(f);
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                l = ChecksumUtil.computeChecksum(is).getValue();
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    public static String getFilenameWithoutExtension(String filename) {
        if (filename == null || filename.length() == 0) {
            return filename;
        }
        int extensionIndex = filename.lastIndexOf(46);
        if (extensionIndex == -1) {
            return filename;
        }
        if (extensionIndex == 0) {
            return "";
        }
        return filename.substring(0, extensionIndex);
    }

    public static String normalizeFileName(String theFileName) {
        if (theFileName == null) {
            return null;
        }
        if (theFileName.length() == 0) {
            return theFileName;
        }
        try {
            return URLDecoder.decode(theFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return theFileName;
        }
    }

    public static void removeChildrenRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                File file = file2;
                if (file.isDirectory()) {
                    FileUtils.removeDirectoryAndChildren(file);
                } else if (!file.delete()) {
                    file.deleteOnExit();
                }
                ++n2;
            }
        }
    }

    public static void removeDirectoryAndChildren(File directory) {
        FileUtils.removeChildrenRecursively(directory);
        if (!directory.delete()) {
            directory.deleteOnExit();
        }
    }

    public static void testDirectoryPermissions(String dirPath) throws TeiidDesignerException {
        File tmpFile = new File(String.valueOf(dirPath) + File.separatorChar + TEMP_FILE);
        boolean success = false;
        try {
            success = tmpFile.createNewFile();
        }
        catch (IOException iOException) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_create_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        if (!tmpFile.canWrite()) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_write_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        if (!tmpFile.canRead()) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_read_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        File newFile = new File(String.valueOf(dirPath) + File.separatorChar + TEMP_FILE_RENAMED);
        success = false;
        try {
            success = tmpFile.renameTo(newFile);
        }
        catch (Exception exception) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_rename_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
        success = false;
        try {
            success = newFile.delete();
        }
        catch (Exception exception) {}
        if (!success) {
            String msg = CoreModelerPlugin.Util.getString("FileUtils.Unable_to_delete_file_in", (Object)dirPath);
            throw new TeiidDesignerException(msg);
        }
    }

    public static void write(InputStream is, File f) throws IOException {
        FileUtils.write(is, f, DEFAULT_BUFFER_SIZE);
    }

    public static void write(InputStream is, File f, int bufferSize) throws IOException {
        f.delete();
        File parentDir = f.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        FileOutputStream fio = null;
        FilterOutputStream bos = null;
        try {
            fio = new FileOutputStream(f);
            bos = new BufferedOutputStream(fio);
            if (bufferSize > 0) {
                int bytesRead;
                byte[] buff = new byte[bufferSize];
                while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                    ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
                }
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fio != null) {
                fio.close();
            }
        }
    }

    public static void write(InputStream is, String fileName) throws IOException {
        File f = new File(fileName);
        FileUtils.write(is, f);
    }

    public static void write(byte[] data, String fileName) throws IOException {
        ByteArrayInputStream bais = null;
        InputStream is = null;
        try {
            bais = new ByteArrayInputStream(data);
            is = new BufferedInputStream(bais);
            FileUtils.write(is, fileName);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static void write(byte[] data, File file) throws IOException {
        ByteArrayInputStream bais = null;
        InputStream is = null;
        try {
            bais = new ByteArrayInputStream(data);
            is = new BufferedInputStream(bais);
            FileUtils.write(is, file);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    private FileUtils() {
    }

    public static String getNameWithoutExtension(IResource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getFullPath().removeFileExtension().lastSegment();
    }

    public static interface Constants {
        public static final char CURRENT_FOLDER_SYMBOL_CHAR = '.';
        public static final char DRIVE_SEPARATOR_CHAR = ':';
        public static final char FILE_EXTENSION_SEPARATOR_CHAR = '.';
        public static final char FILE_NAME_WILDCARD_CHAR = '*';
        public static final String CURRENT_FOLDER_SYMBOL = String.valueOf('.');
        public static final String DRIVE_SEPARATOR = String.valueOf(':');
        public static final String FILE_EXTENSION_SEPARATOR = String.valueOf('.');
        public static final String FILE_NAME_WILDCARD = String.valueOf('*');
        public static final String PARENT_FOLDER_SYMBOL = "..";
    }

    static class UnreliableCopy
    implements OperationUtil.Unreliable {
        private File sourceFile;
        private InputStream source;
        private File destinationFile;
        private OutputStream destination;

        UnreliableCopy(File source, OutputStream destination) {
            this.sourceFile = source;
            this.destination = destination;
        }

        UnreliableCopy(InputStream source, File destination) {
            this.source = source;
            this.destinationFile = destination;
        }

        @Override
        public void doIfFails() {
        }

        @Override
        public void finallyDo() throws Exception {
            if (this.destinationFile != null) {
                this.destination.close();
            }
            if (this.sourceFile != null) {
                this.source.close();
            }
        }

        @Override
        public void tryToDo() throws Exception {
            if (this.source == null) {
                this.source = new FileInputStream(this.sourceFile);
            }
            if (this.destination == null) {
                File folder = this.destinationFile.getParentFile();
                if (folder != null) {
                    folder.mkdirs();
                }
                this.destination = new FileOutputStream(this.destinationFile);
            }
            FileUtils.copy(this.source, this.destination);
        }
    }
}

