/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.teiid.core.designer.util.CoreArgCheck;

public class BundleUtil {
    protected static ResourceBundle productProps;
    private final String bundleName;
    private final ResourceBundle bundle;
    protected final String pluginId;

    public static BundleUtil getBundleUtil(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        while (true) {
            String bundleName = String.valueOf(packageName) + ".i18n";
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), clazz.getClassLoader());
                return new BundleUtil(packageName, bundleName, bundle);
            }
            catch (MissingResourceException e) {
                int index = packageName.lastIndexOf(46);
                if (index < 0) {
                    throw e;
                }
                packageName = packageName.substring(0, index);
                continue;
            }
            break;
        }
    }

    public BundleUtil(String pluginId, String bundleName, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.bundleName = bundleName;
        this.bundle = bundle;
    }

    public String getString(String key) {
        try {
            String value = this.getProductValue(key);
            return value == null ? this.bundle.getString(key) : value;
        }
        catch (Exception err) {
            String msg = err instanceof NullPointerException ? "<No message available>" : (err instanceof MissingResourceException ? "<Missing message for key \"" + key + "\" in: " + this.bundleName + '>' : err.getLocalizedMessage());
            return msg;
        }
    }

    private String getProductValue(String theKey) {
        if (productProps == null) {
            return null;
        }
        if (theKey == null || theKey.length() == 0) {
            return null;
        }
        String result = null;
        String key = String.valueOf(this.pluginId) + '.' + theKey;
        try {
            result = productProps.getString(key);
        }
        catch (MissingResourceException missingResourceException) {}
        return result;
    }

    public boolean keyExists(String key) {
        try {
            return this.getProductValue(key) != null || this.bundle.getString(key) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getString(String key, List parameters) {
        if (parameters == null) {
            return this.getString(key);
        }
        return this.getString(key, parameters.toArray());
    }

    public String getString(String key, Object ... parameters) {
        String text = this.getString(key);
        if (text == null) {
            return String.valueOf('<') + key + '>';
        }
        if (parameters == null || parameters.length == 0) {
            return text;
        }
        return MessageFormat.format(text, parameters);
    }

    public String gs(String key, Object ... parameters) {
        return this.getString(key, parameters);
    }

    public String gs(Event key, Object ... parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append(" ");
        sb.append(this.getString(key.toString(), parameters));
        return sb.toString();
    }

    public String getStringOrKey(String key) {
        CoreArgCheck.isNotNull(key);
        String value = this.getProductValue(key);
        if (value == null) {
            try {
                return this.bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return key;
            }
        }
        return value;
    }

    public static interface Event {
    }
}

