/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.schema.tools.model.schema.ComplexSchemaObject;
import org.teiid.designer.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import org.teiid.designer.schema.tools.model.schema.RootElement;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.SchemaObjectKey;
import org.teiid.designer.schema.tools.model.schema.impl.BaseSchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.RootElementImpl;
import org.teiid.designer.schema.tools.model.schema.impl.TypeDefinitionKey;

public class TypeDefinition
extends BaseSchemaObject
implements ComplexSchemaObject {
    private boolean doesNotHaveUniqueName = false;
    private XSDSchema schema;

    public TypeDefinition(XSDTypeDefinition type, String namespacePrefix, XSDSchema schema) {
        super(namespacePrefix, type, schema);
    }

    @Override
    public SchemaObjectKey getKey() {
        return new TypeDefinitionKey(this.type);
    }

    @Override
    public XSDTypeDefinition getType() {
        return this.type;
    }

    @Override
    public String getNamespace() {
        return this.type.getTargetNamespace();
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public String getSimpleName() {
        String uniqueName;
        String elemName = this.type.getName();
        if (this.doesNotHaveUniqueName) {
            String typeName = this.type.getAliasName();
            uniqueName = String.valueOf(elemName) + '(' + typeName + ')';
        } else {
            uniqueName = elemName;
        }
        return uniqueName;
    }

    @Override
    public String toString() {
        String retval = this.type.getName();
        if (this.type.getTargetNamespace() != null) {
            retval = String.valueOf(retval) + " (" + this.type.getTargetNamespace() + ")";
        }
        return retval;
    }

    @Override
    public int getMinOccurs() {
        XSDParticle particle = this.type.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        XSDParticle particle = this.type.getComplexType();
        if (particle == null) {
            return 1;
        }
        return particle.getMaxOccurs();
    }

    @Override
    public SchemaObject copy(ISchemaModelCopyTraversalContext ctx) {
        TypeDefinition copy = new TypeDefinition(this.type, this.getNamespacePrefix(), this.schema);
        return copy;
    }

    @Override
    public String getElementTypeNamespace() {
        return this.type.getTargetNamespace();
    }

    @Override
    public RootElement getRootRepresentation() {
        return new RootElementImpl(this.getKey(), this.getName(), this.getNamespace(), true);
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TypeDefinition) {
            TypeDefinition other = (TypeDefinition)obj;
            if (this.type == other.type) {
                result = true;
            }
        }
        return result;
    }
}

