/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.ModelResourceIndexSelector;
import org.teiid.designer.core.index.NullIndexSelector;
import org.teiid.designer.core.index.TargetLocationIndexSelector;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.IQueryResolver;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.DelegatingQueryMetadataInterface;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.IReferenceCollectorVisitor;
import org.teiid.designer.query.sql.IResolverVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;
import org.teiid.designer.transformation.metadata.TransformationMetadataFacade;
import org.teiid.designer.transformation.metadata.TransformationMetadataFactory;
import org.teiid.designer.transformation.metadata.VdbMetadata;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidationResult;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.validator.IUpdateValidator;
import org.teiid.designer.validator.IValidator;

public class TransformationValidator
implements QueryValidator {
    private static final boolean DEFAULT_USE_CACHING = true;
    public static final String QUERY_METADATA_INTERFACE = String.valueOf(TransformationValidator.class.getSimpleName()) + ".QUERY_METADATA_INTERFACE";
    private IQueryMetadataInterface metadata;
    private final boolean restrictSearch;
    private final SqlTransformationMappingRoot mappingRoot;
    private final EObject targetGroup;
    private final ValidationContext validationContext;
    private static final String XML_URI = "http://www.metamatrix.com/metamodels/XmlDocument";
    private QueryValidator.ElementSymbolOptimization elementSymbolOptimization = QueryValidator.ElementSymbolOptimization.UNMODIFIED;

    public TransformationValidator(SqlTransformationMappingRoot eObject) {
        this(eObject, null, true, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching) {
        this(eObject, null, useCaching, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching, boolean restrictSearch) {
        this(eObject, null, useCaching, restrictSearch);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, ValidationContext context, boolean useCaching, boolean restrictSearch) {
        this.restrictSearch = restrictSearch;
        this.mappingRoot = eObject;
        this.targetGroup = eObject.getTarget();
        this.validationContext = context;
    }

    public TransformationValidationResult validateTransformation() {
        EmfResource emfResource = (EmfResource)this.mappingRoot.eResource();
        if (emfResource.getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && XML_URI.equals(stringURI)) {
                return new TransformationValidationResult();
            }
        }
        if (!this.shouldValidate()) {
            return new TransformationValidationResult();
        }
        SqlTransformation sqlTrans = (SqlTransformation)this.mappingRoot.getHelper();
        String objectPath = TransformationHelper.getSqlEObjectPath(this.targetGroup);
        if (sqlTrans == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Error_in_the_Sql_tranformation_for_1", (Object)objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "org.teiid.designer.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        TransformationValidationResult transformResult = new TransformationValidationResult();
        SqlTransformationResult selectStatus = SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 0, this.restrictSearch, this.validationContext);
        if (selectStatus == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Found_problems_validating_transformation_defining_{0},_re-validate_in_the_transformation_editor._1", (Object)objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "org.teiid.designer.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        transformResult.setSelectResult(selectStatus);
        if (transformResult.isValid() && SqlAspectHelper.isUpdatableGroup((EObject)this.targetGroup)) {
            if (sqlTrans.isInsertAllowed()) {
                transformResult.setInsertResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 1, this.restrictSearch, this.validationContext));
                transformResult.setInsertAllowed(true);
            }
            if (sqlTrans.isUpdateAllowed()) {
                transformResult.setUpdateResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 2, this.restrictSearch, this.validationContext));
                transformResult.setUpdateAllowed(true);
            }
            if (sqlTrans.isDeleteAllowed()) {
                transformResult.setDeleteResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 3, this.restrictSearch, this.validationContext));
                transformResult.setDeleteAllowed(true);
            }
        }
        return transformResult;
    }

    public boolean isValidRoot() {
        return this.mappingRoot != null && this.mappingRoot.eResource() != null;
    }

    public QueryValidationResult validateSql(String sql, int transformType, boolean cacheResult) {
        ICommand command;
        if (!this.isValidRoot()) {
            return null;
        }
        if (!this.shouldValidate()) {
            return null;
        }
        SqlTransformationResult commandValidationResult = null;
        switch (transformType) {
            case 1: {
                if (!((SqlTransformation)this.mappingRoot.getHelper()).isInsertSqlDefault()) break;
                Status status = new Status(0, "org.teiid.designer.transformation", 0, "\"Use Default\" option is turned on for Insert procedure.", null);
                ICommand command2 = null;
                if (sql != null && sql.length() > 0) {
                    SqlTransformationResult parsedResult = TransformationValidator.parseSQL(sql);
                    command2 = parsedResult.getCommand();
                }
                commandValidationResult = new SqlTransformationResult(command2, (IStatus)status);
                commandValidationResult.setSqlString(sql);
                return commandValidationResult;
            }
            case 2: {
                if (!((SqlTransformation)this.mappingRoot.getHelper()).isUpdateSqlDefault()) break;
                Status status = new Status(0, "org.teiid.designer.transformation", 0, "\"Use Default\" option is turned on for UPDATE procedure.", null);
                ICommand command3 = null;
                if (sql != null && sql.length() > 0) {
                    SqlTransformationResult parsedResult = TransformationValidator.parseSQL(sql);
                    command3 = parsedResult.getCommand();
                }
                commandValidationResult = new SqlTransformationResult(command3, (IStatus)status);
                commandValidationResult.setSqlString(sql);
                return commandValidationResult;
            }
            case 3: {
                if (!((SqlTransformation)this.mappingRoot.getHelper()).isDeleteSqlDefault()) break;
                Status status = new Status(0, "org.teiid.designer.transformation", 0, "\"Use Default\" option is turned on for DELETE procedure.", null);
                ICommand command4 = null;
                if (sql != null && sql.length() > 0) {
                    SqlTransformationResult parsedResult = TransformationValidator.parseSQL(sql);
                    command4 = parsedResult.getCommand();
                }
                commandValidationResult = new SqlTransformationResult(command4, (IStatus)status);
                commandValidationResult.setSqlString(sql);
                return commandValidationResult;
            }
        }
        commandValidationResult = TransformationValidator.parseSQL(sql);
        if (commandValidationResult.isParsable() && transformType != -1 && (commandValidationResult = this.resolveCommand(command = commandValidationResult.getCommand(), transformType)).isResolvable()) {
            if (this.elementSymbolOptimization == QueryValidator.ElementSymbolOptimization.DEOPTIMIZED) {
                IQueryService queryService = ModelerCore.getTeiidQueryService();
                queryService.fullyQualifyElements(command);
            }
            commandValidationResult = this.validateCommand(command, transformType);
            commandValidationResult.setResolvable(true);
        }
        commandValidationResult.setSqlString(sql);
        commandValidationResult.setSourceGroups((Collection)this.mappingRoot.getInputs());
        if (cacheResult) {
            SqlMappingRootCache.setStatus((EObject)this.mappingRoot, transformType, commandValidationResult);
        }
        return commandValidationResult;
    }

    public static SqlTransformationResult parseSQL(String sqlString) {
        ICommand command = null;
        Status status = null;
        if (sqlString == null || sqlString.trim().isEmpty()) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.emptySQLMessage");
            status = new Status(4, "org.teiid.designer.transformation", 0, msg, null);
        } else {
            try {
                IQueryParser parser = ModelerCore.getTeiidQueryService().getQueryParser();
                command = parser.parseDesignerCommand(sqlString);
            }
            catch (Throwable e) {
                status = new Status(4, "org.teiid.designer.transformation", 0, e.getMessage(), e);
            }
        }
        SqlTransformationResult result = new SqlTransformationResult(command, (IStatus)status);
        if (status != null && !status.isOK()) {
            result.setParsable(false);
        }
        return result;
    }

    public SqlTransformationResult resolveCommand(ICommand command, int transformType) {
        String commandSQL;
        IStatus status;
        block9: {
            status = this.checkCommandType(command, transformType, this.targetGroup);
            if (status != null && status.getSeverity() != 0) {
                SqlTransformationResult resolverResult = new SqlTransformationResult(command, status);
                resolverResult.setTargetValidStatus(status);
                return resolverResult;
            }
            CoreArgCheck.isNotNull((Object)command);
            commandSQL = command.toString();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IResolverVisitor resolverVisitor = queryService.getResolverVisitor();
            IQueryFactory factory = queryService.createQueryFactory();
            IQueryResolver queryResolver = queryService.getQueryResolver();
            try {
                try {
                    DelegatingQueryMetadataInterface metadata = new DelegatingQueryMetadataInterface(this.getQueryMetadata()){

                        public boolean findShortName() {
                            return TransformationValidator.this.elementSymbolOptimization == QueryValidator.ElementSymbolOptimization.OPTIMIZED;
                        }
                    };
                    String targetFullName = TransformationHelper.getSqlEObjectFullName(this.targetGroup);
                    IGroupSymbol gSymbol = factory.createGroupSymbol(targetFullName);
                    if (this.elementSymbolOptimization == QueryValidator.ElementSymbolOptimization.OPTIMIZED) {
                        resolverVisitor.setProperty("shortName", (Object)true);
                    }
                    int teiidCommandType = this.getTeiidCommandType(transformType);
                    queryResolver.resolveCommand(command, gSymbol, teiidCommandType, (IQueryMetadataInterface)metadata);
                    queryResolver.postResolveCommand(command, gSymbol, teiidCommandType, (IQueryMetadataInterface)metadata, this.getProjectedSymbols());
                }
                catch (Exception e) {
                    status = new Status(4, "org.teiid.designer.transformation", 0, e.getMessage(), (Throwable)e);
                    resolverVisitor.setProperty("shortName", (Object)false);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                resolverVisitor.setProperty("shortName", (Object)false);
                throw throwable;
            }
            resolverVisitor.setProperty("shortName", (Object)false);
        }
        if (status != null && status.getSeverity() == 4) {
            return new SqlTransformationResult(TransformationValidator.parseSQL(commandSQL).getCommand(), status);
        }
        SqlTransformationResult resolverResult = new SqlTransformationResult(command, status);
        if (status == null) {
            resolverResult.setResolvable(true);
        }
        return resolverResult;
    }

    private int getTeiidCommandType(int cmdtype) {
        switch (cmdtype) {
            case 0: {
                if (this.targetGroup instanceof Table || this.targetGroup instanceof MappingClass) {
                    return 1;
                }
                return 6;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public SqlTransformationResult validateCommand(ICommand command, int cmdType) {
        CoreArgCheck.isNotNull((Object)command);
        Collection<IStatus> statusList = null;
        ArrayList<Object> updateStatusList = null;
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        try {
            IValidator validator = queryService.getValidator();
            IValidator.IValidatorReport report = validator.validate((ILanguageObject)command, this.getQueryMetadata());
            if (!report.hasItems()) {
                statusList = this.validateSources(command, statusList);
                statusList = this.validateReferences(command, statusList);
            } else {
                statusList = this.createStatusList(report);
            }
        }
        catch (Exception e) {
            statusList = new ArrayList<IStatus>(1);
            statusList.add((IStatus)new Status(4, "org.teiid.designer.transformation", 0, e.getMessage(), (Throwable)e));
        }
        boolean validateAndResolve = false;
        if (statusList == null || statusList.isEmpty()) {
            statusList = Collections.EMPTY_LIST;
            validateAndResolve = true;
        }
        boolean allowsUpdates = TransformationHelper.tableSupportsUpdate(this.targetGroup);
        if (validateAndResolve && cmdType == 0 && allowsUpdates) {
            updateStatusList = new ArrayList<Object>();
            IUpdateValidator.TransformUpdateType insertType = IUpdateValidator.TransformUpdateType.INSTEAD_OF;
            IUpdateValidator.TransformUpdateType updateType = IUpdateValidator.TransformUpdateType.INSTEAD_OF;
            IUpdateValidator.TransformUpdateType deleteType = IUpdateValidator.TransformUpdateType.INSTEAD_OF;
            SqlTransformation transformation = (SqlTransformation)this.mappingRoot.getHelper();
            boolean doUpdateValidation = false;
            if (transformation.isInsertSqlDefault()) {
                insertType = IUpdateValidator.TransformUpdateType.INHERENT;
                doUpdateValidation = true;
            }
            if (transformation.isUpdateSqlDefault()) {
                updateType = IUpdateValidator.TransformUpdateType.INHERENT;
                doUpdateValidation = true;
            }
            if (transformation.isDeleteSqlDefault()) {
                deleteType = IUpdateValidator.TransformUpdateType.INHERENT;
                doUpdateValidation = true;
            }
            if (doUpdateValidation) {
                IUpdateValidator updateValidator = queryService.getUpdateValidator(this.metadata, insertType, updateType, deleteType);
                List<IElementSymbol> elemSymbols = null;
                try {
                    elemSymbols = this.getProjectedSymbols();
                    List theSymbols = CommandHelper.getProjectedSymbols((ICommand)command);
                    ArrayList symbols = new ArrayList(theSymbols.size());
                    symbols.addAll(theSymbols);
                    if (!elemSymbols.isEmpty() && elemSymbols.size() == symbols.size()) {
                        updateValidator.validate(command, elemSymbols);
                    }
                }
                catch (Exception e) {
                    updateStatusList = new ArrayList(1);
                    updateStatusList.add(new Status(4, "org.teiid.designer.transformation", 0, e.getMessage(), (Throwable)e));
                }
                if (updateStatusList.isEmpty()) {
                    if (insertType == IUpdateValidator.TransformUpdateType.INHERENT) {
                        updateStatusList.addAll(this.getReportStatusList(updateValidator.getInsertReport(), 700));
                    }
                    if (updateType == IUpdateValidator.TransformUpdateType.INHERENT) {
                        updateStatusList.addAll(this.getReportStatusList(updateValidator.getUpdateReport(), 701));
                    }
                    if (deleteType == IUpdateValidator.TransformUpdateType.INHERENT) {
                        updateStatusList.addAll(this.getReportStatusList(updateValidator.getDeleteReport(), 702));
                    }
                    updateStatusList.addAll(this.getReportStatusList(updateValidator.getReport(), 699));
                }
            }
        }
        SqlTransformationResult result = new SqlTransformationResult(command, statusList, updateStatusList);
        result.setValidatable(validateAndResolve);
        result.setResolvable(validateAndResolve);
        return result;
    }

    public IQueryMetadataInterface getQueryMetadata() {
        return this.getDirectQueryMetadata();
    }

    private IQueryMetadataInterface getDirectQueryMetadata() {
        if (this.metadata == null && this.mappingRoot.eResource() != null) {
            boolean useServerMetadata;
            TransformationMetadataFactory factory = TransformationMetadataFactory.getInstance();
            boolean bl = useServerMetadata = this.validationContext != null && this.validationContext.useServerIndexes();
            if (!useServerMetadata) {
                ModelResourceIndexSelector selector = new ModelResourceIndexSelector(this.mappingRoot.eResource());
                QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                queryContext.setRestrictedSearch(this.restrictSearch);
                Container container = null;
                if (this.validationContext != null) {
                    container = this.validationContext.getResourceContainer();
                    if (!this.validationContext.useIndexesToResolve()) {
                        queryContext.setIndexSelector((IndexSelector)new NullIndexSelector());
                    }
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                } else {
                    try {
                        container = ModelerCore.getModelContainer();
                        try {
                            ModelResource mr = ModelUtil.getModel((Object)this.mappingRoot);
                            IProject proj = mr.getCorrespondingResource().getProject();
                            ArrayList projectResources = new ArrayList(0);
                            ModelUtil.collectResources((IContainer)proj, projectResources);
                            queryContext.setResources(projectResources);
                            queryContext.setRestrictedSearch(true);
                        }
                        catch (RuntimeException runtimeException) {
                            queryContext.setResources((Collection)this.mappingRoot.eResource().getResourceSet().getResources());
                        }
                    }
                    catch (CoreException e) {
                        TransformationPlugin.Util.log((Throwable)e);
                    }
                }
                this.metadata = factory.getModelerMetadata(queryContext, container);
            } else {
                CoreArgCheck.isNotNull((Object)this.validationContext);
                NullIndexSelector selector = null;
                if (this.validationContext.useIndexesToResolve()) {
                    if (this.validationContext.getData(QUERY_METADATA_INTERFACE) != null) {
                        this.metadata = (IQueryMetadataInterface)this.validationContext.getData(QUERY_METADATA_INTERFACE);
                        if (!(this.metadata instanceof VdbMetadata) && this.metadata instanceof TransformationMetadataFacade && !(((TransformationMetadataFacade)this.metadata).getDelegate() instanceof VdbMetadata)) {
                            throw new TeiidDesignerRuntimeException(TransformationPlugin.Util.getString("TransformationValidator.QMI_of_unexpected_type"));
                        }
                    } else {
                        selector = new TargetLocationIndexSelector(this.validationContext.getIndexLocation());
                    }
                } else {
                    selector = new NullIndexSelector();
                }
                if (this.metadata == null) {
                    QueryMetadataContext queryContext = new QueryMetadataContext((IndexSelector)selector);
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                    queryContext.setRestrictedSearch(this.restrictSearch);
                    this.metadata = factory.getVdbMetadata(queryContext, this.validationContext.getResourceContainer());
                    this.validationContext.setData(QUERY_METADATA_INTERFACE, (Object)this.metadata);
                }
            }
        }
        return this.metadata;
    }

    private IStatus checkCommandType(ICommand command, int transformType, Object targetGroup) {
        CoreArgCheck.isNotNull((Object)command);
        CoreArgCheck.isNotNull((Object)targetGroup);
        int cmdType = command.getType();
        switch (transformType) {
            case 0: {
                if (targetGroup instanceof Table) {
                    if (cmdType == 1 || cmdType == 6) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_group_can_only_be_of_type_Select_or_Exec._1");
                    return new Status(4, "org.teiid.designer.transformation", 0, msg, null);
                }
                if (targetGroup instanceof Procedure) {
                    if (cmdType == 7) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_procedure_can_only_be_of_type_Virtual_procedure._2");
                    return new Status(4, "org.teiid.designer.transformation", 0, msg, null);
                }
                if (!(targetGroup instanceof Operation) || cmdType == 7) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_an_operation_can_only_be_of_type_Virtual_procedure._1");
                return new Status(4, "org.teiid.designer.transformation", 0, msg, null);
            }
            case 1: 
            case 2: 
            case 3: {
                if (cmdType == 13 || cmdType == 7) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Only_update_procedures_are_allowed_in_the_INSERT/UPDATE/DELETE_tabs._1");
                return new Status(4, "org.teiid.designer.transformation", 0, msg, null);
            }
            default: {
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Invalid_transformation_type,_only_allowed_transformations_are_select,_insert,_update,_delete_transforms._1");
                return new Status(4, "org.teiid.designer.transformation", 0, msg, null);
            }
        }
        return null;
    }

    private List<IStatus> createStatusList(IValidator.IValidatorReport report) {
        if (report != null && report.hasItems()) {
            Collection items = report.getItems();
            ArrayList<IStatus> statusList = new ArrayList<IStatus>(items.size());
            for (IValidator.IValidatorFailure item : items) {
                int statusVal = 0;
                switch (item.getStatus()) {
                    case ERROR: {
                        statusVal = 4;
                        break;
                    }
                    case WARNING: {
                        statusVal = 2;
                    }
                }
                Status status = new Status(statusVal, "org.teiid.designer.transformation", item.toString(), null);
                statusList.add((IStatus)status);
            }
            return statusList;
        }
        return Collections.emptyList();
    }

    public static List getOutputColumns(SqlTransformationMappingRoot transRoot) {
        EObject target = transRoot.getTarget();
        List outputColumns = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)target);
        if (sqlAspect instanceof SqlTableAspect) {
            outputColumns = ((SqlTableAspect)sqlAspect).getColumns(target);
        } else if (sqlAspect instanceof SqlProcedureAspect) {
            SqlProcedureAspect procAspect = (SqlProcedureAspect)sqlAspect;
            EObject resultSet = (EObject)procAspect.getResult(target);
            if (resultSet != null) {
                SqlColumnSetAspect resultAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)resultSet);
                outputColumns = resultAspect.getColumns(resultSet);
            } else {
                outputColumns = Collections.EMPTY_LIST;
            }
        }
        return outputColumns;
    }

    private List<IElementSymbol> getProjectedSymbols() throws Exception {
        List outputColumns = TransformationValidator.getOutputColumns(this.mappingRoot);
        ArrayList<IElementSymbol> projectedSymbols = new ArrayList<IElementSymbol>(outputColumns.size());
        for (EObject outputColumn : outputColumns) {
            String outputColumnName = TransformationHelper.getSqlColumnName(outputColumn);
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)outputColumn);
            EObject datatype = columnAspect.getDatatype(outputColumn);
            SqlDatatypeAspect typeAspect = datatype != null ? (SqlDatatypeAspect)AspectManager.getSqlAspect((EObject)datatype) : null;
            Class targetType = null;
            if (typeAspect != null) {
                IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
                targetType = service.getDataTypeClass(typeAspect.getRuntimeTypeName(datatype));
            }
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryFactory factory = queryService.createQueryFactory();
            IElementSymbol column = factory.createElementSymbol(outputColumnName);
            column.setType(targetType);
            column.setMetadataID(this.getQueryMetadata().getElementID(columnAspect.getFullName(outputColumn)));
            projectedSymbols.add(column);
        }
        return projectedSymbols;
    }

    private List<IStatus> getReportStatusList(IValidator.IValidatorReport report, int errorCode) {
        Collection items = report.getItems();
        ArrayList<IStatus> statusList = new ArrayList<IStatus>(items.size());
        for (IValidator.IValidatorFailure item : items) {
            int statusVal = 0;
            switch (item.getStatus()) {
                case ERROR: {
                    statusVal = 4;
                    break;
                }
                case WARNING: {
                    statusVal = 2;
                }
            }
            Status status = new Status(statusVal, "org.teiid.designer.transformation", errorCode, item.getStatus().toString(), null);
            statusList.add((IStatus)status);
        }
        return statusList;
    }

    private Collection<IStatus> validateReferences(ICommand command, Collection<IStatus> statusList) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IReferenceCollectorVisitor referenceCollectorVisitor = queryService.getReferenceCollectorVisitor();
        List references = referenceCollectorVisitor.findReferences((ILanguageObject)command);
        if (!references.isEmpty()) {
            statusList = statusList != null ? statusList : new ArrayList<Status>(1);
            Status status = new Status(4, "org.teiid.designer.transformation", 0, TransformationPlugin.Util.getString("TransformationValidator.The_transformation_contains_Reference_Symbols_(_),_which_is_not_allowed,_replace___with_a_constant,_element,_or_parameter_name._1"), null);
            statusList.add(status);
        }
        return statusList;
    }

    private Collection<IStatus> validateSources(ICommand command, Collection<IStatus> statusList) {
        if (this.isTargetASourceInCommand(command)) {
            statusList = statusList != null ? statusList : new ArrayList<Status>(1);
            String message = TransformationPlugin.Util.getString("TransformationValidator.errorTargetIsSourceMsg", (Object)ModelerCore.getModelEditor().getName(this.targetGroup));
            Status status = new Status(4, "org.teiid.designer.transformation", 0, message, null);
            statusList.add(status);
        }
        return statusList;
    }

    protected boolean isTargetASourceInCommand(ICommand command) {
        boolean result = false;
        Collection<IGroupSymbol> sourceSymbols = TransformationSqlHelper.getGroupSymbols(command);
        List sourceEObjects = TransformationSqlHelper.getGroupSymbolEObjects(sourceSymbols);
        if (!sourceEObjects.isEmpty() && this.mappingRoot != null) {
            EObject tRootTarget = this.mappingRoot.getTarget();
            Iterator iter = sourceEObjects.iterator();
            Object nextObj = null;
            while (iter.hasNext() && !result) {
                nextObj = iter.next();
                if (!nextObj.equals(tRootTarget)) continue;
                result = true;
            }
        }
        return result;
    }

    public EObject getTransformationRoot() {
        return this.mappingRoot;
    }

    public void setElementSymbolOptimization(QueryValidator.ElementSymbolOptimization status) {
        this.elementSymbolOptimization = status;
    }

    public boolean shouldValidate() {
        return !(this.targetGroup instanceof Procedure) || !((Procedure)this.targetGroup).isFunction();
    }
}

