/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.util.INewModelObjectHelper;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class TransformationNewModelObjectHelper
implements INewModelObjectHelper {
    public static final String CREATE_OBJECT_GENERATE_DEFAULT_SQL_PROPERTY = "generateDefaultSQL";
    public static final String CREATE_OBJECT_VALIDATE_PROPERTY = "validate";
    public static final String CREATE_OBJECT_PROVIDED_SQL_PROPERTY = "providedSQL";
    public static final String VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE = "clearSupportsUpdate";
    public static final String VIRTUAL_PROCEDURE_TEMPLATE_SQL = "CREATE VIRTUAL PROCEDURE\nBEGIN\n <--insert SQL here-->;\nEND";

    public boolean canHelpCreate(Object newObject) {
        EObject newEObject;
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject && TransformationHelper.isVirtual(newEObject = (EObject)newObject)) {
            if (TransformationHelper.isSqlTable(newEObject) && !TransformationHelper.isXmlDocument(newEObject)) {
                return true;
            }
            if (TransformationHelper.isSqlProcedure(newEObject)) {
                return true;
            }
        }
        return false;
    }

    private String generateDefaultSQL(EObject newTarget, SqlTableAspect tableAspect) {
        List columns = tableAspect.getColumns(newTarget);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        if (!columns.isEmpty()) {
            sb.append("SELECT");
            for (Object col : columns) {
                String colName = ModelerCore.getModelEditor().getName((EObject)col);
                if (count > 0) {
                    sb.append(',');
                }
                String seg = " null AS " + colName;
                sb.append(seg);
                ++count;
            }
        }
        return sb.toString();
    }

    public boolean helpCreate(Object newObject, Map properties, List<EObject> references) {
        CoreArgCheck.isNotNull((Object)newObject);
        if (properties == null) {
            properties = new HashMap();
        }
        boolean defineDefaultTableSQL = properties.get(CREATE_OBJECT_GENERATE_DEFAULT_SQL_PROPERTY) != null;
        boolean doValidate = properties.get(CREATE_OBJECT_VALIDATE_PROPERTY) != null;
        String providedSQL = (String)properties.get(CREATE_OBJECT_PROVIDED_SQL_PROPERTY);
        if (!(newObject instanceof EObject)) {
            return false;
        }
        EObject newTarget = (EObject)newObject;
        if (!TransformationHelper.isVirtual(newTarget)) {
            return false;
        }
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)newTarget);
        if (aspect != null && aspect instanceof SqlTableAspect) {
            EObject tRoot;
            String selectSql;
            SqlTableAspect tableAspect = (SqlTableAspect)aspect;
            if (!TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                if (TransformationNewModelObjectHelper.isMapValueTrue(VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE, properties, true)) {
                    tableAspect.setSupportsUpdate(newTarget, false);
                }
            }
            if ((selectSql = TransformationHelper.getSelectSqlString(tRoot = TransformationHelper.getMappingRoot(newTarget))) != null) {
                return true;
            }
            if (defineDefaultTableSQL) {
                selectSql = this.generateDefaultSQL(newTarget, tableAspect);
            } else if (providedSQL != null) {
                selectSql = providedSQL;
            }
            if (selectSql == null) {
                return false;
            }
            TransformationHelper.setSelectSqlString(tRoot, selectSql, false, this);
            TransformationMappingHelper.reconcileMappingsOnSqlChange(tRoot, null);
            TransformationMappingHelper.reconcileTargetAttributes(tRoot, null);
            if (doValidate) {
                TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)tRoot);
                validator.validateSql(selectSql, 0, true);
            }
            return true;
        }
        if (TransformationHelper.isSqlProcedure(newTarget) && !TransformationHelper.isOperation(newTarget)) {
            EObject tRoot;
            String selectSql;
            if (!TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
            }
            if ((selectSql = TransformationHelper.getSelectSqlString(tRoot = TransformationHelper.getMappingRoot(newTarget))) != null) {
                return true;
            }
            if (defineDefaultTableSQL) {
                selectSql = VIRTUAL_PROCEDURE_TEMPLATE_SQL;
            } else if (providedSQL != null) {
                selectSql = providedSQL;
            }
            if (selectSql == null) {
                return false;
            }
            TransformationHelper.setSelectSqlString(tRoot, selectSql, false, this);
            return true;
        }
        return false;
    }

    private static boolean isMapValueTrue(String propertyName, Map properties, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Boolean bool = (Boolean)properties.get(propertyName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }
}

