/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.metadata;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.ModelResourceIndexSelector;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.ModelerMetadata;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;
import org.teiid.designer.transformation.metadata.ServerMetadataFactory;
import org.teiid.designer.transformation.metadata.TransformationMetadataFacade;
import org.teiid.designer.transformation.metadata.VdbMetadata;

public class TransformationMetadataFactory
extends ServerMetadataFactory {
    private static final TransformationMetadataFactory INSTANCE = new TransformationMetadataFactory();

    public static TransformationMetadataFactory getInstance() {
        return INSTANCE;
    }

    public IQueryMetadataInterface getModelerMetadata(QueryMetadataContext context, Container container) {
        return new ModelerMetadata(context, container);
    }

    public IQueryMetadataInterface getModelerMetadata(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        return this.getModelerMetadata(eObject, false);
    }

    public IQueryMetadataInterface getModelerMetadata(EObject eObject, boolean restrictSearch) {
        CoreArgCheck.isNotNull((Object)eObject);
        QueryMetadataContext context = TransformationMetadataFactory.buildQueryMetadataContext(eObject, restrictSearch);
        Container container = null;
        try {
            container = ModelerCore.getModelContainer();
        }
        catch (CoreException e) {
            TransformationPlugin.Util.log((Throwable)e);
        }
        return this.getModelerMetadata(context, container);
    }

    public static QueryMetadataContext buildQueryMetadataContext(EObject eObject, boolean restrictSearch) {
        Object resources = null;
        Container container = null;
        try {
            container = ModelerCore.getModelContainer();
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            resources = workspace.isOpen() ? Arrays.asList(workspace.getEmfResources()) : container.getResources();
        }
        catch (CoreException e) {
            TransformationPlugin.Util.log((Throwable)e);
        }
        Resource resource = ModelerCore.getModelEditor().findResource(container, eObject);
        ModelResourceIndexSelector selector = new ModelResourceIndexSelector(resource);
        QueryMetadataContext context = new QueryMetadataContext((IndexSelector)selector);
        context.setResources((Collection)resources);
        context.setRestrictedSearch(restrictSearch);
        return context;
    }

    public IQueryMetadataInterface getVdbMetadata(QueryMetadataContext context, Container container) {
        CoreArgCheck.isNotNull((Object)context);
        return new TransformationMetadataFacade(new VdbMetadata(context, container));
    }

    public static /* bridge */ /* synthetic */ ServerMetadataFactory getInstance() {
        return TransformationMetadataFactory.getInstance();
    }
}

