/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.materialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.transformation.TransformationPlugin;

public class MaterializationModelGenerator {
    private static String MV_PREFIX = "MV";
    private static int STARTING_INDEX = 1000000;
    private static String RESULT_MSG = TransformationPlugin.Util.getString("MVModelGenerator.resultStr");
    private static String OK_MSG = TransformationPlugin.Util.getString("MVModelGenerator.success");
    private static String UNDEFINED = TransformationPlugin.Util.getString("MVModelGenerator.undefined");
    private static IStatus OK_STATUS = new Status(0, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.allInputsOkStatusMessage"));
    private final ModelEditor modelEditor;
    private final HashMap virtToPhysMappings;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private ModelResource materializedViewModel;
    private Object targetLocation;
    private Collection<EObject> virtualTables;
    private int nextIndex;
    private MultiStatus result;
    private Set usedNIS;

    public MaterializationModelGenerator() {
        this.modelEditor = ModelerCore.getModelEditor();
        this.virtToPhysMappings = new HashMap();
        this.usedNIS = new HashSet();
        this.nextIndex = STARTING_INDEX + 1;
    }

    public MultiStatus execute() {
        return this.execute(this.materializedViewModel, this.targetLocation, this.virtualTables);
    }

    public MultiStatus execute(ModelResource targetResource, Object targetLocation, Collection<EObject> virtualTables) {
        CoreArgCheck.isNotNull((Object)targetResource, (String)"targetResource");
        this.materializedViewModel = targetResource;
        try {
            Schema schema = null;
            schema = targetLocation != null && targetLocation instanceof Schema ? (Schema)targetLocation : this.createSchema(targetResource.getPath().removeFileExtension().lastSegment());
            for (EObject next : virtualTables) {
                if (!(next instanceof Table)) continue;
                ((Table)next).setMaterialized(true);
                EObject mvTable = this.createMaterializedView((Table)next, schema);
                ((Table)next).setMaterializedTable((Table)mvTable);
            }
        }
        catch (Exception err) {
            TransformationPlugin.Util.log((Throwable)err);
        }
        if (this.result == null) {
            this.addStatus(0, OK_MSG, null);
        }
        return this.result;
    }

    private Schema createSchema(String inputModelName) {
        try {
            for (Object eObj : this.materializedViewModel.getEObjects()) {
                if (!(eObj instanceof Schema) || !inputModelName.equalsIgnoreCase(ModelerCore.getModelEditor().getName((EObject)eObj))) continue;
                return (Schema)eObj;
            }
        }
        catch (ModelWorkspaceException err) {
            TransformationPlugin.Util.log((Throwable)err);
        }
        Schema newSchema = RelationalFactory.eINSTANCE.createSchema();
        newSchema.setName(inputModelName);
        newSchema.setNameInSource(inputModelName);
        this.addValue(this.materializedViewModel, newSchema, this.getModelResourceContents());
        return newSchema;
    }

    public HashMap getVirtToPhysMappings() {
        return this.virtToPhysMappings;
    }

    public ModelResource getMaterializedViewModel() {
        return this.materializedViewModel;
    }

    private EObject createMaterializedView(Table table, Schema owner) {
        Table mv = (Table)RelationalFactory.eINSTANCE.create(table.eClass());
        String name = table.getName();
        String tmp = this.nameValidator.createValidUniqueName(name);
        if (tmp != null) {
            name = tmp;
        }
        mv.setName(name);
        this.copyTableValues(table, mv);
        ++this.nextIndex;
        owner.getTables().add((Object)mv);
        ArrayList<Table> newTables = new ArrayList<Table>();
        newTables.add(mv);
        this.virtToPhysMappings.put(table, newTables);
        Iterator cols = table.getColumns().iterator();
        HashSet indexes = new HashSet();
        HashSet pks = new HashSet();
        while (cols.hasNext()) {
            Column nextCol = (Column)cols.next();
            Column newCol = RelationalFactory.eINSTANCE.createColumn();
            Column stageCol = RelationalFactory.eINSTANCE.createColumn();
            mv.getColumns().add((Object)newCol);
            this.copyColValues(nextCol, newCol);
            this.copyColValues(nextCol, stageCol);
            indexes.addAll(nextCol.getIndexes());
            pks.addAll(nextCol.getUniqueKeys());
        }
        for (UniqueKey nextKey : pks) {
            UniqueKey newKey = (UniqueKey)RelationalFactory.eINSTANCE.create(nextKey.eClass());
            if (nextKey instanceof PrimaryKey) {
                ((BaseTable)mv).setPrimaryKey((PrimaryKey)newKey);
            } else {
                ((BaseTable)mv).getUniqueConstraints().add((Object)((UniqueConstraint)newKey));
            }
            this.copyUniqueKeyValues(nextKey, newKey);
        }
        for (Index nextIndex : indexes) {
            Index newIndex = RelationalFactory.eINSTANCE.createIndex();
            this.copyIndexValues(nextIndex, newIndex, false, table, mv);
            this.addValue(this.materializedViewModel, newIndex, this.getModelResourceContents());
        }
        return mv;
    }

    protected void copyTableValues(Table orig, Table copy) {
        copy.setNameInSource(this.getUniqueNIS(orig));
        copy.setCardinality(orig.getCardinality());
        copy.setSystem(orig.isSystem());
        copy.setSupportsUpdate(true);
    }

    private void copyColValues(Column orig, Column copy) {
        copy.setAutoIncremented(orig.isAutoIncremented());
        copy.setCaseSensitive(orig.isCaseSensitive());
        copy.setCharacterSetName(orig.getCharacterSetName());
        copy.setCollationName(orig.getCollationName());
        copy.setCurrency(copy.isCurrency());
        copy.setDefaultValue(orig.getDefaultValue());
        copy.setFixedLength(orig.isFixedLength());
        copy.setFormat(orig.getFormat());
        copy.setLength(orig.getLength());
        copy.setMaximumValue(orig.getMaximumValue());
        copy.setMinimumValue(orig.getMinimumValue());
        copy.setName(orig.getName());
        copy.setNameInSource(orig.getNameInSource());
        copy.setNativeType(orig.getNativeType());
        copy.setNullable(orig.getNullable());
        copy.setPrecision(orig.getPrecision());
        copy.setRadix(orig.getRadix());
        copy.setScale(orig.getScale());
        copy.setSearchability(orig.getSearchability());
        copy.setSelectable(orig.isSelectable());
        copy.setSigned(orig.isSigned());
        copy.setType(orig.getType());
        copy.setUpdateable(true);
    }

    private void addStatus(int severity, String msg, Exception e) {
        if (this.result == null) {
            this.result = new MultiStatus("org.teiid.designer.transformation", -1, RESULT_MSG, null);
        }
        this.result.add((IStatus)new Status(severity, "org.teiid.designer.transformation", -1, msg, (Throwable)e));
    }

    private void copyUniqueKeyValues(UniqueKey orig, UniqueKey copy) {
        copy.setName(orig.getName());
        copy.setNameInSource(orig.getNameInSource());
        try {
            BaseTable copyOwner = copy.getTable();
            BaseTable origOwner = orig.getTable();
            for (Column nextOrigCol : orig.getColumns()) {
                int index = origOwner.getColumns().indexOf((Object)nextOrigCol);
                Column copyCol = (Column)copyOwner.getColumns().get(index);
                if (nextOrigCol.getName().equals(copyCol.getName())) {
                    copy.getColumns().add((Object)copyCol);
                    continue;
                }
                String msg = TransformationPlugin.Util.getString("MVModelGenerator.errorSettingUCvals", (Object)copy.getName());
                throw new ModelerCoreRuntimeException(msg);
            }
        }
        catch (Exception exception) {
            String msg = TransformationPlugin.Util.getString("MVModelGenerator.errorSettingUCvals", (Object)copy.getName());
            throw new ModelerCoreRuntimeException(msg);
        }
    }

    private void copyIndexValues(Index orig, Index copy, boolean isStage, Table origTable, Table copyTable) {
        copy.setAutoUpdate(orig.isAutoUpdate());
        copy.setFilterCondition(orig.getFilterCondition());
        copy.setName(orig.getName());
        String nameInSource = orig.getNameInSource();
        copy.setNameInSource(nameInSource == null || nameInSource.length() == 0 ? orig.getName() : nameInSource);
        copy.setNullable(orig.isNullable());
        copy.setUnique(orig.isUnique());
        EList origTableCols = origTable.getColumns();
        EList copyTableCols = copyTable.getColumns();
        EList origIndexCols = orig.getColumns();
        EList copyIndexCols = copy.getColumns();
        int size = origIndexCols.size();
        int i = 0;
        while (i < size) {
            Column origCol = (Column)origIndexCols.get(i);
            int index = origTableCols.indexOf(origCol);
            if (index != -1) {
                copyIndexCols.add(copyTableCols.get(index));
            }
            ++i;
        }
    }

    private String getUniqueNIS(Table orig) {
        if (orig.getNameInSource() != null && !orig.getNameInSource().trim().equals("")) {
            StringBuffer buffer = new StringBuffer(orig.getNameInSource());
            if (this.usedNIS.contains(buffer.toString())) {
                buffer.append(this.nextIndex);
            }
            this.usedNIS.add(buffer.toString());
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer(MV_PREFIX);
        buffer.append(this.nextIndex);
        return buffer.toString();
    }

    public EList getModelResourceContents() {
        EList eList = null;
        try {
            eList = this.materializedViewModel.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException err) {
            TransformationPlugin.Util.log((Throwable)err);
        }
        return eList;
    }

    public void addValue(Object owner, Object value, EList feature) {
        try {
            this.modelEditor.addValue(owner, value, feature);
        }
        catch (ModelerCoreException err) {
            TransformationPlugin.Util.log((Throwable)err);
        }
    }

    public void setVirtualTables(Collection<EObject> tables) {
        this.virtualTables = new ArrayList<EObject>(tables);
    }

    public Collection<EObject> getVirtualTables() {
        return this.virtualTables;
    }

    public Object getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Object targetLocation) {
        this.targetLocation = targetLocation;
        try {
            if (this.targetLocation instanceof Schema) {
                this.materializedViewModel = ModelUtil.getModel((Object)this.targetLocation);
            } else if (this.targetLocation instanceof IFile) {
                this.materializedViewModel = ModelUtil.getModelResource((IFile)((IFile)this.targetLocation), (boolean)true);
                this.targetLocation = this.materializedViewModel;
            } else if (this.targetLocation instanceof ModelResource) {
                this.materializedViewModel = (ModelResource)this.targetLocation;
            }
        }
        catch (ModelWorkspaceException err) {
            TransformationPlugin.Util.log((Throwable)err);
        }
    }

    public void setMaterializedViewModel(ModelResource materializedViewModel) {
        this.materializedViewModel = materializedViewModel;
    }

    public String getModelName() {
        if (this.materializedViewModel != null) {
            return this.materializedViewModel.getPath().removeFileExtension().lastSegment();
        }
        return UNDEFINED;
    }

    public String getLocationName() {
        if (this.targetLocation != null) {
            if (this.targetLocation instanceof ModelResource) {
                return this.getModelName();
            }
            return ModelerCore.getModelEditor().getName((EObject)((Schema)this.targetLocation));
        }
        return UNDEFINED;
    }

    public IStatus getExecuteStatus() {
        if (this.virtualTables == null || this.virtualTables.isEmpty()) {
            return new Status(4, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.noVirtualTablesSelectedError"));
        }
        for (EObject vTable : this.virtualTables) {
            if (!(vTable instanceof Table)) {
                return new Status(4, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.nonTableSelectedError", (Object)ModelerCore.getModelEditor().getName(vTable)));
            }
            if (!((Table)vTable).isMaterialized()) continue;
            return new Status(2, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.viewAlreadyMaterializedError", (Object)((Table)vTable).getName()));
        }
        if (this.targetLocation == null) {
            return new Status(4, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.targetLocationIsNullError"));
        }
        if (this.materializedViewModel == null) {
            return new Status(4, "org.teiid.designer.transformation", TransformationPlugin.Util.getString("MVModelGenerator.materializedViewModelIsNullError"));
        }
        return OK_STATUS;
    }
}

