/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.ModelType;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.transformation.ddl.TeiidDDLConstants;
import org.teiid.designer.transformation.ddl.TeiidReservedConstants;
import org.teiid.designer.transformation.ddl.TeiidSQLConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.type.IDataTypeManagerService;

public class TeiidModelToDdlGenerator
implements TeiidDDLConstants,
TeiidReservedConstants {
    private StringBuilder ddlBuffer = new StringBuilder();
    private boolean includeTables = true;
    private boolean includeProcedures = true;
    private boolean isVirtual = false;
    private RelationalModelExtensionAssistant assistant;
    private List<IStatus> issues = new ArrayList<IStatus>();

    public String generate(ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource);
        ModelContents contents = ModelContents.getModelContents((ModelResource)modelResource);
        this.isVirtual = modelResource.getModelType().getValue() == ModelType.VIRTUAL;
        this.append("\n");
        for (Object obj : contents.getAllRootEObjects()) {
            String statement = this.getStatement((EObject)obj);
            if (StringUtilities.isEmpty((String)statement)) continue;
            this.append(statement);
            this.append("\n");
        }
        return this.ddlBuffer.toString();
    }

    private String getStatement(EObject eObj) {
        if (eObj instanceof Table) {
            if (this.isVirtual) {
                return this.view((Table)eObj);
            }
            return this.table((Table)eObj);
        }
        if (eObj instanceof Procedure) {
            return this.procedure((Procedure)eObj);
        }
        return null;
    }

    private String getColumnDdl(Column col) {
        String options;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName((EObject)col));
        sb.append(" ");
        String teiidDdlDataType = this.resolveExportedDataType(col.getType());
        sb.append(this.getColumnDatatypeDdl(teiidDdlDataType, col.getLength(), col.getPrecision(), col.getScale()));
        String properties = this.getColumnProperties(col);
        if (!StringUtilities.isEmpty((String)properties)) {
            sb.append(" ").append(properties);
        }
        if (!StringUtilities.isEmpty((String)(options = this.getColumnOptions(col)))) {
            sb.append(" ").append(options);
        }
        return sb.toString();
    }

    private String resolveExportedDataType(EObject dataTypeEObject) {
        String dataTypeName = ModelerCore.getBuiltInTypesManager().getName(dataTypeEObject);
        if (dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.VARBINARY.name())) {
            return dataTypeName;
        }
        String runtimeTypeName = ModelerCore.getBuiltInTypesManager().getRuntimeTypeName(dataTypeEObject);
        if (runtimeTypeName.equalsIgnoreCase("XMLLITERAL")) {
            return IDataTypeManagerService.DataTypeName.XML.name();
        }
        return runtimeTypeName;
    }

    private String getColumnDatatypeDdl(String name, int length, int precision, int scale) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        boolean isLengthType = ModelerCore.getTeiidDataTypeManagerService().isLengthDataType(name);
        boolean isPrecisionType = ModelerCore.getTeiidDataTypeManagerService().isPrecisionDataType(name);
        boolean isScaleType = ModelerCore.getTeiidDataTypeManagerService().isScaleDataType(name);
        if (isLengthType) {
            if (length > 0) {
                sb.append("(").append(length).append(")");
            }
        } else if (isPrecisionType && precision > 0) {
            sb.append("(").append(precision);
            if (isScaleType && scale > 0) {
                sb.append(",").append(" ").append(scale).append(")");
            } else {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getParameterDatatypeDdl(String name, int length, int precision, int scale) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        boolean isLengthType = ModelerCore.getTeiidDataTypeManagerService().isLengthDataType(name);
        boolean isPrecisionType = ModelerCore.getTeiidDataTypeManagerService().isPrecisionDataType(name);
        boolean isScaleType = ModelerCore.getTeiidDataTypeManagerService().isScaleDataType(name);
        if (isLengthType) {
            if (length > 0) {
                sb.append("(").append(length).append(")");
            }
        } else if (isPrecisionType && precision > 0) {
            sb.append("(").append(precision);
            if (isScaleType && scale > 0) {
                sb.append(",").append(" ").append(scale).append(")");
            } else {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getParameterDdl(ProcedureParameter param) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName((EObject)param));
        sb.append(" ");
        String teiidDdlDataType = this.resolveExportedDataType(param.getType());
        sb.append(this.getParameterDatatypeDdl(teiidDdlDataType, param.getLength(), param.getPrecision(), param.getScale()));
        return sb.toString();
    }

    private String getName(EObject eObj) {
        return ModelerCore.getModelEditor().getName(eObj);
    }

    private String getDescription(EObject eObj) {
        try {
            return ModelerCore.getModelEditor().getDescription(eObj);
        }
        catch (ModelerCoreException e) {
            this.issues.add((IStatus)new Status(4, "org.teiid.designer.transformation", "Error finding description for " + this.getName(eObj), (Throwable)e));
            return null;
        }
    }

    private void append(Object o) {
        this.ddlBuffer.append(o);
    }

    private String table(Table table) {
        String constraints;
        if (!this.includeTables) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE FOREIGN TABLE").append(" ");
        sb.append(this.getName((EObject)table));
        sb.append(" (");
        EList columns = table.getColumns();
        int nColumns = columns.size();
        int count = 0;
        for (Column col : columns) {
            if (count == 0) {
                sb.append("\n");
            }
            String columnStr = this.getColumnDdl(col);
            sb.append("\t").append(columnStr);
            if (++count >= nColumns) continue;
            sb.append(",\n");
        }
        if (table instanceof BaseTable && (constraints = this.getContraints((BaseTable)table)) != null) {
            sb.append(constraints);
        }
        sb.append("\n)");
        String options = this.getTableOptions(table);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append(" ").append(options);
        }
        sb.append("\n");
        return sb.toString();
    }

    private String view(Table table) {
        TransformationMappingRoot tRoot;
        String sqlString;
        String constraints;
        if (!this.includeTables) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE VIEW").append(" ");
        sb.append(this.getName((EObject)table));
        sb.append(" (");
        EList columns = table.getColumns();
        int nColumns = columns.size();
        int count = 0;
        for (Column col : columns) {
            if (count == 0) {
                sb.append("\n");
            }
            String columnStr = this.getColumnDdl(col);
            sb.append("\t").append(columnStr);
            if (++count >= nColumns) continue;
            sb.append(",\n");
        }
        if (table instanceof BaseTable && (constraints = this.getContraints((BaseTable)table)) != null) {
            sb.append(constraints);
        }
        sb.append("\n)");
        String options = this.getTableOptions(table);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append(" ").append(options);
        }
        if ((sqlString = TransformationHelper.getSelectSqlString(tRoot = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)table))) != null) {
            sb.append(" ").append("\nAS").append("\n\t\t").append(sqlString);
            sb.append(";\n");
        }
        return sb.toString();
    }

    private String procedure(Procedure procedure) {
        if (!this.includeProcedures) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFunction = procedure.isFunction();
        if (isFunction) {
            if (this.isVirtual) {
                sb.append("CREATE VIRTUAL FUNCTION").append(" ");
            } else {
                sb.append("CREATE FOREIGN FUNCTION").append(" ");
            }
        } else if (this.isVirtual) {
            sb.append("CREATE VIRTUAL PROCEDURE").append(" ");
        } else {
            sb.append("CREATE FOREIGN PROCEDURE").append(" ");
        }
        sb.append(this.getName((EObject)procedure));
        sb.append(" (");
        EList params = procedure.getParameters();
        int nParams = params.size();
        int count = 0;
        for (ProcedureParameter param : params) {
            String paramStr = this.getParameterDdl(param);
            sb.append(paramStr);
            if (++count >= nParams) continue;
            sb.append(", ");
        }
        String options = this.getProcedureOptions(procedure);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append("\n)");
            sb.append(" ").append(options);
        } else {
            sb.append(")");
        }
        if (this.isVirtual && !isFunction) {
            TransformationMappingRoot tRoot = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
            String sqlString = TransformationHelper.getSelectSqlString(tRoot);
            if (sqlString != null) {
                sb.append("\n\t").append("AS").append("\n ").append(sqlString);
                if (!sqlString.endsWith(";")) {
                    sb.append(";");
                }
                sb.append("\n");
            }
        } else {
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getColumnProperties(Column col) {
        boolean autoIncremented;
        String defaultValue;
        StringBuffer sb = new StringBuffer();
        NullableType nullableType = col.getNullable();
        if (nullableType.equals(NullableType.NO_NULLS_LITERAL)) {
            sb.append("NOT NULL").append(" ");
        }
        if ((defaultValue = col.getDefaultValue()) != null) {
            sb.append("DEFAULT").append(" ").append(defaultValue).append(" ");
        }
        if (autoIncremented = col.isAutoIncremented()) {
            sb.append("AUTO_INCREMENT").append(" ");
        }
        if (col.getOwner() instanceof BaseTable) {
            BaseTable cfr_ignored_0 = (BaseTable)col.getOwner();
            if (!col.getIndexes().isEmpty()) {
                sb.append("INDEX").append(" ");
            }
        }
        return sb.toString().trim();
    }

    private String getColumnOptions(Column col) {
        OptionsStatement options = new OptionsStatement();
        options.add("NAMEINSOURCE", col.getNameInSource(), null);
        options.add("NATIVE_TYPE", col.getNativeType(), null);
        options.add("CASE_SENSITIVE", Boolean.toString(col.isCaseSensitive()), Boolean.TRUE.toString());
        options.add("SELECTABLE", Boolean.toString(col.isSelectable()), Boolean.TRUE.toString());
        options.add("UPDATABLE", Boolean.toString(col.isUpdateable()), Boolean.TRUE.toString());
        options.add("SIGNED", Boolean.toString(col.isSigned()), Boolean.TRUE.toString());
        options.add("CURRENCY", Boolean.toString(col.isCurrency()), Boolean.FALSE.toString());
        options.add("FIXED_LENGTH", Boolean.toString(col.isFixedLength()), Boolean.FALSE.toString());
        String desc = this.getDescription((EObject)col);
        if (!StringUtilities.isEmpty((String)desc)) {
            options.add("ANNOTATION", desc, "");
        }
        if (!col.getSearchability().equals(0)) {
            options.add("SEARCHABLE", col.getSearchability().getLiteral(), SearchabilityType.SEARCHABLE_LITERAL.toString());
        }
        return options.toString();
    }

    private String getContraints(BaseTable table) {
        StringBuilder theSB;
        boolean hasUCs;
        StringBuffer sb = new StringBuffer();
        boolean hasPK = table.getPrimaryKey() != null;
        boolean hasFKs = table.getForeignKeys().size() > 0;
        int nColumns = 0;
        int count = 0;
        Collection<UniqueConstraint> uniqueConstraints = this.getUniqueUniqueContraints(table);
        boolean bl = hasUCs = uniqueConstraints.size() > 0;
        if (hasPK) {
            PrimaryKey pk = table.getPrimaryKey();
            String pkName = this.getName((EObject)pk);
            sb.append(",");
            StringBuilder theSB2 = new StringBuilder("\n\tCONSTRAINT " + pkName + " " + "PRIMARY KEY");
            nColumns = pk.getColumns().size();
            count = 0;
            for (Object col : pk.getColumns()) {
                if (++count == 1) {
                    theSB2.append("(");
                }
                theSB2.append(this.getName((EObject)col));
                if (count < nColumns) {
                    theSB2.append(", ");
                    continue;
                }
                theSB2.append(")");
            }
            sb.append(theSB2.toString());
            if (hasFKs || hasUCs) {
                sb.append(",");
            }
        }
        if (hasFKs) {
            int nFKs = table.getForeignKeys().size();
            int countFK = 0;
            for (UniqueConstraint obj : table.getForeignKeys()) {
                ++countFK;
                ForeignKey fk = (ForeignKey)obj;
                String fkName = this.getName((EObject)fk);
                theSB = new StringBuilder("\n\tCONSTRAINT " + fkName + " " + "FOREIGN KEY");
                nColumns = fk.getColumns().size();
                count = 0;
                for (Object col : fk.getColumns()) {
                    if (++count == 1) {
                        theSB.append("(");
                    }
                    theSB.append(this.getName((EObject)col));
                    if (count < nColumns) {
                        theSB.append(", ");
                        continue;
                    }
                    theSB.append(")");
                }
                if (fk.getTable() != null) {
                    theSB.append(" ").append("REFERENCES").append(" ").append(this.getName((EObject)fk.getTable()));
                    BaseTable fkTableRef = fk.getUniqueKey().getTable();
                    PrimaryKey pkRef = fkTableRef.getPrimaryKey();
                    nColumns = pkRef.getColumns().size();
                    count = 0;
                    for (Object col : pkRef.getColumns()) {
                        if (++count == 1) {
                            theSB.append("(");
                        }
                        theSB.append(this.getName((EObject)col));
                        if (count < nColumns) {
                            theSB.append(", ");
                            continue;
                        }
                        theSB.append(")");
                    }
                }
                sb.append(theSB.toString());
                if (countFK >= nFKs) continue;
                sb.append(",");
            }
            if (hasUCs) {
                sb.append(",");
            }
        }
        if (hasUCs) {
            int nUCs = uniqueConstraints.size();
            int ucCount = 0;
            for (UniqueConstraint obj : uniqueConstraints) {
                ++ucCount;
                UniqueConstraint uc = obj;
                String name = this.getName((EObject)uc);
                theSB = new StringBuilder("\n\tCONSTRAINT " + name + " " + "UNIQUE");
                nColumns = uc.getColumns().size();
                count = 0;
                for (Object col : uc.getColumns()) {
                    if (++count == 1) {
                        theSB.append("(");
                    }
                    theSB.append(this.getName((EObject)col));
                    if (count < nColumns) {
                        theSB.append(", ");
                        continue;
                    }
                    theSB.append(")");
                }
                if (ucCount < nUCs) {
                    sb.append(",");
                }
                sb.append(theSB.toString());
            }
        }
        return sb.toString();
    }

    private String getTableOptions(Table table) {
        String desc;
        OptionsStatement options = new OptionsStatement();
        options.add("NAMEINSOURCE", table.getNameInSource(), null);
        options.add("MATERIALIZED", Boolean.toString(table.isMaterialized()), Boolean.FALSE.toString());
        options.add("UPDATABLE", Boolean.toString(table.isSupportsUpdate()), Boolean.TRUE.toString());
        if (table.getCardinality() > 0) {
            options.add("CARDINALITY", Integer.toString(table.getCardinality()), Integer.toString(0));
        }
        if (table.getMaterializedTable() != null) {
            options.add("MATERIALIZED_TABLE", table.getMaterializedTable().getName(), null);
        }
        if (!StringUtilities.isEmpty((String)(desc = this.getDescription((EObject)table)))) {
            options.add("ANNOTATION", desc, null);
        }
        return options.toString();
    }

    private String getProcedureOptions(Procedure procedure) {
        boolean isFunction;
        OptionsStatement options = new OptionsStatement();
        options.add("NAMEINSOURCE", procedure.getNameInSource(), null);
        String nativeQuery = this.getPropertyValue((EObject)procedure, "relational:native-query");
        if (!CoreStringUtil.isEmpty((String)nativeQuery)) {
            options.add("NATIVE-QUERY", nativeQuery, null);
        }
        if (!this.isVirtual) {
            String nonPreparedValue = this.getPropertyValue((EObject)procedure, "relational:non-prepared");
            this.setBooleanProperty("NON-PREPARED", nonPreparedValue, false, options);
        }
        if (isFunction = procedure.isFunction()) {
            boolean booleanValue;
            String value = this.getPropertyValue((EObject)procedure, "relational:function-category");
            options.add("FUNCTION-CATEGORY", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:java-class");
            options.add("JAVA_CLASS", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:java-method");
            options.add("JAVA_METHOD", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:varargs");
            this.setBooleanProperty("VARARGS", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:null-on-null");
            this.setBooleanProperty("NULL-ON-NULL", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:deterministic");
            this.setBooleanProperty("DETERMINISM", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:aggregate");
            if (value != null && (booleanValue = Boolean.getBoolean(value))) {
                this.setBooleanProperty("AGGREGATE", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:analytic");
                this.setBooleanProperty("ANALYTIC", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:allows-orderby");
                this.setBooleanProperty("ALLOWS-ORDERBY", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:uses-distinct-rows");
                this.setBooleanProperty("USES-DISTINCT-ROWS", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:allows-distinct");
                this.setBooleanProperty("ALLOWS-DISTINCT", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:decomposable");
                this.setBooleanProperty("DECOMPOSABLE", value, false, options);
            }
        }
        return options.toString();
    }

    private RelationalModelExtensionAssistant getRelationalModelExtensionAssistant() {
        if (this.assistant == null) {
            this.assistant = RelationalUtil.getRelationalExtensionAssistant();
        }
        return this.assistant;
    }

    private String getPropertyValue(EObject eObj, String propertyID) {
        try {
            return this.getRelationalModelExtensionAssistant().getPropertyValue((Object)eObj, propertyID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setBooleanProperty(String propID, String stringValue, boolean defaultValue, OptionsStatement options) {
        if (stringValue != null) {
            boolean booleanValue = Boolean.parseBoolean(stringValue);
            options.add(propID, String.valueOf(booleanValue), String.valueOf(defaultValue));
        }
    }

    private String escapeStringValue(String str, String tick) {
        return StringUtilities.replaceAll((String)str, (String)tick, (String)(String.valueOf(tick) + tick));
    }

    private String escapeSinglePart(String token) {
        if (TeiidSQLConstants.isReservedWord(token)) {
            return "\"" + token + "\"";
        }
        boolean escape = true;
        char start = token.charAt(0);
        if ("#".equals(Character.toString(start)) || "@".equals(Character.toString(start)) || StringUtilities.isLetter((char)start)) {
            escape = false;
            int i = 1;
            while (!escape && i < token.length()) {
                char c = token.charAt(i);
                escape = !StringUtilities.isLetterOrDigit((char)c) && c != '_';
                ++i;
            }
        }
        if (escape) {
            return "\"" + this.escapeStringValue(token, "\"") + "\"";
        }
        return token;
    }

    private Collection<UniqueConstraint> getUniqueUniqueContraints(BaseTable table) {
        EList ucs = table.getUniqueConstraints();
        ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();
        PrimaryKey pk = table.getPrimaryKey();
        for (Object obj : ucs) {
            UniqueConstraint uc = (UniqueConstraint)obj;
            if (pk != null) {
                EList pkColumns = pk.getColumns();
                EList ucColumns = uc.getColumns();
                if (pkColumns.size() == ucColumns.size()) {
                    boolean matchesAll = true;
                    for (Object col : ucColumns) {
                        if (pkColumns.contains(col)) continue;
                        matchesAll = false;
                    }
                    if (matchesAll) continue;
                    uniqueConstraints.add(uc);
                    continue;
                }
                uniqueConstraints.add(uc);
                continue;
            }
            uniqueConstraints.add(uc);
        }
        return uniqueConstraints;
    }

    class OptionsStatement {
        boolean hasOptions;
        StringBuilder sb = new StringBuilder();

        public OptionsStatement() {
            this.sb.append("OPTIONS").append("(");
        }

        public void add(String key, String value, String defaultValue) {
            if (StringUtilities.isEmpty((String)value)) {
                return;
            }
            if (!StringUtilities.areDifferent((String)value, (String)defaultValue)) {
                return;
            }
            if (this.hasOptions) {
                this.sb.append(", ");
            }
            this.hasOptions = true;
            this.sb.append(TeiidModelToDdlGenerator.this.escapeSinglePart(key)).append(" ");
            if ("FALSE".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
                this.sb.append("'" + value.toUpperCase() + "'");
                return;
            }
            this.sb.append("'" + value + "'");
        }

        public String toString() {
            this.sb.append(")");
            if (!this.hasOptions) {
                return null;
            }
            return this.sb.toString();
        }
    }

    class ProcedureHandler {
        Procedure proc;

        public ProcedureHandler(Procedure procedure) {
            this.proc = procedure;
        }
    }
}

