/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.EditColumnDialog;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.panels.EditColumnsPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class ColumnsInfoPanel {
    private ProcedureInfo procedureInfo;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Button editButton;
    private Text rootPathText;
    private Shell shell;
    TreeViewer schemaTreeViewer;
    EditColumnsPanel editColumnsPanel;
    private int type = -1;
    final OperationsDetailsPage detailsPage;
    boolean initializing = false;

    public ColumnsInfoPanel(Composite parent, int style, int type, OperationsDetailsPage detailsPage) {
        this.type = type;
        this.detailsPage = detailsPage;
        this.shell = parent.getShell();
        this.init(parent);
    }

    public ProcedureInfo getProcedureInfo() {
        return this.procedureInfo;
    }

    public void setProcedureInfo(ProcedureInfo info) {
        this.initializing = true;
        this.procedureInfo = info;
        this.editColumnsPanel.setProcedureInfo(info);
        this.editColumnsPanel.refresh();
        this.addButton.setEnabled(info != null);
        String rootPath = "";
        if (this.getProcedureInfo().getRootPath() != null) {
            rootPath = this.getProcedureInfo().getRootPath();
        }
        this.rootPathText.setText(rootPath);
        this.initializing = false;
    }

    public void refresh() {
        this.editColumnsPanel.refresh();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Text getRootPathText() {
        return this.rootPathText;
    }

    private void init(Composite parent) {
        Group columnInfoGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.ColumnInfo, (int)0, (int)3, (int)3);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.grabExcessVerticalSpace = true;
        columnInfoGroup.setLayoutData((Object)gd);
        Label prefixLabel = new Label((Composite)columnInfoGroup, 0);
        prefixLabel.setText(Messages.RootPath);
        this.rootPathText = WidgetFactory.createTextField((Composite)columnInfoGroup, (int)0);
        gd = new GridData(768);
        gd.minimumWidth = 50;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.rootPathText.setLayoutData((Object)gd);
        this.rootPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ColumnsInfoPanel.this.notifyColumnDataChanged();
            }
        });
        Composite leftToolbarPanel = new Composite((Composite)columnInfoGroup, 0);
        GridLayout tbGL = new GridLayout();
        tbGL.numColumns = 1;
        tbGL.marginHeight = 0;
        tbGL.marginWidth = 0;
        tbGL.verticalSpacing = 2;
        leftToolbarPanel.setLayout((Layout)tbGL);
        GridData ltpGD = new GridData(1040);
        ltpGD.heightHint = 120;
        leftToolbarPanel.setLayoutData((Object)ltpGD);
        this.addButton = new Button(leftToolbarPanel, 8);
        this.addButton.setText(Messages.Add);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiBusyIndicator.showWhile((Display)ColumnsInfoPanel.this.addButton.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String name = null;
                        try {
                            (this).ColumnsInfoPanel.this.initializing = true;
                            name = (this).ColumnsInfoPanel.this.detailsPage.createResponseColumn(ColumnsInfoPanel.this.type);
                        }
                        finally {
                            (this).ColumnsInfoPanel.this.initializing = false;
                        }
                        if (name == null) {
                            return;
                        }
                        boolean ok = MessageDialog.openQuestion((Shell)(this).ColumnsInfoPanel.this.detailsPage.getShell(), (String)Messages.InvalidSelectedSchemaObject, (String)NLS.bind((String)Messages.InvalidSelectedSchemaObject_column_msg, (Object)name));
                        if (!ok) {
                            return;
                        }
                        if (ColumnsInfoPanel.this.type == 0) {
                            (this).ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().addBodyColumn(name, false, "string", null, null, null);
                        } else {
                            (this).ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().addHeaderColumn(name, false, "string", null, null, null);
                        }
                        (this).ColumnsInfoPanel.this.editColumnsPanel.refresh();
                        ColumnsInfoPanel.this.notifyColumnDataChanged();
                    }
                });
            }
        });
        this.deleteButton = new Button(leftToolbarPanel, 8);
        this.deleteButton.setText(Messages.Delete);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    if (ColumnsInfoPanel.this.type == 0) {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().removeBodyColumn(info);
                    } else {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().removeHeaderColumn(info);
                    }
                    ColumnsInfoPanel.this.deleteButton.setEnabled(false);
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(-1);
                    ColumnsInfoPanel.this.editColumnsPanel.refresh();
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                }
            }
        });
        this.editButton = new Button(leftToolbarPanel, 8);
        this.editButton.setText(Messages.Edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    EditColumnDialog dialog = new EditColumnDialog(ColumnsInfoPanel.this.getShell(), ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn());
                    dialog.open();
                }
                ColumnsInfoPanel.this.editButton.setEnabled(true);
                ColumnsInfoPanel.this.editColumnsPanel.refresh();
                ColumnsInfoPanel.this.notifyColumnDataChanged();
            }
        });
        this.upButton = new Button(leftToolbarPanel, 8);
        this.upButton.setText(Messages.Up);
        this.upButton.setLayoutData((Object)new GridData(768));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ColumnsInfoPanel.this.editColumnsPanel.getSelectedIndex();
                    if (ColumnsInfoPanel.this.type == 0) {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().moveBodyColumnUp(info);
                        ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveBodyColumnDown(info));
                        ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveBodyColumnUp(info));
                    } else {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().moveHeaderColumnUp(info);
                        ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveHeaderColumnDown(info));
                        ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveHeaderColumnUp(info));
                    }
                    ColumnsInfoPanel.this.editColumnsPanel.refresh();
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(selectedIndex - 1);
                }
            }
        });
        this.downButton = new Button(leftToolbarPanel, 8);
        this.downButton.setText(Messages.Down);
        this.downButton.setLayoutData((Object)new GridData(768));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ColumnsInfoPanel.this.editColumnsPanel.getSelectedIndex();
                    if (ColumnsInfoPanel.this.type == 0) {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().moveBodyColumnDown(info);
                        ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveBodyColumnDown(info));
                        ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveBodyColumnUp(info));
                    } else {
                        ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().moveHeaderColumnDown(info);
                        ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveHeaderColumnDown(info));
                        ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.detailsPage.getProcedureGenerator().getResponseInfo().canMoveHeaderColumnUp(info));
                    }
                    ColumnsInfoPanel.this.editColumnsPanel.refresh();
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(selectedIndex + 1);
                }
            }
        });
        this.editColumnsPanel = new EditColumnsPanel((Composite)columnInfoGroup, 0, this.type, this.detailsPage);
        this.editColumnsPanel.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ColumnsInfoPanel.this.deleteButton.setEnabled(false);
                    ColumnsInfoPanel.this.editButton.setEnabled(false);
                    ColumnsInfoPanel.this.upButton.setEnabled(false);
                    ColumnsInfoPanel.this.downButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    ColumnInfo columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof ColumnInfo)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (ColumnInfo)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ColumnsInfoPanel.this.deleteButton.setEnabled(enable);
                    ColumnsInfoPanel.this.editButton.setEnabled(enable);
                    if (enable) {
                        if (ColumnsInfoPanel.this.type == 0) {
                            ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.procedureInfo.canMoveBodyColumnUp(columnInfo));
                            ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.procedureInfo.canMoveBodyColumnDown(columnInfo));
                        } else {
                            ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.procedureInfo.canMoveHeaderColumnUp(columnInfo));
                            ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.procedureInfo.canMoveHeaderColumnDown(columnInfo));
                        }
                    }
                }
            }
        });
    }

    private void notifyColumnDataChanged() {
        if (!this.initializing) {
            this.detailsPage.notifyColumnDataChanged();
        }
    }

    public void disableButtons() {
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    public void setEnabled(boolean enable) {
        this.addButton.setEnabled(enable);
        this.disableButtons();
        this.rootPathText.setEnabled(enable);
        this.editColumnsPanel.setEnabled(enable);
    }
}

