/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.modelgenerator.wsdl.ModelBuildingException;
import org.teiid.designer.modelgenerator.wsdl.RelationalModelBuilder;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiPlugin;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportWsdlProcessor;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ModelDefinitionPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsOptionsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.WsdlDefinitionPage;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class ImportWsdlSoapWizard
extends AbstractWizard
implements IImportWizard,
IPropertiesContext {
    private static final String TITLE = Messages.ImportWsdlSoapWizard_title;
    private static final ImageDescriptor IMAGE = ModelGeneratorWsdlUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_wsdl.gif");
    private WSDLImportWizardManager importManager = new WSDLImportWizardManager();
    private WsdlDefinitionPage selectWsdlPage;
    private WizardPage operationsDetailsPage;
    private WizardPage modelDefinitionPage;
    private WizardPage operationsOptionsPage;
    private IStructuredSelection selection;
    private boolean openProjectExists = true;
    private IProject newProject;

    public ImportWsdlSoapWizard() {
        super((AbstractUIPlugin)ModelGeneratorWsdlUiPlugin.getDefault(), TITLE, IMAGE);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.updateForProperties();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        IProject targetProject = null;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                this.selection = new StructuredSelection((Object)this.newProject);
                targetProject = this.newProject;
                this.openProjectExists = true;
            } else {
                this.openProjectExists = false;
            }
        }
        Object selectedObj = this.selection.getFirstElement();
        if (targetProject == null && selectedObj instanceof IResource) {
            targetProject = ((IResource)selectedObj).getProject();
        }
        this.importManager.setTargetProject(targetProject);
        this.createWizardPages((ISelection)this.selection);
        this.setNeedsProgressMonitor(true);
    }

    public void createWizardPages(ISelection theSelection) {
        if (!this.openProjectExists) {
            this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
            return;
        }
        this.selectWsdlPage = new WsdlDefinitionPage(this.importManager, this);
        this.selectWsdlPage.setPageComplete(false);
        this.addPage((IWizardPage)this.selectWsdlPage);
        this.modelDefinitionPage = new ModelDefinitionPage(this.importManager, this);
        this.modelDefinitionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.modelDefinitionPage);
        this.operationsOptionsPage = new OperationsOptionsPage(this.importManager, this);
        this.operationsOptionsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.operationsOptionsPage);
        this.operationsDetailsPage = new OperationsDetailsPage(this.importManager);
        this.operationsDetailsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.operationsDetailsPage);
        this.selectWsdlPage.setInitialSelection(theSelection);
    }

    public boolean finish() {
        if (!this.importManager.doGenerateDefaultProcedures()) {
            this.runFinishWithDetails();
            return true;
        }
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Generate Models From WSDL", (Object)new Object());
                boolean succeeded = false;
                try {
                    try {
                        ImportWsdlSoapWizard.this.runFinishAsDefault(monitor);
                        succeeded = true;
                    }
                    catch (ModelBuildingException mbe) {
                        mbe.printStackTrace(System.err);
                        throw new InvocationTargetException(mbe);
                    }
                    catch (Throwable t) {
                        throw new InvocationTargetException(t);
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            try {
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
                dlg.run(true, true, op);
                result = true;
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)err).getTargetException();
                    Status iteStatus = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", 4, Messages.ImportWsdlSoapWizard_importError_msg, t);
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWsdlSoapWizard_importError_title, (String)Messages.ImportWsdlSoapWizard_importError_msg, (IStatus)iteStatus);
                    t.printStackTrace(System.err);
                } else {
                    Status status = new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", 4, Messages.ImportWsdlSoapWizard_importError_msg, err);
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportWsdlSoapWizard_importError_title, (String)Messages.ImportWsdlSoapWizard_importError_msg, (IStatus)status);
                    err.printStackTrace(System.err);
                }
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
        return result;
    }

    private void runFinishAsDefault(IProgressMonitor theMonitor) throws ModelGenerationException, SchemaProcessingException, ModelBuildingException {
        this.importManager.getViewModelLocation();
        Model model = this.importManager.getWSDLModel();
        RelationalModelBuilder modelBuilder = new RelationalModelBuilder(model, this.importManager.getConnectionProfile());
        try {
            modelBuilder.modelOperations(this.importManager.getSelectedOperations(), this.importManager.getSourceModelLocation(), this.importManager.getSourceModelName(), this.importManager.getViewModelLocation(), this.importManager.getViewModelName());
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        catch (ModelerCoreException e) {
            e.printStackTrace();
        }
    }

    private void runFinishWithDetails() {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ImportWsdlProcessor processor = new ImportWsdlProcessor(ImportWsdlSoapWizard.this.importManager, Display.getCurrent().getActiveShell());
                processor.execute();
            }
        }, (boolean)false);
    }

    public void notifyManagerChanged() {
        boolean doGenerate = this.importManager.doGenerateDefaultProcedures();
        if (doGenerate) {
            this.removePage((IWizardPage)this.operationsDetailsPage);
        } else {
            this.addPage((IWizardPage)this.operationsDetailsPage);
        }
    }

    public void setProperties(Properties props) {
        this.importManager.setDesignerProperties(props);
    }

    protected void updateForProperties() {
        String profileName;
        IProject project;
        Properties designerProperties = this.importManager.getDesignerProperties();
        if (designerProperties == null) {
            return;
        }
        if (this.importManager.getSourceModelLocation() == null) {
            project = DesignerPropertiesUtil.getProject((Properties)designerProperties);
            IContainer srcResource = DesignerPropertiesUtil.getSourcesFolder((Properties)designerProperties);
            if (srcResource != null) {
                this.importManager.setSourceModelLocation(srcResource);
            } else if (project != null) {
                this.importManager.setSourceModelLocation((IContainer)project);
            }
        }
        if (this.importManager.getViewModelLocation() == null) {
            project = DesignerPropertiesUtil.getProject((Properties)designerProperties);
            IContainer viewResource = DesignerPropertiesUtil.getViewsFolder((Properties)designerProperties);
            if (viewResource != null) {
                this.importManager.setViewModelLocation(viewResource);
            } else if (project != null) {
                this.importManager.setViewModelLocation((IContainer)project);
            }
        }
        if (this.importManager.getConnectionProfile() == null && (profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)designerProperties)) != null && !profileName.isEmpty()) {
            this.selectWsdlPage.selectConnectionProfile(profileName);
        }
        if (!this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus((Properties)designerProperties, (String)"noOpenProject");
        }
    }
}

