/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDAttributeUseImpl;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.Part;
import org.teiid.designer.modelgenerator.wsdl.model.impl.ModelImpl;
import org.teiid.designer.modelgenerator.wsdl.schema.extensions.SOAPSchemaProcessor;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.WSDLImportWizardManager;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ColumnInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.OperationsDetailsPage;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureGenerator;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ProcedureInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.SchemaTreeModel;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.BaseSchemaObject;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ImportWsdlSchemaHandler {
    private static final String WSDL_SCHEMA_HANDLER_RECURSIVE_DEPTH_PROPERTY = "WsdlSchemaHandlerRecursiveDepth";
    private static int MAX_DEPTH = 750;
    private WSDLImportWizardManager importManager;
    private OperationsDetailsPage operationsDetailsPage;
    private SchemaTreeModel requestSchemaTreeModel = null;
    private SchemaTreeModel responseSchemaTreeModel = null;
    private SchemaTreeModel.SchemaNode rootnode = null;
    private SchemaModel schemaModel;
    private int depth = 0;
    boolean circularSchemaWarningTriggered = false;

    static {
        try {
            String value = System.getProperty(WSDL_SCHEMA_HANDLER_RECURSIVE_DEPTH_PROPERTY);
            if (value != null) {
                MAX_DEPTH = Integer.parseInt(value);
            }
        }
        catch (Exception ex) {
            ModelGeneratorWsdlPlugin.Util.log((Throwable)ex);
        }
    }

    public ImportWsdlSchemaHandler(WSDLImportWizardManager manager, OperationsDetailsPage operationsDetailsPage) {
        this.importManager = manager;
        this.operationsDetailsPage = operationsDetailsPage;
    }

    public List<SchemaTreeModel.SchemaNode> getSchemaForSelectedOperation(IWsdlConstants.ProcedureType type, ProcedureGenerator generator) {
        Model wsdlModel = null;
        Object elementDeclaration = null;
        if (IWsdlConstants.ProcedureType.REQUEST.equals((Object)type)) {
            this.requestSchemaTreeModel = new SchemaTreeModel();
        } else {
            this.responseSchemaTreeModel = new SchemaTreeModel();
        }
        try {
            wsdlModel = this.importManager.getWSDLModel();
        }
        catch (ModelGenerationException e) {
            throw new RuntimeException(e);
        }
        XSDSchema[] schemas = wsdlModel.getSchemas();
        Operation selectedOperation = generator.getOperation();
        String partElementName = null;
        Part[] partArray = null;
        if (IWsdlConstants.ProcedureType.REQUEST.equals((Object)type)) {
            if (selectedOperation.getInputMessage() != null) {
                partArray = selectedOperation.getInputMessage().getParts();
            }
        } else if (selectedOperation.getOutputMessage() != null) {
            partArray = selectedOperation.getOutputMessage().getParts();
        }
        ArrayList<XSDElementDeclaration> elementArrayList = new ArrayList<XSDElementDeclaration>();
        if (partArray != null) {
            Part[] partArray2 = partArray;
            int n = partArray.length;
            int n2 = 0;
            while (n2 < n) {
                Part part = partArray2[n2];
                partElementName = this.getPartElementName(part);
                String namespace = part.getElementNamespace();
                if (IWsdlConstants.ProcedureType.REQUEST.equals((Object)type)) {
                    this.requestSchemaTreeModel.setNamespace(namespace);
                } else {
                    this.responseSchemaTreeModel.setNamespace(namespace);
                }
                boolean foundElement = false;
                XSDSchema[] xSDSchemaArray = schemas;
                int n3 = schemas.length;
                int n4 = 0;
                while (n4 < n3) {
                    XSDSchema schema = xSDSchemaArray[n4];
                    EList elements = schema.getElementDeclarations();
                    for (XSDElementDeclaration element : elements) {
                        String elementName = element.getName();
                        if (!elementName.equals(partElementName)) continue;
                        elementDeclaration = element.getTypeDefinition() instanceof XSDSimpleTypeDefinition ? element : element.getTypeDefinition();
                        foundElement = true;
                        try {
                            if (IWsdlConstants.ProcedureType.REQUEST.equals((Object)type)) {
                                this.requestSchemaTreeModel = this.describe(schema, elementName, element, this.requestSchemaTreeModel);
                            } else {
                                this.responseSchemaTreeModel = this.describe(schema, elementName, element, this.responseSchemaTreeModel);
                            }
                        }
                        catch (ModelerCoreException ex) {
                            this.openErrorDialog(ex.getMessage());
                        }
                        catch (StackOverflowError stackOverflowError) {
                            String message = NLS.bind((String)Messages.Error_GeneratingSchemaModelCircularReferenceStackOverflow, (Object)MAX_DEPTH, (Object)WSDL_SCHEMA_HANDLER_RECURSIVE_DEPTH_PROPERTY);
                            this.openErrorDialog(message);
                            System.exit(1);
                        }
                        elementArrayList.add((XSDElementDeclaration)elementDeclaration);
                        break;
                    }
                    if (foundElement) break;
                    if (elementDeclaration == null) {
                        EList types = schema.getTypeDefinitions();
                        for (XSDTypeDefinition xsdType : types) {
                            String elementName = xsdType.getName();
                            if (!elementName.equals(partElementName)) continue;
                            elementDeclaration = xsdType;
                            foundElement = true;
                            try {
                                if (IWsdlConstants.ProcedureType.REQUEST.equals((Object)type)) {
                                    this.requestSchemaTreeModel = this.describe(schema, elementName, null, this.requestSchemaTreeModel);
                                } else {
                                    this.responseSchemaTreeModel = this.describe(schema, elementName, null, this.responseSchemaTreeModel);
                                }
                            }
                            catch (ModelerCoreException modelerCoreException) {
                                ErrorDialog.openError((Shell)this.operationsDetailsPage.getShell(), (String)Messages.Error_GeneratingSchemaModelDueToCircularReferences_title, null, (IStatus)new Status(2, "org.teiid.designer.modelgenerator.wsdl.ui", Messages.Error_GeneratingSchemaModelDueToCircularReferences));
                            }
                            elementArrayList.add((XSDElementDeclaration)elementDeclaration);
                            break;
                        }
                    }
                    if (foundElement) {
                        foundElement = false;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        Collection<Object> nodeList = new ArrayList();
        nodeList = IWsdlConstants.ProcedureType.REQUEST.equals((Object)type) ? this.requestSchemaTreeModel.getNodeList() : this.responseSchemaTreeModel.getNodeList();
        ArrayList<SchemaTreeModel.SchemaNode> elementsArray = new ArrayList<SchemaTreeModel.SchemaNode>();
        for (SchemaTreeModel.SchemaNode schemaNode : nodeList) {
            if (!schemaNode.isRoot()) continue;
            elementsArray.add(schemaNode);
        }
        return elementsArray;
    }

    private void openErrorDialog(String msg) {
        ErrorDialog.openError((Shell)this.operationsDetailsPage.getShell(), (String)Messages.Error_GeneratingSchemaModelDueToCircularReferences_title, null, (IStatus)new Status(2, "org.teiid.designer.modelgenerator.wsdl.ui", msg));
    }

    private String getPartElementName(Part part) {
        String partElementName = null;
        partElementName = part.getTypeName();
        if (partElementName == null) {
            partElementName = part.getElementName();
        }
        return partElementName;
    }

    public SchemaTreeModel getResponseSchemaTreeModel() {
        return this.responseSchemaTreeModel;
    }

    public String createRequestColumn(int type, IStructuredSelection selection, ProcedureInfo requestInfo) {
        SchemaTreeModel.SchemaNode node = (SchemaTreeModel.SchemaNode)selection.getFirstElement();
        Object obj = node.getElement();
        requestInfo.setTreeModel(this.requestSchemaTreeModel);
        if (this.requestSchemaTreeModel.getNamespace() != null) {
            try {
                requestInfo.addNamespace((String)((ModelImpl)this.importManager.getWSDLModel()).getNamespaces().get(this.requestSchemaTreeModel.getNamespace()), this.requestSchemaTreeModel.getNamespace());
            }
            catch (ModelGenerationException ex) {
                throw new RuntimeException(ex);
            }
        }
        String name = null;
        String ns = null;
        if (obj instanceof XSDParticleImpl && ((XSDParticleImpl)obj).getContent() instanceof XSDElementDeclarationImpl) {
            name = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getName();
            if (name == null) {
                name = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getResolvedElementDeclaration().getName();
            }
            ns = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getTargetNamespace();
            try {
                if (ns != null) {
                    requestInfo.addNamespace((String)((ModelImpl)this.importManager.getWSDLModel()).getReverseNamespaces().get(ns), ns);
                }
            }
            catch (ModelGenerationException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            if (type == 0) {
                requestInfo.addBodyColumn(requestInfo.getUniqueBodyColumnName(name), false, "string", null, null, ns);
            } else {
                requestInfo.addHeaderColumn(requestInfo.getUniqueHeaderColumnName(name), false, "string", null, null, ns);
            }
            this.operationsDetailsPage.notifyColumnDataChanged();
            return null;
        }
        if (obj instanceof XSDElementDeclarationImpl) {
            name = ((XSDElementDeclarationImpl)obj).getName();
            ns = ((XSDElementDeclarationImpl)obj).getTargetNamespace();
            if (type == 0) {
                requestInfo.addBodyColumn(requestInfo.getUniqueBodyColumnName(name), false, "string", null, null, ns);
            } else {
                requestInfo.addHeaderColumn(requestInfo.getUniqueHeaderColumnName(name), false, "string", null, null, ns);
            }
            this.operationsDetailsPage.notifyColumnDataChanged();
            return null;
        }
        if (obj instanceof XSDAttributeUseImpl) {
            XSDAttributeUseImpl attributeImpl = (XSDAttributeUseImpl)obj;
            name = attributeImpl.getAttributeDeclaration().getName();
            if (name == null) {
                name = attributeImpl.getAttributeDeclaration().getAliasName();
            }
            ns = attributeImpl.getAttributeDeclaration().getTargetNamespace();
            ColumnInfo columnInfo = this.getColumnInfoForAttribute(type, requestInfo, (XSDAttributeUse)attributeImpl, node);
            columnInfo.addAttributeInfo(columnInfo.getXmlElement(), columnInfo.getUniqueAttributeName(name));
            this.operationsDetailsPage.notifyColumnDataChanged();
            return null;
        }
        return this.operationsDetailsPage.getSchemaLabelProvider().getText(obj);
    }

    private ColumnInfo getColumnInfoForAttribute(int type, ProcedureInfo requestInfo, XSDAttributeUse attributeUse, SchemaTreeModel.SchemaNode parentNode) {
        SchemaTreeModel.SchemaNode parentSchemaNode = this.getParentElement(parentNode);
        if (parentSchemaNode != null) {
            Object parentElement = parentSchemaNode.getElement();
            ColumnInfo[] columnInfoArray = requestInfo.getBodyColumnInfoList();
            int n = columnInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo info = columnInfoArray[n2];
                if (parentElement == info.getXmlElement()) {
                    return info;
                }
                ++n2;
            }
            String name = null;
            String ns = null;
            ColumnInfo newInfo = null;
            if (parentElement instanceof XSDParticleImpl && ((XSDParticleImpl)parentElement).getContent() instanceof XSDElementDeclarationImpl) {
                name = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getName();
                if (name == null) {
                    name = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getResolvedElementDeclaration().getName();
                }
                ns = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getTargetNamespace();
                if (type == 0) {
                    newInfo = requestInfo.addBodyColumn(requestInfo.getUniqueBodyColumnName(name), false, "string", null, null, ns);
                    newInfo.setXmlElement(parentElement);
                } else {
                    newInfo = requestInfo.addHeaderColumn(requestInfo.getUniqueHeaderColumnName(name), false, "string", null, null, ns);
                    newInfo.setXmlElement(parentElement);
                }
                this.operationsDetailsPage.notifyColumnDataChanged();
            } else if (parentElement instanceof XSDElementDeclarationImpl) {
                name = ((XSDElementDeclarationImpl)parentElement).getName();
                ns = ((XSDElementDeclarationImpl)parentElement).getTargetNamespace();
                if (type == 0) {
                    newInfo = requestInfo.addBodyColumn(requestInfo.getUniqueBodyColumnName(name), false, "string", null, null, ns);
                    newInfo.setXmlElement(parentElement);
                } else {
                    newInfo = requestInfo.addHeaderColumn(requestInfo.getUniqueHeaderColumnName(name), false, "string", null, null, ns);
                    newInfo.setXmlElement(parentElement);
                }
                this.operationsDetailsPage.notifyColumnDataChanged();
            }
            return newInfo;
        }
        return null;
    }

    public static boolean shouldCreateRequestColumn(Object obj) {
        XSDTypeDefinition type;
        if (obj instanceof XSDParticleImpl) {
            XSDParticleContent content = ((XSDParticleImpl)obj).getContent();
            if (content instanceof XSDElementDeclarationImpl) {
                return !(((XSDElementDeclaration)content).getType() instanceof XSDComplexTypeDefinition);
            }
            return !(content instanceof XSDModelGroup);
        }
        return obj instanceof XSDElementDeclarationImpl ? (type = ((XSDElementDeclarationImpl)obj).getTypeDefinition()) instanceof XSDSimpleTypeDefinitionImpl : obj instanceof XSDAttributeUseImpl;
    }

    public static boolean shouldCreateResponseColumn(Object obj) {
        XSDTypeDefinition type;
        if (obj instanceof XSDParticleImpl) {
            XSDParticleContent content = ((XSDParticleImpl)obj).getContent();
            if (content instanceof XSDElementDeclarationImpl) {
                return !(((XSDElementDeclaration)content).getType() instanceof XSDComplexTypeDefinition);
            }
            return !(content instanceof XSDModelGroup);
        }
        return obj instanceof XSDElementDeclarationImpl ? (type = ((XSDElementDeclarationImpl)obj).getTypeDefinition()) instanceof XSDSimpleTypeDefinitionImpl : obj instanceof XSDAttributeUseImpl;
    }

    public String createResponseColumn(int type, IStructuredSelection selection, ProcedureInfo responseInfo) {
        SchemaTreeModel.SchemaNode node = (SchemaTreeModel.SchemaNode)selection.getFirstElement();
        if (node == null) {
            return null;
        }
        Object obj = node.getElement();
        responseInfo.setTreeModel(this.responseSchemaTreeModel);
        if (!ImportWsdlSchemaHandler.shouldCreateResponseColumn(obj)) {
            return this.operationsDetailsPage.getSchemaLabelProvider().getText(obj);
        }
        if (obj instanceof XSDParticleImpl && ((XSDParticleImpl)obj).getContent() instanceof XSDElementDeclarationImpl) {
            String pathPrefix;
            Model wsdlModel = null;
            try {
                wsdlModel = this.operationsDetailsPage.getImportManager().getWSDLModel();
            }
            catch (ModelGenerationException e) {
                throw new RuntimeException(e);
            }
            SOAPSchemaProcessor processor = new SOAPSchemaProcessor(null);
            processor.representTypes(true);
            processor.setNamespaces(wsdlModel.getNamespaces());
            XSDSchema[] schemas = wsdlModel.getSchemas();
            try {
                processor.processSchemas(schemas);
            }
            catch (SchemaProcessingException e) {
                throw new RuntimeException(e);
            }
            this.schemaModel = processor.getSchemaModel();
            List elements = this.schemaModel.getElements();
            XSDElementDeclaration element = (XSDElementDeclaration)((XSDParticleImpl)obj).getContent();
            XSDTypeDefinition typeDefinition = element.getType();
            String name = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getName();
            if (name == null) {
                name = ((XSDElementDeclarationImpl)((XSDParticleImpl)obj).getContent()).getResolvedElementDeclaration().getName();
            }
            StringBuilder xpath = new StringBuilder();
            String namespace = null;
            String prefix = null;
            StringBuilder parentXpath = new StringBuilder();
            if (this.importManager.isMessageServiceMode()) {
                responseInfo.addNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            if (this.responseSchemaTreeModel.getNamespace() != null) {
                responseInfo.addNamespace((String)((ModelImpl)wsdlModel).getReverseNamespaces().get(this.responseSchemaTreeModel.getNamespace()), this.responseSchemaTreeModel.getNamespace());
            }
            this.getParentXpath(node, parentXpath, this.responseSchemaTreeModel);
            for (SchemaObject schemaObject : elements) {
                if (!schemaObject.getName().equals(name)) continue;
                namespace = schemaObject.getNamespace();
                prefix = ((BaseSchemaObject)schemaObject).getNamespacePrefix();
                if (namespace == null) break;
                responseInfo.addNamespace(prefix, namespace);
                break;
            }
            this.responseSchemaTreeModel.setNamespaceMap(responseInfo.getNamespaceMap());
            if (this.responseSchemaTreeModel.getRootPath() == null || this.responseSchemaTreeModel.getRootPath().isEmpty()) {
                this.responseSchemaTreeModel.setRootPath(this.responseSchemaTreeModel.determineRootPath());
            }
            if (this.importManager.isMessageServiceMode()) {
                this.operationsDetailsPage.responseBodyColumnsInfoPanel.getRootPathText().setText("/soap:Envelope");
            } else {
                this.operationsDetailsPage.responseBodyColumnsInfoPanel.getRootPathText().setText(this.responseSchemaTreeModel.getRootPath());
            }
            responseInfo.setRootPath(this.responseSchemaTreeModel.getRootPath());
            this.getRelativeXpath(node, xpath, this.responseSchemaTreeModel);
            if (type == 0) {
                pathPrefix = "";
                if (this.importManager.isMessageServiceMode()) {
                    pathPrefix = "/soap:Body";
                    String root = this.responseSchemaTreeModel.getRootPath().replaceAll("/soap:Envelope", "");
                    xpath = new StringBuilder(root).append((CharSequence)xpath);
                }
                String theType = "string";
                if (typeDefinition != null && typeDefinition.getName() != null) {
                    theType = typeDefinition.getName();
                }
                String runtimeTypeName = theType;
                try {
                    runtimeTypeName = DatatypeUtilities.getRuntimeTypeName((String)theType);
                }
                catch (ModelerCoreException ex) {
                    ex.printStackTrace();
                }
                if (runtimeTypeName != null && !runtimeTypeName.equalsIgnoreCase(theType)) {
                    theType = runtimeTypeName;
                }
                responseInfo.addBodyColumn(responseInfo.getUniqueBodyColumnName(name), false, theType, null, String.valueOf(pathPrefix) + xpath.toString(), null);
            } else {
                pathPrefix = "";
                if (this.importManager.isMessageServiceMode()) {
                    pathPrefix = "/soap:Header";
                }
                responseInfo.addHeaderColumn(responseInfo.getUniqueHeaderColumnName(name), false, "string", null, String.valueOf(pathPrefix) + xpath.toString(), null);
            }
            this.operationsDetailsPage.notifyColumnDataChanged();
            return null;
        }
        if (obj instanceof XSDAttributeUseImpl) {
            String pathPrefix;
            String dTypeString;
            XSDElementDeclaration content;
            Object parentElement;
            Model wsdlModel = null;
            try {
                wsdlModel = this.operationsDetailsPage.getImportManager().getWSDLModel();
            }
            catch (ModelGenerationException e) {
                throw new RuntimeException(e);
            }
            String prefix = null;
            try {
                prefix = (String)this.importManager.getWSDLModel().getNamespaces().get(this.operationsDetailsPage.getProcedureGenerator().getNamespaceURI());
            }
            catch (ModelGenerationException ex) {
                throw new RuntimeException(ex);
            }
            responseInfo.addNamespace(prefix != null && prefix.length() > 0 ? prefix : "ns", this.operationsDetailsPage.getProcedureGenerator().getNamespaceURI());
            SOAPSchemaProcessor processor = new SOAPSchemaProcessor(null);
            processor.representTypes(true);
            processor.setNamespaces(wsdlModel.getNamespaces());
            XSDSchema[] schemas = wsdlModel.getSchemas();
            try {
                processor.processSchemas(schemas);
            }
            catch (SchemaProcessingException e) {
                throw new RuntimeException(e);
            }
            SchemaModel schemaModel = processor.getSchemaModel();
            List elements = schemaModel.getElements();
            XSDAttributeUse attributeUse = (XSDAttributeUse)obj;
            String name = attributeUse.getAttributeDeclaration().getName();
            if (name == null) {
                name = attributeUse.getAttributeDeclaration().getAliasName();
            }
            String parentElementName = null;
            SchemaTreeModel.SchemaNode parentSchemaNode = this.getParentElement(node);
            if (parentSchemaNode != null && (parentElement = parentSchemaNode.getElement()) instanceof XSDParticleImpl && ((XSDParticleImpl)parentElement).getContent() instanceof XSDElementDeclarationImpl && (parentElementName = (content = (XSDElementDeclaration)((XSDParticleImpl)parentElement).getContent()).getName()) == null) {
                parentElementName = ((XSDElementDeclarationImpl)((XSDParticleImpl)parentElement).getContent()).getResolvedElementDeclaration().getName();
            }
            String runtimeTypeName = dTypeString = attributeUse.getAttributeDeclaration().getType().getAliasName();
            try {
                runtimeTypeName = DatatypeUtilities.getRuntimeTypeName((String)dTypeString);
            }
            catch (ModelerCoreException ex) {
                ex.printStackTrace();
            }
            if (runtimeTypeName != null && !runtimeTypeName.equalsIgnoreCase(dTypeString)) {
                dTypeString = runtimeTypeName;
            }
            StringBuilder xpath = new StringBuilder();
            String namespace = null;
            prefix = null;
            StringBuilder parentXpath = new StringBuilder();
            this.getParentXpath(node, parentXpath, this.responseSchemaTreeModel);
            if (this.responseSchemaTreeModel.getRootPath() == null || this.responseSchemaTreeModel.getRootPath().isEmpty()) {
                this.responseSchemaTreeModel.setRootPath(this.responseSchemaTreeModel.determineRootPath());
            }
            this.getRelativeXpath(node, xpath, this.responseSchemaTreeModel);
            xpath.append('/').append('@').append(name);
            if (parentElementName != null) {
                for (SchemaObject schemaObject : elements) {
                    if (!schemaObject.getName().equals(parentElementName)) continue;
                    namespace = schemaObject.getNamespace();
                    prefix = ((BaseSchemaObject)schemaObject).getNamespacePrefix();
                    if (namespace != null) {
                        responseInfo.addNamespace(prefix, namespace);
                    }
                    responseInfo.setRootPath(this.responseSchemaTreeModel.getRootPath());
                    if (this.importManager.isMessageServiceMode()) {
                        this.operationsDetailsPage.responseBodyColumnsInfoPanel.getRootPathText().setText("/soap:Envelope");
                        continue;
                    }
                    this.operationsDetailsPage.responseBodyColumnsInfoPanel.getRootPathText().setText(this.responseSchemaTreeModel.getRootPath());
                }
            }
            if (type == 0) {
                pathPrefix = "";
                if (this.importManager.isMessageServiceMode()) {
                    pathPrefix = "/soap:Body";
                    String root = this.responseSchemaTreeModel.getRootPath().replaceAll("/soap:Envelope", "");
                    xpath = new StringBuilder(root).append((CharSequence)xpath);
                }
                responseInfo.addBodyColumn(responseInfo.getUniqueBodyColumnName(name), false, dTypeString, null, String.valueOf(pathPrefix) + xpath.toString(), null);
            } else {
                pathPrefix = "";
                if (this.importManager.isMessageServiceMode()) {
                    pathPrefix = "/soap:Header";
                }
                responseInfo.addHeaderColumn(responseInfo.getUniqueHeaderColumnName(name), false, "string", null, String.valueOf(pathPrefix) + xpath.toString(), null);
            }
            this.operationsDetailsPage.notifyColumnDataChanged();
            return null;
        }
        return this.operationsDetailsPage.getSchemaLabelProvider().getText(obj);
    }

    public static String getBaseTypeString(XSDAttributeUse attribute) {
        XSDTypeDefinition typeDef = attribute.getAttributeDeclaration().getType().getBaseType();
        while (typeDef.getBaseType() != null && !typeDef.equals(typeDef.getBaseType()) && !typeDef.getBaseType().getName().startsWith("any")) {
            typeDef = typeDef.getBaseType();
        }
        return typeDef.getName();
    }

    private SchemaTreeModel describe(XSDSchema schema, String element, XSDElementDeclaration elementDeclaration, SchemaTreeModel schemaTreeModel) throws ModelerCoreException {
        this.circularSchemaWarningTriggered = false;
        this.rootnode = schemaTreeModel.new SchemaTreeModel.SchemaNode();
        this.depth = 0;
        XSDElementDeclaration xed = elementDeclaration == null ? schema.resolveElementDeclaration(element) : elementDeclaration;
        XSDTypeDefinition xtd = xed.getTypeDefinition();
        if (xtd instanceof XSDComplexTypeDefinition) {
            this.rootnode.setElement(xed);
            this.rootnode.setRoot(true);
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)xtd;
            this.addComplexTypeDefToTree(complexType, this.rootnode, true, this.depth++, schemaTreeModel);
        } else if (xtd instanceof XSDSimpleTypeDefinition) {
            this.rootnode.setElement(xed);
            this.rootnode.setRoot(true);
            this.addAttributes(xtd, this.rootnode, schemaTreeModel);
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)xtd;
            this.addSimpleTypeDefToTree(simpleType, this.rootnode, schemaTreeModel);
        } else {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)xed.getType();
            this.addElementDeclarationToTree(xed, simpleType, this.rootnode, schemaTreeModel);
        }
        return schemaTreeModel;
    }

    private void addElementDeclarationToTree(XSDElementDeclaration element, XSDSimpleTypeDefinition type, SchemaTreeModel.SchemaNode node, SchemaTreeModel schemaTreeModel) throws ModelerCoreException {
        String name = element.getName();
        if (name == null) {
            name = element.getAliasName();
        }
        this.addToSchemaMap(node, schemaTreeModel);
    }

    private void addComplexTypeDefToTree(XSDComplexTypeDefinition complexType, SchemaTreeModel.SchemaNode node, boolean isRootNode, int depth, SchemaTreeModel schemaTreeModel) throws ModelerCoreException {
        if (depth > MAX_DEPTH) {
            String message = NLS.bind((String)Messages.Error_GeneratingSchemaModelDueToCircularReferences, (Object)MAX_DEPTH, (Object)WSDL_SCHEMA_HANDLER_RECURSIVE_DEPTH_PROPERTY);
            throw new ModelerCoreException(message);
        }
        XSDComplexTypeContent content = complexType.getContent();
        this.addToSchemaMap(node, schemaTreeModel);
        this.addAttributes(complexType, node, schemaTreeModel);
        if (content instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)content;
            this.addSimpleTypeDefToTree(simpleType, node, schemaTreeModel);
        } else if (content instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)content;
            this.addXSDParticleToTree(particle, node, null, depth++, schemaTreeModel);
        }
    }

    private void addXSDParticleToTree(XSDParticle particle, SchemaTreeModel.SchemaNode parent, SchemaTreeModel.SchemaNode node, int depth, SchemaTreeModel schemaTreeModel) throws ModelerCoreException {
        block8: {
            XSDParticleContent content;
            block10: {
                block9: {
                    content = particle.getContent();
                    if (content instanceof XSDWildcard) break block8;
                    if (!(content instanceof XSDModelGroup)) break block9;
                    XSDModelGroup group = (XSDModelGroup)content;
                    EList contents = group.getContents();
                    SchemaTreeModel schemaTreeModel2 = schemaTreeModel;
                    schemaTreeModel2.getClass();
                    node = schemaTreeModel2.new SchemaTreeModel.SchemaNode(content, parent, null, false);
                    if (parent != null) {
                        parent.addChild(node);
                    }
                    this.addToSchemaMap(node, schemaTreeModel);
                    parent = node;
                    for (XSDParticle xsdParticle : contents) {
                        this.addXSDParticleToTree(xsdParticle, parent, node, depth++, schemaTreeModel);
                    }
                    break block8;
                }
                if (!(content instanceof XSDElementDeclaration)) break block10;
                XSDElementDeclaration element = (XSDElementDeclaration)content;
                SchemaTreeModel schemaTreeModel3 = schemaTreeModel;
                schemaTreeModel3.getClass();
                node = schemaTreeModel3.new SchemaTreeModel.SchemaNode(particle, parent, null, false);
                if (parent != null) {
                    parent.addChild(node);
                }
                this.addToSchemaMap(node, schemaTreeModel);
                this.addAttributes(element, node, schemaTreeModel);
                if (element.isElementDeclarationReference()) {
                    element = element.getResolvedElementDeclaration();
                }
                if (element.getType() instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)element.getType();
                    this.addElementDeclarationToTree(element, type, node, schemaTreeModel);
                } else {
                    XSDComplexTypeDefinition type = (XSDComplexTypeDefinition)element.getType();
                    String name = element.getName();
                    if (name == null) {
                        name = element.getAliasName();
                    }
                    this.addComplexTypeDefToTree(type, node, false, depth, schemaTreeModel);
                }
                break block8;
            }
            if (!(content instanceof XSDModelGroupDefinition)) break block8;
            XSDModelGroupDefinition groupDefinition = (XSDModelGroupDefinition)content;
            XSDModelGroup group = groupDefinition.getModelGroup();
            EList contents = group.getContents();
            for (XSDParticle xsdParticle : contents) {
                this.addXSDParticleToTree(xsdParticle, node, null, depth, schemaTreeModel);
            }
        }
    }

    private void addAttributes(Object element, SchemaTreeModel.SchemaNode parent, SchemaTreeModel schemaTreeModel) {
        Object[] result = new Object[]{};
        result = element instanceof XSDComplexTypeDefinition ? ((XSDComplexTypeDefinition)element).getAttributeUses().toArray() : ModelUtilities.getModelContentProvider().getChildren(element);
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof XSDAttributeUse) {
                SchemaTreeModel schemaTreeModel2 = schemaTreeModel;
                schemaTreeModel2.getClass();
                SchemaTreeModel.SchemaNode node = schemaTreeModel2.new SchemaTreeModel.SchemaNode(obj, parent, null, false);
                if (parent != null) {
                    parent.addChild(node);
                }
                this.addToSchemaMap(node, schemaTreeModel);
            }
            ++n2;
        }
    }

    private void addToSchemaMap(SchemaTreeModel.SchemaNode node, SchemaTreeModel schemaTreeModel) {
        schemaTreeModel.getNodeList().add(node);
    }

    private void addSimpleTypeDefToTree(XSDSimpleTypeDefinition simpleType, SchemaTreeModel.SchemaNode node, SchemaTreeModel schemaTreeModel) throws ModelerCoreException {
        this.addToSchemaMap(node, schemaTreeModel);
    }

    private void getParentXpath(SchemaTreeModel.SchemaNode node, StringBuilder parentXpath, SchemaTreeModel schemaTreeModel) {
        String rootPath = schemaTreeModel.getRootNodeXpath();
        String parentXPath = node == null ? "" : node.getParentXpath();
        parentXpath.append(rootPath).append(parentXPath);
    }

    private SchemaTreeModel.SchemaNode getParentElement(SchemaTreeModel.SchemaNode node) {
        if (node != null) {
            return node.getParent();
        }
        return null;
    }

    private void getRelativeXpath(SchemaTreeModel.SchemaNode node, StringBuilder xpath, SchemaTreeModel schemaTreeModel) {
        String relativeXpath = node == null ? "" : node.getRelativeXpath();
        String parentXPath = node == null ? "" : node.getParentXpath();
        parentXPath = parentXPath.replace(schemaTreeModel.getRootPath(), "");
        xpath.append(parentXPath).append(relativeXpath);
    }
}

