/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.modelgenerator.wsdl.ui.Messages;
import org.teiid.designer.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.AttributeInfo;
import org.teiid.designer.modelgenerator.wsdl.ui.wizards.soap.ImportManagerValidator;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlColumnInfo;
import org.teiid.designer.query.sql.symbol.IElementSymbol;

public class ColumnInfo
implements IWsdlColumnInfo,
ModelGeneratorWsdlUiConstants {
    private static final char SEPARATOR = '/';
    public static final String INTEGER_DATATYPE = "integer";
    private static final String[] NO_SEGMENTS = new String[0];
    private static final StringNameValidator nameValidator = new RelationalStringNameValidator(false);
    private final SchemaPath EMPTY_PATH = new SchemaPath("");
    private Collection<AttributeInfo> attributeInfoList;
    private IElementSymbol nameSymbol;
    private String datatype;
    private int width = 10;
    private String namespace;
    private boolean forOrdinality;
    private String defaultValue = "";
    private SchemaPath fullXmlPath = this.EMPTY_PATH;
    private SchemaPath rootXmlPath = this.EMPTY_PATH;
    private Object xmlElement;
    private IStatus status;

    public ColumnInfo(String name) {
        this(name, "string");
    }

    public ColumnInfo(String name, String datatype) {
        CoreArgCheck.isNotEmpty((String)name, (String)"name is null");
        CoreArgCheck.isNotEmpty((String)datatype, (String)"datatype is null");
        this.initNameSymbol(name);
        this.setDatatype(datatype);
        this.attributeInfoList = new ArrayList<AttributeInfo>();
        this.validate();
    }

    public ColumnInfo(String name, String datatype, int width) {
        this(name, datatype);
        CoreArgCheck.isPositive((int)width, (String)"width is zero or less");
        this.width = width;
    }

    public ColumnInfo(String name, boolean ordinality, String datatype, String defaultValue, String fullXmlPath, String namespace) {
        this(name, datatype);
        this.forOrdinality = ordinality;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.fullXmlPath = fullXmlPath == null ? this.EMPTY_PATH : new SchemaPath(fullXmlPath);
        if (namespace != null) {
            this.namespace = namespace;
        }
        this.validate();
    }

    private void initNameSymbol(String name) {
        IQueryService service = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = service.createQueryFactory();
        this.nameSymbol = factory.createElementSymbol(name.replaceAll("\\.", "_"));
    }

    public String getName() {
        String name = this.nameSymbol.toString();
        return name.replaceAll("\"", "");
    }

    public String getSymbolName() {
        return this.nameSymbol.toString();
    }

    public void setName(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name is null");
        this.initNameSymbol(name);
        this.validate();
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        CoreArgCheck.isNotNull((Object)datatype, (String)"datatype is null");
        this.datatype = datatype.equals(INTEGER_DATATYPE) ? "biginteger" : datatype;
        this.validate();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        CoreArgCheck.isPositive((int)width, (String)"width is less than 1");
        this.width = width;
        this.validate();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validate();
    }

    public void setRelativePath(String relativePath) {
        if (relativePath != null) {
            this.rootXmlPath.append(relativePath);
        }
        this.fullXmlPath = new SchemaPath(this.rootXmlPath.toString());
    }

    public String getRelativePath() {
        String rootPath;
        String fullPath;
        if (this.xmlElement != null && (fullPath = this.getFullXmlPath()).startsWith(rootPath = this.rootXmlPath.toString())) {
            return fullPath.substring(rootPath.length(), fullPath.length());
        }
        if (!this.fullXmlPath.isEmpty()) {
            if (!this.rootXmlPath.isEmpty() && this.fullXmlPath.toString().indexOf(this.rootXmlPath.toString()) > -1) {
                this.fullXmlPath.removeFirstSegments(this.rootXmlPath.segmentCount());
                return this.fullXmlPath.toString();
            }
            return this.fullXmlPath.toString();
        }
        return "";
    }

    public void setXmlElement(Object element) {
        this.xmlElement = element;
    }

    public String getFullXmlPath() {
        return this.fullXmlPath.toString();
    }

    public void setFullXmlPath(String fullPath) {
        this.fullXmlPath = fullPath == null ? this.EMPTY_PATH : new SchemaPath(fullPath);
    }

    public void setRootPath(String thePath) {
        if (thePath != null && thePath.length() > 0) {
            SchemaPath oldRelativePath = new SchemaPath(this.getRelativePath());
            SchemaPath newRelativePath = this.rootXmlPath;
            StringBuffer buf = new StringBuffer();
            String[] stringArray = newRelativePath.segments;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                if (!thePath.contains(seg)) {
                    buf.append("/").append(seg);
                }
                ++n2;
            }
            StringBuffer newRelativeBuf = new StringBuffer();
            String[] stringArray2 = oldRelativePath.segments;
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String seg = stringArray2[n];
                if (!thePath.contains(seg)) {
                    newRelativeBuf.append("/").append(seg);
                }
                ++n;
            }
            String tmpRoot = thePath;
            if (thePath.endsWith("/")) {
                tmpRoot = tmpRoot.substring(0, thePath.length() - 1);
            }
            String newFullPath = String.valueOf(tmpRoot) + buf + newRelativeBuf;
            this.setFullXmlPath(newFullPath);
            this.rootXmlPath = new SchemaPath(thePath);
        } else {
            this.rootXmlPath = this.EMPTY_PATH;
        }
    }

    public Object getXmlElement() {
        return this.xmlElement;
    }

    public boolean getOrdinality() {
        return this.forOrdinality;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOrdinality(boolean value) {
        this.forOrdinality = value;
        this.validate();
    }

    public IWsdlAttributeInfo[] getAttributeInfoArray() {
        return this.attributeInfoList.toArray(new AttributeInfo[this.attributeInfoList.size()]);
    }

    public void addAttributeInfo(Object xmlElement, String name) {
        this.attributeInfoList.add(new AttributeInfo(xmlElement, name, this));
        this.validate();
    }

    public void removeAttributeInfo(IWsdlAttributeInfo theInfo) {
        this.attributeInfoList.remove(theInfo);
        this.validate();
    }

    public String getUniqueAttributeName(String proposedName) {
        IWsdlAttributeInfo[] iWsdlAttributeInfoArray = this.getAttributeInfoArray();
        int n = iWsdlAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWsdlAttributeInfo info = iWsdlAttributeInfoArray[n2];
            nameValidator.addExistingName(info.getName());
            ++n2;
        }
        String changedName = nameValidator.createUniqueName(proposedName);
        String finalName = changedName == null ? proposedName : changedName;
        nameValidator.clearExistingNames();
        return finalName;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    private void validate() {
        if (!ImportManagerValidator.isValidDatatype(this.getDatatype())) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.modelgenerator.wsdl.ui", NLS.bind((String)Messages.InvalidDatatype_0_ForColumn_1, (Object)this.getDatatype(), (Object)this.getName())));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Column Info: ");
        text.append("name = ").append(this.getSymbolName());
        text.append(", ordinal = ").append(this.getOrdinality());
        text.append(", datatype = ").append(this.getDatatype());
        text.append(", default = ").append(this.getDefaultValue());
        text.append(", PATH = ").append(this.getRelativePath());
        return text.toString();
    }

    class SchemaPath {
        private String[] segments;

        public SchemaPath(String string) {
            this.segments = this.computeSegments(string);
        }

        public boolean isEmpty() {
            return this.segments.length == 0;
        }

        public int segmentCount() {
            return this.segments.length;
        }

        public void append(String string) {
            String seg;
            String[] tempSegments = this.computeSegments(string);
            int segCount = tempSegments.length + this.segments.length;
            ArrayList<String> allSegments = new ArrayList<String>(this.segments.length);
            String[] stringArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                seg = stringArray[n2];
                allSegments.add(seg);
                ++n2;
            }
            stringArray = tempSegments;
            n = tempSegments.length;
            n2 = 0;
            while (n2 < n) {
                seg = stringArray[n2];
                allSegments.add(seg);
                ++n2;
            }
            this.segments = allSegments.toArray(new String[segCount]);
        }

        public void removeFirstSegments(int nSegs) {
            int newSegCount = this.segments.length - nSegs;
            ArrayList<String> newSegments = new ArrayList<String>(newSegCount);
            int i = 1;
            String[] stringArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                if (i > nSegs) {
                    newSegments.add(seg);
                }
                ++i;
                ++n2;
            }
            this.segments = newSegments.toArray(new String[newSegCount]);
        }

        private String[] computeSegments(String path) {
            int firstPosition;
            int segmentCount = this.computeSegmentCount(path);
            if (segmentCount == 0) {
                return NO_SEGMENTS;
            }
            String[] newSegments = new String[segmentCount];
            int len = path.length();
            int n = firstPosition = path.charAt(0) == '/' ? 1 : 0;
            if (firstPosition == 1 && len > 1 && path.charAt(1) == '/') {
                firstPosition = 2;
            }
            int lastPosition = path.charAt(len - 1) != '/' ? len - 1 : len - 2;
            int next = firstPosition;
            int i = 0;
            while (i < segmentCount) {
                int start = next;
                int end = path.indexOf(47, next);
                newSegments[i] = end == -1 ? path.substring(start, lastPosition + 1) : path.substring(start, end);
                next = end + 1;
                ++i;
            }
            return newSegments;
        }

        private int computeSegmentCount(String path) {
            int i;
            int len = path.length();
            if (len == 0 || len == 1 && path.charAt(0) == '/') {
                return 0;
            }
            int count = 1;
            int prev = -1;
            while ((i = path.indexOf(47, prev + 1)) != -1) {
                if (i != prev + 1 && i != len) {
                    ++count;
                }
                prev = i;
            }
            if (path.charAt(len - 1) == '/') {
                --count;
            }
            return count;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int segCount = this.segmentCount();
            int nSeg = 0;
            String[] stringArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                if (nSeg == 0 && seg.charAt(0) != '/') {
                    buf.append('/');
                }
                buf.append(seg);
                if (nSeg < segCount - 1) {
                    buf.append('/');
                }
                ++nSeg;
                ++n2;
            }
            return buf.toString();
        }
    }
}

