/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class EditIndexDialog
extends TitleAreaDialog {
    private static final String EMPTY_STRING = "";
    private final String CREATE_TITLE = Messages.createIndexTitle;
    private final String EDIT_TITLE = Messages.editIndexTitle;
    RelationalIndex originalIndex;
    RelationalIndex editedIndex;
    RelationalTable theTable;
    String selectedTableName;
    String selectedIndexName;
    private Button autoUpdateCB;
    private Text filterConditionText;
    private Button nullableCB;
    private Button uniqueCB;
    StyledTextEditor descriptionTextEditor;
    TableViewer theColumnDataViewer;
    Set<RelationalColumn> selectedColumns = new HashSet<RelationalColumn>();
    boolean isEdit;
    boolean creatingContents = false;
    boolean processingChecks = false;

    public EditIndexDialog(Shell parent, RelationalTable theTable, RelationalIndex index, boolean isEdit) {
        super(parent);
        this.theTable = theTable;
        this.isEdit = isEdit;
        boolean reallyIsEdit = isEdit;
        this.originalIndex = index;
        if (reallyIsEdit) {
            this.editedIndex = this.originalIndex.clone();
        }
        if (!reallyIsEdit) {
            this.editedIndex = index;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(this.EDIT_TITLE);
        } else {
            shell.setText(this.CREATE_TITLE);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.creatingContents = true;
        if (this.isEdit) {
            this.setTitle(this.EDIT_TITLE);
        } else {
            this.setTitle(this.CREATE_TITLE);
        }
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite composite = WidgetFactory.createPanel((Composite)dialogComposite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        label.setLayoutData((Object)new GridData());
        final Text indexNameText = new Text(composite, 2052);
        indexNameText.setForeground(Display.getCurrent().getSystemColor(10));
        indexNameText.setLayoutData((Object)new GridData(768));
        indexNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = indexNameText.getText();
                if (value == null) {
                    value = EditIndexDialog.EMPTY_STRING;
                }
                EditIndexDialog.this.editedIndex.setName(value);
                EditIndexDialog.this.validate();
            }
        });
        label = new Label(composite, 131072);
        label.setText(Messages.nameInSourceLabel);
        label.setLayoutData((Object)new GridData());
        final Text indexNISText = new Text(composite, 2052);
        indexNISText.setForeground(Display.getCurrent().getSystemColor(10));
        indexNISText.setLayoutData((Object)new GridData(768));
        indexNISText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = indexNISText.getText();
                if (value == null) {
                    value = EditIndexDialog.EMPTY_STRING;
                }
                EditIndexDialog.this.editedIndex.setNameInSource(value);
                EditIndexDialog.this.validate();
            }
        });
        this.autoUpdateCB = new Button(composite, 131104);
        this.autoUpdateCB.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.autoUpdateCB.setText(Messages.autoUpdateLabel);
        this.autoUpdateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIndexDialog.this.editedIndex.setAutoUpdate(EditIndexDialog.this.autoUpdateCB.getSelection());
                EditIndexDialog.this.validate();
            }
        });
        new Label(composite, 0);
        this.nullableCB = new Button(composite, 131104);
        this.nullableCB.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nullableCB.setText(Messages.nullableLabel);
        this.nullableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIndexDialog.this.editedIndex.setNullable(EditIndexDialog.this.nullableCB.getSelection());
                EditIndexDialog.this.validate();
            }
        });
        new Label(composite, 0);
        this.uniqueCB = new Button(composite, 131104);
        this.uniqueCB.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.uniqueCB.setText(Messages.uniqueLabel);
        this.uniqueCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIndexDialog.this.editedIndex.setUnique(EditIndexDialog.this.uniqueCB.getSelection());
                EditIndexDialog.this.validate();
            }
        });
        new Label(composite, 0);
        label = new Label(composite, 131072);
        label.setText(Messages.filterConditionLabel);
        label.setLayoutData((Object)new GridData());
        this.filterConditionText = new Text(composite, 2052);
        this.filterConditionText.setForeground(Display.getCurrent().getSystemColor(10));
        this.filterConditionText.setLayoutData((Object)new GridData(768));
        this.filterConditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = EditIndexDialog.this.filterConditionText.getText();
                if (value == null) {
                    value = EditIndexDialog.EMPTY_STRING;
                }
                EditIndexDialog.this.editedIndex.setFilterCondition(value);
                EditIndexDialog.this.validate();
            }
        });
        Group theColumnsGroup = WidgetFactory.createGroup((Composite)dialogComposite, (String)Messages.selectColumnReferencesForIndex, (int)0, (int)1, (int)1);
        GridData gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 500;
        theColumnsGroup.setLayoutData((Object)gd);
        Table tableWidget = new Table((Composite)theColumnsGroup, 2850);
        tableWidget.setHeaderVisible(false);
        tableWidget.setLinesVisible(true);
        tableWidget.setLayout((Layout)new TableLayout());
        tableWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.theColumnDataViewer = new TableViewer(tableWidget);
        gd = new GridData(1808);
        gd.heightHint = 160;
        gd.horizontalSpan = 2;
        this.theColumnDataViewer.getControl().setLayoutData((Object)gd);
        this.theColumnDataViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return !EditIndexDialog.this.theTable.getColumns().isEmpty();
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof RelationalTable) {
                    return EditIndexDialog.this.theTable.getColumns().toArray(new Object[0]);
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.theColumnDataViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditIndexDialog.this.editedIndex.getColumns().clear();
                TableItem[] tableItemArray = EditIndexDialog.this.theColumnDataViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        EditIndexDialog.this.editedIndex.addColumn((RelationalColumn)item.getData());
                    }
                    ++n2;
                }
                EditIndexDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.theColumnDataViewer.setLabelProvider((IBaseLabelProvider)new ColumnDataLabelProvider(0));
        this.theColumnDataViewer.setInput((Object)this.theTable);
        for (RelationalColumn col : this.editedIndex.getColumns()) {
            TableItem[] tableItemArray = this.theColumnDataViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() == col) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }
        Group descGroup = WidgetFactory.createGroup((Composite)dialogComposite, (String)UILabelUtil.getLabel((int)7), (int)1808, (int)3);
        this.descriptionTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridData descGridData = new GridData(1808);
        descGridData.horizontalSpan = 1;
        descGridData.heightHint = 120;
        descGridData.grabExcessVerticalSpace = true;
        this.descriptionTextEditor.setLayoutData((Object)descGridData);
        this.descriptionTextEditor.setText(EMPTY_STRING);
        this.descriptionTextEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditIndexDialog.this.editedIndex.setDescription(EditIndexDialog.this.descriptionTextEditor.getText());
            }
        });
        this.setMessage(Messages.newIndexMessage);
        if (this.editedIndex.getName() != null) {
            indexNameText.setText(this.editedIndex.getName());
        }
        if (this.editedIndex.getNameInSource() != null) {
            indexNISText.setText(this.editedIndex.getNameInSource());
        }
        this.autoUpdateCB.setSelection(this.editedIndex.isAutoUpdate());
        this.nullableCB.setSelection(this.editedIndex.isNullable());
        this.uniqueCB.setSelection(this.editedIndex.isUnique());
        if (this.editedIndex.getFilterCondition() != null) {
            this.filterConditionText.setText(this.editedIndex.getFilterCondition());
        }
        if (this.editedIndex.getDescription() != null) {
            this.descriptionTextEditor.setText(this.editedIndex.getDescription());
        }
        this.creatingContents = false;
        return composite;
    }

    private void validate() {
        if (this.creatingContents) {
            return;
        }
        this.editedIndex.validate();
        boolean enable = true;
        this.setMessage(Messages.newIndexMessage);
        if (this.editedIndex.getName() == null || this.editedIndex.getName().trim().length() == 0) {
            enable = false;
            this.setErrorMessage(this.editedIndex.getStatus().getMessage());
        } else if (this.editedIndex.getStatus().getSeverity() < 4) {
            this.setErrorMessage(null);
        } else if (this.editedIndex.getStatus().getSeverity() == 2) {
            this.setMessage(this.editedIndex.getStatus().getMessage(), 2);
        } else if (this.editedIndex.getStatus().getSeverity() == 4) {
            this.setErrorMessage(this.editedIndex.getStatus().getMessage());
        }
        this.getButton(0).setEnabled(enable);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        if (this.isEdit) {
            this.originalIndex.inject((RelationalReference)this.editedIndex);
        }
        super.okPressed();
    }

    public String getTableName() {
        return this.selectedTableName;
    }

    public String getIndexName() {
        return this.selectedIndexName;
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return EditIndexDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }
}

