/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class BuiltInListType
implements ListType,
Serializable {
    private int fingerprint;
    public static BuiltInListType ENTITIES = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "ENTITIES");
    public static BuiltInListType IDREFS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "IDREFS");
    public static BuiltInListType NMTOKENS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
    public static BuiltInListType ANY_URIS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema-instance", "anonymous_schemaLocationType");
    private BuiltInAtomicType itemType = null;

    @Override
    public boolean isExternalType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return true;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    @Override
    public int getWhitespaceAction(TypeHierarchy th) {
        return 2;
    }

    @Override
    public AtomicType getCommonAtomicType() {
        return this.itemType;
    }

    public BuiltInListType(int fingerprint) {
        this.fingerprint = fingerprint;
        switch (fingerprint) {
            case 564: {
                this.itemType = BuiltInAtomicType.ENTITY;
                break;
            }
            case 562: {
                this.itemType = BuiltInAtomicType.IDREF;
                break;
            }
            case 557: {
                this.itemType = BuiltInAtomicType.NMTOKEN;
                break;
            }
            case 645: {
                this.itemType = BuiltInAtomicType.ANY_URI;
            }
        }
    }

    @Override
    public int getValidationStatus() {
        return 3;
    }

    @Override
    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return this.fingerprint == 562;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    @Override
    public boolean isAnonymousType() {
        return false;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return this;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public String getName() {
        return StandardNames.getLocalName(this.fingerprint);
    }

    @Override
    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public int getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public int getNameCode() {
        return this.fingerprint;
    }

    @Override
    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public int getBlock() {
        return 0;
    }

    public SchemaType getKnownBaseType() throws IllegalStateException {
        return AnySimpleType.getInstance();
    }

    @Override
    public int getDerivationMethod() {
        return 8;
    }

    @Override
    public boolean allowsDerivation(int derivation) {
        return true;
    }

    @Override
    public SequenceIterator getTypedValue(NodeInfo node) throws XPathException {
        try {
            return this.getTypedValue(node.getStringValue(), new InscopeNamespaceResolver(node), node.getConfiguration().getNameChecker());
        }
        catch (ValidationException err) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + err.getMessage());
        }
    }

    @Override
    public Value atomize(NodeInfo node) throws XPathException {
        return new SequenceExtent(this.getTypedValue(node)).simplify();
    }

    @Override
    public boolean isSameType(SchemaType other) {
        return other.getFingerprint() == this.getFingerprint();
    }

    @Override
    public String getDescription() {
        return this.getDisplayName();
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
    }

    public String getLocalName() {
        return this.getDisplayName().substring(3);
    }

    @Override
    public SimpleType getItemType() {
        return this.itemType;
    }

    public String applyWhitespaceNormalization(String value) {
        return Whitespace.collapseWhitespace(value).toString();
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, env, kind);
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, NameChecker nameChecker) {
        StringValue val;
        SimpleType base = this.getItemType();
        StringTokenIterator iter = new StringTokenIterator(value.toString());
        ValidationFailure result = null;
        int count = 0;
        while ((val = (StringValue)iter.next()) != null) {
            ++count;
            ValidationFailure v = base.validateContent(val.getStringValue(), nsResolver, nameChecker);
            if (v == null) continue;
            return v;
        }
        if (count == 0) {
            result = new ValidationFailure("The built-in list type " + StandardNames.getDisplayName(this.fingerprint) + " does not allow a zero-length list");
        }
        return result;
    }

    @Override
    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, NameChecker nameChecker) throws ValidationException {
        StringTokenIterator iter = new StringTokenIterator(value.toString());
        ListTypeMappingFunction map = new ListTypeMappingFunction();
        map.resolver = resolver;
        map.atomicType = (AtomicType)this.getItemType();
        map.nameChecker = nameChecker;
        return new MappingIterator(iter, map);
    }

    private static BuiltInListType makeListType(String namespace, String lname) {
        BuiltInListType t = new BuiltInListType(StandardNames.getFingerprint(namespace, lname));
        BuiltInType.register(t.getFingerprint(), t);
        return t;
    }

    @Override
    public CharSequence preprocess(CharSequence input) {
        return input;
    }

    @Override
    public CharSequence postprocess(CharSequence input) throws ValidationException {
        return input;
    }

    private static class ListTypeMappingFunction
    implements MappingFunction {
        public NamespaceResolver resolver;
        public AtomicType atomicType;
        public NameChecker nameChecker;

        private ListTypeMappingFunction() {
        }

        @Override
        public SequenceIterator map(Item item) throws XPathException {
            try {
                return this.atomicType.getTypedValue(item.getStringValue(), this.resolver, this.nameChecker);
            }
            catch (ValidationException err) {
                throw new XPathException(err);
            }
        }
    }
}

