/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class XSLSequence
extends StyleElement {
    private Expression select;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected ItemType getReturnedItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return this.select.getItemType(th);
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public boolean mayContainFallback() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        } else {
            this.reportAbsence("select");
            this.select = Literal.makeEmptySequence();
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLFallback) continue;
            this.compileError("The only child node allowed for xsl:sequence is an xsl:fallback instruction", "XTSE0010");
            break;
        }
        this.select = this.typeCheck("select", this.select);
    }

    @Override
    public Expression compile(Executable exec) {
        return this.select;
    }
}

