/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.jee.AbstractClasspathContainer;
import org.jboss.ide.eclipse.as.classpath.core.jee.AbstractClasspathContainerInitializer;
import org.jboss.ide.eclipse.as.classpath.core.xpl.ClasspathDecorations;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.esb.core.messages.JBossFacetCoreMessages;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeManager;

public class JBossRuntimeClassPathInitializer
extends AbstractClasspathContainerInitializer {
    public static final String JBOSS_ESB_RUNTIME_CLASSPATH_CONTAINER_ID = "org.jboss.esb.runtime.classpath";
    public static final String JBOSS_ESB_RUNTIME_CLASSPATH_SERVER_SUPPLIED = "server.supplied";
    private String segment;
    private boolean isServerSupplied = false;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        this.javaProject = project;
        if (containerPath.segment(0).equals(JBOSS_ESB_RUNTIME_CLASSPATH_CONTAINER_ID)) {
            if (containerPath.segmentCount() == 3 && containerPath.segment(1).equals(JBOSS_ESB_RUNTIME_CLASSPATH_SERVER_SUPPLIED)) {
                this.segment = containerPath.segment(2);
                this.isServerSupplied = true;
            } else {
                this.segment = containerPath.segment(1);
                this.isServerSupplied = false;
            }
            JBossRuntimeClasspathContainer container = new JBossRuntimeClasspathContainer(containerPath, project, this.isServerSupplied);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public IClasspathEntry[] getEntries(IPath path) {
        return new JBossRuntimeClasspathContainer(path, this.javaProject, this.isServerSupplied).getClasspathEntries();
    }

    protected AbstractClasspathContainer createClasspathContainer(IPath path) {
        return new JBossRuntimeClasspathContainer(path, this.javaProject, this.isServerSupplied);
    }

    protected String getClasspathContainerID() {
        return JBOSS_ESB_RUNTIME_CLASSPATH_CONTAINER_ID;
    }

    public class JBossRuntimeClasspathContainer
    extends AbstractClasspathContainer {
        private IPath path;
        private boolean isFromServer;
        private IClasspathEntry[] entries;
        private List<String> jars;
        private boolean unbound;

        public JBossRuntimeClasspathContainer(IPath path, IJavaProject project, boolean isFromServer) {
            super(path, JBossFacetCoreMessages.JBoss_Runtime, null, project);
            this.isFromServer = false;
            this.entries = null;
            this.unbound = false;
            this.path = path;
            this.isFromServer = isFromServer;
        }

        public String getDescription() {
            if (this.unbound) {
                return String.valueOf(JBossFacetCoreMessages.JBoss_Runtime) + " [" + this.path.segment(this.path.segmentCount() - 1) + "] (unbound)";
            }
            return String.valueOf(JBossFacetCoreMessages.JBoss_Runtime) + " [" + this.path.segment(this.path.segmentCount() - 1) + "]";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.computeEntries();
        }

        public IClasspathEntry[] computeEntries() {
            ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
            if (this.isFromServer) {
                IRuntime serverRuntime = ServerCore.findRuntime((String)JBossRuntimeClassPathInitializer.this.segment);
                if (serverRuntime == null) {
                    this.unbound = true;
                    return new IClasspathEntry[0];
                }
                this.unbound = false;
                String runtimeLocation = serverRuntime.getLocation().toOSString();
                IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)serverRuntime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                this.jars = JBossRuntimeManager.getInstance().getAllRuntimeJars(runtimeLocation, serverRuntime.getRuntimeType().getId(), jbossRuntime.getJBossConfiguration());
            } else {
                JBossESBRuntime jbws = JBossRuntimeManager.getInstance().findRuntimeByName(JBossRuntimeClassPathInitializer.this.segment);
                if (jbws != null) {
                    this.jars = JBossRuntimeManager.getInstance().getAllRuntimeJars(jbws, jbws.getVersion());
                    this.unbound = false;
                } else {
                    this.unbound = true;
                }
            }
            if (this.jars == null) {
                return new IClasspathEntry[0];
            }
            for (String jar : this.jars) {
                Path entryPath = new Path(jar);
                IPath sourceAttachementPath = null;
                IPath sourceAttachementRootPath = null;
                ClasspathDecorations dec = decorations.getDecorations(JBossRuntimeClasspathContainer.getDecorationManagerKey((String)this.getPath().toString()), entryPath.toString());
                IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
                if (dec != null) {
                    sourceAttachementPath = dec.getSourceAttachmentPath();
                    sourceAttachementRootPath = dec.getSourceAttachmentRootPath();
                    attrs = dec.getExtraAttributes();
                }
                IAccessRule[] access = new IAccessRule[]{};
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourceAttachementPath, (IPath)sourceAttachementRootPath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
                entryList.add(entry);
            }
            this.entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
            return this.entries;
        }

        public void refresh() {
            new JBossRuntimeClasspathContainer(this.path, this.javaProject, JBossRuntimeClassPathInitializer.this.isServerSupplied).install();
        }
    }
}

