/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.util;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.modelgenerator.ModelGeneratorPlugin;
import org.teiid.designer.modelgenerator.util.AnnotationHelper;
import org.teiid.designer.modelgenerator.util.AnnotationHelperException;

public class AnnotationHelperImpl
implements AnnotationHelper {
    private final ModelSelector selector;
    private ModelContents contents;

    public AnnotationHelperImpl(ModelSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(ModelGeneratorPlugin.Util.getString("AnnotationHelperImpl.The_ModelSelector_instance_used_to_try_to_instantiate_a_AnnotationHelperImpl_was_Null._1", new Object[0]));
        }
        this.selector = selector;
    }

    @Override
    public Annotation createAnnotation(EObject targetObject, String objectDescription) throws AnnotationHelperException {
        AnnotationContainer ac;
        Annotation annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)targetObject);
        if (annotation == null) {
            annotation = CoreFactory.eINSTANCE.createAnnotation();
        }
        if ((ac = this.getModelContents().getAnnotationContainer(false)) != null) {
            annotation.setAnnotationContainer(ac);
        }
        annotation.setDescription(objectDescription);
        return annotation;
    }

    @Override
    public void setAnnotation(EObject targetObject, String key, Object value) throws AnnotationHelperException {
        ModelContents modelContents = this.getModelContents();
        Annotation annotation = modelContents.getAnnotation(targetObject);
        if (annotation == null && (annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)targetObject, (AnnotationContainer)ModelResourceContainerFactory.getAnnotationContainer((Resource)modelContents.getResource(), (boolean)true))) == null) {
            annotation = this.createAnnotation(targetObject, null);
        }
        if (annotation != null) {
            EMap annotationMap = annotation.getTags();
            annotationMap.put((Object)key, value);
        }
    }

    private ModelContents getModelContents() throws AnnotationHelperException {
        if (this.contents == null) {
            try {
                this.contents = this.selector.getModelContents();
            }
            catch (ModelWorkspaceException e) {
                throw new AnnotationHelperException(e);
            }
        }
        return this.contents;
    }
}

