/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.tools.textimport.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.tools.textimport.ui.PluginConstants;
import org.teiid.designer.tools.textimport.ui.TextImportContributionManager;
import org.teiid.designer.tools.textimport.ui.TextImportPlugin;
import org.teiid.designer.tools.textimport.ui.UiConstants;
import org.teiid.designer.tools.textimport.ui.wizards.ITextImportMainPage;
import org.teiid.designer.tools.textimport.ui.wizards.ImportTextMainPage;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class ImportTextWizard
extends AbstractWizard
implements PluginConstants.Images,
IImportWizard,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ImportTextWizard.class);
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String TITLE = ImportTextWizard.getString("title");
    private static final ImageDescriptor IMAGE = TextImportPlugin.getDefault().getImageDescriptor("icons/full/wizban/import_project.gif");
    private static final String NOT_LICENSED_MSG = ImportTextWizard.getString("notLicensedMessage");
    private static boolean importLicensed = true;
    private ImportTextMainPage importTextMainPage;
    private static ITextImportMainPage[] importers;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ImportTextWizard() {
        super((AbstractUIPlugin)TextImportPlugin.getDefault(), TITLE, IMAGE);
        importers = TextImportContributionManager.getTextImporters();
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            IDialogSettings settings = this.getDialogSettings();
            try {
                settings.getInt(WIDTH);
                settings.getInt(HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                settings.put(WIDTH, 500);
                settings.put(HEIGHT, 500);
            }
            super.createPageControls(pageContainer);
        }
    }

    public boolean finish() {
        boolean result = true;
        String importType = this.importTextMainPage.getImportType();
        int i = 0;
        while (i < importers.length) {
            if (importers[i].getType().equals(importType)) {
                importers[i].finish();
                break;
            }
            ++i;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IStructuredSelection finalSelection = selection;
        if (!ModelerUiViewUtils.workspaceHasOpenModelProjects()) {
            IProject newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (newProject != null) {
                finalSelection = new StructuredSelection((Object)newProject);
            } else {
                this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
                return;
            }
        }
        if (importLicensed) {
            this.importTextMainPage = new ImportTextMainPage(finalSelection);
            this.addPage((IWizardPage)this.importTextMainPage);
            int i = 0;
            while (i < importers.length) {
                this.addPage((IWizardPage)importers[i]);
                ++i;
            }
        } else {
            WizardPage page = new WizardPage(ImportTextWizard.class.getSimpleName(), TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)ImportTextWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
    }

    public IWizardPage getNextPage(IWizardPage thePage) {
        IWizardPage result = null;
        if (thePage == this.importTextMainPage) {
            String importType = this.importTextMainPage.getImportType();
            int i = 0;
            while (i < importers.length) {
                if (importers[i].getType().equals(importType)) {
                    result = (IWizardPage)importers[i];
                    break;
                }
                ++i;
            }
            this.importTextMainPage.saveWidgetValues();
        } else {
            boolean isContributed = false;
            int i = 0;
            while (i < importers.length) {
                if (thePage.equals(importers[i])) {
                    isContributed = true;
                    break;
                }
                ++i;
            }
            if (!isContributed) {
                CoreArgCheck.isTrue((boolean)false, (String)("Unexpected TextImport Wizard Page:" + thePage));
            }
        }
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage thePage) {
        IWizardPage pPage = super.getPreviousPage(thePage);
        pPage.setVisible(true);
        return pPage;
    }

    public boolean canFinish() {
        boolean canFinish = false;
        IWizardPage[] pages = this.getPages();
        IWizardPage page1 = pages[0];
        if (page1.isPageComplete()) {
            IWizardPage page2 = null;
            String importType = this.importTextMainPage.getImportType();
            int i = 0;
            while (i < importers.length) {
                if (importers[i].getType().equals(importType)) {
                    page2 = (IWizardPage)importers[i];
                    break;
                }
                ++i;
            }
            if (page2 != null && page2.isPageComplete()) {
                canFinish = true;
            }
        }
        return canFinish;
    }

    public void dispose() {
        super.dispose();
    }
}

