/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.tools.textimport.ui.wizards;

import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.teiid.designer.tools.textimport.ui.TextImportContributionManager;
import org.teiid.designer.tools.textimport.ui.UiConstants;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.WrappingLabel;

public class ImportTextMainPage
extends WizardDataTransferPage
implements UiConstants {
    protected Combo importTypeCombo;
    private StyledTextEditor expectedFormatListViewer;
    private WrappingLabel descriptionLabel;
    boolean entryChanged = false;
    private boolean initializing = false;
    private static final String I18N_PREFIX = "ImportTextMainPage";
    private static final String SEPARATOR = ".";
    private static final String INITIAL_MESSAGE = ImportTextMainPage.getString("initialMessage");
    private static final String PAGE_TITLE = ImportTextMainPage.getString("pageTitle");
    private static final String STORE_IMPORT_TYPE_SELECTION_ID = ImportTextMainPage.getString("storeImportTypeSelectionId");

    private static String getString(String id) {
        return Util.getString("ImportTextMainPage." + id, new Object[0]);
    }

    public ImportTextMainPage(IStructuredSelection selection) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.importTypeCombo) {
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createImportTypeGroup(composite);
        this.createDescriptionGroup(composite);
        this.createExpectedFormatListGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(true);
        this.setMessage(INITIAL_MESSAGE);
        this.setControl((Control)composite);
    }

    private void createDescriptionGroup(Composite parent) {
        this.descriptionLabel = WidgetFactory.createWrappingLabel((Composite)parent, (int)784);
        this.descriptionLabel.setFont(parent.getFont());
    }

    protected void createImportTypeGroup(Composite parent) {
        Composite typeContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        typeContainerGroup.setLayout((Layout)layout);
        typeContainerGroup.setFont(parent.getFont());
        typeContainerGroup.setLayoutData((Object)new GridData(768));
        Label importTypeLabel = new Label(typeContainerGroup, 0);
        importTypeLabel.setText(ImportTextMainPage.getString("importTypeLabel"));
        importTypeLabel.setFont(parent.getFont());
        this.importTypeCombo = new Combo(typeContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.importTypeCombo.setLayoutData((Object)data);
        this.importTypeCombo.setFont(parent.getFont());
        String[] importTypes = TextImportContributionManager.getTypes();
        int i = 0;
        while (i < importTypes.length) {
            this.importTypeCombo.add(importTypes[i]);
            ++i;
        }
        this.importTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTextMainPage.this.updateFromComboSelection();
                Composite comp = (Composite)ImportTextMainPage.this.getControl();
                comp.layout();
                ImportTextMainPage.this.setCompletionStatus();
            }
        });
        this.importTypeCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportTextMainPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.importTypeCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportTextMainPage.this.entryChanged) {
                    ImportTextMainPage.this.entryChanged = false;
                }
            }
        });
    }

    private void createExpectedFormatListGroup(Composite parent) {
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText(ImportTextMainPage.getString("expectedFormatListMessage"));
        messageLabel.setFont(parent.getFont());
        this.expectedFormatListViewer = new StyledTextEditor(parent, 2816);
        GridData data = new GridData(768);
        data.widthHint = 600;
        data.heightHint = 400;
        this.expectedFormatListViewer.setLayoutData((Object)data);
        this.expectedFormatListViewer.setEditable(false);
    }

    protected void updateFromComboSelection() {
        this.loadDescriptionText(this.importTypeCombo.getText());
        this.clearExpectedFormatListViewer();
        this.loadExpectedFormatList(this.importTypeCombo.getText());
    }

    public String getImportType() {
        return this.importTypeCombo.getText();
    }

    public void dispose() {
        super.dispose();
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    boolean setCompletionStatus() {
        boolean isValid = true;
        if (isValid) {
            this.setErrorMessage(null);
            this.setMessage(INITIAL_MESSAGE);
            this.setPageComplete(true);
            return true;
        }
        this.setPageComplete(false);
        return false;
    }

    public boolean finish() {
        this.saveWidgetValues();
        return true;
    }

    private void clearExpectedFormatListViewer() {
        this.expectedFormatListViewer.setText("");
    }

    private void loadDescriptionText(String typeStr) {
        String desc;
        if (typeStr != null && typeStr.length() > 0 && (desc = TextImportContributionManager.getDescription(typeStr)) != null) {
            this.descriptionLabel.setText(desc);
        }
    }

    private void loadExpectedFormatList(String typeStr) {
        String sampleData;
        if (typeStr != null && typeStr.length() > 0 && (sampleData = TextImportContributionManager.getSampleData(typeStr)) != null) {
            this.expectedFormatListViewer.setText(ImportTextMainPage.parseList_2(sampleData));
        }
    }

    private static String parseList_2(String listString) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(listString, "|");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            sb.append(token);
            if (!tokenizer.hasMoreTokens()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            int comboIndex;
            try {
                comboIndex = settings.getInt(STORE_IMPORT_TYPE_SELECTION_ID);
            }
            catch (NumberFormatException numberFormatException) {
                comboIndex = 0;
            }
            this.importTypeCombo.select(comboIndex);
            this.updateFromComboSelection();
        } else {
            this.importTypeCombo.select(0);
            this.updateFromComboSelection();
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_IMPORT_TYPE_SELECTION_ID, this.importTypeCombo.getSelectionIndex());
        }
    }
}

