/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.validator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.metamodels.xsd.XsdPlugin;

public class XsdResourceValidator
implements ResourceValidator {
    private int prefStatus = 2;
    private Set unloaded;
    private Set xsds;
    private Set allResources;
    private Set modifiedResources;

    public boolean isValidatorForObject(Object obj) {
        File f;
        Resource eResource;
        IResource iResource;
        return obj instanceof IResource ? ModelUtil.isXsdFile((IResource)(iResource = (IResource)obj)) : (obj instanceof Resource ? ModelUtil.isXsdFile((Resource)(eResource = (Resource)obj)) : obj instanceof File && (f = (File)obj).exists() && ModelFileUtil.isXsdFile((File)f));
    }

    public void validate(IProgressMonitor monitor, Object obj, ValidationContext context) throws ModelerCoreException {
        IProgressMonitor progressMonitor;
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = XsdPlugin.Util.getString("XsdResourceValidator.validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        Object object = progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            if (mResource != null) {
                Resource eResource = mResource.getEmfResource();
                this.validate(progressMonitor, eResource, context);
            }
        } else if (obj instanceof Resource) {
            Resource eResource = (Resource)obj;
            this.validate(progressMonitor, eResource, context);
        } else if (obj instanceof File) {
            try {
                File f = (File)obj;
                URI uri = URI.createURI((String)f.getAbsolutePath());
                Resource eResource = ModelerCore.getModelContainer().getResource(uri, false);
                this.validate(progressMonitor, eResource, context);
            }
            catch (Exception err) {
                throw new ModelerCoreException((Throwable)err);
            }
        }
    }

    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                for (ValidationResult result : results) {
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    String locationPath = result.getLocationPath();
                    String locationUri = result.getLocationUri();
                    String targetUri = result.getTargetUri();
                    int probCnt = 0;
                    while (probCnt < problems.length) {
                        this.createProblemMarker(locationPath, locationUri, targetUri, problems[probCnt], iResource);
                        ++probCnt;
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    public boolean isValidatorForResource(IResource iResource) {
        return ModelUtil.isXsdFile((IResource)iResource);
    }

    public void validate(IProgressMonitor monitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)iResource);
        if (!ModelUtil.isXsdFile((IResource)iResource)) {
            String msg = XsdPlugin.Util.getString("XsdResourceValidator.XsdResourceValidator_may_only_be_used_to_validate_XsdResources_1", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        this.validate(monitor, resource, context);
    }

    public void validationStarted(Collection resources, ValidationContext context) {
        if (!this.canValidate(context)) {
            return;
        }
        this.unloaded = new HashSet();
        this.xsds = new HashSet();
        this.allResources = new HashSet();
        this.modifiedResources = new HashSet();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        ResourceSet ctnr = null;
        for (Object obj : resources) {
            Resource emfResrc = null;
            try {
                if (obj instanceof IResource) {
                    ModelResource model = workspace.findModelResource((IResource)obj);
                    emfResrc = model != null ? model.getEmfResource() : null;
                } else if (obj instanceof Resource) {
                    emfResrc = (Resource)obj;
                }
                if (!ModelUtil.isXsdFile(emfResrc)) continue;
                if (emfResrc instanceof XSDResourceImpl && emfResrc.isModified()) {
                    String msg = XsdPlugin.Util.getString("XsdResourceValidator.Can_not_perform_validation_on_unsaved_Xsd_Resources.__Please_save_and_revalidate_1", new Object[0]);
                    this.addProblem(((XSDResourceImpl)emfResrc).getSchema(), 0, 4, msg, context);
                    return;
                }
                if (!this.xsds.add(emfResrc)) continue;
                this.allResources.add(emfResrc);
                if (ctnr == null) {
                    ctnr = emfResrc.getResourceSet();
                    if (ctnr == null) {
                        ctnr = ModelerCore.getModelContainer();
                    }
                    if (ctnr != null) {
                        for (Resource r : ctnr.getResources()) {
                            if (!r.isLoaded()) {
                                this.unloaded.add(r);
                            }
                            this.allResources.add(r);
                            if (!r.isModified()) continue;
                            this.modifiedResources.add(r);
                        }
                    }
                }
                if (!emfResrc.isLoaded()) {
                    emfResrc.load(null);
                }
                this.loadReferencedXsdResources(emfResrc, this.xsds, ctnr);
            }
            catch (Exception err) {
                XsdPlugin.Util.log((Throwable)err);
            }
        }
        Iterator iter = this.xsds.iterator();
        while (iter.hasNext()) {
            ((Resource)iter.next()).unload();
        }
        iter = this.xsds.iterator();
        while (iter.hasNext()) {
            try {
                ((Resource)iter.next()).load(null);
            }
            catch (IOException err) {
                XsdPlugin.Util.log((Throwable)err);
            }
        }
    }

    public void validationEnded(ValidationContext context) {
        if (!this.canValidate(context)) {
            return;
        }
        Iterator iter = this.unloaded.iterator();
        while (iter.hasNext()) {
            ((Resource)iter.next()).unload();
        }
        this.xsds = null;
        this.unloaded = null;
        for (Resource resource : this.allResources) {
            if (this.modifiedResources.contains(resource)) {
                resource.setModified(true);
                continue;
            }
            resource.setModified(false);
        }
        this.allResources = null;
        this.modifiedResources = null;
    }

    private void loadReferencedXsdResources(Resource resource, Set resources, ResourceSet container) throws Exception {
        CoreArgCheck.isNotNull((Object)ModelerCore.getContainer((Resource)resource));
        ResourceFinder finder = ModelerCore.getContainer((Resource)resource).getResourceFinder();
        if (!resource.isLoaded()) {
            ResourceSet ctnr = resource.getResourceSet();
            if (ctnr == null) {
                ctnr = ModelerCore.getModelContainer();
            }
            Map options = ctnr == null ? null : ctnr.getLoadOptions();
            resource.load(options);
        }
        XSDSchema schema = ((XSDResourceImpl)resource).getSchema();
        for (Object obj : schema.getContents()) {
            if (!(obj instanceof XSDSchemaDirective) || (resource = finder.findByImport((XSDSchemaDirective)obj, false)) == null || resource.getResourceSet() != container || !resources.add(resource)) continue;
            this.loadReferencedXsdResources(resource, resources, container);
        }
    }

    private void validate(IProgressMonitor monitor, Resource resource, ValidationContext context) throws ModelerCoreException {
        boolean reload;
        CoreArgCheck.isNotNull((Object)resource);
        boolean bl = reload = this.xsds == null;
        if (reload) {
            HashSet<Resource> xsds = new HashSet<Resource>(1);
            xsds.add(resource);
            this.validationStarted(xsds, context);
        }
        if (!this.canValidate(context)) {
            return;
        }
        try {
            if (!(resource instanceof XSDResourceImpl)) {
                String msg = XsdPlugin.Util.getString("XsdResourceValidator.XsdResource_validator_may_only_be_used_to_validate_instances_of_XsdResourceImpl_1", new Object[0]);
                throw new ModelerCoreException(msg);
            }
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            ResourceSet resourceSet = xsdResource.getResourceSet();
            List xsdResources = XsdResourceValidator.getXsdResources(resourceSet);
            HashMap<String, Boolean> xsdResourceModifiedState = new HashMap<String, Boolean>();
            for (Resource r : xsdResources) {
                String rUri = r.getURI().toString();
                if (r.isModified()) {
                    xsdResourceModifiedState.put(rUri, Boolean.TRUE);
                    continue;
                }
                xsdResourceModifiedState.put(rUri, Boolean.FALSE);
            }
            XSDSchema schema = xsdResource.getSchema();
            if (schema == null) {
                String msg = XsdPlugin.Util.getString("XsdResourceValidator.Error_processing_XSD_file_during_validation_1", new Object[0]);
                throw new ModelerCoreException(msg);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            schema.validate();
            EList diagnostics = schema.getAllDiagnostics();
            for (XSDDiagnostic next : diagnostics) {
                this.addProblem(next, context);
            }
            xsdResource.setModified(false);
            xsdResources = XsdResourceValidator.getXsdResources(resourceSet);
            for (Resource r : xsdResources) {
                Boolean modifiedState;
                String rUri = r.getURI().toString();
                r.setModified(false);
                if (!xsdResourceModifiedState.containsKey(rUri) || (modifiedState = (Boolean)xsdResourceModifiedState.get(rUri)) != Boolean.TRUE) continue;
                r.setModified(true);
            }
        }
        finally {
            if (reload) {
                this.validationEnded(context);
            }
        }
    }

    private boolean canValidate(ValidationContext context) {
        this.prefStatus = context.getPreferenceStatus("xsdPreferences.performValidation", 2);
        return this.prefStatus != 0;
    }

    private static List getXsdResources(ResourceSet resourceSet) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                if (!(resource instanceof XSDResourceImpl)) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private void addProblem(Object object, int code, int severity, String msg, ValidationContext context) {
        ValidationProblemImpl problem = new ValidationProblemImpl(code, severity, msg);
        ValidationResultImpl result = new ValidationResultImpl(object);
        result.addProblem((ValidationProblem)problem);
        context.addResult((ValidationResult)result);
    }

    private void addProblem(XSDDiagnostic diagnostic, ValidationContext context) {
        XSDConcreteComponent target = diagnostic.getPrimaryComponent();
        if (target != null) {
            int severity = Math.min(this.getStatusSeverity(diagnostic), this.prefStatus);
            this.addProblem(target, 0, severity, diagnostic.getMessage(), context);
        }
    }

    private void createProblemMarker(String locationPath, String locationUri, String targetUri, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("location", (Object)locationPath);
        marker.setAttribute("org.teiid.designer.core.markerURI", (Object)locationUri);
        marker.setAttribute("org.teiid.designer.core.targetMarkerURI", (Object)targetUri);
        marker.setAttribute("message", (Object)problem.getMessage());
        this.setMarkerSeverity(marker, problem.getSeverity());
    }

    private int getStatusSeverity(XSDDiagnostic diagnostic) {
        int severity = diagnostic.getSeverity().getValue();
        switch (severity) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private void setMarkerSeverity(IMarker marker, int theSeverity) throws CoreException {
        if (theSeverity > this.prefStatus) {
            while (--theSeverity > this.prefStatus) {
            }
        }
        switch (theSeverity) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }
}

