/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TeiidPropertyDefinition {
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String PROPERTY_TYPE_CLASS_NAME = "propertyTypeClassName";
    private static final String DEFAULT_VALUE = " defaultValue";
    private static final String ALLOWED_VALUES = "allowedValues";
    private static final String MODIFIABLE = "modifiable";
    private static final String CONSTRAINED_TO_ALLOWED_VALUES = "constrainedToAllowedValues";
    private static final String ADVANCED = "advanced";
    private static final String REQUIRED = "required";
    private static final String MASKED = "masked";
    private static final String OWNER = "owner";
    private Map<String, Object> properties = new HashMap<String, Object>();

    private <V> V getProperty(String key, Class<V> klazz) {
        Object value = this.properties.get(key);
        if (value == null && Boolean.class.equals(klazz)) {
            value = Boolean.FALSE;
        } else if (value == null) {
            return null;
        }
        return klazz.cast(value);
    }

    private void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public String getName() {
        return this.getProperty(NAME, String.class);
    }

    public void setName(String name) {
        this.setProperty(NAME, name);
    }

    public String getDisplayName() {
        return this.getProperty(DISPLAY_NAME, String.class);
    }

    public void setDisplayName(String displayName) {
        this.setProperty(DISPLAY_NAME, displayName);
    }

    public String getDescription() {
        return this.getProperty(DESCRIPTION, String.class);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, description);
    }

    public String getPropertyTypeClassName() {
        return this.getProperty(PROPERTY_TYPE_CLASS_NAME, String.class);
    }

    public void setPropertyTypeClassName(String propertyTypeClassName) {
        this.setProperty(PROPERTY_TYPE_CLASS_NAME, propertyTypeClassName);
    }

    public Object getDefaultValue() {
        return this.getProperty(DEFAULT_VALUE, Object.class);
    }

    public void setDefaultValue(Object defaultValue) {
        this.setProperty(DEFAULT_VALUE, defaultValue);
    }

    public Collection<String> getAllowedValues() {
        return this.getProperty(ALLOWED_VALUES, Collection.class);
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        this.setProperty(ALLOWED_VALUES, allowedValues);
    }

    public boolean isModifiable() {
        return this.getProperty(MODIFIABLE, Boolean.class);
    }

    public void setModifiable(boolean modifiable) {
        this.setProperty(MODIFIABLE, modifiable);
    }

    public boolean isConstrainedToAllowedValues() {
        return this.getProperty(CONSTRAINED_TO_ALLOWED_VALUES, Boolean.class);
    }

    public void setConstrainedToAllowedValues(boolean constrainedToAllowedValues) {
        this.setProperty(CONSTRAINED_TO_ALLOWED_VALUES, constrainedToAllowedValues);
    }

    public boolean isAdvanced() {
        return this.getProperty(ADVANCED, Boolean.class);
    }

    public void setAdvanced(boolean advanced) {
        this.setProperty(ADVANCED, advanced);
    }

    public boolean isRequired() {
        return this.getProperty(REQUIRED, Boolean.class);
    }

    public void setRequired(boolean required) {
        this.setProperty(REQUIRED, required);
    }

    public boolean isMasked() {
        return this.getProperty(MASKED, Boolean.class);
    }

    public void setMasked(boolean masked) {
        this.setProperty(MASKED, masked);
    }

    public String getOwner() {
        return this.getProperty(OWNER, String.class);
    }

    public void setOwner(String owner) {
        this.setProperty(OWNER, owner);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("\n\tNAME = ").append(this.getName()).append("   Properties: ").append(this.properties.toString());
        return sb.toString();
    }
}

