/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.translator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.builder.MetamodelBuilderPlugin;
import org.teiid.designer.metamodels.builder.MetamodelEntityRecord;
import org.teiid.designer.metamodels.builder.ModelRecord;
import org.teiid.designer.metamodels.builder.translator.ResultSetTranslator;
import org.teiid.designer.metamodels.builder.util.BuilderUtil;
import org.teiid.designer.metamodels.builder.util.MetaClassUriHelper;

public class RecordGenerator {
    private static final String MODEL_TYPE = "ModelType";
    private static final String MODEL_SUBTYPE = "SubType";
    private static final String MODEL_NAME = "Name";
    private static final String MODEL_NAME_IN_SOURCE = "NameInSource";
    private static final String MODEL_DESC = "Description";
    private static final String MODEL_EXT_PACKAGE = "ExtPackage";
    private static final String METACLASS_URI = "MetaClassUri";
    private static final String PARENT_PATH = "ParentPath";
    private static final String PARENT_METACLASS_URI = "ParentMetaClassUri";
    private static final String ENTITY_NAME = "name";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RecordGenerator.class);

    private static String getString(String id) {
        return MetamodelBuilderPlugin.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param1, Object param2) {
        return MetamodelBuilderPlugin.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{param1, param2});
    }

    public static List generateModelRecords(ResultSet resultSet, String locationPathStr, MultiStatus status, IProgressMonitor monitor) throws SQLException {
        List mapList = ResultSetTranslator.translate(resultSet);
        ArrayList<ModelRecord> recordList = new ArrayList<ModelRecord>(mapList.size());
        for (Map recordMap : mapList) {
            String modelType = (String)recordMap.get(MODEL_TYPE);
            String subType = (String)recordMap.get(MODEL_SUBTYPE);
            String name = (String)recordMap.get(MODEL_NAME);
            String nameInSource = (String)recordMap.get(MODEL_NAME_IN_SOURCE);
            String desc = (String)recordMap.get(MODEL_DESC);
            String extPackage = (String)recordMap.get(MODEL_EXT_PACKAGE);
            ModelRecord record = null;
            if (modelType == null || name == null) {
                String msg = RecordGenerator.getString("unableToCreateModelRecord");
                BuilderUtil.addStatus(status, 2, msg);
            } else {
                try {
                    record = new ModelRecord(modelType, subType, name, nameInSource, desc, extPackage);
                }
                catch (IllegalArgumentException ex) {
                    String msg = RecordGenerator.getString("unableToCreateModelRecord");
                    BuilderUtil.addStatus(status, 2, msg, ex);
                }
            }
            if (record != null) {
                record.setLocationPath(locationPathStr);
                recordList.add(record);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return recordList;
    }

    public static List generateEntityRecords(ResultSet resultSet, MultiStatus status, IProgressMonitor monitor) throws SQLException {
        List mapList = ResultSetTranslator.translate(resultSet);
        ArrayList<MetamodelEntityRecord> recordList = new ArrayList<MetamodelEntityRecord>(mapList.size());
        for (Map recordMap : mapList) {
            String metaClassUri = (String)recordMap.remove(METACLASS_URI);
            String parentPath = (String)recordMap.remove(PARENT_PATH);
            String parentMetaclassUri = (String)recordMap.remove(PARENT_METACLASS_URI);
            String name = (String)recordMap.get(ENTITY_NAME);
            MetamodelEntityRecord record = null;
            if (metaClassUri == null || parentPath == null) {
                String metaClass = "NullMetaClass";
                if (metaClassUri != null) {
                    metaClass = MetaClassUriHelper.getEClassName(metaClassUri);
                }
                String msg = RecordGenerator.getString("unableToCreateEntityRecord", metaClass, name);
                BuilderUtil.addStatus(status, 2, msg);
            } else {
                try {
                    record = new MetamodelEntityRecord(metaClassUri, parentPath, parentMetaclassUri, recordMap);
                }
                catch (IllegalArgumentException ex) {
                    String metaClass = "NullMetaClass";
                    metaClass = MetaClassUriHelper.getEClassName(metaClassUri);
                    String msg = RecordGenerator.getString("unableToCreateEntityRecord", metaClass, name);
                    BuilderUtil.addStatus(status, 2, msg, ex);
                }
            }
            if (record != null) {
                recordList.add(record);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return recordList;
    }
}

