/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDSchema;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.processing.SchemaUtil;

public class SchemaRepresentation {
    private List schemaURIs;
    private XSDSchema[] xsdSchemas;
    private Map m_namespaces;
    private List m_defaultNamespaces;
    private List elements;
    private int m_catalogType;
    private String m_customCatalogName;
    private Object syncObject;

    public SchemaRepresentation(Object syncObject) {
        this.syncObject = syncObject;
        this.setSchemaURIs(new ArrayList());
        this.m_catalogType = 1;
        this.m_customCatalogName = null;
        this.m_namespaces = new HashMap();
        this.m_defaultNamespaces = new ArrayList();
        this.elements = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaURIs(List schemaURIs) {
        Object object = this.syncObject;
        synchronized (object) {
            this.schemaURIs = schemaURIs;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSchemaURIs() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.schemaURIs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCatalogs() {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<String> retVal = null;
            switch (this.m_catalogType) {
                case 1: 
                case 2: {
                    retVal = this.getDefaultNamespaces();
                    break;
                }
                case 3: {
                    retVal = this.getFileNames();
                    break;
                }
                case 4: {
                    retVal = new ArrayList(1);
                    retVal.add(this.m_customCatalogName);
                    break;
                }
                default: {
                    retVal = new ArrayList<String>();
                }
            }
            return retVal;
        }
    }

    private List getDefaultNamespaces() {
        return this.m_defaultNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject[] getRootTables() {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<SchemaObject> roots = new ArrayList<SchemaObject>();
            for (Object otable : this.elements) {
                SchemaObject table = (SchemaObject)otable;
                if (!table.isCanBeRoot()) continue;
                roots.add(table);
            }
            SchemaObject[] retval = new SchemaObject[roots.size()];
            roots.toArray(retval);
            return retval;
        }
    }

    private void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNamespaces() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.m_namespaces;
        }
    }

    private List getFileNames() {
        ArrayList<String> retVal = new ArrayList<String>(this.xsdSchemas.length);
        int i = 0;
        while (i < this.xsdSchemas.length) {
            retVal.add(SchemaUtil.shortenFileName((String)this.xsdSchemas[i].getSchemaLocation()));
            ++i;
        }
        return retVal;
    }

    public void setCustomCatalogName(String name) {
        this.m_customCatalogName = name;
    }

    public boolean addElement(SchemaObject element) {
        return this.elements.add(element);
    }
}

