/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.DnBuilderWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewEntryDnWizardPage
extends WizardPage
implements WidgetModifyListener {
    private NewEntryWizard wizard;
    private DnBuilderWidget dnBuilderWidget;
    private Combo contextEntryDnCombo;
    private ContentProposalAdapter contextEntryDnComboCPA;

    public NewEntryDnWizardPage(String pageName, NewEntryWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("NewEntryDnWizardPage.DistinguishedName"));
        if (wizard.isNewContextEntry()) {
            this.setDescription(Messages.getString("NewEntryDnWizardPage.EnterDN"));
        } else {
            this.setDescription(Messages.getString("NewEntryDnWizardPage.SelectParent"));
        }
        this.setImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
    }

    public void dispose() {
        if (this.dnBuilderWidget != null) {
            this.dnBuilderWidget.removeWidgetModifyListener(this);
            this.dnBuilderWidget.dispose();
            this.dnBuilderWidget = null;
        }
        super.dispose();
    }

    private void validate() {
        if (this.wizard.isNewContextEntry() && !"".equals(this.contextEntryDnCombo.getText()) && Dn.isValid((String)this.contextEntryDnCombo.getText())) {
            this.setPageComplete(true);
            this.saveState();
        } else if (!this.wizard.isNewContextEntry() && this.dnBuilderWidget.getRdn() != null && this.dnBuilderWidget.getParentDn() != null) {
            this.setPageComplete(true);
            this.saveState();
        } else {
            this.setPageComplete(false);
        }
    }

    private void loadState() {
        DummyEntry newEntry = this.wizard.getPrototypeEntry();
        if (this.wizard.isNewContextEntry()) {
            IAttribute attribute = this.wizard.getSelectedConnection().getRootDSE().getAttribute("namingContexts");
            if (attribute != null) {
                String[] values = attribute.getStringValues();
                this.contextEntryDnComboCPA.setContentProposalProvider((IContentProposalProvider)new ListContentProposalProvider(values));
                this.contextEntryDnCombo.setItems(values);
                if (Arrays.asList(values).contains(newEntry.getDn().getName())) {
                    this.contextEntryDnCombo.setText(newEntry.getDn().getName());
                }
            }
        } else {
            boolean newEntryParentDnNotNullOrEmpty;
            Collection atds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)newEntry);
            String[] attributeNames = SchemaUtils.getNames((Collection)atds).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
            Dn parentDn = null;
            boolean hasSelectedEntry = this.wizard.getSelectedEntry() != null;
            boolean bl = newEntryParentDnNotNullOrEmpty = !Dn.isNullOrEmpty((Dn)newEntry.getDn().getParent());
            if (hasSelectedEntry) {
                boolean newEntryDnEqualsSelectedEntryDn = newEntry.getDn().equals((Object)this.wizard.getSelectedEntry().getDn());
                parentDn = newEntryDnEqualsSelectedEntryDn && newEntryParentDnNotNullOrEmpty ? newEntry.getDn().getParent() : this.wizard.getSelectedEntry().getDn();
            } else if (newEntryParentDnNotNullOrEmpty) {
                parentDn = newEntry.getDn().getParent();
            }
            Rdn rdn = newEntry.getRdn();
            this.dnBuilderWidget.setInput(this.wizard.getSelectedConnection(), attributeNames, rdn, parentDn);
        }
    }

    private void saveState() {
        DummyEntry newEntry = this.wizard.getPrototypeEntry();
        try {
            Dn dn;
            EventRegistry.suspendEventFiringInCurrentThread();
            if (newEntry.getRdn().size() > 0) {
                for (Ava atav : newEntry.getRdn()) {
                    IAttribute attribute = newEntry.getAttribute(atav.getType());
                    if (attribute == null) continue;
                    IValue[] values = attribute.getValues();
                    int v = 0;
                    while (v < values.length) {
                        if (values[v].getStringValue().equals(atav.getNormValue().getString())) {
                            attribute.deleteValue(values[v]);
                        }
                        ++v;
                    }
                    if (attribute.getValueSize() != 0) continue;
                    newEntry.deleteAttribute(attribute);
                }
            }
            if (this.wizard.isNewContextEntry()) {
                try {
                    dn = new Dn(new String[]{this.contextEntryDnCombo.getText()});
                }
                catch (LdapInvalidDnException ldapInvalidDnException) {
                    dn = Dn.EMPTY_DN;
                }
            } else {
                try {
                    dn = this.dnBuilderWidget.getParentDn().add(this.dnBuilderWidget.getRdn());
                }
                catch (LdapInvalidDnException ldapInvalidDnException) {
                    dn = Dn.EMPTY_DN;
                }
            }
            newEntry.setDn(dn);
            if (dn.getRdn().size() > 0) {
                for (Ava atav : dn.getRdn()) {
                    IAttribute rdnAttribute = newEntry.getAttribute(atav.getType());
                    if (rdnAttribute == null) {
                        rdnAttribute = new Attribute((IEntry)newEntry, atav.getType());
                        newEntry.addAttribute(rdnAttribute);
                    }
                    String rdnValue = atav.getNormValue().getString();
                    String[] stringValues = rdnAttribute.getStringValues();
                    if (Arrays.asList(stringValues).contains(rdnValue)) continue;
                    rdnAttribute.addValue((IValue)new Value(rdnAttribute, (Object)rdnValue));
                }
            }
        }
        finally {
            EventRegistry.resumeEventFiringInCurrentThread();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadState();
            this.validate();
            if (this.wizard.isNewContextEntry()) {
                this.contextEntryDnCombo.setFocus();
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        block9: {
            if (!this.wizard.isNewContextEntry()) {
                Dn dn;
                block8: {
                    this.dnBuilderWidget.validate();
                    Rdn rdn = this.dnBuilderWidget.getRdn();
                    Dn parentDn = this.dnBuilderWidget.getParentDn();
                    try {
                        dn = parentDn.add(rdn);
                        ReadEntryRunnable readEntryRunnable1 = new ReadEntryRunnable(this.wizard.getSelectedConnection(), parentDn);
                        RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)readEntryRunnable1, (IRunnableContext)this.getContainer(), (boolean)false);
                        IEntry parentEntry = readEntryRunnable1.getReadEntry();
                        if (parentEntry != null) break block8;
                        this.getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)NewEntryDnWizardPage.this.getShell(), (String)Messages.getString("NewEntryDnWizardPage.Error"), (String)NLS.bind((String)Messages.getString("NewEntryDnWizardPage.ParentDoesNotExist"), (Object)NewEntryDnWizardPage.this.dnBuilderWidget.getParentDn().toString()));
                            }
                        });
                        return null;
                    }
                    catch (LdapInvalidDnException ldapInvalidDnException) {
                        return null;
                    }
                }
                ReadEntryRunnable readEntryRunnable2 = new ReadEntryRunnable(this.wizard.getSelectedConnection(), dn);
                RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)readEntryRunnable2, (IRunnableContext)this.getContainer(), (boolean)false);
                IEntry entry = readEntryRunnable2.getReadEntry();
                if (entry != null) {
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)NewEntryDnWizardPage.this.getShell(), (String)Messages.getString("NewEntryDnWizardPage.Error"), (String)NLS.bind((String)Messages.getString("NewEntryDnWizardPage.EntryAlreadyExists"), (Object)dn.toString()));
                        }
                    });
                    return null;
                }
                break block9;
            }
            try {
                final Dn dn = new Dn(new String[]{this.contextEntryDnCombo.getText()});
                ReadEntryRunnable readEntryRunnable2 = new ReadEntryRunnable(this.wizard.getSelectedConnection(), dn);
                RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)readEntryRunnable2, (IRunnableContext)this.getContainer(), (boolean)false);
                IEntry entry = readEntryRunnable2.getReadEntry();
                if (entry != null) {
                    this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)NewEntryDnWizardPage.this.getShell(), (String)Messages.getString("NewEntryDnWizardPage.Error"), (String)NLS.bind((String)Messages.getString("NewEntryDnWizardPage.EntryAlreadyExists"), (Object)dn.toString()));
                        }
                    });
                    return null;
                }
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                return null;
            }
        }
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        if (this.wizard.isNewContextEntry()) {
            Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
            this.contextEntryDnCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])ArrayUtils.EMPTY_STRING_ARRAY, (int)0, (int)1);
            this.contextEntryDnCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewEntryDnWizardPage.this.validate();
                }
            });
            this.contextEntryDnComboCPA = new ContentProposalAdapter((Control)this.contextEntryDnCombo, (IControlContentAdapter)new ComboContentAdapter(), null, null, null);
            this.contextEntryDnComboCPA.setFilterStyle(1);
            this.contextEntryDnComboCPA.setProposalAcceptanceStyle(2);
            this.setControl((Control)composite);
        } else {
            this.dnBuilderWidget = new DnBuilderWidget(true, true);
            this.dnBuilderWidget.addWidgetModifyListener(this);
            Composite composite = this.dnBuilderWidget.createContents(parent);
            this.setControl((Control)composite);
        }
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }

    public void saveDialogSettings() {
        if (!this.wizard.isNewContextEntry()) {
            this.dnBuilderWidget.saveDialogSettings();
        }
    }
}

