/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.ui.widgets.AbstractWidget;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DnBuilderWidget
extends AbstractWidget
implements ModifyListener {
    private String[] attributeNames;
    private Rdn currentRdn;
    private Dn currentParentDn;
    private boolean showRDN;
    private boolean showParent;
    private Shell shell;
    private Dn parentDn;
    private Label parentEntryLabel;
    private EntryWidget parentEntryWidget;
    private Label rdnLabel;
    private Composite rdnComposite;
    private Rdn rdn;
    private ArrayList<RdnLine> rdnLineList;
    private Label previewLabel;
    private Text previewText;
    private SelectionListener rdnAddButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = DnBuilderWidget.this.rdnLineList.size();
            int i = 0;
            while (i < DnBuilderWidget.this.rdnLineList.size()) {
                RdnLine rdnLine = (RdnLine)DnBuilderWidget.this.rdnLineList.get(i);
                if (rdnLine.rdnAddButton == e.widget) {
                    index = i + 1;
                }
                ++i;
            }
            DnBuilderWidget.this.addRdnLine(DnBuilderWidget.this.rdnComposite, index);
            DnBuilderWidget.this.validate();
        }
    };
    private SelectionListener rdnDeleteButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = 0;
            int i = 0;
            while (i < DnBuilderWidget.this.rdnLineList.size()) {
                RdnLine rdnLine = (RdnLine)DnBuilderWidget.this.rdnLineList.get(i);
                if (rdnLine.rdnDeleteButton == e.widget) {
                    index = i;
                }
                ++i;
            }
            DnBuilderWidget.this.deleteRdnLine(DnBuilderWidget.this.rdnComposite, index);
            DnBuilderWidget.this.validate();
        }
    };

    public DnBuilderWidget(boolean showRDN, boolean showParent) {
        this.showRDN = showRDN;
        this.showParent = showParent;
    }

    public void dispose() {
    }

    public void setInput(IBrowserConnection browserConnection, String[] attributeNames, Rdn rdn, Dn parentDn) {
        int i;
        this.attributeNames = attributeNames;
        this.currentRdn = rdn;
        this.currentParentDn = parentDn;
        if (this.showRDN) {
            i = 0;
            while (i < this.rdnLineList.size()) {
                RdnLine rdnLine = this.rdnLineList.get(i);
                String oldName = rdnLine.rdnTypeCombo.getText();
                rdnLine.rdnTypeCombo.setItems(attributeNames);
                rdnLine.rdnNameCPA.setContentProposalProvider((IContentProposalProvider)new ListContentProposalProvider(attributeNames));
                if (Arrays.asList(rdnLine.rdnTypeCombo.getItems()).contains(oldName)) {
                    rdnLine.rdnTypeCombo.setText(oldName);
                }
                ++i;
            }
        }
        if (this.showRDN) {
            while (!this.rdnLineList.isEmpty()) {
                this.deleteRdnLine(this.rdnComposite, 0);
            }
            if (this.currentRdn == null || this.currentRdn.size() == 0) {
                this.addRdnLine(this.rdnComposite, 0);
                this.rdnLineList.get(0).rdnTypeCombo.setFocus();
            } else {
                i = 0;
                for (Ava ava : this.currentRdn) {
                    this.addRdnLine(this.rdnComposite, i);
                    this.removeRdnLineListeners(i);
                    this.rdnLineList.get(i).rdnTypeCombo.setText(ava.getType());
                    this.rdnLineList.get(i).rdnValueText.setText(ava.getNormValue().getString());
                    this.addRdnLineListeners(i);
                    if (i == 0) {
                        if ("".equals(this.rdnLineList.get(i).rdnTypeCombo)) {
                            this.rdnLineList.get(i).rdnTypeCombo.setFocus();
                        } else {
                            this.rdnLineList.get(i).rdnValueText.selectAll();
                            this.rdnLineList.get(i).rdnValueText.setFocus();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.showParent) {
            this.parentEntryWidget.setInput(browserConnection, this.currentParentDn);
        }
        this.validate();
    }

    public Rdn getRdn() {
        return this.rdn;
    }

    public Dn getParentDn() {
        return this.parentDn;
    }

    public Composite createContents(Composite parent) {
        this.shell = parent.getShell();
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        if (this.showParent) {
            this.parentEntryLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("DnBuilderWidget.Parent"), (int)1);
            this.parentEntryWidget = new EntryWidget();
            this.parentEntryWidget.createWidget(composite);
            this.parentEntryWidget.addWidgetModifyListener(new WidgetModifyListener(){

                public void widgetModified(WidgetModifyEvent event) {
                    DnBuilderWidget.this.validate();
                }
            });
            BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
        }
        if (this.showRDN) {
            this.rdnLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("DnBuilderWidget.RDN"), (int)1);
            this.rdnComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)5, (int)2);
            this.rdnLineList = new ArrayList();
            BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
        }
        if (this.showRDN) {
            this.previewLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)(this.showParent ? Messages.getString("DnBuilderWidget.DNPreview") : Messages.getString("DnBuilderWidget.RDNPreview")), (int)1);
            this.previewText = BaseWidgetUtils.createReadonlyText((Composite)composite, (String)"", (int)2);
            BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
        }
        return composite;
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    public void saveDialogSettings() {
        if (this.parentEntryWidget != null) {
            this.parentEntryWidget.saveDialogSettings();
        }
    }

    public void validate() {
        Exception rdnE = null;
        if (this.showRDN) {
            try {
                String[] rdnTypes = new String[this.rdnLineList.size()];
                String[] rdnValues = new String[this.rdnLineList.size()];
                int i = 0;
                while (i < this.rdnLineList.size()) {
                    RdnLine rdnLine = this.rdnLineList.get(i);
                    rdnTypes[i] = rdnLine.rdnTypeCombo.getText();
                    rdnValues[i] = rdnLine.rdnValueText.getText();
                    if (this.rdnLineList.size() > 1) {
                        rdnLine.rdnDeleteButton.setEnabled(true);
                    } else {
                        rdnLine.rdnDeleteButton.setEnabled(false);
                    }
                    ++i;
                }
                this.rdn = DnUtils.composeRdn((String[])rdnTypes, (String[])rdnValues);
            }
            catch (Exception e) {
                rdnE = e;
                this.rdn = null;
            }
        }
        Exception parentE = null;
        if (this.showParent) {
            try {
                this.parentDn = this.parentEntryWidget.getDn();
            }
            catch (Exception e) {
                parentE = e;
                this.parentDn = null;
            }
        }
        String s = "";
        if (rdnE != null) {
            s = String.valueOf(s) + (rdnE.getMessage() != null ? rdnE.getMessage() : Messages.getString("DnBuilderWidget.ErrorInRDN"));
        }
        if (parentE != null) {
            s = String.valueOf(s) + (", " + parentE.getMessage() != null ? parentE.getMessage() : Messages.getString("DnBuilderWidget.ErrorInParentDN"));
        }
        if (this.previewText != null) {
            if (s.length() > 0) {
                this.previewText.setText(s);
            } else {
                Dn dn;
                if (this.showParent && this.showRDN) {
                    try {
                        dn = this.parentDn.add(this.rdn);
                    }
                    catch (LdapInvalidDnException ldapInvalidDnException) {
                        dn = Dn.EMPTY_DN;
                    }
                } else if (this.showParent) {
                    dn = this.parentDn;
                } else if (this.showRDN) {
                    try {
                        dn = new Dn(new Rdn[]{this.rdn});
                    }
                    catch (LdapInvalidDnException ldapInvalidDnException) {
                        dn = Dn.EMPTY_DN;
                    }
                } else {
                    dn = Dn.EMPTY_DN;
                }
                this.previewText.setText(dn.getName());
            }
        }
        this.notifyListeners();
    }

    private void addRdnLine(Composite rdnComposite, int index) {
        RdnLine[] rdnLines = this.rdnLineList.toArray(new RdnLine[this.rdnLineList.size()]);
        if (rdnLines.length > 0) {
            int i = 0;
            while (i < rdnLines.length) {
                RdnLine oldRdnLine = rdnLines[i];
                String oldName = oldRdnLine.rdnTypeCombo.getText();
                String oldValue = oldRdnLine.rdnValueText.getText();
                oldRdnLine.rdnTypeCombo.dispose();
                oldRdnLine.rdnEqualsLabel.dispose();
                oldRdnLine.rdnValueText.dispose();
                oldRdnLine.rdnAddButton.dispose();
                oldRdnLine.rdnDeleteButton.dispose();
                this.rdnLineList.remove(oldRdnLine);
                RdnLine newRdnLine = this.createRdnLine(rdnComposite);
                this.rdnLineList.add(newRdnLine);
                newRdnLine.rdnTypeCombo.setText(oldName);
                newRdnLine.rdnValueText.setText(oldValue);
                if (index == i + 1) {
                    RdnLine rdnLine = this.createRdnLine(rdnComposite);
                    this.rdnLineList.add(rdnLine);
                }
                ++i;
            }
        } else {
            RdnLine rdnLine = this.createRdnLine(rdnComposite);
            this.rdnLineList.add(rdnLine);
        }
        this.shell.layout(true, true);
    }

    private RdnLine createRdnLine(Composite rdnComposite) {
        RdnLine rdnLine = new RdnLine();
        rdnLine.rdnTypeCombo = new Combo(rdnComposite, 2052);
        GridData gd = new GridData();
        gd.widthHint = 180;
        rdnLine.rdnTypeCombo.setLayoutData((Object)gd);
        rdnLine.rdnNameCPA = (ContentProposalAdapter)new ExtendedContentAssistCommandAdapter((Control)rdnLine.rdnTypeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.attributeNames), null, null, true);
        rdnLine.rdnEqualsLabel = new Label(rdnComposite, 0);
        rdnLine.rdnEqualsLabel.setText("=");
        rdnLine.rdnValueText = new Text(rdnComposite, 2048);
        gd = new GridData(768);
        rdnLine.rdnValueText.setLayoutData((Object)gd);
        rdnLine.rdnAddButton = new Button(rdnComposite, 8);
        rdnLine.rdnAddButton.setText("  +   ");
        rdnLine.rdnDeleteButton = new Button(rdnComposite, 8);
        rdnLine.rdnDeleteButton.setText("  \u2212  ");
        if (this.attributeNames != null) {
            rdnLine.rdnTypeCombo.setItems(this.attributeNames);
        }
        this.addRdnLineListeners(rdnLine);
        return rdnLine;
    }

    private void deleteRdnLine(Composite rdnComposite, int index) {
        RdnLine rdnLine = this.rdnLineList.remove(index);
        if (rdnLine != null) {
            rdnLine.rdnTypeCombo.dispose();
            rdnLine.rdnEqualsLabel.dispose();
            rdnLine.rdnValueText.dispose();
            rdnLine.rdnAddButton.dispose();
            rdnLine.rdnDeleteButton.dispose();
            if (!rdnComposite.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    private void addRdnLineListeners(int index) {
        if (this.rdnLineList != null) {
            this.addRdnLineListeners(this.rdnLineList.get(index));
        }
    }

    private void addRdnLineListeners(RdnLine rdnLine) {
        if (rdnLine != null) {
            rdnLine.rdnAddButton.addSelectionListener(this.rdnAddButtonSelectionListener);
            rdnLine.rdnDeleteButton.addSelectionListener(this.rdnDeleteButtonSelectionListener);
            rdnLine.rdnTypeCombo.addModifyListener((ModifyListener)this);
            rdnLine.rdnValueText.addModifyListener((ModifyListener)this);
        }
    }

    private void removeRdnLineListeners(int index) {
        if (this.rdnLineList != null) {
            this.removeRdnLineListeners(this.rdnLineList.get(index));
        }
    }

    private void removeRdnLineListeners(RdnLine rdnLine) {
        if (rdnLine != null) {
            rdnLine.rdnAddButton.removeSelectionListener(this.rdnAddButtonSelectionListener);
            rdnLine.rdnDeleteButton.removeSelectionListener(this.rdnDeleteButtonSelectionListener);
            rdnLine.rdnTypeCombo.removeModifyListener((ModifyListener)this);
            rdnLine.rdnValueText.removeModifyListener((ModifyListener)this);
        }
    }

    public void setEnabled(boolean b) {
        if (this.parentEntryWidget != null) {
            this.parentEntryLabel.setEnabled(b);
            this.parentEntryWidget.setEnabled(b);
        }
        if (this.rdnComposite != null && this.rdnLineList != null) {
            this.rdnLabel.setEnabled(b);
            this.rdnComposite.setEnabled(b);
            for (RdnLine rdnLine : this.rdnLineList) {
                rdnLine.rdnTypeCombo.setEnabled(b);
                rdnLine.rdnEqualsLabel.setEnabled(b);
                rdnLine.rdnValueText.setEnabled(b);
                rdnLine.rdnAddButton.setEnabled(b);
                rdnLine.rdnDeleteButton.setEnabled(b && this.rdnLineList.size() > 1);
            }
            if (b) {
                this.rdnLineList.get(0).rdnValueText.setFocus();
            }
        }
        if (this.previewText != null) {
            this.previewLabel.setEnabled(b);
            this.previewText.setEnabled(b);
        }
    }

    private class RdnLine {
        private Combo rdnTypeCombo;
        private ContentProposalAdapter rdnNameCPA;
        private Text rdnValueText;
        private Label rdnEqualsLabel;
        private Button rdnAddButton;
        private Button rdnDeleteButton;

        private RdnLine() {
        }
    }
}

