/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.DnBuilderWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RenameEntryDialog
extends Dialog
implements WidgetModifyListener {
    private static final String DELETE_OLD_RDN_DIALOGSETTING_KEY = String.valueOf(RenameEntryDialog.class.getName()) + ".deleteOldRdn";
    private static final String DIALOG_TITLE = Messages.getString("RenameEntryDialog.RenameEntry");
    private IEntry entry;
    private DnBuilderWidget dnBuilderWidget;
    private Button okButton;
    private Rdn rdn;
    private boolean initialized = false;

    public RenameEntryDialog(Shell parentShell, IEntry entry) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.entry = entry;
        this.rdn = null;
        if (BrowserCommonActivator.getDefault().getDialogSettings().get(DELETE_OLD_RDN_DIALOGSETTING_KEY) == null) {
            BrowserCommonActivator.getDefault().getDialogSettings().put(DELETE_OLD_RDN_DIALOGSETTING_KEY, true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    public boolean close() {
        this.dnBuilderWidget.removeWidgetModifyListener(this);
        this.dnBuilderWidget.dispose();
        return super.close();
    }

    protected void okPressed() {
        this.rdn = this.dnBuilderWidget.getRdn();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 3 / 2;
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("RenameEntryDialog.RenameEntryDescription"), (int)1);
        this.dnBuilderWidget = new DnBuilderWidget(true, false);
        this.dnBuilderWidget.addWidgetModifyListener(this);
        this.dnBuilderWidget.createContents(composite);
        Collection allAtds = SchemaUtils.getAllAttributeTypeDescriptions((IEntry)this.entry);
        String[] allAttributeNames = SchemaUtils.getNames((Collection)allAtds).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        this.dnBuilderWidget.setInput(this.entry.getBrowserConnection(), allAttributeNames, this.entry.getRdn(), null);
        RenameEntryDialog.applyDialogFont((Control)composite);
        this.initialized = true;
        return composite;
    }

    public void widgetModified(WidgetModifyEvent event) {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.dnBuilderWidget.getRdn() != null);
        }
        if (this.initialized && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().pack();
        }
    }

    public Rdn getRdn() {
        return this.rdn;
    }
}

