/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class MessageLabel
extends CLabel {
    private static final String EMPTY_STRING = "";
    private Color fNormalMsgAreaBackground = null;
    private boolean hideMessageIfOk = true;

    public MessageLabel(Composite parent) {
        this(parent, 16384);
    }

    public MessageLabel(Composite parent, int style) {
        super(parent, style);
    }

    private Image findImage(IStatus status) {
        if (status.isOK()) {
            return null;
        }
        if (status.matches(4)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (status.matches(2)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (status.matches(1)) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        return null;
    }

    public void setErrorStatus(IStatus status) {
        if (status != null) {
            String message = this.hideMessageIfOk && status.isOK() ? EMPTY_STRING : status.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            this.setText(message);
            this.setImage(this.findImage(status));
            this.setBackground(JFaceColors.getErrorBackground((Display)this.getDisplay()));
            this.pack();
            this.redraw();
        } else {
            this.setText(EMPTY_STRING);
            this.setImage(null);
            this.setBackground(this.fNormalMsgAreaBackground);
        }
    }

    public void setOkMessageHidden(boolean flag) {
        this.hideMessageIfOk = flag;
    }
}

