/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;

public class Dialog
extends org.eclipse.jface.dialogs.Dialog {
    private int widthPercentage = -1;
    private int heightPercentage = -1;
    private boolean centerOnDisplay = false;
    private String title;

    public Dialog(Shell parent, String title) {
        super(parent);
        this.setTitle(title);
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.widthPercentage >= 1 && this.widthPercentage <= 100 && this.heightPercentage >= 1 && this.heightPercentage <= 100) {
            int y;
            int x;
            Shell shell = this.getShell();
            Point point = shell.getDisplay().getCursorLocation();
            Monitor currentMonitor = null;
            Monitor[] monitorArray = shell.getDisplay().getMonitors();
            int n = monitorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Monitor monitor = monitorArray[n2];
                if (monitor.getClientArea().contains(point)) {
                    currentMonitor = monitor;
                    break;
                }
                ++n2;
            }
            if (currentMonitor == null) {
                currentMonitor = shell.getDisplay().getPrimaryMonitor();
            }
            Rectangle bounds = currentMonitor.getClientArea();
            int scaledWidth = bounds.width * this.widthPercentage / 100;
            int scaledHeight = bounds.height * this.heightPercentage / 100;
            shell.setSize(scaledWidth, scaledHeight);
            Point size = shell.getSize();
            if (this.centerOnDisplay) {
                int excessX = bounds.width - size.x;
                int excessY = bounds.height - size.y;
                x = bounds.x + excessX / 2;
                y = bounds.y + excessY / 2;
            } else {
                Point loc = shell.getLocation();
                x = Math.max(bounds.x, Math.min(loc.x, bounds.x + bounds.width - size.x));
                y = Math.max(bounds.y, Math.min(loc.y, bounds.y + bounds.height - size.y));
            }
            shell.setLocation(x, y);
        }
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        this.getShell().setText(this.title);
        this.title = null;
    }

    public void setSizeRelativeToScreen(int theWidthPercentage, int theHeightPercentage) {
        this.widthPercentage = theWidthPercentage < 1 || theWidthPercentage > 100 ? 50 : theWidthPercentage;
        this.heightPercentage = theHeightPercentage < 1 || theHeightPercentage > 100 ? 50 : theHeightPercentage;
    }

    public String getTitle() {
        Shell shell = this.getShell();
        return shell == null ? this.title : this.getShell().getText();
    }

    public void setTitle(String title) {
        CoreArgCheck.isNotNull((Object)title);
        Shell shell = this.getShell();
        if (shell == null) {
            this.title = title;
        } else {
            shell.setText(title);
        }
    }

    public void setCenterOnDisplay(boolean flag) {
        this.centerOnDisplay = flag;
    }

    public boolean getCenterOnDisplay() {
        return this.centerOnDisplay;
    }
}

