/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.graphics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.ui.common.util.UiUtil;

public class GlobalUiColorManager {
    private static Map<RGB, Color> fColorTable = Collections.synchronizedMap(new HashMap(10));
    public static final Color NOTE_COLOR = GlobalUiColorManager.getSystemColor(10);
    public static final Color EMPHASIS_COLOR = GlobalUiColorManager.getSystemColor(10);
    public static final Color EMPHASIS_COLOR_DISABLED = GlobalUiColorManager.getSystemColor(18);
    private static Color varColor;

    static Color getSystemColor(final int colorID) {
        varColor = null;
        UiUtil.runInSwtThread(new Runnable(){

            @Override
            public void run() {
                varColor = UiUtil.getSystemColor(colorID);
            }
        }, true);
        return varColor;
    }

    public static void dispose() {
        Iterator<Color> e = fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        fColorTable.clear();
    }

    public static Color getColor(RGB rgb) {
        Color color = fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            fColorTable.put(rgb, color);
        }
        return color;
    }
}

