/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.dialog;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.dialog.FileContentsDialog;

public class FileUiUtils
implements UiConstants {
    public static FileUiUtils INSTANCE = new FileUiUtils();

    public String getExistingCaseVariantFileName(String theFullPathName) {
        String result = theFullPathName;
        if (result != null) {
            result = theFullPathName.trim();
        }
        CoreArgCheck.isTrue((!CoreStringUtil.isEmpty((String)result) ? 1 : 0) != 0, (String)"The full path name cannot be empty");
        File file = new File(result);
        if (file.exists()) {
            String name = file.getName();
            File parentDir = file.getParentFile();
            if (parentDir == null) {
                File tempFile = file.getAbsoluteFile();
                parentDir = tempFile.getParentFile();
            }
            if (parentDir != null) {
                File[] kids = parentDir.listFiles();
                int i = 0;
                while (i < kids.length) {
                    String existingName = kids[i].getName();
                    if (existingName.equalsIgnoreCase(name)) {
                        result = kids[i].getAbsolutePath();
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public String getExistingCaseVariantFileName(IPath path) {
        return this.getExistingCaseVariantFileName(path.toOSString());
    }

    public void showFileContents(Shell shell, File file, String title, String displayedFileName) {
        if (file.exists()) {
            new FileContentsDialog(shell, title, file, displayedFileName).open();
        } else {
            MessageDialog.openError((Shell)shell, (String)"File Not Found", (String)("The file: " + displayedFileName + " does not exist"));
        }
    }
}

