/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class EditorPerspectiveListener
implements IPerspectiveListener3 {
    private Map<IPerspectiveDescriptor, IEditorInput> activeEditorMap = new HashMap<IPerspectiveDescriptor, IEditorInput>();
    IEditorReference currentEditor;

    public EditorPerspectiveListener(IWorkbenchWindow window) {
        window.getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    EditorPerspectiveListener.this.currentEditor = (IEditorReference)ref;
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    EditorPerspectiveListener.this.currentEditor = (IEditorReference)ref;
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                if (ref != null && ref.equals(EditorPerspectiveListener.this.currentEditor)) {
                    EditorPerspectiveListener.this.currentEditor = null;
                }
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partVisible(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.activeEditorMap.remove(perspective);
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        try {
            if (this.currentEditor != null && this.currentEditor.getEditorInput() != null) {
                this.activeEditorMap.put(perspective, this.currentEditor.getEditorInput());
            }
        }
        catch (PartInitException partInitException) {}
        this.currentEditor = null;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        IEditorInput editorInput;
        if (this.activeEditorMap.keySet().contains(perspective) && (editorInput = this.activeEditorMap.get(perspective)) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                try {
                    if (editors[i].getEditorInput().equals(editorInput)) {
                        page.openEditor(editorInput, editors[i].getId(), false);
                        break;
                    }
                }
                catch (PartInitException partInitException) {}
                ++i;
            }
        }
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        IEditorInput editor = this.activeEditorMap.get(oldPerspective);
        if (editor != null) {
            this.activeEditorMap.put(newPerspective, editor);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }
}

