/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.xerces.util.EncodingMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.xsd.XsdResourceFactory;
import org.teiid.designer.metamodels.xsd.ui.XsdUiPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class XsdEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IGotoMarker {
    protected static ResourceSet resourceSet;
    protected XSDSchema xsdSchema;
    protected AdapterFactoryEditingDomain editingDomain;
    protected XSDItemProviderAdapterFactory syntacticAdapterFactory;
    protected XSDItemProviderAdapterFactory semanticAdapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TextEditor textEditor;
    protected ISourceViewer sourceViewer;
    protected TreeViewer syntacticSelectionViewer;
    protected TreeViewer semanticSelectionViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected SelectDiagnosticAction selectNextDiagnosticsAction;
    protected SelectDiagnosticAction selectPreviousDiagnosticsAction;
    protected SelectUseAction selectNextUseAction;
    protected SelectUseAction selectPreviousUseAction;
    private Resource xsdResource;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            XsdEditor.this.handlePartActivated(p);
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected boolean handledStructuredModelChange = false;

    public XsdEditor() {
        this.syntacticAdapterFactory = new XSDItemProviderAdapterFactory();
        this.semanticAdapterFactory = new XSDSemanticItemProviderAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                XsdEditor.this.getParentComposite().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XsdEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            XsdEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        XsdEditor.this.handleStructuredModelChange();
                        XsdEditor.this.updateActions();
                        if ((this).XsdEditor.this.propertySheetPage != null) {
                            (this).XsdEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = resourceSet != null ? new AdapterFactoryEditingDomain((AdapterFactory)this.syntacticAdapterFactory, (CommandStack)commandStack, resourceSet) : new AdapterFactoryEditingDomain((AdapterFactory)this.syntacticAdapterFactory, (CommandStack)commandStack);
        Map map = this.editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!map.containsKey("xsd")) {
            map.put("xsd", new XsdResourceFactory());
        }
    }

    Composite getParentComposite() {
        return this.getContainer();
    }

    protected void updateActions() {
        if (this.selectNextDiagnosticsAction != null) {
            this.selectNextDiagnosticsAction.updateAction();
            this.selectPreviousDiagnosticsAction.updateAction();
            this.selectNextUseAction.updateAction();
            this.selectPreviousUseAction.updateAction();
        }
    }

    protected String determineEncoding() {
        String encoding = (String)((XSDResourceImpl)this.getXsdSchema().eResource()).getDefaultSaveOptions().get(XSDResourceImpl.XSD_ENCODING);
        if (encoding != null && EncodingMap.getIANA2JavaMapping((String)encoding) != null) {
            encoding = EncodingMap.getIANA2JavaMapping((String)encoding);
        }
        return encoding;
    }

    protected void handleStructuredModelChange() {
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        if (this.getXsdSchema().getElement() == null) {
            this.getXsdSchema().updateElement();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getXsdSchema().eResource().save((OutputStream)out, null);
            String encoding = this.determineEncoding();
            String newContent = encoding == null ? out.toString() : out.toString(encoding);
            String oldContent = document.get();
            int startIndex = 0;
            while (startIndex < newContent.length() && startIndex < oldContent.length() && newContent.charAt(startIndex) == oldContent.charAt(startIndex)) {
                ++startIndex;
            }
            int newEndIndex = newContent.length() - 1;
            int oldEndIndex = oldContent.length() - 1;
            while (newEndIndex >= startIndex && oldEndIndex >= startIndex && newContent.charAt(newEndIndex) == oldContent.charAt(oldEndIndex)) {
                --newEndIndex;
                --oldEndIndex;
            }
            String replacement = newContent.substring(startIndex, newEndIndex + 1);
            int length = oldEndIndex - startIndex + 1;
            this.handledStructuredModelChange = true;
            document.replace(startIndex, length, replacement);
            this.getXsdSchema().eResource().setModified(true);
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    protected void handlePartActivated(IWorkbenchPart workbenchPart) {
        if (workbenchPart == this) {
            if (this.getActivePage() == 0) {
                this.setCurrentViewer((Viewer)this.sourceViewer);
            }
        } else if (workbenchPart instanceof ContentOutline) {
            if (((ContentOutline)workbenchPart).getCurrentPage() == this.contentOutlinePage) {
                this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
                this.setCurrentViewer((Viewer)this.contentOutlineViewer);
            }
        } else if (workbenchPart instanceof PropertySheet && ((PropertySheet)workbenchPart).getCurrentPage() == this.propertySheetPage) {
            this.getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(final Collection collection) {
        if (collection != null && !collection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (XsdEditor.this.currentViewer != null) {
                        XsdEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        if (this.currentViewerPane != null) {
            this.setCurrentViewer(this.currentViewerPane.getViewer());
        }
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        XsdEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.additions_21", new Object[0])));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createPages() {
        this.createSourcePage();
        this.createSemanticsPage();
        this.createSyntaxPage();
        this.setActivePage(0);
        this.setCurrentViewer((Viewer)this.sourceViewer);
    }

    protected void createResource(String uri) {
        this.extendedCreateResource(uri);
    }

    protected void standardCreateResource(String uri) {
        XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.loadResource(uri);
        this.xsdSchema = xsdResource.getSchema();
    }

    protected void extendedCreateResource(String uri) {
        this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        try {
            XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.getResourceSet().getResource(URI.createFileURI((String)uri), true);
            this.xsdSchema = xsdResource.getSchema();
            this.textEditor.getDocumentProvider().addElementStateListener(new IElementStateListener(){

                public void elementDirtyStateChanged(Object element, boolean isDirty) {
                }

                public void elementContentAboutToBeReplaced(Object element) {
                }

                public void elementContentReplaced(Object element) {
                }

                public void elementDeleted(Object element) {
                    Display display = XsdEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).XsdEditor.this.sourceViewer != null) {
                                XsdEditor.this.getSite().getPage().closeEditor((IEditorPart)XsdEditor.this, false);
                            }
                        }
                    });
                }

                public void elementMoved(Object originalElement, Object movedElement) {
                }
            });
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    protected void createModel() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        progressMonitor.beginTask(XsdUiPlugin.Util.getString("XsdEditor._22", new Object[0]), 10);
                        IFileEditorInput modelFile = (IFileEditorInput)XsdEditor.this.getEditorInput();
                        IFile file = modelFile.getFile();
                        XsdEditor.this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_PROGRESS_MONITOR, progressMonitor);
                        XsdEditor.this.createResource(file.getLocation().toString());
                        XsdEditor.this.editingDomain.getResourceSet().getLoadOptions().remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                        progressMonitor.worked(1);
                        String msg = XsdUiPlugin.Util.getString("_UI_Validating_message", new Object[0]);
                        progressMonitor.subTask(msg);
                        if (XsdEditor.this.getXsdSchema().getDiagnostics().isEmpty()) {
                            XsdEditor.this.getXsdSchema().validate();
                            XsdEditor.this.getXsdSchema().eResource().setModified(false);
                        }
                        progressMonitor.worked(1);
                        progressMonitor.subTask(XsdUiPlugin.Util.getString("_UI_ReportingErrors_message", new Object[0]));
                        XsdEditor.this.handleDiagnostics(progressMonitor);
                    }
                    catch (Throwable t) {
                        XsdUiPlugin.Util.log(t);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    protected void handleSourceCaretPosition() {
        int offset = this.sourceViewer.getTextWidget().getCaretOffset();
        Element element = this.getXsdSchema().getElement();
        if (element != null) {
            IDocument document = this.sourceViewer.getDocument();
            int line = 0;
            int lineOffset = 0;
            try {
                line = document.getLineOfOffset(offset);
                lineOffset = document.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {}
            int column = offset - lineOffset;
            Element bestElement = this.findBestElement(element, line + 1, column + 1);
            if (bestElement != null) {
                this.handleSelectedNodes(Collections.singleton(bestElement));
            }
        }
    }

    public Element findBestElement(Element element, int line, int column) {
        int startLine = XSDParser.getStartLine((Node)element);
        int startColumn = XSDParser.getStartColumn((Node)element);
        int endLine = XSDParser.getEndLine((Node)element);
        int endColumn = XSDParser.getEndColumn((Node)element);
        Element candidate = null;
        if ((line == startLine ? column >= startColumn : line > startLine) && (line == endLine ? column <= endColumn : line < endLine)) {
            candidate = element;
            Node child = element.getFirstChild();
            while (child != null) {
                Element childElement;
                Element betterCandidate;
                if (child.getNodeType() == 1 && (betterCandidate = this.findBestElement(childElement = (Element)child, line, column)) != null) {
                    candidate = betterCandidate;
                    break;
                }
                child = child.getNextSibling();
            }
        }
        return candidate;
    }

    public void handleSelectedNodes(Collection nodes) {
        ArrayList<XSDConcreteComponent> selection = new ArrayList<XSDConcreteComponent>();
        for (Node node : nodes) {
            XSDConcreteComponent bestXSDConcreteComponent = this.getXsdSchema().getCorrespondingComponent(node);
            if (bestXSDConcreteComponent == null) continue;
            boolean add = true;
            XSDConcreteComponent parent = bestXSDConcreteComponent;
            while (parent != null) {
                if (selection.contains(parent)) {
                    add = false;
                    break;
                }
                parent = parent.getContainer();
            }
            if (!add) continue;
            XSDConcreteComponent container = bestXSDConcreteComponent.getContainer();
            if (container instanceof XSDParticle || container instanceof XSDAttributeUse) {
                bestXSDConcreteComponent = container;
            }
            selection.add(bestXSDConcreteComponent);
        }
        if (!selection.isEmpty()) {
            StructuredSelection newSelection = new StructuredSelection(selection.toArray());
            if (this.contentOutlineViewer != null) {
                this.contentOutlineViewer.setSelection((ISelection)newSelection, true);
            }
            this.setSelection((ISelection)newSelection);
            this.handleContentOutlineSelectionForTextEditor((ISelection)newSelection, false);
        }
    }

    protected void handleDocumentChange() {
        try {
            XSDParser xsdParser = new XSDParser(null);
            String documentContent = this.sourceViewer.getDocument().get();
            byte[] bytes = documentContent.getBytes();
            xsdParser.parse((InputStream)new ByteArrayInputStream(bytes));
            xsdParser.setSchema(this.getXsdSchema());
            this.getXsdSchema().validate();
            this.getXsdSchema().eResource().setModified(true);
            this.handleDiagnostics(null);
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    protected void createSourcePage() {
        try {
            this.textEditor = new TextEditor(){

                public ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
                    ISourceViewer result = super.createSourceViewer(parent, ruler, styles);
                    result.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent event) {
                            XsdEditor.this.handleSourceCaretPosition();
                        }
                    });
                    result.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            switch (event.keyCode) {
                                case 0x1000001: 
                                case 0x1000002: 
                                case 0x1000003: 
                                case 0x1000004: 
                                case 0x1000005: 
                                case 0x1000006: {
                                    XsdEditor.this.handleSourceCaretPosition();
                                }
                            }
                        }
                    });
                    XsdEditor.this.sourceViewer = result;
                    return result;
                }
            };
            IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
            int pageIndex = this.addPage((IEditorPart)this.textEditor, (IEditorInput)modelFile);
            this.createModel();
            String encoding = this.determineEncoding();
            IEncodingSupport encodingSupport = (IEncodingSupport)this.textEditor.getAdapter(IEncodingSupport.class);
            if (encodingSupport != null && encoding != null) {
                encodingSupport.setEncoding(encoding);
            }
            this.setPageText(pageIndex, XsdUiPlugin.Util.getString("XsdEditor.Source_26", new Object[0]));
            IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
            document.addDocumentListener(new IDocumentListener(){
                protected Timer timer = new Timer();
                protected TimerTask timerTask;

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    try {
                        if (this.timerTask != null) {
                            this.timerTask.cancel();
                        }
                        if (XsdEditor.this.handledStructuredModelChange) {
                            XsdEditor.this.handledStructuredModelChange = false;
                            XsdEditor.this.handleDocumentChange();
                        } else {
                            this.timerTask = new TimerTask(){

                                @Override
                                public void run() {
                                    XsdEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            XsdEditor.this.handleDocumentChange();
                                        }
                                    });
                                }
                            };
                            this.timer.schedule(this.timerTask, 1000L);
                        }
                    }
                    catch (Exception exception) {
                        XsdUiPlugin.Util.log((Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    protected void createSemanticsPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XsdEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.semanticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.semanticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setAutoExpandLevel(2);
        this.semanticSelectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (XsdEditor.this.currentViewer == XsdEditor.this.semanticSelectionViewer && XsdEditor.this.contentOutlineViewer != null) {
                    XsdEditor.this.contentOutlineViewer.setSelection(selectionChangedEvent.getSelection(), true);
                }
            }
        });
        this.semanticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.getXsdSchema())));
        viewerPane.setTitle((Object)this.getXsdSchema());
        new AdapterFactoryTreeEditor(this.semanticSelectionViewer.getTree(), (AdapterFactory)this.semanticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.semanticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XsdUiPlugin.Util.getString("_UI_Semantics_title", new Object[0]));
    }

    protected void createSyntaxPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XsdEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.syntacticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.syntacticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setAutoExpandLevel(2);
        this.syntacticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.getXsdSchema())));
        viewerPane.setTitle((Object)this.getXsdSchema());
        new AdapterFactoryTreeEditor(this.syntacticSelectionViewer.getTree(), (AdapterFactory)this.syntacticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.syntacticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XsdUiPlugin.Util.getString("_UI_Syntax_title", new Object[0]));
    }

    protected void initializeMarkerPosition(IMarker marker, XSDDiagnostic xsdDiagnostic) throws CoreException {
        Node node = xsdDiagnostic.getNode();
        if (node != null && node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        if (node != null && XSDParser.getUserData((Node)node) != null) {
            int startLine = XSDParser.getStartLine((Node)node) - 1;
            int startColumn = XSDParser.getStartColumn((Node)node);
            int endLine = XSDParser.getEndLine((Node)node) - 1;
            int endColumn = XSDParser.getEndColumn((Node)node);
            marker.setAttribute("lineNumber", startLine);
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                marker.setAttribute("charStart", document.getLineOffset(startLine) + startColumn - 1);
                marker.setAttribute("charEnd", document.getLineOffset(endLine) + endColumn - 1);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            marker.setAttribute("lineNumber", xsdDiagnostic.getLine());
        }
    }

    protected void handleDiagnostics(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor localProgressMonitor) {
                    XsdEditor.this.handleDiagnostics(localProgressMonitor);
                }
            };
            try {
                ModelerCore.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                XsdUiPlugin.Util.log((Throwable)exception);
            }
        } else {
            XSDConcreteComponent newSelection = null;
            try {
                IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
                IFile file = modelFile.getFile();
                IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                ArrayList<IMarker> deletableMarkers = new ArrayList<IMarker>(Arrays.asList(markers));
                for (XSDDiagnostic xsdDiagnostic : this.getXsdSchema().getAllDiagnostics()) {
                    String uriReferencePath = this.getXsdSchema().eResource().getURIFragment((EObject)xsdDiagnostic);
                    IMarker marker = null;
                    int i = 0;
                    while (i < markers.length) {
                        if (markers[i].getAttribute("diagnostic", XsdUiPlugin.Util.getString("XsdEditor._29", new Object[0])).equals(uriReferencePath)) {
                            marker = markers[i];
                            deletableMarkers.remove(marker);
                            break;
                        }
                        ++i;
                    }
                    if (marker == null) {
                        marker = file.createMarker("org.eclipse.xsd.diagnostic");
                        marker.setAttribute("diagnostic", (Object)uriReferencePath);
                    }
                    this.initializeMarkerPosition(marker, xsdDiagnostic);
                    marker.setAttribute("message", (Object)xsdDiagnostic.getMessage());
                    switch (xsdDiagnostic.getSeverity().getValue()) {
                        case 0: 
                        case 1: {
                            if (newSelection == null) {
                                newSelection = xsdDiagnostic.getPrimaryComponent();
                            }
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 2: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 3: {
                            marker.setAttribute("severity", 0);
                        }
                    }
                }
                for (IMarker marker : deletableMarkers) {
                    marker.delete();
                }
            }
            catch (Exception exception) {
                XsdUiPlugin.Util.log((Throwable)exception);
            }
            if (this.editorSelection != null) {
                this.setSelection(this.editorSelection);
            } else if (newSelection != null) {
                StructuredSelection errorSelection = new StructuredSelection(newSelection);
                this.getSite().getShell().getDisplay().asyncExec(new Runnable((IStructuredSelection)errorSelection){
                    private final /* synthetic */ IStructuredSelection val$errorSelection;
                    {
                        this.val$errorSelection = iStructuredSelection;
                    }

                    @Override
                    public void run() {
                        if (XsdEditor.this.contentOutlineViewer != null) {
                            XsdEditor.this.contentOutlineViewer.setSelection((ISelection)this.val$errorSelection, true);
                        }
                        if (XsdEditor.this.sourceViewer != null) {
                            XsdEditor.this.handleContentOutlineSelectionForTextEditor((ISelection)this.val$errorSelection, true);
                        }
                        XsdEditor.this.setSelection((ISelection)this.val$errorSelection);
                        XsdEditor.this.handleSourceCaretPosition();
                    }
                });
            }
        }
    }

    protected void pageChange(int pageIndex) {
        Control control;
        super.pageChange(pageIndex);
        if (pageIndex == 0) {
            this.setCurrentViewerPane(null);
            this.setCurrentViewer((Viewer)this.sourceViewer);
        }
        if ((control = this.getControl(pageIndex)) != null) {
            control.setVisible(true);
            control.setFocus();
        }
        this.handleContentOutlineSelection(this.getContentOutlinePage().getSelection());
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return this.textEditor.getAdapter(key);
    }

    public static XSDConcreteComponent getResolvedObject(XSDConcreteComponent xsdConcreteComponent) {
        XSDConcreteComponent result = (XSDConcreteComponent)new XSDSwitch(){

            public Object caseXSDAttributeUse(XSDAttributeUse xsdAttributeUse) {
                return xsdAttributeUse.getAttributeDeclaration().getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                return xsdAttributeDeclaration.getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                return xsdAttributeGroupDefinition.getResolvedAttributeGroupDefinition();
            }

            public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                return xsdElementDeclaration.getResolvedElementDeclaration();
            }

            public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                return xsdModelGroupDefinition.getResolvedModelGroupDefinition();
            }

            public Object caseXSDParticle(XSDParticle xsdParticle) {
                XSDConcreteComponent resolvedObject = XsdEditor.getResolvedObject((XSDConcreteComponent)xsdParticle.getContent());
                if (resolvedObject instanceof XSDModelGroup) {
                    return xsdParticle;
                }
                return resolvedObject;
            }
        }.doSwitch((EObject)xsdConcreteComponent);
        return result == null ? xsdConcreteComponent : result;
    }

    public static void setResourceSet(ResourceSet rs) {
        resourceSet = rs;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    XsdEditor.this.contentOutlineViewer = this.getTreeViewer();
                    XsdEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    XsdEditor.this.contentOutlineViewer.setAutoExpandLevel(2);
                    XsdEditor.this.selectNextDiagnosticsAction = new SelectDiagnosticAction(true, (StructuredViewer)XsdEditor.this.contentOutlineViewer);
                    XsdEditor.this.selectPreviousDiagnosticsAction = new SelectDiagnosticAction(false, (StructuredViewer)XsdEditor.this.contentOutlineViewer);
                    XsdEditor.this.selectNextUseAction = new SelectUseAction(true, (StructuredViewer)XsdEditor.this.contentOutlineViewer);
                    XsdEditor.this.selectPreviousUseAction = new SelectUseAction(false, (StructuredViewer)XsdEditor.this.contentOutlineViewer);
                    XsdEditor.this.contentOutlineViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent event) {
                            IStructuredSelection selection = (IStructuredSelection)((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.getSelection();
                            for (XSDConcreteComponent object : selection.toList()) {
                                XSDComplexTypeDefinition xsdComplexTypeDefinition;
                                XSDSimpleTypeDefinition baseTypeDefinition;
                                XSDSimpleTypeDefinition typeDefinition;
                                XSDConcreteComponent resolvedObject;
                                if (object != (resolvedObject = XsdEditor.getResolvedObject(object))) {
                                    ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{resolvedObject}), true);
                                    break;
                                }
                                if (object instanceof XSDAttributeDeclaration) {
                                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)object;
                                    typeDefinition = xsdAttributeDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdAttributeDeclaration.getSchema()) continue;
                                    ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (object instanceof XSDElementDeclaration) {
                                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)object;
                                    typeDefinition = xsdElementDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdElementDeclaration.getSchema()) continue;
                                    ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (object instanceof XSDSimpleTypeDefinition) {
                                    XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)object;
                                    baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                                    if (baseTypeDefinition != null && baseTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                        break;
                                    }
                                    XSDSimpleTypeDefinition itemTypeDefinition = xsdSimpleTypeDefinition.getItemTypeDefinition();
                                    if (itemTypeDefinition != null && itemTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{itemTypeDefinition}), true);
                                        break;
                                    }
                                    EList memberTypeDefinitions = xsdSimpleTypeDefinition.getMemberTypeDefinitions();
                                    if (memberTypeDefinitions.isEmpty()) continue;
                                    ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(memberTypeDefinitions.toArray()), true);
                                    break;
                                }
                                if (!(object instanceof XSDComplexTypeDefinition) || (baseTypeDefinition = (xsdComplexTypeDefinition = (XSDComplexTypeDefinition)object).getBaseTypeDefinition()) == null || baseTypeDefinition.getSchema() != xsdComplexTypeDefinition.getSchema()) continue;
                                ((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                break;
                            }
                        }
                    });
                    XsdEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)XsdEditor.this.syntacticAdapterFactory));
                    XsdEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)XsdEditor.this.syntacticAdapterFactory));
                    XsdEditor.this.contentOutlineViewer.setInput((Object)new ItemProvider(Collections.singleton(XsdEditor.this.getXsdSchema())));
                    XsdEditor.this.createContextMenuFor((StructuredViewer)XsdEditor.this.contentOutlineViewer);
                    ArrayList<XSDSchema> selection = new ArrayList<XSDSchema>();
                    selection.add(XsdEditor.this.getXsdSchema());
                    XsdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    this.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            ISelection s = event.getSelection();
                            if (((MyContentOutlinePage)this).XsdEditor.this.contentOutlineViewer == ((MyContentOutlinePage)this).XsdEditor.this.currentViewer) {
                                XsdEditor.this.handleContentOutlineSelection(s);
                            }
                            ((MyContentOutlinePage)this).XsdEditor.this.selectNextDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XsdEditor.this.selectPreviousDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XsdEditor.this.selectNextUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XsdEditor.this.selectPreviousUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                        }
                    });
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    XsdEditor.this.contentOutlineStatusLineManager = actionBars.getStatusLineManager();
                    actionBars.getToolBarManager().add((IAction)XsdEditor.this.selectNextUseAction);
                    actionBars.getToolBarManager().add((IAction)XsdEditor.this.selectPreviousUseAction);
                    actionBars.getToolBarManager().add((IAction)XsdEditor.this.selectNextDiagnosticsAction);
                    actionBars.getToolBarManager().add((IAction)XsdEditor.this.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XsdEditor.this.selectNextDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XsdEditor.this.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XsdEditor.this.selectNextUseAction);
                    actionBars.getMenuManager().add((IAction)XsdEditor.this.selectPreviousUseAction);
                    XsdEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (XsdEditor.this.contentOutlineViewer == XsdEditor.this.currentViewer) {
                        XsdEditor.this.handleContentOutlineSelection(event.getSelection());
                    }
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory){

                public void notifyChanged(Notification notification) {
                    XsdEditor.this.getParentComposite().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).XsdEditor.this.propertySheetPage.refresh();
                        }
                    });
                }

                protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                    return new PropertySource(object, itemPropertySource){

                        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                            return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                                public CellEditor createPropertyEditor(Composite composite) {
                                    Collection choiceOfValues;
                                    EStructuralFeature feature;
                                    EClassifier getEType;
                                    if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                                        return null;
                                    }
                                    CellEditor result = null;
                                    Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
                                    if (genericFeature instanceof EStructuralFeature && (getEType = (feature = (EStructuralFeature)genericFeature).getEType()) == ecorePackage.getEBoolean() && (choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object)) != null) {
                                        result = new ExtendedComboBoxCellEditor(composite, new ArrayList(choiceOfValues), this.getLabelProvider(), true);
                                    }
                                    if (result == null) {
                                        result = super.createPropertyEditor(composite);
                                    }
                                    return result;
                                }
                            };
                        }
                    };
                }
            });
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if ((this.currentViewerPane != null || this.getActivePage() == 0) && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            if (this.getActivePage() == 0) {
                this.handleContentOutlineSelectionForTextEditor(selection, true);
            } else if (this.currentViewerPane.getViewer() == this.syntacticSelectionViewer) {
                this.syntacticSelectionViewer.setSelection(selection);
            } else if (this.currentViewerPane.getViewer() == this.semanticSelectionViewer) {
                ArrayList<XSDConcreteComponent> selectionList = new ArrayList<XSDConcreteComponent>();
                Iterator elements = ((IStructuredSelection)selection).iterator();
                while (elements.hasNext()) {
                    selectionList.add(XsdEditor.getResolvedObject((XSDConcreteComponent)elements.next()));
                }
                this.semanticSelectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            }
        }
    }

    public void handleContentOutlineSelectionForTextEditor(ISelection selection, boolean reveal) {
        Element element;
        XSDParticle xsdParticle;
        XSDParticleContent content;
        XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)((IStructuredSelection)selection).iterator().next();
        if (xsdConcreteComponent instanceof XSDParticle && (content = (xsdParticle = (XSDParticle)xsdConcreteComponent).getContent()) != null) {
            xsdConcreteComponent = content;
        }
        if ((element = xsdConcreteComponent.getElement()) != null) {
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                int startLine = XSDParser.getStartLine((Node)element);
                int startColumn = XSDParser.getStartColumn((Node)element);
                int endLine = XSDParser.getEndLine((Node)element);
                int endColumn = XSDParser.getEndColumn((Node)element);
                int startOffset = document.getLineOffset(startLine - 1);
                startOffset += startColumn - 1;
                int endOffset = document.getLineOffset(endLine - 1);
                endOffset += endColumn - 1;
                if (startLine == endLine) {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, false);
                    if (reveal) {
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                } else {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, reveal);
                }
            }
            catch (Exception exception) {
                XsdUiPlugin.Util.log((Throwable)exception);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || this.textEditor != null && this.textEditor.isDirty();
    }

    public XSDSchema getXsdSchema() {
        XSDResourceImpl rsrc;
        if (this.xsdSchema != null && this.xsdSchema.eResource() != null) {
            return this.xsdSchema;
        }
        if (this.xsdResource != null && this.xsdResource instanceof XSDResourceImpl && (rsrc = (XSDResourceImpl)this.xsdResource) != null) {
            this.xsdSchema = rsrc.getSchema();
        }
        return this.xsdSchema;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final IEditorInput input = this.getEditorInput();
        final IDocumentProvider documentProvider = this.textEditor.getDocumentProvider();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                try {
                    documentProvider.saveDocument(monitor, (Object)input, documentProvider.getDocument((Object)input), true);
                }
                catch (Exception exception) {
                    XsdUiPlugin.Util.log((Throwable)exception);
                }
            }
        };
        try {
            documentProvider.aboutToChange((Object)input);
            operation.run(progressMonitor);
            documentProvider.changed((Object)input);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ModelerCore.getWorkspace().getRoot().getFile(path)) != null && (!file.exists() || MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)XsdUiPlugin.Util.getString("_UI_FileExists_title", new Object[0]), (String)XsdUiPlugin.Util.getString("_UI_FileExists_description", new Object[]{file.getFullPath()})))) {
            this.getXsdSchema().eResource().setURI(URI.createURI((String)(String.valueOf(XsdUiPlugin.Util.getString("XsdEditor.platform_/resource_32", new Object[0])) + file.getFullPath())));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setPartName(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            this.setActivePage(0);
            ((IGotoMarker)this.textEditor.getAdapter(IGotoMarker.class)).gotoMarker(marker);
        }
        catch (Exception exception) {
            XsdUiPlugin.Util.log((Throwable)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof IFileEditorInput) {
            try {
                IFile xsdFile = ((IFileEditorInput)editorInput).getFile();
                if (xsdFile == null) {
                    String msg = XsdUiPlugin.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)editorInput.getName());
                    throw new PartInitException(msg);
                }
                String xsdLocation = xsdFile.getLocation().toString();
                URI xsdUri = URI.createFileURI((String)xsdLocation);
                this.xsdResource = ModelerCore.getModelContainer().getResource(xsdUri, true);
                if (this.xsdResource == null) {
                    String msg = XsdUiPlugin.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_1", (Object)editorInput.getName());
                    throw new PartInitException(msg);
                }
                xsdFile.getProject();
            }
            catch (ModelWorkspaceException e) {
                String msg = XsdUiPlugin.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)editorInput.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
            catch (CoreException e) {
                String msg = XsdUiPlugin.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)editorInput.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
        } else {
            throw new PartInitException(XsdUiPlugin.Util.getString("XsdEditor.Invalid_Input__Must_be_IFileEditorInput._33", new Object[0]));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setPartName(((IFileEditorInput)editorInput).getFile().getName());
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        site.getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(selectionChangedEvent);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(selectionChangedEvent);
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            statusLineManager = this.contentOutlineStatusLineManager;
        }
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(XsdUiPlugin.Util.getString("_UI_NoObjectSelected", new Object[0]));
                        break;
                    }
                    case 1: {
                        XSDConcreteComponent xsdConcreteComponent;
                        Object object = collection.iterator().next();
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.syntacticAdapterFactory).getText(object);
                        text = XsdUiPlugin.Util.getString("_UI_SingleObjectSelected", new Object[]{text});
                        if (object instanceof XSDConcreteComponent && !(xsdConcreteComponent = (XSDConcreteComponent)object).getDiagnostics().isEmpty()) {
                            text = ((XSDDiagnostic)xsdConcreteComponent.getDiagnostics().get(0)).getMessage();
                        }
                        statusLineManager.setMessage(text);
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(XsdUiPlugin.Util.getString("_UI_MultiObjectSelected", new Object[]{Integer.toString(collection.size())}));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.semanticAdapterFactory.dispose();
        this.syntacticAdapterFactory.dispose();
    }

    public static class ActionBarContributor
    extends EditingDomainActionBarContributor
    implements ISelectionChangedListener {
        protected IEditorPart activeEditorPart;
        protected ISelectionProvider selectionProvider;
        protected Collection createChildActions = Collections.EMPTY_LIST;
        protected IMenuManager createChildMenuManager;
        protected Collection createSiblingActions = Collections.EMPTY_LIST;
        protected IMenuManager createSiblingMenuManager;

        public void contributeToMenu(IMenuManager menuManager) {
            super.contributeToMenu(menuManager);
            MenuManager submenuManager = new MenuManager(XsdUiPlugin.Util.getString("_UI_XSDEditor_menu", new Object[0]), "org.eclipse.xsdMenuID");
            menuManager.insertAfter(XsdUiPlugin.Util.getString("XsdEditor.additions_4", new Object[0]), (IContributionItem)submenuManager);
            submenuManager.add((IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.settings_5", new Object[0])));
            submenuManager.add((IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.additions_6", new Object[0])));
            this.createChildMenuManager = new MenuManager(XsdUiPlugin.Util.getString("_UI_CreateChild_menu_item", new Object[0]));
            this.createSiblingMenuManager = new MenuManager(XsdUiPlugin.Util.getString("_UI_CreateSibling_menu_item", new Object[0]));
            submenuManager.insertBefore(XsdUiPlugin.Util.getString("XsdEditor.additions_9", new Object[0]), (IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.actions_10", new Object[0])));
            submenuManager.insertBefore(XsdUiPlugin.Util.getString("XsdEditor.additions_11", new Object[0]), (IContributionItem)this.createChildMenuManager);
            submenuManager.insertBefore(XsdUiPlugin.Util.getString("XsdEditor.additions_12", new Object[0]), (IContributionItem)this.createSiblingMenuManager);
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            toolBarManager.add((IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.xsd-settings_13", new Object[0])));
            toolBarManager.add((IContributionItem)new Separator(XsdUiPlugin.Util.getString("XsdEditor.xsd-additions_14", new Object[0])));
        }

        public void setActiveEditor(IEditorPart part) {
            super.setActiveEditor(part);
            this.activeEditorPart = part;
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.createChildMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
            }
            if (this.createSiblingMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
            }
            Collection newChildDescriptors = Collections.EMPTY_LIST;
            Collection newSiblingDescriptors = Collections.EMPTY_LIST;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
                Object object = ((IStructuredSelection)sel).getFirstElement();
                EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                newChildDescriptors = domain.getNewChildDescriptors(object, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(domain.getParent(object), object);
            }
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, sel);
            this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, sel);
            if (this.createChildMenuManager != null) {
                this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
                this.createChildMenuManager.update(true);
            }
            if (this.createSiblingMenuManager != null) {
                this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
                this.createSiblingMenuManager.update(true);
            }
        }

        protected Collection generateCreateChildActions(Collection descriptors, ISelection sel) {
            LinkedList<CreateChildAction> actions = new LinkedList<CreateChildAction>();
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.activeEditorPart, sel, i.next()));
            }
            return actions;
        }

        protected Collection generateCreateSiblingActions(Collection descriptors, ISelection sel) {
            LinkedList<CreateSiblingAction> actions = new LinkedList<CreateSiblingAction>();
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateSiblingAction(this.activeEditorPart, sel, i.next()));
            }
            return actions;
        }

        protected void populateManager(IContributionManager manager, Collection actions, String ID) {
            for (IAction action : actions) {
                if (ID != null) {
                    manager.insertBefore(ID, action);
                    continue;
                }
                manager.add(action);
            }
        }

        protected void depopulateManager(IContributionManager manager, Collection actions) {
            IContributionItem[] item = manager.getItems();
            int i = 0;
            while (i < item.length) {
                IAction action;
                IContributionItem curItem = item[i];
                while (curItem instanceof SubContributionItem) {
                    curItem = ((SubContributionItem)curItem).getInnerItem();
                }
                if (curItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)curItem).getAction())) {
                    manager.remove(curItem);
                }
                ++i;
            }
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            super.menuAboutToShow(menuManager);
            menuManager.insertAfter(XsdUiPlugin.Util.getString("XsdEditor.additions_15", new Object[0]), (IContributionItem)new Separator());
            MenuManager submenuManager = new MenuManager(XsdUiPlugin.Util.getString("_UI_CreateSibling_menu_item", new Object[0]));
            this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
            menuManager.insertAfter(XsdUiPlugin.Util.getString("XsdEditor.additions_17", new Object[0]), (IContributionItem)submenuManager);
            submenuManager = new MenuManager(XsdUiPlugin.Util.getString("_UI_CreateChild_menu_item", new Object[0]));
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.insertAfter(XsdUiPlugin.Util.getString("XsdEditor.additions_19", new Object[0]), (IContributionItem)submenuManager);
        }
    }

    public static class GenericXMLLoadAction
    extends ActionDelegate {
        protected IFile file;

        public void run(IAction action) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new GenericXMLResourceFactoryImpl());
            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true), true);
            resource.setURI(URI.createPlatformResourceURI((String)(String.valueOf(this.file.getFullPath().toString()) + ".save.xml"), (boolean)true));
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                XsdUiPlugin.Util.log((Throwable)exception);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
            Object object;
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
                this.file = (IFile)object;
                action.setEnabled(true);
                return;
            }
            this.file = null;
            action.setEnabled(false);
        }
    }

    public static class GenericXMLResourceFactoryImpl
    extends XMLResourceFactoryImpl {
        protected XMLResource.XMLMap xmlMap = new XMLMapImpl();

        public Resource createResource(URI uri) {
            GenericXMLResourceImpl result = new GenericXMLResourceImpl(uri);
            result.getDefaultSaveOptions().put("XML_MAP", this.xmlMap);
            result.getDefaultLoadOptions().put("XML_MAP", this.xmlMap);
            return result;
        }
    }

    public static class GenericXMLResourceImpl
    extends XMLResourceImpl {
        protected XSDEcoreBuilder xsdEcoreBuilder;
        protected XMLHelper xmlHelper;

        public GenericXMLResourceImpl(URI uri) {
            super(uri);
        }

        protected XMLHelper createXMLHelper() {
            if (this.xmlHelper == null) {
                this.xmlHelper = new XMLHelperImpl((XMLResource)this){

                    protected String getQName(String uri, String name) {
                        if (uri == null) {
                            return name;
                        }
                        EPackage pkg = (EPackage)GenericXMLResourceImpl.this.xsdEcoreBuilder.getTargetNamespaceToEPackageMap().get(uri);
                        if (pkg == null || pkg.getNsPrefix().equals("")) {
                            return name;
                        }
                        this.packages.put(pkg, null);
                        return String.valueOf(pkg.getNsPrefix()) + ":" + name;
                    }
                };
            }
            return this.xmlHelper;
        }

        public void doLoad(InputStream inputStream, final Map op) throws IOException {
            XMLLoadImpl xmlStart = new XMLLoadImpl(this.createXMLHelper()){

                protected DefaultHandler makeDefaultHandler() {
                    final XMLResource resrc = this.resource;
                    SAXXMLHandler saxXMLHandler = new SAXXMLHandler(resrc, this.helper, op){
                        protected XMLHandler.MyStack elementDeclarations;
                        protected XMLHandler.MyStack dfaStates;
                        {
                            super($anonymous0, $anonymous1, $anonymous2);
                            this.elementDeclarations = new XMLHandler.MyStack();
                            this.dfaStates = new XMLHandler.MyStack();
                        }

                        protected void createTopObject(String prefix, String name) {
                            String namespaceURI = this.helper.getURI(prefix);
                            int i = 0;
                            int size = this.attribs.getLength();
                            while (i < size) {
                                String attributeName = this.attribs.getQName(i);
                                int index = attributeName.indexOf(":");
                                String attributeNamespaceURI = null;
                                String attributeLocalName = attributeName;
                                if (index != -1) {
                                    attributeNamespaceURI = this.helper.getURI(attributeName.substring(0, index));
                                    attributeLocalName = attributeName.substring(index + 1);
                                }
                                if ("http://www.w3.org/2001/XMLSchema-instance".equals(attributeNamespaceURI) && (namespaceURI == null ? XsdUiPlugin.Util.getString("XsdEditor.noSchemaLocation_57", new Object[0]) : XsdUiPlugin.Util.getString("XsdEditor.schemaLocation_58", new Object[0])).equals(attributeLocalName)) {
                                    String schemaLocationHint = null;
                                    if (namespaceURI == null) {
                                        schemaLocationHint = this.attribs.getValue(i);
                                    } else {
                                        StringTokenizer stringTokenizer = new StringTokenizer(this.attribs.getValue(i));
                                        while (stringTokenizer.hasMoreTokens()) {
                                            String namespaceURIHint = stringTokenizer.nextToken();
                                            if (!stringTokenizer.hasMoreTokens()) break;
                                            if (namespaceURIHint.equals(namespaceURI)) {
                                                schemaLocationHint = stringTokenizer.nextToken();
                                                break;
                                            }
                                            stringTokenizer.nextToken();
                                        }
                                    }
                                    if (schemaLocationHint != null) {
                                        URI uri = URI.createURI((String)schemaLocationHint);
                                        if (this.resolve && uri.isRelative() && uri.hasRelativePath()) {
                                            uri = uri.resolve(this.resourceURI);
                                        }
                                        (this).GenericXMLResourceImpl.this.xsdEcoreBuilder = new XSDEcoreBuilder();
                                        Collection resources = (this).GenericXMLResourceImpl.this.xsdEcoreBuilder.generateResources(uri);
                                        resrc.getResourceSet().getResources().addAll(resources);
                                    }
                                }
                                ++i;
                            }
                            if ((this).GenericXMLResourceImpl.this.xsdEcoreBuilder == null) {
                                this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Cannot_resolve_schema_location_59", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                            } else {
                                XSDElementDeclaration xsdElementDeclaration = (this).GenericXMLResourceImpl.this.xsdEcoreBuilder.getSchema().resolveElementDeclaration(namespaceURI, name);
                                EClass eClass = (EClass)(this).GenericXMLResourceImpl.this.xsdEcoreBuilder.getXSDComponentToEModelElementMap().get(xsdElementDeclaration);
                                if (eClass != null) {
                                    this.processTopObject(eClass.getEPackage().getEFactoryInstance().create(eClass));
                                    this.elementDeclarations.push((Object)xsdElementDeclaration);
                                    XSDParticle xsdParticle = xsdElementDeclaration.getTypeDefinition().getComplexType();
                                    if (xsdParticle != null) {
                                        this.dfaStates.push((Object)xsdParticle.getDFA().getInitialState());
                                    } else {
                                        this.dfaStates.push(null);
                                    }
                                } else {
                                    this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Cannot_resolve_EClass__60", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                }
                            }
                        }

                        protected void processElement(String name, String prefix, String localName) {
                            if (this.isError()) {
                                this.types.push((Object)"error");
                            } else if (this.objects.isEmpty()) {
                                this.createTopObject(prefix, localName);
                            } else {
                                EObject peekObject = (EObject)this.objects.peek();
                                XSDParticle.DFA.State state = (XSDParticle.DFA.State)this.dfaStates.peek();
                                if (state == null) {
                                    this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Cannot_contain_content__61", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                } else {
                                    XSDParticle.DFA.Transition transition = state.accept(this.helper.getURI(prefix), localName);
                                    if (transition == null) {
                                        this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Not_expecting_this_element__62", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                    } else {
                                        this.dfaStates.set(this.dfaStates.size() - 1, (Object)transition.getState());
                                        XSDParticle transitionXSDParticle = transition.getParticle();
                                        XSDTerm xsdTerm = transitionXSDParticle.getTerm();
                                        XSDElementDeclaration xsdElementDeclaration = null;
                                        xsdElementDeclaration = xsdTerm instanceof XSDElementDeclaration ? (XSDElementDeclaration)xsdTerm : (this).GenericXMLResourceImpl.this.xsdEcoreBuilder.getSchema().resolveElementDeclaration(this.helper.getURI(prefix), name);
                                        EClass eClass = (EClass)(this).GenericXMLResourceImpl.this.xsdEcoreBuilder.getXSDComponentToEModelElementMap().get(xsdElementDeclaration);
                                        if (eClass != null) {
                                            EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
                                            ((EList)peekObject.eGet(peekObject.eClass().getEStructuralFeature(XsdUiPlugin.Util.getString("XsdEditor.contents_63", new Object[0])))).add((Object)eObject);
                                            this.processObject(eObject);
                                            this.elementDeclarations.push((Object)xsdElementDeclaration);
                                            XSDParticle xsdParticle = xsdElementDeclaration.getTypeDefinition().getComplexType();
                                            if (xsdParticle != null) {
                                                this.dfaStates.push((Object)xsdParticle.getDFA().getInitialState());
                                            } else {
                                                EStructuralFeature valueFeature;
                                                this.dfaStates.push(null);
                                                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdElementDeclaration.getTypeDefinition().getSimpleType();
                                                if (xsdSimpleTypeDefinition != null && (valueFeature = eClass.getEStructuralFeature(XsdUiPlugin.Util.getString("XsdEditor.value_64", new Object[0]))) != null) {
                                                    this.text = new StringBuffer();
                                                    this.types.set(this.types.size() - 1, (Object)valueFeature);
                                                }
                                            }
                                        } else {
                                            this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Cannot_resolve_EClass__65", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                        }
                                    }
                                }
                            }
                        }

                        public void endElement(String uri, String localName, String name) {
                            XSDParticle.DFA.State state;
                            EObject topObject = (EObject)this.objects.pop();
                            this.elements.pop();
                            Object type = this.types.pop();
                            if (this.text != null) {
                                EAttribute eAttribute = (EAttribute)type;
                                EDataType eDataType = eAttribute.getEAttributeType();
                                Object value = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, this.text.toString());
                                topObject.eSet((EStructuralFeature)eAttribute, value);
                                this.text = null;
                            }
                            if ((state = (XSDParticle.DFA.State)this.dfaStates.pop()) != null && !state.isAccepting()) {
                                this.error(new XMIException(XsdUiPlugin.Util.getString("XsdEditor.Need_more_content__66", new Object[0]), this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                            }
                            this.elementDeclarations.pop();
                        }
                    };
                    return saxXMLHandler;
                }
            };
            xmlStart.load((XMLResource)this, inputStream, op);
        }
    }

    class SelectDiagnosticAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectDiagnosticAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? XsdUiPlugin.Util.getString("XsdEditor.Select_&Next_Diagnosed_Object_38", new Object[0]) : XsdUiPlugin.Util.getString("XsdEditor.Select_&Previous_Diagnosed_Object_39", new Object[0]), ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/elcl16/SelectNextDiagnosticObject.gif" : "icons/full/elcl16/SelectPreviousDiagnosticObject.gif")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/clcl16/SelectNextDiagnosticObject.gif" : "icons/full/clcl16/SelectPreviousDiagnosticObject.gif")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/dlcl16/SelectNextDiagnosticObject.gif" : "icons/full/dlcl16/SelectPreviousDiagnosticObject.gif")));
            this.setToolTipText(isForward ? XsdUiPlugin.Util.getString("XsdEditor.Select_&Next_Diagnosed_Object_38", new Object[0]) : XsdUiPlugin.Util.getString("XsdEditor.Select_&Previous_Diagnosed_Object_39", new Object[0]));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List objects) {
            XSDConcreteComponent result = null;
            boolean isStarted = false;
            TreeIterator tree = XsdEditor.this.editingDomain.treeIterator((Object)XsdEditor.this.getXsdSchema());
            while (tree.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    if (xsdConcreteComponent.getDiagnostics().isEmpty() && (!(xsdConcreteComponent instanceof XSDParticle) || ((XSDParticle)xsdConcreteComponent).getContent().getDiagnostics().isEmpty()) && (!(xsdConcreteComponent instanceof XSDAttributeUse) || ((XSDAttributeUse)xsdConcreteComponent).getContent().getDiagnostics().isEmpty())) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }

    class SelectObjectAction
    extends Action {
        protected Collection objectsToSelect;
        protected StructuredViewer structuredViewer;

        public SelectObjectAction(StructuredViewer structuredViewer, String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this.structuredViewer = structuredViewer;
            this.setEnabled(false);
        }

        public void setObjectToSelect(Object objectToSelect) {
            this.setObjectsToSelect(objectToSelect != null ? Collections.singleton(objectToSelect) : Collections.EMPTY_LIST);
        }

        public void setObjectsToSelect(Collection objectsToSelect) {
            this.objectsToSelect = new ArrayList(objectsToSelect);
            this.setEnabled(!objectsToSelect.isEmpty());
        }

        public void run() {
            StructuredSelection selection = null;
            selection = this.objectsToSelect == null || this.objectsToSelect.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(this.objectsToSelect.toArray());
            this.structuredViewer.setSelection((ISelection)selection, true);
        }
    }

    class SelectUseAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectUseAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? XsdUiPlugin.Util.getString("XsdEditor.Select_&Next_Use_46", new Object[0]) : XsdUiPlugin.Util.getString("XsdEditor.Select_&Previous_Use_47", new Object[0]), ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/elcl16/SelectNextUseObject.gif" : "icons/full/elcl16/SelectPreviousUseObject.gif")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/clcl16/SelectNextUseObject.gif" : "icons/full/clcl16/SelectPreviousUseObject.gif")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor((Object)XsdUiPlugin.INSTANCE.getImage(isForward ? "icons/full/dlcl16/SelectNextUseObject.gif" : "icons/full/dlcl16/SelectPreviousUseObject.gif")));
            this.setToolTipText(isForward ? XsdUiPlugin.Util.getString("XsdEditor.Select_&Next_Use_46", new Object[0]) : XsdUiPlugin.Util.getString("XsdEditor.Select_&Previous_Use_47", new Object[0]));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List objects) {
            XSDConcreteComponent result = null;
            ArrayList<XSDConcreteComponent> resolvedObjects = new ArrayList<XSDConcreteComponent>();
            for (XSDConcreteComponent xsdConcreteComponent : objects) {
                XSDConcreteComponent resolvedObject = XsdEditor.getResolvedObject(xsdConcreteComponent);
                if (((Object)((Object)this)).equals(resolvedObject)) continue;
                resolvedObjects.add(resolvedObject);
            }
            boolean isStarted = false;
            TreeIterator tree = XsdEditor.this.editingDomain.treeIterator((Object)XsdEditor.this.getXsdSchema());
            while (tree.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    XSDConcreteComponent resolvedObject = XsdEditor.getResolvedObject(xsdConcreteComponent);
                    if (!resolvedObjects.contains(resolvedObject)) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }
}

