/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.core.designer.I18n;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.ddl.DdlImporterManager;
import org.teiid.designer.ddl.importer.DdlImporterI18n;
import org.teiid.designer.ddl.importer.node.AbstractImporter;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMappingImpl;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.type.IDataTypeManagerService;

public class StandardImporter
extends AbstractImporter {
    protected static final String STRING_TYPENAME = "string";
    protected static final String CHAR_TYPENAME = "char";
    protected static final int DEFAULT_PRECISION = 20;

    protected Info createInfo(AstNode node, RelationalModel model) throws Exception {
        return new Info(node, model);
    }

    protected <T extends RelationalReference> T find(Class<T> type, String name, AstNode node, RelationalReference parent, Collection<RelationalReference> allModelRefs) throws AbstractImporter.EntityNotFoundException, CoreException {
        for (RelationalReference obj : allModelRefs) {
            RelationalReference relEntity;
            if (!type.isInstance(obj) || !(relEntity = obj).getName().equalsIgnoreCase(name)) continue;
            RelationalReference relParent = relEntity.getParent();
            if (parent != null) {
                if (!relParent.getName().equalsIgnoreCase(parent.getName())) continue;
                return (T)relEntity;
            }
            return (T)relEntity;
        }
        while (node.getProperty("ddl:expression") == null) {
            node = node.getParent();
        }
        throw new AbstractImporter.EntityNotFoundException(this, I18n.format((String)DdlImporterI18n.ENTITY_NOT_FOUND_MSG, (Object[])new Object[]{type.getSimpleName(), name, DdlImporterI18n.MODEL, parent == null ? this.getImporterManager().getModelName() : parent.getName(), node.getProperty("ddl:startLineNumber").toString(), node.getProperty("ddl:startColumnNumber").toString()}));
    }

    protected <T extends RelationalReference> T find(Class<T> type, AstNode node, RelationalReference parent, Collection<RelationalReference> allModelRefs) throws AbstractImporter.EntityNotFoundException, CoreException {
        String nodeName = node.getName();
        int indx = nodeName.lastIndexOf(46);
        if (indx >= 0) {
            nodeName = nodeName.substring(indx + 1);
        }
        return this.find(type, nodeName, node, parent, allModelRefs);
    }

    protected void initialize(RelationalReference entity, AstNode node, String name) {
        entity.setName(name);
        if (this.getImporterManager().optToSetModelEntityDescription()) {
            Object prop = node.getProperty("ddl:expression");
            if (prop != null) {
                entity.setDescription(prop.toString());
            } else {
                entity.setDescription("");
            }
        }
    }

    protected void initialize(RelationalReference entity, AstNode node) {
        this.initialize(entity, node, node.getName());
    }

    protected String getUniqueFKName(Collection<RelationalForeignKey> currentFKs, String newFKName) {
        if (currentFKs == null || currentFKs.isEmpty()) {
            return newFKName;
        }
        StringNameValidator nameValidator = new StringNameValidator();
        for (RelationalForeignKey fk : currentFKs) {
            nameValidator.addExistingName(fk.getName());
        }
        return nameValidator.createValidUniqueName(newFKName);
    }

    protected void initializeFK(Collection<RelationalForeignKey> currentFKs, RelationalForeignKey key, AstNode node) {
        String fkName = node.getName();
        String uniqueName = this.getUniqueFKName(currentFKs, fkName);
        this.initialize((RelationalReference)key, node, uniqueName);
    }

    protected <T extends RelationalTable> T initializeTable(T table, AstNode node, RelationalModel model) throws Exception {
        Info info = this.createInfo(node, model);
        if (info.getSchema() == null) {
            model.addChild(table);
        } else {
            info.getSchema().getTables().add(table);
        }
        this.initialize((RelationalReference)table, node, info.getName());
        return table;
    }

    protected void handleColumnOption(RelationalColumn column, AstNode columnOptionNode) {
    }

    protected void handleColumnOptions(RelationalColumn column, AstNode columnNode) {
        List children = columnNode.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            this.handleColumnOption(column, child);
        }
    }

    protected String getTeiidDataTypeName(String datatype) throws Exception {
        String typeName = "";
        EObject dataType = RelationalTypeMappingImpl.getInstance().getDatatype(datatype);
        if (dataType != null) {
            typeName = ModelerCore.getWorkspaceDatatypeManager().getName(dataType);
        }
        return typeName;
    }

    protected RelationalColumn createColumn(AstNode node, RelationalTable table) throws Exception {
        RelationalColumn col = this.getFactory().createColumn();
        col.setParent((RelationalReference)table);
        table.getColumns().add(col);
        this.initialize((RelationalReference)col, node);
        this.setDataType(node, col);
        return col;
    }

    protected void setDataType(AstNode node, RelationalColumn column) throws Exception {
        String datatype = node.getProperty("ddl:datatypeName").toString();
        column.setNativeType(datatype);
        String teiidType = this.getTeiidDataTypeName(datatype);
        column.setDatatype(teiidType);
        Object prop = node.getProperty("ddl:datatypeLength");
        if (prop != null) {
            column.setLength(Integer.parseInt(prop.toString()));
        } else if (teiidType != null) {
            if (teiidType.equalsIgnoreCase(STRING_TYPENAME)) {
                column.setLength(ModelerCore.getTransformationPreferences().getDefaultStringLength());
            } else if (teiidType.equalsIgnoreCase(CHAR_TYPENAME)) {
                column.setLength(1);
            }
        }
        prop = node.getProperty("ddl:datatypePrecision");
        if (prop != null) {
            column.setPrecision(Integer.parseInt(prop.toString()));
        } else if (teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BIGDECIMAL.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DECIMAL.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.FLOAT.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DOUBLE.name())) {
            column.setPrecision(20);
        }
        prop = node.getProperty("ddl:datatypeScale");
        if (prop != null) {
            column.setScale(Integer.parseInt(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:nullable")) != null) {
            column.setNullable(this.getRelRefNullable(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:defaultValue")) != null) {
            column.setDefaultValue(prop.toString());
        }
    }

    protected RelationalParameter createProcedureParameter(AstNode node, RelationalProcedure procedure) throws Exception {
        RelationalParameter prm = this.getFactory().createParameter();
        procedure.getParameters().add(prm);
        this.initialize((RelationalReference)prm, node);
        String datatype = node.getProperty("ddl:datatypeName").toString();
        prm.setNativeType(datatype);
        String teiidType = this.getTeiidDataTypeName(datatype);
        prm.setDatatype(teiidType);
        Object prop = node.getProperty("ddl:datatypeLength");
        if (prop != null) {
            prm.setLength(Integer.parseInt(prop.toString()));
        } else if (teiidType != null && teiidType.equalsIgnoreCase(STRING_TYPENAME)) {
            prm.setLength(ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        prop = node.getProperty("ddl:datatypePrecision");
        if (prop != null) {
            prm.setPrecision(Integer.parseInt(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:datatypeScale")) != null) {
            prm.setScale(Integer.parseInt(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:nullable")) != null) {
            prm.setNullable(this.getRelRefNullable(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:defaultValue")) != null) {
            prm.setDefaultValue(prop.toString());
        }
        return prm;
    }

    protected void createPrimaryKey(AstNode node, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        String type = node.getProperty("ddl:constraintType").toString();
        if ("PRIMARY KEY".equals(type)) {
            RelationalPrimaryKey key = this.getFactory().createPrimaryKey();
            table.setPrimaryKey(key);
            this.initialize((RelationalReference)key, node);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:columnReference")) continue;
                try {
                    RelationalColumn column = this.find(RelationalColumn.class, node1, (RelationalReference)table, allRefs);
                    key.getColumns().add(column);
                }
                catch (AbstractImporter.EntityNotFoundException error) {
                    this.addProgressMessage(error.getMessage());
                }
            }
        }
    }

    protected void createConstraint(AstNode node, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        block13: {
            String type;
            block14: {
                type = node.getProperty("ddl:constraintType").toString();
                if (!"FOREIGN KEY".equals(type)) break block14;
                RelationalForeignKey key = this.getFactory().createForeignKey();
                this.initializeFK(table.getForeignKeys(), key, node);
                table.getForeignKeys().add(key);
                RelationalTable foreignTable = null;
                HashSet<RelationalColumn> foreignColumns = new HashSet<RelationalColumn>();
                for (AstNode node1 : node) {
                    try {
                        if (this.is(node1, "ddl:columnReference")) {
                            key.getColumns().add(this.find(RelationalColumn.class, node1, (RelationalReference)table, allRefs));
                            continue;
                        }
                        if (this.is(node1, "ddl:tableReference")) {
                            foreignTable = this.find(RelationalTable.class, node1, null, allRefs);
                            continue;
                        }
                        if (!this.is(node1, "ddl:fkColumnReference") || foreignTable == null) continue;
                        foreignColumns.add(this.find(RelationalColumn.class, node1, (RelationalReference)foreignTable, allRefs));
                    }
                    catch (Exception error) {
                        this.addProgressMessage(error.getMessage());
                    }
                }
                if (foreignTable == null) {
                    return;
                }
                RelationalPrimaryKey primaryKey = foreignTable.getPrimaryKey();
                Collection primaryKeyColumns = primaryKey.getColumns();
                if (foreignColumns.isEmpty()) {
                    key.setUniqueKeyName(primaryKey.getName());
                    key.setUniqueKeyTableName(foreignTable.getName());
                }
                if (primaryKeyColumns.containsAll(foreignColumns) && primaryKeyColumns.size() == foreignColumns.size()) {
                    key.setUniqueKeyName(primaryKey.getName());
                    key.setUniqueKeyTableName(foreignTable.getName());
                } else {
                    for (Object obj : foreignTable.getUniqueConstraints()) {
                        RelationalUniqueConstraint uniqueKey = (RelationalUniqueConstraint)obj;
                        List uniqueKeyColumns = uniqueKey.getColumns();
                        if (!uniqueKeyColumns.containsAll(foreignColumns) || uniqueKeyColumns.size() != foreignColumns.size()) continue;
                        key.setUniqueKeyName(uniqueKey.getName());
                        key.setUniqueKeyTableName(foreignTable.getName());
                        break block13;
                    }
                }
                break block13;
            }
            if (!"UNIQUE".equals(type)) break block13;
            RelationalUniqueConstraint key = this.getFactory().createUniqueConstraint();
            table.getUniqueConstraints().add(key);
            this.initialize((RelationalReference)key, node);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:columnReference")) continue;
                try {
                    RelationalColumn column = this.find(RelationalColumn.class, node1, (RelationalReference)table, allRefs);
                    key.getColumns().add(column);
                }
                catch (Exception error) {
                    this.addProgressMessage(error.getMessage());
                }
            }
        }
    }

    protected RelationalProcedure createProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalProcedure procedure = this.getFactory().createProcedure();
        Info info = this.createInfo(procedureNode, model);
        if (info.getSchema() == null) {
            model.addChild((RelationalReference)procedure);
        } else {
            info.getSchema().getProcedures().add(procedure);
            procedure.setParent((RelationalReference)info.getSchema());
        }
        this.initialize((RelationalReference)procedure, procedureNode, info.getName());
        if (procedureNode.getProperty("ddl:datatypeName") != null) {
            RelationalProcedureResultSet result = this.getFactory().createProcedureResultSet();
            procedure.setResultSet(result);
            this.initialize((RelationalReference)result, procedureNode);
        }
        return procedure;
    }

    public RelationalModel importNode(AstNode rootNode, DdlImporterManager importManager, Properties props) throws Exception {
        this.setImporterManager(importManager);
        RelationalModel model = this.getFactory().createModel("ddlImportedModel");
        HashMap<AstNode, RelationalReference> deferredCreateMap = new HashMap<AstNode, RelationalReference>();
        for (AstNode node : rootNode) {
            if (this.is(node, "ddl:createSchemaStatement")) {
                RelationalSchema schema = this.getFactory().createSchema();
                model.addChild((RelationalReference)schema);
                this.initialize((RelationalReference)schema, node);
                for (AstNode node1 : node) {
                    Map<AstNode, RelationalReference> deferredMap = this.createObject(node1, model, schema);
                    if (deferredMap.isEmpty()) continue;
                    deferredCreateMap.putAll(deferredMap);
                }
                continue;
            }
            Map<AstNode, RelationalReference> deferredMap = this.createObject(node, model, null);
            if (deferredMap.isEmpty()) continue;
            deferredCreateMap.putAll(deferredMap);
        }
        this.createDeferredObjects(deferredCreateMap, model);
        return model;
    }

    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        if (this.is(node, "ddl:createTableStatement")) {
            RelationalTable table = this.initializeTable(this.getFactory().createBaseTable(), node, model);
            for (AstNode child : node) {
                if (this.is(child, "ddl:columnDefinition")) {
                    this.createColumn(child, table);
                    continue;
                }
                if (!this.is(child, "ddl:tableConstraint")) continue;
                deferredMap.put(child, (RelationalReference)table);
            }
        } else if (this.is(node, "ddl:createViewStatement")) {
            if (this.getImporterManager().getModelType() != ModelType.VIRTUAL_LITERAL && this.getImporterManager().optToCreateModelEntitiesForUnsupportedDdl()) {
                this.initializeTable(this.getFactory().createView(), node, model);
            }
        } else if (this.is(node, "ddl:alterTableStatement")) {
            deferredMap.put(node, null);
        } else {
            StringBuffer sb = new StringBuffer();
            List mixins = node.getMixins();
            Iterator iter = mixins.iterator();
            while (iter.hasNext()) {
                String mixin = (String)iter.next();
                sb.append(mixin);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            this.getImporterManager().getImportMessages().incrementUnhandledNodeType(sb.toString());
        }
        return deferredMap;
    }

    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createPrimaryKey(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:addTableConstraintDefinition")) continue;
                this.createPrimaryKey(node1, table, allRefs);
            }
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (this.is(node1, "ddl:addTableConstraintDefinition")) {
                    this.createConstraint(node1, table, allRefs);
                    continue;
                }
                if (!this.is(node1, "ddl:addColumnDefinition")) continue;
                this.createColumn(node1, table);
            }
        }
    }

    protected String getRelRefNullable(String astNullableStr) {
        String nullableStr = "NULLABLE_UNKNOWN";
        if (astNullableStr != null) {
            if (astNullableStr.equalsIgnoreCase("null")) {
                nullableStr = "NULLABLE";
            } else if (astNullableStr.equalsIgnoreCase("not null")) {
                nullableStr = "NO_NULLS";
            }
        }
        return nullableStr;
    }

    class Info {
        protected RelationalSchema schema;
        protected String name;

        public Info(AstNode node, RelationalModel model) throws Exception {
            this.init(node, model);
        }

        protected void init(AstNode node, RelationalModel model) throws Exception {
            this.schema = null;
            this.name = node.getName();
        }

        protected String removeLeadingTrailingTicks(String name) {
            String resultName = name;
            if (name != null && name.length() > 2 & name.startsWith("`") && name.endsWith("`")) {
                resultName = name.substring(1, name.length() - 1);
            }
            return resultName;
        }

        public String getName() {
            return this.name;
        }

        public RelationalSchema getSchema() {
            return this.schema;
        }
    }
}

